/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.applets.VOTableFilter;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotData;
import com.jvt.votable.VOTableWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;

public class PlotVotableDisplayDialog
extends JFrame {
    public Component contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"Close"};
    private static String[] _buttons1 = new String[]{"Close", "Save As File"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    public PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private PlotButtons _pb = null;
    private JScrollPane _votableDisplayPane;
    private JPanel _panel;
    private JPanel _votableDisplayPanel;
    private JTextArea _votableDisplayArea;
    private int _verticalscrollbar = 22;
    private int _horizontalscrollbar = 32;
    private JLabel _votable = new JLabel("VOTable  : ");
    private JCheckBox _dataDisplayed;
    public static final int dialogboxHeight = 600;
    public static final int dialogboxWidth = 800;
    public static final int textareaHeight = 27;
    public static final int textareaWidth = 60;
    public ArrayList selectedIndexs;
    String _truncatedVOTable = "";
    File _currentDirectory;
    String _noVOTable = "There is no VOTable loaded ";

    public PlotVotableDisplayDialog(Frame frame, PlotVOApplet plotVOApplet, PlotButtons plotButtons) {
        this.setTitle("Display Data In VOTable Format.");
        this._pb = plotButtons;
        this.init(plotVOApplet);
        this.addPanel();
    }

    private void addPanel() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._panel.add(this._votableDisplayPanel);
        this.contents = this._votableDisplayPanel;
        this._optionPane = this._pva.isWebApp() ? new JOptionPane(this._panel, 1, 1, null, _buttons, _buttons[0]) : new JOptionPane(this._panel, 1, 1, null, _buttons1, _buttons1[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotVotableDisplayDialog.this.isVisible() && propertyChangeEvent.getSource() == PlotVotableDisplayDialog.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotVotableDisplayDialog.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotVotableDisplayDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotVotableDisplayDialog.this._buttonPressed = (String)object;
                    }
                    if (_buttons1[1].equals(PlotVotableDisplayDialog.this._buttonPressed)) {
                        if (PlotVotableDisplayDialog.this._pva.getPlotData() == null) {
                            PlotVotableDisplayDialog.this.ClosingDialogBox();
                        } else {
                            String string2 = "";
                            PlotVotableDisplayDialog.this.selectedIndexs = PlotVotableDisplayDialog.this._pva.getSelectedPointsIndex();
                            try {
                                JFileChooser jFileChooser = new JFileChooser(PlotVotableDisplayDialog.this._currentDirectory);
                                jFileChooser.addChoosableFileFilter(new VOTableFilter());
                                int n = jFileChooser.showSaveDialog(PlotVotableDisplayDialog.this._pva);
                                if (n == 0) {
                                    Object object2;
                                    Object object3 = jFileChooser.getSelectedFile();
                                    String string3 = ((File)object3).toString();
                                    String string4 = ".XML";
                                    String string5 = ".xml";
                                    if (!string3.endsWith(string4) && !string3.endsWith(string5)) {
                                        string3 = string3 + string5;
                                        object3 = object2 = new File(string3);
                                    }
                                    object2 = new FileOutputStream((File)object3);
                                    VOTableWriter vOTableWriter = new VOTableWriter(PlotVotableDisplayDialog.this._pva);
                                    string2 = ((File)object3).getName();
                                    if (PlotVotableDisplayDialog.this._dataDisplayed.isSelected()) {
                                        vOTableWriter.getSelectedDataInVOTableFormat((OutputStream)object2, PlotVotableDisplayDialog.this.selectedIndexs);
                                    } else {
                                        vOTableWriter.getDataInVOTableFormat((OutputStream)object2);
                                    }
                                    PlotVotableDisplayDialog.this._currentDirectory = jFileChooser.getCurrentDirectory();
                                    JOptionPane.showMessageDialog(null, string2 + " Saved", "Saved", 1);
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(null, string2 + " Not Saved", "Error", 1);
                                exception.printStackTrace();
                            }
                        }
                    } else {
                        PlotVotableDisplayDialog.this.ClosingDialogBox();
                    }
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        ((Component)this).setSize(800, 600);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JVTUtil.SHOW_VOTABLE = true;
                PlotVotableDisplayDialog.this._pb.unselectVOTableDisplayButton();
                PlotVotableDisplayDialog.this._handleClosing();
            }
        });
        ((Component)this).setVisible(true);
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet plotVOApplet) {
        this._pva = plotVOApplet;
        this._pd = plotVOApplet.getPlotData();
        JVTUtil.SHOW_VOTABLE = false;
        this._dataDisplayed = new JCheckBox("Display Data Of Selected Points");
        this._dataDisplayed.addItemListener(new CheckboxListener());
        this._votableDisplayPanel = new JPanel(new BorderLayout());
        this._votableDisplayArea = new JTextArea(60, 27);
        this.selectedIndexs = this._pva.getSelectedPointsIndex();
        if (this.selectedIndexs == null || this.selectedIndexs.size() <= 0) {
            this.showEntireTable();
        } else {
            this._dataDisplayed.setSelected(true);
            this.showSelectedPointsTable();
        }
        this._votableDisplayPane = new JScrollPane(this._votableDisplayArea);
        this._votableDisplayPanel.add((Component)this._votable, "North");
        this._votableDisplayPanel.add((Component)this._votableDisplayPane, "Center");
        this._votableDisplayPanel.add((Component)this._dataDisplayed, "South");
        if (!this._pva.isWebApp()) {
            this._currentDirectory = new File(System.getProperty("user.dir"));
        }
    }

    private void showEntireTable() {
        VOTableWriter vOTableWriter = new VOTableWriter(this._pva, 100);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        vOTableWriter.getDataInVOTableFormat(byteArrayOutputStream);
        this._truncatedVOTable = byteArrayOutputStream.toString();
        this._votableDisplayArea.setText(this._truncatedVOTable);
        this._votableDisplayArea.setCaretPosition(0);
    }

    private void showSelectedPointsTable() {
        this.selectedIndexs = this._pva.getSelectedPointsIndex();
        VOTableWriter vOTableWriter = new VOTableWriter(this._pva, 100);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        vOTableWriter.getSelectedDataInVOTableFormat(byteArrayOutputStream, this.selectedIndexs);
        this._truncatedVOTable = byteArrayOutputStream.toString();
        this._votableDisplayArea.setText(this._truncatedVOTable);
        this._votableDisplayArea.setCaretPosition(0);
    }

    private void ClosingDialogBox() {
        if (this._pva.getPlotData() == null) {
            JOptionPane.showMessageDialog(null, this._noVOTable, "Error", 1);
        }
        ((Component)this).setVisible(false);
        JVTUtil.SHOW_VOTABLE = true;
        this._pb.unselectVOTableDisplayButton();
        this._handleClosing();
    }

    class CheckboxListener
    implements ItemListener {
        CheckboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (PlotVotableDisplayDialog.this._pva.getPlotData() != null) {
                if (PlotVotableDisplayDialog.this._dataDisplayed.isSelected()) {
                    PlotVotableDisplayDialog.this.showSelectedPointsTable();
                } else {
                    PlotVotableDisplayDialog.this.showEntireTable();
                }
            } else {
                PlotVotableDisplayDialog.this.ClosingDialogBox();
            }
        }
    }
}

