/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.ColumnExprParser;

public class PlotTransformerDialog
extends JDialog {
    public Component _contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"OK", "Cancel", "Help"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private JTextArea _messageArea;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private Query _wideQuery;
    private JTable _table;
    private JScrollPane _scrollPane;
    private JPanel _transPanel;
    private static final int MAX_COL_DIGITS = 3;
    private static final String ORIGINAL_COLS_IN_VOTABLE = "Original";
    private final short ERROR_NO_COL_NAME = 1;
    private final short ERROR_COL_EXISTS = (short)2;
    private static final int DIALOGBOX_HEIGHT = 350;
    private static final int DIALOGBOX_WIDTH = 600;
    private static final String[] errorMessages = new String[]{"", "No Column name. Please enter a column name.", "Column name already exists. Please enter another name.", "No expression entered. Please enter an expression.", "Invalid column number. Please enter a correct expression.", "Exception while parsing expression. Please check that the expression is correct."};
    private static final String[] availableFunctions = new String[]{" ", "Operators available for use in the Transformation Dialog Box    ", " ", "       ' + ',  ' - ',  ' * ',  ' / '  ", " ", "Functions available for use in the Transformation Dialog Box    ", " ", "       log(a)                          ln(a)", "       sqrt(a)                        pow(a,b)", "       dexp(a)                       exp(a)", "       cos(a)                         acos(a)", "       sin(a)                          asin(a)", "       tan(a)                          atan(a)", "       toradians(a)              todegrees(a)", " ", "For example, $1 + sin((3.14 * $2) / $2)", " "};

    public PlotTransformerDialog(Frame frame, PlotVOApplet plotVOApplet) {
        super(frame, "Create new virtual columns", true);
        this.init(plotVOApplet);
        this.addPanel(frame);
    }

    private void addPanel(Frame frame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this._transPanel);
        this._contents = this._transPanel;
        this._wideQuery.requestFocus();
        this._optionPane = new JOptionPane(jPanel, 3, 1, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotTransformerDialog.this.isVisible() && propertyChangeEvent.getSource() == PlotTransformerDialog.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotTransformerDialog.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotTransformerDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotTransformerDialog.this._buttonPressed = (String)object;
                    }
                    if (_buttons[0].equals(PlotTransformerDialog.this._buttonPressed) && !PlotTransformerDialog.this.applyChanges()) {
                        return;
                    }
                    if (_buttons[2].equals(PlotTransformerDialog.this._buttonPressed)) {
                        JOptionPane.showMessageDialog(null, availableFunctions, "Help for creating new virtual columns", 1);
                        return;
                    }
                    ((Component)PlotTransformerDialog.this).setVisible(false);
                    PlotTransformerDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotTransformerDialog.this._handleClosing();
            }
        });
        ((Component)this).setSize(600, 350);
        ((Component)this).setVisible(true);
    }

    private void _handleClosing() {
        if (this._contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this._contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet plotVOApplet) {
        this._pva = plotVOApplet;
        this._pd = plotVOApplet.getPlotData();
        this._transPanel = new JPanel();
        try {
            Vector<String> vector = new Vector<String>();
            vector.add("Column Id");
            vector.add("Column Name");
            vector.add("UCD");
            vector.add("Expression");
            Vector vector2 = new Vector();
            int n = 0;
            while (n < this._pd.getNumOfPlotColumns()) {
                Vector<String> vector3 = new Vector<String>();
                vector3.add("$" + (n + 1));
                PlotColumn plotColumn = this._pd.getPlotColumn(n);
                vector3.add(plotColumn.getName());
                vector3.add(plotColumn.getUCD());
                String string = plotColumn.getExpression();
                if (null == string || string.trim().length() <= 0) {
                    string = ORIGINAL_COLS_IN_VOTABLE;
                }
                vector3.add(string);
                vector2.add(vector3);
                ++n;
            }
            this._table = new JTable(vector2, vector);
            this._table.setPreferredScrollableViewportSize(new Dimension(200, 160));
            this._scrollPane = new JScrollPane(this._table);
            this._scrollPane.setRequestFocusEnabled(false);
            this._transPanel.setLayout(new BorderLayout());
            this._transPanel.add((Component)this._scrollPane, "North");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._wideQuery = new Query();
        this._wideQuery.requestFocus();
        this._transPanel.add((Component)this._wideQuery, "South");
        this._wideQuery.requestFocus();
        this._wideQuery.setTextWidth(20);
        String string = "";
        this._wideQuery.addLine("name", "Enter column name", string);
        String string2 = "";
        this._wideQuery.addLine("expr", "Enter expression", string2);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
            }
        });
    }

    private boolean applyChanges() {
        JVTUtil.showWaitCursor(this);
        PlotColumn plotColumn = new PlotColumn();
        String string = this._wideQuery.getStringValue("name");
        int n = this.checkColNameValid(string);
        if (n > 0) {
            JVTUtil.showDefaultCursor(this);
            JOptionPane.showMessageDialog(null, errorMessages[n], "Error", 0);
            return false;
        }
        plotColumn.setName(string);
        plotColumn.setDatatype("double");
        try {
            String string2 = this._wideQuery.getStringValue("expr");
            if (string2 != null && string2.trim().length() <= 0) {
                JVTUtil.showDefaultCursor(this);
                JOptionPane.showMessageDialog(null, errorMessages[3], "Error", 0);
                return false;
            }
            string2 = string2.trim();
            plotColumn.setExpression(string2);
            ColumnExprParser columnExprParser = new ColumnExprParser(this._pd);
            if (!columnExprParser.parseAndEvaluate(string2, plotColumn)) {
                if (columnExprParser.getErrorCode() == 4) {
                    String string3 = columnExprParser.getColumnNumber();
                    JOptionPane.showMessageDialog(null, "Invalid column number : $" + string3 + ". Please check the expression.", "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(null, errorMessages[columnExprParser.getErrorCode()], "Error", 0);
                }
                JVTUtil.showDefaultCursor(this);
                return false;
            }
            plotColumn.setUserCreated(true);
            this._pd.addPlotColumn(plotColumn);
            this._pva.setPlotData(this._pd, false);
            JOptionPane.showMessageDialog(null, "Created column '" + plotColumn.getName() + "' successfully.", "Success", 1);
        }
        catch (Exception exception) {
            JVTUtil.showDefaultCursor(this);
            JOptionPane.showMessageDialog(null, errorMessages[5], "Error", 0);
            return false;
        }
        JVTUtil.showDefaultCursor(this);
        return true;
    }

    private void printColData(PlotColumn plotColumn) {
        Double[] doubleArray = plotColumn.getData();
        System.out.println(plotColumn.getName() + " data length = " + doubleArray.length);
        int n = 0;
        while (n < doubleArray.length) {
            System.out.println(doubleArray.toString());
            ++n;
        }
    }

    private int checkColNameValid(String string) {
        if (null == string || string.trim().length() <= 0) {
            return 1;
        }
        int n = 0;
        while (n < this._pd.getNumOfPlotColumns()) {
            if (string.equals(this._pd.getPlotColumn(n).getName())) {
                return 2;
            }
            ++n;
        }
        return 0;
    }
}

