/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.exprparser.Expression_Parser;
import com.jvt.exprparser.SimpleNode;
import com.jvt.votable.Column;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;

public class PlotTransformer
extends JPanel {
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private Query _wideQuery;
    private JTable table;
    private JScrollPane scrollPane;
    private static final String[] errorMessages = new String[]{"", "No Column name. Please enter a column name.", "Column name already exists. Please enter another name.", ""};

    public PlotTransformer(PlotVOApplet plotVOApplet) {
        this._pva = plotVOApplet;
        this._pd = plotVOApplet.getPlotData();
        try {
            Vector<String> vector = new Vector<String>();
            vector.add("Column Id");
            vector.add("Column Name");
            Vector vector2 = new Vector();
            int n = 0;
            while (n < this._pd.getNumOfColumns()) {
                Vector<String> vector3 = new Vector<String>();
                vector3.add("$" + (n + 1));
                vector3.add(this._pd.getPlotColumn(n).getName());
                vector2.add(vector3);
                ++n;
            }
            this.table = new JTable(vector2, vector);
            this.table.setPreferredScrollableViewportSize(new Dimension(300, 70));
            this.scrollPane = new JScrollPane(this.table);
            this.setLayout(new BorderLayout());
            this.add((Component)this.scrollPane, "North");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._wideQuery = new Query();
        this.add((Component)this._wideQuery, "South");
        this._wideQuery.setTextWidth(20);
        String string = "";
        this._wideQuery.addLine("name", "Column Name", string);
        String string2 = "";
        this._wideQuery.addLine("expr", "Expression", string2);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
            }
        });
    }

    public void apply() {
        PlotColumn plotColumn = new PlotColumn();
        String string = this._wideQuery.stringValue("name");
        int n = this.checkColNameValid(string);
        if (n > 0) {
            System.out.println(errorMessages[n]);
            JOptionPane.showMessageDialog(null, errorMessages[n], "Error", 0);
        } else {
            plotColumn.setName(this._wideQuery.stringValue("name"));
        }
        try {
            Object object;
            Object object2;
            String string2 = this._wideQuery.stringValue("expr");
            if (string2 != null && string2.trim().length() <= 0) {
                return;
            }
            string2 = string2.trim();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            while (n4 < string2.length()) {
                if (string2.charAt(n4) == '$' && n4 + 1 < string2.length()) {
                    object2 = new char[1];
                    object2[0] = string2.charAt(n4 + 1);
                    int n5 = 0;
                    try {
                        n5 = Integer.parseInt(new String((char[])object2));
                        System.out.println(n5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        return;
                    }
                    n3 = n4;
                    String string3 = string2.substring(n2, n3);
                    object = new ColNumExpr(--n5, string3);
                    arrayList.add(object);
                    if (n4 + 2 < string2.length()) {
                        n3 = n2 = n4 + 2;
                        n4 += 2;
                    }
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                System.out.println("Incorrect Expression");
            }
            object2 = string2.substring(n2);
            Double d = null;
            int n6 = 0;
            if (this._pd.getNumOfColumns() > 0) {
                object = this._pd.getPlotColumn(0);
                n6 = ((Column)object).getNumOfRows();
            }
            System.out.println("Num of rows = " + n6);
            int n7 = 0;
            while (n7 < n6) {
                Object object3;
                Object object4;
                StringBuffer stringBuffer = new StringBuffer();
                int n8 = 0;
                while (n8 < arrayList.size()) {
                    object4 = (ColNumExpr)arrayList.get(n8);
                    stringBuffer.append(((ColNumExpr)object4).getExpr());
                    object3 = this._pd.getPlotColumn(((ColNumExpr)object4).getColNum());
                    d = ((PlotColumn)object3).getData(n7);
                    if (null == d) {
                        plotColumn.addData(null);
                    } else {
                        stringBuffer.append(d);
                    }
                    ++n8;
                }
                stringBuffer.append((String)object2);
                object4 = stringBuffer.toString();
                object3 = new ByteArrayInputStream(((String)object4).getBytes());
                Expression_Parser expression_Parser = new Expression_Parser((InputStream)object3);
                SimpleNode simpleNode = expression_Parser.parseExpression();
                Object object5 = simpleNode.eval();
                String string4 = object5.toString();
                Double d2 = new Double(string4);
                plotColumn.addData(d2);
                ++n7;
            }
            System.out.println(plotColumn.getNumOfRows());
            this._pd.addPlotColumn(plotColumn);
            this._pva.setPlotData(this._pd);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int checkColNameValid(String string) {
        if (null == string || string.trim().length() <= 0) {
            return 1;
        }
        int n = 0;
        while (n < this._pd.getNumOfColumns()) {
            if (string.equals(this._pd.getPlotColumn(n).getName())) {
                return 2;
            }
            ++n;
        }
        return 0;
    }

    public void openModal() {
        ComponentDialog componentDialog;
        String[] stringArray = new String[]{"OK", "Cancel"};
        JPanel jPanel = new JPanel();
        Frame frame = null;
        if (jPanel instanceof Frame) {
            frame = (Frame)((Object)jPanel);
        }
        if ((componentDialog = new ComponentDialog(frame, "Define Transformations", this, stringArray)).buttonPressed().equals("OK")) {
            this.apply();
            System.out.println("OK clicked");
        } else {
            System.out.println("Cancel clicked");
        }
    }

    class ColNumExpr {
        private String _expr;
        private int _colNum;

        public ColNumExpr() {
        }

        public ColNumExpr(int n, String string) {
            this._expr = string;
            this._colNum = n;
        }

        public void setExpr(String string) {
            this._expr = string;
        }

        public void setColNum(int n) {
            this._colNum = n;
        }

        public String getExpr() {
            return this._expr;
        }

        public int getColNum() {
            return this._colNum;
        }
    }
}

