/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;

public class PlotSetFilterDialog
extends JDialog {
    public Component contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"Apply", "Close"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private JTextArea _messageArea;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private JComboBox _filters;
    private JTable table;
    private JScrollPane scrollPane;
    private JPanel transPanel;
    public static final String NO_FILTER = "No Filter";

    public PlotSetFilterDialog(Frame frame, PlotVOApplet plotVOApplet) {
        super(frame, "Set filter on data", true);
        this.init(plotVOApplet);
        this.addPanel(frame);
    }

    private void addPanel(Frame frame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.transPanel);
        this.contents = this.transPanel;
        String[] stringArray = new String[]{"Apply", "Close"};
        this._optionPane = new JOptionPane(jPanel, 3, 0, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotSetFilterDialog.this.isVisible() && propertyChangeEvent.getSource() == PlotSetFilterDialog.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotSetFilterDialog.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotSetFilterDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotSetFilterDialog.this._buttonPressed = (String)object;
                    }
                    if (_buttons[0].equals(PlotSetFilterDialog.this._buttonPressed) && !PlotSetFilterDialog.this.applyChanges()) {
                        return;
                    }
                    ((Component)PlotSetFilterDialog.this).setVisible(false);
                    PlotSetFilterDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotSetFilterDialog.this._handleClosing();
            }
        });
        ((Component)this).setVisible(true);
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet plotVOApplet) {
        this._pva = plotVOApplet;
        this._pd = plotVOApplet.getPlotData();
        this.transPanel = new JPanel();
        String[] stringArray = new String[this._pd.getNumOfFilters() + 1];
        try {
            Vector<String> vector = new Vector<String>();
            vector.add("Filter Name");
            vector.add("Expression");
            stringArray[0] = NO_FILTER;
            Vector vector2 = new Vector();
            Vector<String> vector3 = new Vector<String>();
            vector3.add(NO_FILTER);
            vector3.add("");
            vector2.add(vector3);
            int n = 0;
            while (n < this._pd.getNumOfFilters()) {
                Vector<String> vector4 = new Vector<String>();
                PlotFilter plotFilter = this._pd.getPlotFilter(n);
                vector4.add(plotFilter.getName());
                stringArray[n + 1] = plotFilter.getName();
                String string = plotFilter.getExpression();
                vector4.add(string);
                vector2.add(vector4);
                ++n;
            }
            this.table = new JTable(vector2, vector);
            this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
            this.scrollPane = new JScrollPane(this.table);
            this.scrollPane.setRequestFocusEnabled(false);
            this.transPanel.setLayout(new BorderLayout());
            this.transPanel.add((Component)this.scrollPane, "North");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._filters = new JComboBox<String>(stringArray);
        this._filters.setMaximumRowCount(3);
        this._filters.requestFocus();
        this.transPanel.add((Component)this._filters, "South");
    }

    private boolean applyChanges() {
        System.out.println("Apply pressed " + (String)this._filters.getSelectedItem());
        this._pva.setPlotFilter((String)this._filters.getSelectedItem());
        return true;
    }
}

