/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.utils.JVTUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.Histogram;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class PlotFormatter
extends JPanel {
    protected final PlotBox _plot;
    private Query _wideQuery;
    private Query _narrowQuery;
    private String _originalTitle;
    private String _originalXLabel;
    private String _originalYLabel;
    private String _originalMarks;
    private String _originalXTicksSpec;
    private String _originalYTicksSpec;
    private double[] _originalXRange;
    private double[] _originalYRange;
    private Vector[] _originalXTicks;
    private Vector[] _originalYTicks;
    private boolean _originalGrid;
    private boolean _originalStems;
    private boolean _originalColor;
    private boolean _originalXLog;
    private boolean _originalYLog;
    private boolean _yIncremented;
    private boolean[][] _originalConnected;
    private PlotPoint[][] _originalPoints;
    private double _originalXTickDist;
    private double _originalYTickDist;
    private double _originalBinWidth;

    public PlotFormatter(PlotBox plotBox) {
        int n;
        Vector vector;
        Vector vector2;
        StringBuffer stringBuffer;
        this._plot = plotBox;
        String[] stringArray = new String[2];
        this.setLayout(new BorderLayout());
        this._wideQuery = new Query();
        this.add((Component)this._wideQuery, "West");
        this._narrowQuery = new Query();
        this.add((Component)this._narrowQuery, "East");
        this._wideQuery.setTextWidth(20);
        this._originalTitle = plotBox.getTitle();
        this._wideQuery.addLine("title", "Title", this._originalTitle);
        this._originalXLabel = plotBox.getXLabel();
        this._wideQuery.addLine("xlabel", "X Label", this._originalXLabel);
        this._originalYLabel = plotBox.getYLabel();
        this._wideQuery.addLine("ylabel", "Y Label", this._originalYLabel);
        this._originalXRange = plotBox.getXRange();
        stringArray = JVTUtil.setNoDecimalDigits(this._originalXRange);
        this._wideQuery.addLine("xrange", "X Range", "" + stringArray[0] + ", " + stringArray[1]);
        this._originalYRange = plotBox.getYRange();
        this._originalYTickDist = plotBox.getYTickSpacing();
        stringArray = JVTUtil.setNoDecimalDigits(this._originalYRange);
        this._wideQuery.addLine("yrange", "Y Range", "" + stringArray[0] + ", " + stringArray[1]);
        String[] stringArray2 = new String[]{"none", "pixels", "points", "dots", "various"};
        this._originalMarks = "none";
        if (plotBox instanceof Plot) {
            this._originalMarks = ((Plot)plotBox).getMarksStyle();
            this._wideQuery.addRadioButtons("marks", "Marks", stringArray2, this._originalMarks);
        }
        this._originalXTicks = plotBox.getXTicks();
        this._originalXTicksSpec = "";
        if (this._originalXTicks != null) {
            stringBuffer = new StringBuffer();
            vector2 = this._originalXTicks[0];
            vector = this._originalXTicks[1];
            n = 0;
            while (n < vector.size()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(vector.elementAt(n).toString());
                stringBuffer.append(" ");
                stringBuffer.append(vector2.elementAt(n).toString());
                ++n;
            }
            this._originalXTicksSpec = stringBuffer.toString();
        }
        this._originalYTicks = plotBox.getYTicks();
        this._originalYTicksSpec = "";
        if (this._originalYTicks != null) {
            stringBuffer = new StringBuffer();
            vector2 = this._originalYTicks[0];
            vector = this._originalYTicks[1];
            n = 0;
            while (n < vector.size()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(vector.elementAt(n).toString());
                stringBuffer.append(" ");
                stringBuffer.append(vector2.elementAt(n).toString());
                ++n;
            }
            this._originalYTicksSpec = stringBuffer.toString();
        }
        if (plotBox instanceof Histogram) {
            this._originalBinWidth = ((Histogram)plotBox).getBinWidth();
            this._wideQuery.addLine("binwidth", "Bin Width", "" + this._originalBinWidth);
            this._yIncremented = ((Histogram)plotBox).isYIncremented();
            this._narrowQuery.addCheckBox("yinc", "Incremented Y", this._yIncremented);
        }
        this._originalGrid = plotBox.getGrid();
        this._narrowQuery.addCheckBox("grid", "Grid", this._originalGrid);
        this._originalStems = false;
        this._originalConnected = null;
        if (plotBox instanceof Plot) {
            this._originalStems = ((Plot)plotBox).getImpulses();
            this._narrowQuery.addCheckBox("stems", "Impulses", this._originalStems);
            this._saveConnected();
            this._narrowQuery.addCheckBox("connected", "Connect", ((Plot)plotBox).getConnected());
        }
        this._originalColor = plotBox.getColor();
        this._narrowQuery.addCheckBox("color", "Use Color", this._originalColor);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
                String string2 = new String();
                String string3 = new String();
                String string4 = new String();
                double d = 0.0;
                double d2 = 0.0;
                if (string.equals("title") || string.equals("xlabel") || string.equals("ylabel") || string.equals("xrange") || string.equals("xticks") || string.equals("yrange") || string.equals("yticks") || string.equals("marks")) {
                    // empty if block
                }
            }
        });
        this._narrowQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
                if (string.equals("grid") || string.equals("stems") || string.equals("color") || string.equals("connected")) {
                    // empty if block
                }
            }
        });
    }

    public void apply() {
        this._plot.setTitle(this._wideQuery.getStringValue("title"));
        this._plot.setXLabel(this._wideQuery.getStringValue("xlabel"));
        this._plot.setYLabel(this._wideQuery.getStringValue("ylabel"));
        this._plot.read("XRange: " + this._wideQuery.getStringValue("xrange"));
        this._plot.read("YRange: " + this._wideQuery.getStringValue("yrange"));
        this._plot.setGrid(this._narrowQuery.getBooleanValue("grid"));
        this._plot.setColor(this._narrowQuery.getBooleanValue("color"));
        if (this._plot instanceof Plot) {
            Plot plot = (Plot)this._plot;
            plot.setMarksStyle(this._wideQuery.getStringValue("marks"));
            plot.setImpulses(this._narrowQuery.getBooleanValue("stems"));
            this._setConnected(this._narrowQuery.getBooleanValue("connected"));
        }
        if (this._plot instanceof Histogram) {
            if (this._originalBinWidth != this._wideQuery.getDoubleValue("binwidth")) {
                this._plot.redrawHistogram(this._wideQuery.getDoubleValue("binwidth"));
            }
            ((Histogram)this._plot).setYIncremented(this._narrowQuery.getBooleanValue("yinc"));
        }
        this._plot.repaint();
    }

    public void openModal() {
        ComponentDialog componentDialog;
        String[] stringArray = new String[]{"Apply", "Cancel"};
        Container container = this._plot.getTopLevelAncestor();
        Frame frame = null;
        if (container instanceof Frame) {
            frame = (Frame)container;
        }
        if ((componentDialog = new ComponentDialog(frame, "Set plot format", this, stringArray)).buttonPressed().equals("Apply")) {
            JVTUtil.showWaitCursor(this);
            this.apply();
            JVTUtil.showDefaultCursor(this);
        } else {
            this.restore();
        }
    }

    public void restore() {
        this._plot.repaint();
    }

    private void _saveConnected() {
        Vector vector = ((Plot)this._plot)._points;
        this._originalConnected = new boolean[vector.size()][];
        this._originalPoints = new PlotPoint[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            this._originalConnected[n] = new boolean[vector2.size()];
            this._originalPoints[n] = new PlotPoint[vector2.size()];
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                this._originalConnected[n][n2] = plotPoint.connected;
                this._originalPoints[n][n2] = plotPoint;
                ++n2;
            }
            ++n;
        }
    }

    private void _setConnected(boolean bl) {
        Vector vector = ((Plot)this._plot)._points;
        ((Plot)this._plot).setConnected(bl);
        boolean[][] blArrayArray = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArrayArray[n] = new boolean[vector2.size()];
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                plotPoint.connected = bl && !bl2;
                bl2 = false;
                ++n2;
            }
            ++n;
        }
    }

    private void _restoreConnected() {
        int n = 0;
        while (n < this._originalPoints.length) {
            int n2 = 0;
            while (n2 < this._originalPoints[n].length) {
                PlotPoint plotPoint = this._originalPoints[n][n2];
                plotPoint.connected = this._originalConnected[n][n2];
                ++n2;
            }
            ++n;
        }
    }
}

