/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.Column;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.ColumnExprParser;

public class PlotFilterDialog
extends JDialog {
    public Component _contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"OK", "Cancel", "Help"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private JTextArea _messageArea;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private Query _wideQuery;
    private JTable _colTable;
    private JTable _filterTable;
    private JScrollPane _scrollPaneCol;
    private JScrollPane _scrollPaneFilter;
    private JPanel _transPanel;
    private static final int DIALOGBOX_HEIGHT = 450;
    private static final int DIALOGBOX_WIDTH = 600;
    private static final String[] availableFunctions = new String[]{" ", "Operators available for use in the Create new data subsets Dialog Box    ", " ", "       ' + ',  ' - ',  ' * ',  ' / ' , ' < ', ' <= ', ' > ', ' >= ', ' == ', ' != ', ' && ', ' || ', ' ! '  ", " ", "Functions available for use in the Transformation Dialog Box    ", " ", "       log(a)                          ln(a)", "       sqrt(a)                        pow(a,b)", "       dexp(a)                       exp(a)", "       cos(a)                         acos(a)", "       sin(a)                          asin(a)", "       tan(a)                          atan(a)", "       toradians(a)              todegrees(a)", " ", "For example, $1 > 30 && ($2 < 100 || $3 >= 90) ", " "};
    private static final String[] errorMessages = new String[]{"", "No filter name. Please enter a filter name.", "Filter name already exists. Please enter another name.", "No expression entered. Please enter an expression.", "Invalid column number. Please enter a correct expression.", "Exception while parsing expression. Please check that the expression is correct.", "Please enter another filter name."};

    public PlotFilterDialog(Frame frame, PlotVOApplet plotVOApplet) {
        super(frame, "Create new data subsets ", true);
        this.init(plotVOApplet);
        this.addPanel(frame);
        this._wideQuery.requestFocus();
    }

    private void addPanel(Frame frame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this._transPanel);
        this._contents = this._transPanel;
        this._wideQuery.requestFocus();
        this._optionPane = new JOptionPane(jPanel, 3, 0, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotFilterDialog.this.isVisible() && propertyChangeEvent.getSource() == PlotFilterDialog.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotFilterDialog.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotFilterDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotFilterDialog.this._buttonPressed = (String)object;
                    }
                    if (_buttons[0].equals(PlotFilterDialog.this._buttonPressed) && !PlotFilterDialog.this.applyChanges()) {
                        return;
                    }
                    if (_buttons[2].equals(PlotFilterDialog.this._buttonPressed)) {
                        JOptionPane.showMessageDialog(null, availableFunctions, "Help for creating data subsets", 1);
                        return;
                    }
                    ((Component)PlotFilterDialog.this).setVisible(false);
                    PlotFilterDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotFilterDialog.this._handleClosing();
            }
        });
        ((Component)this).setSize(600, 450);
        ((Component)this).setVisible(true);
    }

    private void _handleClosing() {
        if (this._contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this._contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet plotVOApplet) {
        this._pva = plotVOApplet;
        this._pd = plotVOApplet.getPlotData();
        this._transPanel = new JPanel();
        try {
            Object object;
            Object object2;
            Vector<Object> vector;
            Vector<String> vector2 = new Vector<String>();
            vector2.add("Column Id");
            vector2.add("Column Name");
            vector2.add("UCD");
            vector2.add("Expression");
            Vector vector3 = new Vector();
            int n = 0;
            while (n < this._pd.getNumOfPlotColumns()) {
                vector = new Vector();
                vector.add("$" + (n + 1));
                object2 = this._pd.getPlotColumn(n);
                vector.add(((Column)object2).getName());
                vector.add(((Column)object2).getUCD());
                object = ((Column)object2).getExpression();
                if (null == object || ((String)object).trim().length() <= 0) {
                    object = "Original";
                }
                vector.add(object);
                vector3.add(vector);
                ++n;
            }
            vector = new Vector<Object>();
            object2 = new String[this._pd.getNumOfFilters() + 1];
            vector.add("Data Subset Name");
            vector.add("Condition");
            object2[0] = "All";
            object = new Vector();
            Vector<String> vector4 = new Vector<String>();
            vector4.add("All");
            vector4.add("");
            ((Vector)object).add(vector4);
            int n2 = 0;
            while (n2 < this._pd.getNumOfFilters()) {
                Vector<String> vector5 = new Vector<String>();
                PlotFilter plotFilter = this._pd.getPlotFilter(n2);
                vector5.add(plotFilter.getName());
                object2[n2 + 1] = plotFilter.getName();
                String string = plotFilter.getExpression();
                vector5.add(string);
                ((Vector)object).add(vector5);
                ++n2;
            }
            this._colTable = new JTable(vector3, vector2);
            this._colTable.setPreferredScrollableViewportSize(new Dimension(200, 160));
            this._filterTable = new JTable((Vector<? extends Vector>)object, vector);
            this._filterTable.setPreferredScrollableViewportSize(new Dimension(150, 100));
            this._scrollPaneCol = new JScrollPane(this._colTable);
            this._scrollPaneCol.setRequestFocusEnabled(false);
            this._scrollPaneFilter = new JScrollPane(this._filterTable);
            this._scrollPaneFilter.setRequestFocusEnabled(false);
            this._transPanel.setLayout(new BorderLayout(0, 10));
            this._transPanel.add((Component)this._scrollPaneCol, "North");
            this._transPanel.add((Component)this._scrollPaneFilter, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._wideQuery = new Query();
        this._transPanel.add((Component)this._wideQuery, "South");
        this._wideQuery.setTextWidth(20);
        String string = "";
        this._wideQuery.addLine("name", "Enter data subset name", string);
        String string2 = "";
        this._wideQuery.addLine("expr", "Enter expression", string2);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
            }
        });
        this._wideQuery.requestFocus();
    }

    private boolean applyChanges() {
        JVTUtil.showWaitCursor(this);
        PlotFilter plotFilter = new PlotFilter();
        String string = this._wideQuery.getStringValue("name");
        int n = this.checkFilterNameValid(string);
        if (n > 0) {
            JVTUtil.showDefaultCursor(this);
            JOptionPane.showMessageDialog(null, errorMessages[n], "Error", 0);
            return false;
        }
        plotFilter.setName(string);
        try {
            String string2 = this._wideQuery.getStringValue("expr");
            if (string2 != null && string2.trim().length() <= 0) {
                JVTUtil.showDefaultCursor(this);
                JOptionPane.showMessageDialog(null, errorMessages[3], "Error", 0);
                return false;
            }
            string2 = string2.trim();
            plotFilter.setExpression(string2);
            ColumnExprParser columnExprParser = new ColumnExprParser(this._pd);
            if (!columnExprParser.parseAndEvaluate(string2, plotFilter)) {
                if (columnExprParser.getErrorCode() == 4) {
                    String string3 = columnExprParser.getColumnNumber();
                    JOptionPane.showMessageDialog(null, "Invalid column number : $" + string3 + ". Please check the expression.", "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(null, errorMessages[columnExprParser.getErrorCode()], "Error", 0);
                }
                JVTUtil.showDefaultCursor(this);
                return false;
            }
            plotFilter.setUserCreated(true);
            this._pd.addPlotFilter(plotFilter);
            this._pva.setPlotData(this._pd, true);
            JOptionPane.showMessageDialog(null, "Created data subset '" + plotFilter.getName() + "' successfully.", "Success", 1);
            JVTUtil.showDefaultCursor(this);
            return true;
        }
        catch (Exception exception) {
            JVTUtil.showDefaultCursor(this);
            JOptionPane.showMessageDialog(null, errorMessages[5], "Error", 0);
            exception.printStackTrace();
            return false;
        }
    }

    private int checkFilterNameValid(String string) {
        if (null == string || string.trim().length() <= 0) {
            return 1;
        }
        int n = 0;
        while (n < this._pd.getNumOfFilters()) {
            if (string.equals(this._pd.getPlotFilter(n).getName())) {
                return 2;
            }
            ++n;
        }
        if ("All".equals(string)) {
            return 6;
        }
        return 0;
    }
}

