/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ptolemy.plot.EPSGraphics;

public class PlotBox
extends JPanel
implements Printable {
    private PlotVOApplet pva;
    private PlotButtons buttons;
    private String xcoordFormat = "";
    private String ycoordFormat = "";
    public static final String PTPLOT_RELEASE = "5.2";
    protected transient double _yMax = 0.0;
    protected transient double _yMin = 0.0;
    protected transient double _xMax = 0.0;
    protected transient double _xMin = 0.0;
    protected double _padding = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected transient boolean _xTickDistGiven = false;
    protected transient boolean _yTickDistGiven = false;
    protected transient boolean _rangesGivenByZooming = false;
    protected double _xlowgiven;
    protected double _xhighgiven;
    protected double _ylowgiven;
    protected double _yhighgiven;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    protected boolean _grid = true;
    protected boolean _wrap = false;
    protected double _wrapHigh;
    protected double _wrapLow;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    protected static Color[] _colors = new Color[]{new Color(255), new Color(32768), new Color(0x800080), new Color(16753920), new Color(0), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0xFF00FF)};
    protected int _width = 500;
    protected int _height = 300;
    protected int _preferredWidth = 500;
    protected int _preferredHeight = 300;
    protected boolean _sizeHasBeenSet = false;
    public URL _documentBase = null;
    private static final int ZOOM_MODE = 1;
    private static final int SELECT_MODE = 2;
    private static final int UNSELECT_MODE = 3;
    private int _buttonMode = 1;
    private boolean _actionsDeferred = false;
    private List _deferredActions;
    private String _filespec = null;
    private static final Color _boxColor = Color.orange;
    private double _ytickMax = 0.0;
    private double _ytickMin = 0.0;
    private double _xtickMax = 0.0;
    private double _xtickMin = 0.0;
    private int _yExp = 0;
    private int _xExp = 0;
    private double _ytickscale = 0.0;
    private double _xtickscale = 0.0;
    private Font _labelFont = null;
    private Font _superscriptFont = null;
    private Font _titleFont = null;
    private FontMetrics _labelFontMetrics = null;
    private FontMetrics _superscriptFontMetrics = null;
    private FontMetrics _titleFontMetrics = null;
    private transient int _gridCurJuke = 0;
    private transient double _gridBase = 0.0;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private double _xtickdist;
    private double _ytickdist;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _xticks = null;
    private Vector _xticklabels = null;
    private Vector _yticks = null;
    private Vector _yticklabels = null;
    boolean _originalXRangeGiven = false;
    boolean _originalYRangeGiven = false;
    double _originalXlow = 0.0;
    double _originalXhigh = 0.0;
    double _originalYlow = 0.0;
    double _originalYhigh = 0.0;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    private transient boolean _zooming = false;
    private static final String _DTD = "<!-- PlotML DTD, created by Edward A. Lee, eal@eecs.berkeley.edu.\n   See http://ptolemy.eecs.berkeley.edu/java/ptplot -->\n<!ELEMENT plot (barGraph | bin | dataset | default | noColor | \n\tnoGrid | title | wrap | xLabel | xLog | xRange | xTicks | yLabel | \n yLog | yRange | yTicks)*>\n  <!ELEMENT barGraph EMPTY>\n    <!ATTLIST barGraph width CDATA #IMPLIED>\n    <!ATTLIST barGraph offset CDATA #IMPLIED>\n  <!ELEMENT bin EMPTY>\n    <!ATTLIST bin width CDATA #IMPLIED>\n    <!ATTLIST bin offset CDATA #IMPLIED>\n  <!ELEMENT dataset (m | move | p | point)*>\n    <!ATTLIST dataset connected (yes | no) #IMPLIED>\n    <!ATTLIST dataset marks (none | dots | points | various) #IMPLIED>\n    <!ATTLIST dataset name CDATA #IMPLIED>\n    <!ATTLIST dataset stems (yes | no) #IMPLIED>\n  <!ELEMENT default EMPTY>\n    <!ATTLIST default connected (yes | no) \"yes\">\n    <!ATTLIST default marks (none | dots | points | various) \"none\">\n    <!ATTLIST default stems (yes | no) \"no\">\n  <!ELEMENT noColor EMPTY>\n  <!ELEMENT noGrid EMPTY>\n  <!ELEMENT title (#PCDATA)>\n  <!ELEMENT wrap EMPTY>\n  <!ELEMENT xLabel (#PCDATA)>\n  <!ELEMENT xLog EMPTY>\n  <!ELEMENT xRange EMPTY>\n    <!ATTLIST xRange min CDATA #REQUIRED>\n    <!ATTLIST xRange max CDATA #REQUIRED>\n  <!ELEMENT xTicks (tick)+>\n  <!ELEMENT yLabel (#PCDATA)>\n  <!ELEMENT yLog EMPTY>\n  <!ELEMENT yRange EMPTY>\n    <!ATTLIST yRange min CDATA #REQUIRED>\n    <!ATTLIST yRange max CDATA #REQUIRED>\n  <!ELEMENT yTicks (tick)+>\n    <!ELEMENT tick EMPTY>\n      <!ATTLIST tick label CDATA #REQUIRED>\n      <!ATTLIST tick position CDATA #REQUIRED>\n    <!ELEMENT m EMPTY>\n      <!ATTLIST m x CDATA #IMPLIED>\n      <!ATTLIST m x CDATA #REQUIRED>\n      <!ATTLIST m lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST m highErrorBar CDATA #IMPLIED>\n    <!ELEMENT move EMPTY>\n      <!ATTLIST move x CDATA #IMPLIED>\n      <!ATTLIST move x CDATA #REQUIRED>\n      <!ATTLIST move lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST move highErrorBar CDATA #IMPLIED>\n    <!ELEMENT p EMPTY>\n      <!ATTLIST p x CDATA #IMPLIED>\n      <!ATTLIST p x CDATA #REQUIRED>\n      <!ATTLIST p lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST p highErrorBar CDATA #IMPLIED>\n    <!ELEMENT point EMPTY>\n      <!ATTLIST point x CDATA #IMPLIED>\n      <!ATTLIST point x CDATA #REQUIRED>\n      <!ATTLIST point lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST point highErrorBar CDATA #IMPLIED>";

    public PlotBox() {
        this.setOpaque(true);
        this.setLayout(new FlowLayout(2, 2, 2));
        this.addMouseListener(new ZoomListener());
        this.addKeyListener(new CommandListener());
        this.addMouseMotionListener(new DragListener());
        this._measureFonts();
    }

    public void setVOApplet(PlotVOApplet plotVOApplet, PlotButtons plotButtons) {
        this.pva = plotVOApplet;
        this.buttons = plotButtons;
    }

    public synchronized void addLegend(int n, String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this._legendStrings.addElement(string);
        this._legendDatasets.addElement(new Integer(n));
    }

    public synchronized void addXTick(String string, double d) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(new Double(d));
        this._xticklabels.addElement(string);
    }

    public synchronized void addYTick(String string, double d) {
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(new Double(d));
        this._yticklabels.addElement(string);
    }

    public synchronized void clear(boolean bl) {
        this._xBottom = Double.MAX_VALUE;
        this._xTop = -1.7976931348623157E308;
        this._yBottom = Double.MAX_VALUE;
        this._yTop = -1.7976931348623157E308;
        if (bl) {
            this._yMax = 0.0;
            this._yMin = 0.0;
            this._xMax = 0.0;
            this._xMin = 0.0;
            this._xRangeGiven = false;
            this._yRangeGiven = false;
            this._xTickDistGiven = false;
            this._yTickDistGiven = false;
            this._originalXRangeGiven = false;
            this._originalYRangeGiven = false;
            this._rangesGivenByZooming = false;
            this._xlog = false;
            this._ylog = false;
            this._wrap = false;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            this._xticks = null;
            this._xticklabels = null;
            this._yticks = null;
            this._yticklabels = null;
        }
    }

    public synchronized void clearLegends() {
        this._legendStrings = new Vector();
        this._legendDatasets = new Vector();
    }

    public void deferIfNecessary(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            if (this._deferredActions == null) {
                this._deferredActions = new LinkedList();
            }
            this._deferredActions.add(runnable);
            if (!this._actionsDeferred) {
                Runnable runnable2 = new Runnable(){

                    public void run() {
                        PlotBox.this._executeDeferredActions();
                    }
                };
                try {
                    SwingUtilities.invokeLater(runnable2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._actionsDeferred = true;
            }
        }
    }

    public synchronized void export(OutputStream outputStream) {
        try {
            EPSGraphics ePSGraphics = new EPSGraphics(outputStream, this._width, this._height);
            this._drawPlot(ePSGraphics, false);
            ePSGraphics.showpage();
        }
        catch (RuntimeException runtimeException) {
            String string = "Export failed: " + runtimeException.getMessage();
            JOptionPane.showMessageDialog(this, string, "Ptolemy Plot Message", 0);
            throw (RuntimeException)runtimeException.fillInStackTrace();
        }
    }

    public synchronized BufferedImage exportImage() {
        Rectangle rectangle = new Rectangle(this._preferredWidth, this._preferredHeight);
        return this.exportImage(new BufferedImage(rectangle.width, rectangle.height, 2), rectangle, this._defaultImageRenderingHints(), false);
    }

    public synchronized BufferedImage exportImage(Rectangle rectangle) {
        return this.exportImage(new BufferedImage(rectangle.width, rectangle.height, 2), rectangle, this._defaultImageRenderingHints(), false);
    }

    public synchronized BufferedImage exportImage(BufferedImage bufferedImage, Rectangle rectangle, RenderingHints renderingHints, boolean bl) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.addRenderingHints(this._defaultImageRenderingHints());
        if (!bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
        }
        this._drawPlot(graphics2D, false, rectangle);
        return bufferedImage;
    }

    public synchronized BufferedImage exportImage(BufferedImage bufferedImage) {
        return this.exportImage(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()), this._defaultImageRenderingHints(), true);
    }

    public synchronized void fillPlot() {
        this.setXRange(this._xBottom, this._xTop);
        this.setYRange(this._yBottom, this._yTop);
        double d = 0.0;
        double d2 = -1.0;
        String string = new String();
        d2 = this.getXTickSpacing();
        d = this._xBottom;
        if (d2 > 0.0) {
            while (d < this._xTop) {
                string = Double.toString(d);
                string = string.substring(0, string.lastIndexOf(46) + 2);
                this.addXTick(Double.toString(d), d);
                d += d2;
            }
        }
        d2 = this.getYTickSpacing();
        d = this._yBottom;
        if (d2 > 0.0) {
            while (d < this._yTop) {
                string = Double.toString(d);
                string = string.substring(0, string.lastIndexOf(46) + 2);
                this.addYTick(Double.toString(d), d);
                d += d2;
            }
        }
        this.repaint();
    }

    public boolean getColor() {
        return this._usecolor;
    }

    /*
     * Unable to fully structure code
     */
    public static Color getColorByName(String var0) {
        try {
            if (var0.startsWith("#")) {
                var0 = var0.substring(1);
            }
            var1_1 = new Color(Integer.parseInt(var0, 16));
            return var1_1;
        }
        catch (NumberFormatException var1_2) {
            var1_3 = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}};
            var2_4 = 0;
            ** while (var2_4 < var1_3.length)
        }
lbl-1000:
        // 1 sources

        {
            if (var0.equals(var1_3[var2_4][0])) {
                try {
                    var3_6 = new Color(Integer.parseInt(var1_3[var2_4][1], 16));
                    return var3_6;
                }
                catch (NumberFormatException var3_5) {
                    // empty catch block
                }
            }
            ++var2_4;
            continue;
        }
lbl18:
        // 1 sources

        return null;
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public synchronized String getLegend(int n) {
        int n2 = this._legendDatasets.indexOf(new Integer(n), 0);
        if (n2 != -1) {
            return (String)this._legendStrings.elementAt(n2);
        }
        return null;
    }

    public synchronized Dimension getMaximumSize() {
        if (this._sizeHasBeenSet) {
            return new Dimension(this._preferredWidth, this._preferredHeight);
        }
        return super.getMaximumSize();
    }

    public synchronized Dimension getMinimumSize() {
        if (this._sizeHasBeenSet) {
            return new Dimension(this._preferredWidth, this._preferredHeight);
        }
        return super.getMinimumSize();
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this._preferredWidth, this._preferredHeight);
    }

    public synchronized String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public synchronized String getXLabel() {
        return this._xlabel;
    }

    public boolean getXLog() {
        return this._xlog;
    }

    public synchronized double[] getXRange() {
        double[] dArray = new double[2];
        if (this._xRangeGiven) {
            dArray[0] = this._xlowgiven;
            dArray[1] = this._xhighgiven;
        } else {
            dArray[0] = this._xMin + (this._xMax - this._xMin) * this._padding;
            dArray[1] = this._xMax - (this._xMax - this._xMin) * this._padding;
        }
        return dArray;
    }

    public synchronized Vector[] getXTicks() {
        if (this._xticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._xticks, this._xticklabels};
        return vectorArray;
    }

    public double getXTickSpacing() {
        if (this._xTickDistGiven) {
            return this._xtickdist;
        }
        return -1.0;
    }

    public String getYLabel() {
        return this._ylabel;
    }

    public boolean getYLog() {
        return this._ylog;
    }

    public synchronized double[] getYRange() {
        double[] dArray = new double[2];
        if (this._yRangeGiven) {
            dArray[0] = this._ylowgiven;
            dArray[1] = this._yhighgiven;
        } else {
            dArray[0] = this._yMin + (this._yMax - this._yMin) * this._padding;
            dArray[1] = this._yMax - (this._yMax - this._yMin) * this._padding;
        }
        return dArray;
    }

    public synchronized Vector[] getYTicks() {
        if (this._yticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._yticks, this._yticklabels};
        return vectorArray;
    }

    public double getYTickSpacing() {
        if (this._yTickDistGiven) {
            return this._ytickdist;
        }
        return -1.0;
    }

    public void init() {
        this.buttons.setButtons(true, Color.white);
        if (this._filespec != null) {
            this.parseFile(this._filespec, this._documentBase);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this._drawPlot(graphics, true);
    }

    public void parseFile(String string) {
        this.parseFile(string, null);
    }

    /*
     * Loose catch block
     */
    public synchronized void parseFile(String string, URL uRL) {
        block25: {
            Object object;
            DataInputStream dataInputStream = null;
            if (string == null || string.length() == 0) {
                dataInputStream = new DataInputStream(System.in);
            } else {
                try {
                    object = null;
                    if (uRL == null && this._documentBase != null) {
                        uRL = this._documentBase;
                    }
                    if (uRL == null) {
                        object = new URL(string);
                    } else {
                        try {
                            object = new URL(uRL, string);
                        }
                        catch (NullPointerException nullPointerException) {
                            object = new URL(string);
                        }
                    }
                    dataInputStream = new DataInputStream(((URL)object).openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        dataInputStream = new DataInputStream(new FileInputStream(string));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this._errorMsg = new String[2];
                        this._errorMsg[0] = "File not found: " + string;
                        this._errorMsg[1] = fileNotFoundException.getMessage();
                        return;
                    }
                    catch (SecurityException securityException) {
                        this._errorMsg = new String[2];
                        this._errorMsg[0] = "Security Exception: " + string;
                        this._errorMsg[1] = securityException.getMessage();
                        return;
                    }
                }
                catch (IOException iOException) {
                    this._errorMsg = new String[3];
                    this._errorMsg[0] = "Failure opening URL: ";
                    this._errorMsg[1] = " " + string;
                    this._errorMsg[2] = iOException.getMessage();
                    return;
                }
            }
            object = new BufferedReader(new InputStreamReader(dataInputStream));
            String string2 = ((BufferedReader)object).readLine();
            while (string2 != null) {
                this._parseLine(string2);
                string2 = ((BufferedReader)object).readLine();
            }
            Object var8_13 = null;
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            break block25;
            {
                catch (MalformedURLException malformedURLException) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Malformed URL: " + string;
                    this._errorMsg[1] = malformedURLException.getMessage();
                    Object var8_14 = null;
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                catch (IOException iOException) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Failure reading data: " + string;
                    this._errorMsg[1] = iOException.getMessage();
                    this._errorMsg[1] = iOException.getMessage();
                    Object var8_15 = null;
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (graphics == null) {
            return 1;
        }
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.scale(d3, d3);
        this._drawPlot(graphics, true);
        return 0;
    }

    public void printPlotBox() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                Container container = this.getTopLevelAncestor();
                JOptionPane.showMessageDialog(container, "Printing failed:\n" + exception.toString(), "Print Error", 2);
            }
        }
    }

    public synchronized void read(InputStream inputStream) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    this._parseLine(string);
                    string = bufferedReader.readLine();
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            {
            }
        }
        catch (IOException iOException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading input data.";
            this._errorMsg[1] = iOException.getMessage();
            throw iOException;
        }
    }

    public synchronized void read(String string) {
        this._parseLine(string);
    }

    public synchronized void removeLegend(int n) {
        int n2 = this._legendDatasets.size();
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2 && !bl) {
            if ((Integer)this._legendDatasets.get(n4) == n) {
                n3 = n4;
                bl = true;
            }
            ++n4;
        }
        if (bl) {
            this._legendDatasets.remove(n3);
            this._legendStrings.remove(n3);
        }
    }

    public synchronized void resetAxes() {
        this.setXRange(this._originalXlow, this._originalXhigh);
        this.setYRange(this._originalYlow, this._originalYhigh);
        this.repaint();
    }

    public void samplePlot() {
    }

    public void setBackground(Color color) {
        this._background = color;
        super.setBackground(this._background);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        this._width = n3;
        this._height = n4;
        super.setBounds(n, n2, this._width, this._height);
    }

    public void redrawHistogram(double d) {
        this.pva.redrawHistograms(d);
        this.repaint();
    }

    public void setColor(boolean bl) {
        this._usecolor = bl;
    }

    public void setDataurl(String string) {
        this._filespec = string;
    }

    public void setDocumentBase(URL uRL) {
        this._documentBase = uRL;
    }

    public void setForeground(Color color) {
        this._foreground = color;
        super.setForeground(this._foreground);
    }

    public void setGrid(boolean bl) {
        this._grid = bl;
    }

    public void setLabelFont(String string) {
        this._labelFont = Font.decode(string);
        this._labelFontMetrics = ((Component)this).getFontMetrics(this._labelFont);
    }

    public void setSize(int n, int n2) {
        this._width = n;
        this._height = n2;
        this._preferredWidth = n;
        this._preferredHeight = n2;
        this._sizeHasBeenSet = true;
        super.setSize(n, n2);
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public void setTitleFont(String string) {
        this._titleFont = Font.decode(string);
        this._titleFontMetrics = ((Component)this).getFontMetrics(this._titleFont);
    }

    public void setWrap(boolean bl) {
        this._wrap = bl;
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this.setXRange(0.0, 0.0);
            } else {
                this.setXRange(this._xBottom, this._xTop);
            }
        }
        this._wrapLow = this._xlowgiven;
        this._wrapHigh = this._xhighgiven;
    }

    public void setXLabel(String string) {
        this._xlabel = string;
    }

    public void setXTickSpacing(double d) {
        this._xTickDistGiven = true;
        this._xtickdist = d;
    }

    public void setXLog(boolean bl) {
        this._xlog = bl;
    }

    public synchronized void setXRange(double d, double d2) {
        this._xRangeGiven = true;
        this._xlowgiven = d;
        this._xhighgiven = d2;
        if (!this._originalXRangeGiven) {
            this._originalXlow = d;
            this._originalXhigh = d2;
            this._originalXRangeGiven = true;
        }
        this._setXRange(d, d2);
    }

    public void setYLabel(String string) {
        this._ylabel = string;
    }

    public void setYTickSpacing(double d) {
        this._yTickDistGiven = true;
        this._ytickdist = d;
    }

    public void setYLog(boolean bl) {
        this._ylog = bl;
    }

    public synchronized void setYRange(double d, double d2) {
        this._yRangeGiven = true;
        this._ylowgiven = d;
        this._yhighgiven = d2;
        if (!this._originalYRangeGiven) {
            this._originalYlow = d;
            this._originalYhigh = d2;
            this._originalYRangeGiven = true;
        }
        this._setYRange(d, d2);
    }

    public void write(OutputStream outputStream) {
        this.write(outputStream, null);
    }

    public synchronized void write(OutputStream outputStream, String string) {
        this.write(new OutputStreamWriter(outputStream), string);
    }

    public synchronized void write(Writer writer, String string) {
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(writer), false);
        if (string == null) {
            printWriter.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            printWriter.println("<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML 1//EN\"");
            printWriter.println("    \"http://ptolemy.eecs.berkeley.edu/xml/dtd/PlotML_1.dtd\">");
        } else {
            printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE plot SYSTEM \"" + string + "\">");
        }
        printWriter.println("<plot>");
        printWriter.println("<!-- Ptolemy plot, version 5.2 , PlotML format. -->");
        this.writeFormat(printWriter);
        this.writeData(printWriter);
        printWriter.println("</plot>");
        printWriter.flush();
    }

    public synchronized void writeData(PrintWriter printWriter) {
    }

    public synchronized void writeFormat(PrintWriter printWriter) {
        int n;
        int n2;
        if (this._title != null) {
            printWriter.println("<title>" + this._title + "</title>");
        }
        if (this._xlabel != null) {
            printWriter.println("<xLabel>" + this._xlabel + "</xLabel>");
        }
        if (this._ylabel != null) {
            printWriter.println("<yLabel>" + this._ylabel + "</yLabel>");
        }
        if (this._xRangeGiven) {
            printWriter.println("<xRange min=\"" + this._xlowgiven + "\" max=\"" + this._xhighgiven + "\"/>");
        }
        if (this._yRangeGiven) {
            printWriter.println("<yRange min=\"" + this._ylowgiven + "\" max=\"" + this._yhighgiven + "\"/>");
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.println("<xTicks>");
            n2 = this._xticks.size() - 1;
            n = 0;
            while (n <= n2) {
                printWriter.println("  <tick label=\"" + (String)this._xticklabels.elementAt(n) + "\" position=\"" + (Double)this._xticks.elementAt(n) + "\"/>");
                ++n;
            }
            printWriter.println("</xTicks>");
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.println("<yTicks>");
            n2 = this._yticks.size() - 1;
            n = 0;
            while (n <= n2) {
                printWriter.println("  <tick label=\"" + (String)this._yticklabels.elementAt(n) + "\" position=\"" + (Double)this._yticks.elementAt(n) + "\"/>");
                ++n;
            }
            printWriter.println("</yTicks>");
        }
        if (this._xlog) {
            printWriter.println("<xLog/>");
        }
        if (this._ylog) {
            printWriter.println("<yLog/>");
        }
        if (!this._grid) {
            printWriter.println("<noGrid/>");
        }
        if (this._wrap) {
            printWriter.println("<wrap/>");
        }
        if (!this._usecolor) {
            printWriter.println("<noColor/>");
        }
    }

    public synchronized void writeOldSyntax(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream), false);
        this._writeOldSyntax(printWriter);
        printWriter.flush();
        if (outputStream != System.out) {
            printWriter.close();
        }
    }

    public synchronized void zoom(double d, double d2, double d3, double d4) {
        this._setXRange(d, d3);
        this._setYRange(d2, d4);
        this.repaint();
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        Rectangle rectangle = this.getBounds();
        this._drawPlot(graphics, bl, rectangle);
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        double d;
        Object object;
        int n4;
        Object object2;
        int n5;
        Object object3;
        if (graphics == null) {
            return;
        }
        graphics.setPaintMode();
        if (this._errorMsg != null) {
            int n6;
            int n7 = n6 = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            int n8 = 0;
            while (n8 < this._errorMsg.length) {
                graphics.drawString(this._errorMsg[n8], 10, n7);
                n7 += n6;
                System.err.println(this._errorMsg[n8]);
                ++n8;
            }
            return;
        }
        int n9 = 0;
        int n10 = 0;
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        int n11 = 0;
        int n12 = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            n11 = n12 + this._topPadding;
        }
        Font font = graphics.getFont();
        graphics.setFont(this._labelFont);
        graphics.setColor(this._foreground);
        int n13 = this._labelFontMetrics.getHeight();
        int n14 = n13 / 2;
        int n15 = rectangle.height - 5;
        int n16 = rectangle.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String string = Integer.toString(this._xExp);
            n16 -= this._superscriptFontMetrics.stringWidth(string);
            graphics.setFont(this._superscriptFont);
            if (!this._xlog) {
                graphics.drawString(string, n16 + 10, n15 - 20 - n14);
                graphics.setFont(this._labelFont);
                graphics.drawString("x10", (n16 -= this._labelFontMetrics.stringWidth("x10")) + 10, n15 - 20);
            }
            this._bottomPadding = 3 * n13 / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < n13 + 5) {
            this._bottomPadding = n13 + 5;
        }
        this._uly = n11 + 5;
        this._lry = rectangle.height - n13 - this._bottomPadding - 3;
        int n17 = this._lry - this._uly;
        this._yscale = (double)n17 / (this._yMax - this._yMin);
        this._ytickscale = (double)n17 / (this._ytickMax - this._ytickMin);
        int n18 = 2 + n17 / (n13 + 10);
        double d2 = this._roundUp((this._ytickMax - this._ytickMin) / (double)n18);
        double d3 = d2 * Math.ceil(this._ytickMin / d2);
        int n19 = 0;
        String[] stringArray = new String[n18];
        int[] nArray = new int[n18];
        int n20 = 0;
        if (this._yticks == null) {
            object3 = null;
            if (this._ylog) {
                object3 = this._gridInit(d3, d2, true, null);
            }
            n10 = n5 = this._numFracDigits(d2);
            double d4 = d3;
            if (this._ylog) {
                d4 = this._gridStep((Vector)object3, d3, d2, this._ylog);
            }
            double d5 = d4;
            while (d5 <= this._ytickMax) {
                if (n20 < n18) {
                    object2 = this._ylog ? this._formatLogNum(d5, n5) : this._formatNum(d5, n5);
                    stringArray[n20] = object2;
                    n4 = this._labelFontMetrics.stringWidth((String)object2);
                    nArray[n20++] = n4;
                    if (n4 > n19) {
                        n19 = n4;
                    }
                    d5 = this._gridStep((Vector)object3, d5, d2, this._ylog);
                    continue;
                }
                break;
            }
        } else {
            object3 = this._yticklabels.elements();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                int n21 = this._labelFontMetrics.stringWidth(string);
                if (n21 <= n19) continue;
                n19 = n21;
            }
        }
        this._ulx = this._ylabel != null ? n19 + this._labelFontMetrics.stringWidth("W") + this._leftPadding : n19 + this._leftPadding;
        int n22 = this._drawLegend(graphics, rectangle.width - this._rightPadding, this._uly);
        this._lrx = rectangle.width - n22 - this._rightPadding;
        n5 = this._lrx - this._ulx;
        this._xscale = (double)n5 / (this._xMax - this._xMin);
        this._xtickscale = (double)n5 / (this._xtickMax - this._xtickMin);
        graphics.setColor(Color.white);
        graphics.fillRect(this._ulx, this._uly, n5, n17);
        graphics.setColor(this._foreground);
        graphics.drawRect(this._ulx, this._uly, n5, n17);
        int n23 = 5;
        int n24 = this._ulx + n23;
        int n25 = this._lrx - n23;
        if (this._yticks == null) {
            object = null;
            double d6 = d3;
            if (this._ylog) {
                object = this._gridInit(d3, d2, true, null);
                d6 = this._gridStep((Vector)object, d3, d2, this._ylog);
                n18 = n20;
            }
            n20 = 0;
            boolean bl2 = this._ylog;
            d = d6;
            while (d <= this._ytickMax) {
                if (n20 >= n18) break;
                n3 = this._lry - (int)((d - this._ytickMin) * this._ytickscale);
                int n26 = 0;
                if (n20 > 0 && !this._ylog) {
                    n26 = n14;
                }
                graphics.drawLine(this._ulx, n3, n24, n3);
                graphics.drawLine(this._lrx, n3, n25, n3);
                if (this._grid && n3 != this._uly && n3 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n24, n3, n25, n3);
                    graphics.setColor(this._foreground);
                }
                if (this._ylog && stringArray[n20].indexOf(101) != -1) {
                    bl2 = false;
                }
                graphics.drawString(stringArray[n20], this._ulx - nArray[n20] - 4, n3 + n26);
                ++n20;
                d = this._gridStep((Vector)object, d, d2, this._ylog);
            }
            if (this._ylog) {
                Vector vector = this._gridInit(d3, d2, false, (Vector)object);
                if (vector.size() > 0) {
                    double d7 = d2 > 1.0 ? 1.0 : d2;
                    double d8 = this._gridStep(vector, d3, d7, this._ylog);
                    while (d8 <= this._ytickMax) {
                        n2 = this._lry - (int)((d8 - this._ytickMin) * this._ytickscale);
                        if (this._grid && n2 != this._uly && n2 != this._lry) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(this._ulx + 1, n2, this._lrx - 1, n2);
                            graphics.setColor(this._foreground);
                        }
                        d8 = this._gridStep(vector, d8, d7, this._ylog);
                    }
                }
                this._yExp = bl2 ? (int)Math.floor(d6) : 0;
            }
            if (this._yExp != 0) {
                graphics.drawString("x10", 10, n11 - 4);
                graphics.setFont(this._superscriptFont);
                graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 10, n11 - 4 - n14);
                graphics.setFont(this._labelFont);
            }
        } else {
            object = this._yticks.elements();
            object2 = this._yticklabels.elements();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                double d9 = (Double)object.nextElement();
                if (d9 > this._yMax || d9 < this._yMin) continue;
                n = this._lry - (int)((d9 - this._yMin) * this._yscale);
                n3 = 0;
                if (d9 < (double)(this._lry - n13)) {
                    n3 = n14;
                }
                graphics.drawLine(this._ulx, n, n24, n);
                graphics.drawLine(this._lrx, n, n25, n);
                if (this._grid && n != this._uly && n != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n24, n, n25, n);
                    graphics.setColor(this._foreground);
                }
                graphics.drawString(string, this._ulx - this._labelFontMetrics.stringWidth(string) - 3, n + n3);
            }
        }
        int n27 = this._uly + n23;
        int n28 = this._lry - n23;
        n4 = this._labelFontMetrics.stringWidth("8");
        if (this._xticks == null) {
            int n29 = 10;
            d = 0.0;
            n3 = 0;
            if (this._xlog) {
                n29 = 2 + n5 / (n4 * 6 + 10);
            } else {
                int n30 = 0;
                while (n30++ <= 10) {
                    int n31;
                    int n32;
                    d = this._roundUp((this._xtickMax - this._xtickMin) / (double)n29);
                    n3 = this._numFracDigits(d);
                    int n33 = this._numIntDigits(this._xtickMax);
                    if (n33 < (n32 = this._numIntDigits(this._xtickMin))) {
                        n33 = n32;
                    }
                    if ((n29 = 2 + n5 / ((n31 = n4 * (n3 + 2 + n33)) + 10)) - (n2 = n29) <= 1 || n2 - n29 <= 1) break;
                }
            }
            d = this._roundUp((this._xtickMax - this._xtickMin) / (double)n29);
            n9 = n3 = this._numFracDigits(d);
            double d10 = d * Math.ceil(this._xtickMin / d);
            Vector vector = null;
            double d11 = d10;
            if (this._xlog) {
                vector = this._gridInit(d10, d, true, null);
                d11 = this._gridRoundUp(vector, d10);
            }
            boolean bl3 = this._xlog;
            double d12 = d11;
            while (d12 <= this._xtickMax) {
                String string;
                if (this._xlog) {
                    string = this._formatLogNum(d12, n3);
                    if (string.indexOf(101) != -1) {
                        bl3 = false;
                    }
                } else {
                    string = this._formatNum(d12, n3);
                }
                n24 = this._ulx + (int)((d12 - this._xtickMin) * this._xtickscale);
                graphics.drawLine(n24, this._uly, n24, n27);
                graphics.drawLine(n24, this._lry, n24, n28);
                if (this._grid && n24 != this._ulx && n24 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n24, n27, n24, n28);
                    graphics.setColor(this._foreground);
                }
                int n34 = n24 - this._labelFontMetrics.stringWidth(string) / 2;
                graphics.drawString(string, n34, this._lry + 3 + n13);
                d12 = this._gridStep(vector, d12, d, this._xlog);
            }
            if (this._xlog) {
                double d13 = d > 1.0 ? 1.0 : d;
                d11 = d13 * Math.ceil(this._xtickMin / d13);
                Vector vector2 = this._gridInit(d11, d13, false, vector);
                if (vector2.size() > 0) {
                    double d14 = this._gridStep(vector2, d11, d13, this._xlog);
                    while (d14 <= this._xtickMax) {
                        n24 = this._ulx + (int)((d14 - this._xtickMin) * this._xtickscale);
                        if (this._grid && n24 != this._ulx && n24 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(n24, this._uly + 1, n24, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        d14 = this._gridStep(vector2, d14, d13, this._xlog);
                    }
                }
                if (bl3) {
                    this._xExp = (int)Math.floor(d11);
                    graphics.setFont(this._superscriptFont);
                    graphics.drawString(Integer.toString(this._xExp), n16 + 10, n15 - 20 - n14);
                    graphics.setFont(this._labelFont);
                    graphics.drawString("x10", (n16 -= this._labelFontMetrics.stringWidth("x10")) + 10, n15 - 20);
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration enumeration = this._xticks.elements();
            Enumeration enumeration2 = this._xticklabels.elements();
            double d15 = 0.0;
            while (enumeration2.hasMoreElements()) {
                int n35;
                String string = (String)enumeration2.nextElement();
                double d16 = (Double)enumeration.nextElement();
                if (d16 > this._xMax || d16 < this._xMin || !((double)(n35 = (n24 = this._ulx + (int)((d16 - this._xMin) * this._xscale)) - this._labelFontMetrics.stringWidth(string) / 2) > d15)) continue;
                d15 = n24 + this._labelFontMetrics.stringWidth(string) / 2 + 10;
                graphics.drawString(string, n35, this._lry + 3 + n13);
                graphics.drawLine(n24, this._uly, n24, n27);
                graphics.drawLine(n24, this._lry, n24, n28);
                if (!this._grid || n24 == this._ulx || n24 == this._lrx) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n24, n27, n24, n28);
                graphics.setColor(this._foreground);
            }
        }
        graphics.setColor(this._foreground);
        if (this._title != null) {
            graphics.setFont(this._titleFont);
            int n36 = this._ulx + (n5 - this._titleFontMetrics.stringWidth(this._title)) / 2;
            graphics.drawString(this._title, n36, n11);
        }
        graphics.setFont(this._labelFont);
        if (this._xlabel != null) {
            int n37 = this._ulx + (n5 - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
            graphics.drawString(this._xlabel, n37, n15);
        }
        int n38 = 2 + this._labelFontMetrics.stringWidth("W") / 2;
        if (this._ylabel != null) {
            int n39 = this._ylabel.length();
            if (graphics instanceof Graphics2D) {
                n = this._uly + (this._lry - this._uly) / 2 + this._labelFontMetrics.stringWidth(this._ylabel) / 2 - n4;
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n40 = n38 + n14 - 2;
                graphics2D.rotate(Math.toRadians(-90.0), n40, n);
                graphics2D.drawString(this._ylabel, n40, n);
                graphics2D.rotate(Math.toRadians(90.0), n40, n);
            } else {
                n = this._uly + (this._lry - this._uly) / 2 - n39 * n14 + n13;
                n3 = 0;
                while (n3 < n39) {
                    String string = this._ylabel.substring(n3, n3 + 1);
                    int n41 = this._labelFontMetrics.stringWidth(string);
                    graphics.drawString(string, n38 - n41 / 2, n);
                    n += n13;
                    ++n3;
                }
            }
        }
        graphics.setFont(font);
        this.xcoordFormat = this.getCoordDecimalFormat(n9, this._xExp);
        this.ycoordFormat = this.getCoordDecimalFormat(n10, this._yExp);
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (graphics == null) {
            return;
        }
        boolean bl5 = bl4 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl4 && bl) {
            return;
        }
        graphics.fillRect((int)l - 6, (int)l2 - 6, 6, 6);
    }

    protected void _help() {
        String string = "Ptolemy plot package\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.2, Build: $Id: PlotBox.java,v 1.42 2003/06/05 04:59:24 ranjan Exp $\n\nKey bindings:\n   Cntrl-c:  copy plot to clipboard (EPS format), if permitted\n   D: dump plot data to standard out\n   E: export plot to standard out (EPS format)\n   F: fill plot\n   H or ?: print help message (this message)\n   Cntrl-D or Q: quit\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n";
        JOptionPane.showMessageDialog(this, string, "Ptolemy Plot Help Window", 1);
    }

    protected boolean _parseLine(String string) {
        String string2 = new String(string.toLowerCase());
        if (string2.startsWith("#")) {
            return true;
        }
        if (string2.startsWith("titletext:")) {
            this.setTitle(string.substring(10).trim());
            return true;
        }
        if (string2.startsWith("title:")) {
            this.setTitle(string.substring(10).trim());
            return true;
        }
        if (string2.startsWith("xlabel:")) {
            this.setXLabel(string.substring(7).trim());
            return true;
        }
        if (string2.startsWith("ylabel:")) {
            this.setYLabel(string.substring(7).trim());
            return true;
        }
        if (string2.startsWith("xrange:")) {
            int n = string.indexOf(",", 7);
            if (n > 0) {
                String string3 = string.substring(7, n).trim();
                String string4 = string.substring(n + 1).trim();
                try {
                    Double d = new Double(string3);
                    Double d2 = new Double(string4);
                    this.setXRange(d, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string2.startsWith("yrange:")) {
            int n = string.indexOf(",", 7);
            if (n > 0) {
                String string5 = string.substring(7, n).trim();
                String string6 = string.substring(n + 1).trim();
                try {
                    Double d = new Double(string5);
                    Double d3 = new Double(string6);
                    this.setYRange(d, d3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string2.startsWith("xticks:")) {
            this._parsePairs(string.substring(7), true);
            return true;
        }
        if (string2.startsWith("yticks:")) {
            this._parsePairs(string.substring(7), false);
            return true;
        }
        if (string2.startsWith("xlog:")) {
            this._xlog = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("ylog:")) {
            this._ylog = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("grid:")) {
            this._grid = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("wrap:")) {
            this._wrap = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("color:")) {
            this._usecolor = string2.indexOf("off", 6) < 0;
            return true;
        }
        return false;
    }

    protected void _setButtonsVisibility(boolean bl) {
    }

    protected void _setPadding(double d) {
        this._padding = d;
    }

    protected void _writeOldSyntax(PrintWriter printWriter) {
        int n;
        int n2;
        printWriter.println("# Ptolemy plot, version 2.0");
        if (this._title != null) {
            printWriter.println("TitleText: " + this._title);
        }
        if (this._xlabel != null) {
            printWriter.println("XLabel: " + this._xlabel);
        }
        if (this._ylabel != null) {
            printWriter.println("YLabel: " + this._ylabel);
        }
        if (this._xRangeGiven) {
            printWriter.println("XRange: " + this._xlowgiven + ", " + this._xhighgiven);
        }
        if (this._yRangeGiven) {
            printWriter.println("YRange: " + this._ylowgiven + ", " + this._yhighgiven);
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.print("XTicks: ");
            n2 = this._xticks.size() - 1;
            n = 0;
            while (n < n2) {
                printWriter.print("\"" + (String)this._xticklabels.elementAt(n) + "\" " + (Double)this._xticks.elementAt(n) + ", ");
                ++n;
            }
            printWriter.println("\"" + (String)this._xticklabels.elementAt(n2) + "\" " + (Double)this._xticks.elementAt(n2));
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.print("YTicks: ");
            n2 = this._yticks.size() - 1;
            n = 0;
            while (n < n2) {
                printWriter.print("\"" + (String)this._yticklabels.elementAt(n) + "\" " + (Double)this._yticks.elementAt(n) + ", ");
                ++n;
            }
            printWriter.println("\"" + (String)this._yticklabels.elementAt(n2) + "\" " + (Double)this._yticks.elementAt(n2));
        }
        if (this._xlog) {
            printWriter.println("XLog: on");
        }
        if (this._ylog) {
            printWriter.println("YLog: on");
        }
        if (!this._grid) {
            printWriter.println("Grid: off");
        }
        if (this._wrap) {
            printWriter.println("Wrap: on");
        }
        if (!this._usecolor) {
            printWriter.println("Color: off");
        }
    }

    private int _drawLegend(Graphics graphics, int n, int n2) {
        if (graphics == null) {
            return 0;
        }
        Font font = graphics.getFont();
        graphics.setFont(this._labelFont);
        int n3 = this._labelFontMetrics.getHeight();
        Enumeration enumeration = this._legendStrings.elements();
        Enumeration enumeration2 = this._legendDatasets.elements();
        int n4 = n2 + n3;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            int n6;
            String string = (String)enumeration.nextElement();
            int n7 = (Integer)enumeration2.nextElement();
            if (n7 < 0) continue;
            if (this._usecolor) {
                n6 = n7 % _colors.length;
                graphics.setColor(_colors[n6]);
            }
            this._drawPoint(graphics, n7, n - 3, n4 - 3, false, false, false);
            graphics.setColor(this._foreground);
            n6 = this._labelFontMetrics.stringWidth(string);
            if (n6 > n5) {
                n5 = n6;
            }
            graphics.drawString(string, n - 15 - n6, n4);
            n4 += n3;
        }
        graphics.setFont(font);
        return 22 + n5;
    }

    private synchronized void _executeDeferredActions() {
        try {
            Iterator iterator = this._deferredActions.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                runnable.run();
            }
            Object var4_3 = null;
            this._actionsDeferred = false;
            this._deferredActions.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._actionsDeferred = false;
            this._deferredActions.clear();
            throw throwable;
        }
    }

    private String _formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : (n2 < 0 && n2 > -10 ? "-0" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)), n)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n));
        return string;
    }

    private String _formatNum(double d, int n) {
        double d2 = 0.5;
        if (d < 0.0) {
            d2 = -0.5;
        }
        String string = Double.toString(d + d2 * Math.pow(10.0, -n));
        int n2 = string.lastIndexOf(".");
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0) {
            if (n <= 0) {
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
            stringBuffer.append(".");
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append("0");
                ++n3;
            }
            return stringBuffer.toString();
        }
        int n4 = n - (string.length() - n2 - 1);
        if (n4 <= 0) {
            int n5 = n2 + n + 1;
            if (n == 0) {
                --n5;
            }
            stringBuffer.append(string.substring(0, n5));
            return stringBuffer.toString();
        }
        stringBuffer.append(string);
        int n6 = 0;
        while (n6 < n4) {
            stringBuffer.append("0");
            ++n6;
        }
        return stringBuffer.toString();
    }

    private Vector _gridInit(double d, double d2, boolean bl, Vector vector) {
        double d3;
        Vector<Double> vector2 = new Vector<Double>(10);
        double d4 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d4 <= 3.5) {
                n = d4 > 2.0 ? 2 : (d4 > 1.26 ? 5 : (d4 > 1.125 ? 10 : (int)Math.rint(1.0 / d2)));
            }
        } else {
            n = d4 > 10.0 ? 1 : (d4 > 3.0 ? 2 : (d4 > 2.0 ? 5 : (d4 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            d3 = (double)n3 * 1.0 / (double)n * 10.0;
            double d5 = _LOG10SCALE * Math.log(d3);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (vector != null && n2 < vector.size()) {
                while (n2 < vector.size() && (Double)vector.elementAt(n2) < d5) {
                    ++n2;
                }
                if (n2 < vector.size()) {
                    if (Math.abs((Double)vector.elementAt(n2) - d5) > 1.0E-5) {
                        vector2.addElement(new Double(d5));
                    }
                } else {
                    vector2.addElement(new Double(d5));
                }
            } else {
                vector2.addElement(new Double(d5));
            }
            ++n3;
        }
        this._gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this._gridBase = Math.floor(d);
        d3 = d - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < vector2.size() && d3 > (Double)vector2.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return vector2;
    }

    private double _gridRoundUp(Vector vector, double d) {
        double d2 = d - Math.floor(d);
        int n = 0;
        while (n < vector.size() && d2 >= (Double)vector.elementAt(n)) {
            ++n;
        }
        if (n >= vector.size()) {
            return d;
        }
        return Math.floor(d) + (Double)vector.elementAt(n);
    }

    private double _gridStep(Vector vector, double d, double d2, boolean bl) {
        if (bl) {
            if (++this._gridCurJuke >= vector.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(d2);
            }
            if (this._gridCurJuke >= vector.size()) {
                return d + d2;
            }
            return this._gridBase + (Double)vector.elementAt(this._gridCurJuke);
        }
        return d + d2;
    }

    private void _measureFonts() {
        if (this._labelFont == null) {
            this._labelFont = Font.decode("Helvetica-PLAIN-12");
        }
        if (this._superscriptFont == null) {
            this._superscriptFont = Font.decode("Helvetica-PLAIN-9");
        }
        if (this._titleFont == null) {
            this._titleFont = Font.decode("Helvetica-BOLD-14");
        }
        this._labelFontMetrics = ((Component)this).getFontMetrics(this._labelFont);
        this._superscriptFontMetrics = ((Component)this).getFontMetrics(this._superscriptFont);
        this._titleFontMetrics = ((Component)this).getFontMetrics(this._titleFont);
    }

    private int _numFracDigits(double d) {
        int n = 0;
        while (n <= 15 && d != Math.floor(d)) {
            d *= 10.0;
            ++n;
        }
        return n;
    }

    private int _numIntDigits(double d) {
        int n = 0;
        while (n <= 15 && (double)((int)d) != 0.0) {
            d /= 10.0;
            ++n;
        }
        return n;
    }

    private void _parsePairs(String string, boolean bl) {
        if (bl) {
            this._xticks = null;
            this._xticklabels = null;
        } else {
            this._yticks = null;
            this._yticklabels = null;
        }
        int n = 0;
        boolean bl2 = true;
        while (bl2) {
            int n2 = string.indexOf(",", n);
            String string2 = null;
            if (n2 > n) {
                string2 = string.substring(n, n2).trim();
            } else {
                string2 = string.substring(n).trim();
                bl2 = false;
            }
            int n3 = -1;
            int n4 = 0;
            if (string2.startsWith("\"")) {
                n3 = string2.indexOf("\"", 1);
                n4 = 1;
            } else {
                n3 = string2.indexOf(" ");
            }
            if (n3 > 0) {
                String string3 = string2.substring(n4, n3);
                String string4 = string2.substring(n3 + 1).trim();
                try {
                    double d = Double.valueOf(string4);
                    if (bl) {
                        this.addXTick(string3, d);
                    } else {
                        this.addYTick(string3, d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning from PlotBox: Unable to parse ticks: " + numberFormatException.getMessage());
                }
            }
            n = n2 + 1;
            n2 = string.indexOf(",", n);
        }
    }

    private RenderingHints _defaultImageRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return renderingHints;
    }

    private double _roundUp(double d) {
        int n;
        if ((d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * _LOG10SCALE)))) > 5.0) {
            d = 10.0;
        } else if (d > 2.0) {
            d = 5.0;
        } else if (d > 1.0) {
            d = 2.0;
        }
        return d *= Math.pow(10.0, n);
    }

    private void _setXRange(double d, double d2) {
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 1.0;
            d2 += 1.0;
        }
        this._xMin = d - (d2 - d) * this._padding;
        this._xMax = d2 + (d2 - d) * this._padding;
        double d3 = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._xExp > 1 || this._xExp < -1) {
            double d4 = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * d4;
            this._xtickMax = this._xMax * d4;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    private void _setYRange(double d, double d2) {
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 0.1;
            d2 += 0.1;
        }
        this._yMin = d - (d2 - d) * this._padding;
        this._yMax = d2 + (d2 - d) * this._padding;
        double d3 = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._yExp > 1 || this._yExp < -1) {
            double d4 = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * d4;
            this._ytickMax = this._yMax * d4;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    void _zoom(int n, int n2) {
        this._zooming = false;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        boolean bl = false;
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int n3 = Math.min(this._zoomx, this._zoomxn);
                int n4 = Math.max(this._zoomx, this._zoomxn);
                int n5 = Math.min(this._zoomy, this._zoomyn);
                int n6 = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(_boxColor);
                graphics.drawRect(n3, n5, n4 - n3, n6 - n5);
                graphics.setPaintMode();
                if (n2 > this._lry) {
                    n2 = this._lry;
                }
                if (n2 < this._uly) {
                    n2 = this._uly;
                }
                if (n > this._lrx) {
                    n = this._lrx;
                }
                if (n < this._ulx) {
                    n = this._ulx;
                }
                if (Math.abs(this._zoomx - n) > 5 && Math.abs(this._zoomy - n2) > 5) {
                    double d = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double d2 = this._xMin + (double)(n - this._ulx) / this._xscale;
                    if (this._buttonMode == 1) {
                        if (d < d2) {
                            this.setXRange(d, d2);
                        } else {
                            this.setXRange(d2, d);
                        }
                        d = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                        d2 = this._yMax - (double)(n2 - this._uly) / this._yscale;
                        if (d < d2) {
                            this.setYRange(d, d2);
                        } else {
                            this.setYRange(d2, d);
                        }
                    } else {
                        double d3;
                        double d4;
                        double d5;
                        double d6;
                        if (d < d2) {
                            d6 = d;
                            d5 = d2;
                        } else {
                            d6 = d2;
                            d5 = d;
                        }
                        d = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                        d2 = this._yMax - (double)(n2 - this._uly) / this._yscale;
                        if (d < d2) {
                            d4 = d;
                            d3 = d2;
                        } else {
                            d4 = d2;
                            d3 = d;
                        }
                        this.select(d6, d4, d5, d3);
                    }
                }
                this.repaint();
                bl = true;
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(_boxColor);
            int n7 = Math.abs(this._zoomx - this._zoomxn);
            int n8 = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - n7, this._zoomy - 15 - n8, 30 + n7 * 2, 30 + n8 * 2);
            graphics.setPaintMode();
            double d = (double)Math.abs(this._zoomx - n) / 30.0;
            double d7 = (double)Math.abs(this._zoomy - n2) / 30.0;
            double d8 = this._xMax + (this._xMax - this._xMin) * d;
            double d9 = this._xMin - (this._xMax - this._xMin) * d;
            double d10 = this._yMax + (this._yMax - this._yMin) * d7;
            double d11 = this._yMin - (this._yMax - this._yMin) * d7;
            if (this._buttonMode == 1) {
                this.zoom(d9, d11, d8, d10);
            } else {
                this.select(d9, d11, d8, d10);
            }
            bl = true;
        } else if (!this._drawn) {
            this.repaint();
            bl = true;
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    void select(double d, double d2, double d3, double d4) {
        if (this._buttonMode == 2) {
            this.pva.selectPointsWithin(true, d, d2, d3, d4);
        } else {
            this.pva.selectPointsWithin(false, d, d2, d3, d4);
        }
    }

    public void zoomSelect(String string) {
        if (string == "Zoom") {
            this._buttonMode = 1;
        } else if (string == "Select") {
            this._buttonMode = 2;
        } else if (string == "UnSelect") {
            this._buttonMode = 3;
        }
    }

    void _zoomBox(int n, int n2) {
        if (!this._zooming) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (n2 < this._zoomy) {
                    this._zoomout = true;
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (n2 > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int n3;
                int n4;
                int n5;
                int n6;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                }
                if (n2 > this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int n7;
                int n8;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                }
                if (n2 < this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    public void printCoord(int n, int n2, int n3, int n4, String string) {
        double d = this._xMin + (double)(n - this._ulx) / this._xscale;
        double d2 = this._xMin + (double)(n3 - this._ulx) / this._xscale;
        double d3 = this._yMax - (double)(n2 - this._uly) / this._yscale;
        double d4 = this._yMax - (double)(n4 - this._uly) / this._yscale;
        if (this._xlog) {
            d = Math.pow(10.0, d);
        }
        if (this._ylog) {
            d3 = Math.pow(10.0, d3);
        }
        System.out.println(string + " : " + d + ", " + d3 + ", " + d2 + ", " + d4);
    }

    private String getCoordDecimalFormat(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("#");
            ++n3;
        }
        stringBuffer.append("#");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("0.").append(stringBuffer.toString());
        if (n2 != 0) {
            stringBuffer2.append("E0");
        }
        return stringBuffer2.toString();
    }

    void _zoomStart(int n, int n2) {
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        this._zoomx = n;
        this._zoomy = n2;
        this._zooming = true;
    }

    class CommandListener
    implements KeyListener {
        private boolean _control = false;
        private boolean _shift = false;

        CommandListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 16: {
                    this._shift = true;
                    break;
                }
                case 67: {
                    if (!this._control) break;
                    PlotBox.this.export(null);
                    String string = "Encapsulated PostScript (EPS) exported to clipboard.";
                    JOptionPane.showMessageDialog(PlotBox.this, string, "Ptolemy Plot Message", 1);
                    break;
                }
                case 68: {
                    if (!this._control && this._shift) {
                        PlotBox.this.write(System.out);
                        String string = "Plot data sent to standard out.";
                        JOptionPane.showMessageDialog(PlotBox.this, string, "Ptolemy Plot Message", 1);
                    }
                    if (!this._control) break;
                    System.exit(1);
                    break;
                }
                case 69: {
                    if (this._control || !this._shift) break;
                    PlotBox.this.export(System.out);
                    String string = "Encapsulated PostScript (EPS) exported to standard out.";
                    JOptionPane.showMessageDialog(PlotBox.this, string, "Ptolemy Plot Message", 1);
                    break;
                }
                case 70: {
                    if (this._control || !this._shift) break;
                    PlotBox.this.fillPlot();
                    break;
                }
                case 72: {
                    if (this._control || !this._shift) break;
                    PlotBox.this._help();
                    break;
                }
                case 81: {
                    if (this._control) break;
                    System.exit(1);
                    break;
                }
                case 47: {
                    if (!this._shift) break;
                    PlotBox.this._help();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = false;
                    break;
                }
                case 16: {
                    this._shift = false;
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class DragListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            PlotBox.this._zoomBox(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            double d = PlotBox.this._xMin + (double)(mouseEvent.getX() - PlotBox.this._ulx) / PlotBox.this._xscale;
            double d2 = PlotBox.this._yMax - (double)(mouseEvent.getY() - PlotBox.this._uly) / PlotBox.this._yscale;
            if (d <= PlotBox.this._xMax && d >= PlotBox.this._xMin && d2 <= PlotBox.this._yMax && d2 >= PlotBox.this._yMin) {
                if (PlotBox.this._xlog) {
                    d = Math.pow(10.0, d);
                }
                if (PlotBox.this._ylog) {
                    d2 = Math.pow(10.0, d2);
                }
                DecimalFormat decimalFormat = new DecimalFormat(PlotBox.this.xcoordFormat);
                DecimalFormat decimalFormat2 = new DecimalFormat(PlotBox.this.ycoordFormat);
                PlotBox.this.buttons.showCoordinates(decimalFormat.format(d), decimalFormat2.format(d2));
            }
        }
    }

    public class ZoomListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            PlotBox.this.requestFocus();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                PlotBox.this._zoomStart(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                PlotBox.this._zoom(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

