/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotApplet
extends JApplet {
    private transient PlotBox _plot;

    public String getAppletInfo() {
        return "PlotApplet 5.2: A data plotter.\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n Christopher Hylands, cxh@eecs.berkeley.edu\n($Id: PlotApplet.java,v 1.3 2003/01/21 07:13:09 sudip Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"dataurl", "url", "the URL of the data to plot"}, {"height", "integer", "100"}, {"width", "integer", "100"}};
        return stringArray;
    }

    public void init() {
        super.init();
        if (this._plot == null) {
            this._plot = this.newPlot();
        }
        this.getContentPane().add((Component)this.plot(), "North");
        String string = this.getParameter("width");
        int n = string != null ? Integer.parseInt(string) : 400;
        String string2 = this.getParameter("height");
        int n2 = string2 != null ? Integer.parseInt(string2) : 400;
        this._setPlotSize(n, n2);
        Color color = Color.white;
        String string3 = this.getParameter("background");
        if (string3 != null) {
            color = PlotBox.getColorByName(string3);
        }
        this.setBackground(color);
        this.plot().setBackground(color);
        this.getContentPane().setBackground(color);
        Color color2 = Color.black;
        string3 = this.getParameter("foreground");
        if (string3 != null) {
            color2 = PlotBox.getColorByName(string3);
        }
        this.setForeground(color2);
        this.plot().setForeground(color2);
        this.plot().setVisible(true);
        String string4 = this.getParameter("dataurl");
        if (string4 != null) {
            try {
                this.showStatus("Reading data");
                URL uRL = new URL(this.getDocumentBase(), string4);
                InputStream inputStream = uRL.openStream();
                this._read(inputStream);
                this.showStatus("Done");
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("PlotApplet: file not found: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println("PlotApplet: error reading input file: " + iOException);
            }
        }
    }

    public PlotBox newPlot() {
        return new Plot();
    }

    public PlotBox plot() {
        return this._plot;
    }

    protected void _read(InputStream inputStream) throws IOException {
        this.plot().read(inputStream);
    }

    protected void _setPlotSize(int n, int n2) {
        this.plot().setSize(n, n2);
    }
}

