/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComponent;
import ptolemy.plot.EPSGraphics;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class Plot
extends PlotBox {
    public Vector _points = new Vector();
    protected int _currentdataset = -1;
    protected int _marks;
    private int _pointsPersistence = 0;
    private double _xPersistence = 0.0;
    private boolean _bars = false;
    private double barWidth = 0.5;
    private double _barOffset = 0.05;
    private boolean _connected = false;
    private boolean _impulses = false;
    private int _maxDataset = -1;
    private boolean _reuseDatasets = false;
    private boolean _firstInSet = true;
    private boolean _sawFirstDataSet = false;
    private int _radius = 3;
    private int _diameter = 6;
    private Vector _prevx = new Vector();
    private Vector _prevy = new Vector();
    private static final int _ERRORBAR_LEG_LENGTH = 5;
    private static final int _MAX_MARKS = 10;
    private boolean _xyInvalid = true;
    private String _filename = null;
    private boolean _showing = false;
    private Vector _formats = new Vector();
    private final Color HIGHLIGHT_COLOR = new Color(0xFF0000);

    public synchronized void addLegend(int n, String string) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string);
    }

    public synchronized void addPoint(final int n, final double d, final double d2, final String string, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot.this._addPoint(n, d, d2, 0.0, 0.0, bl, false, false, string);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void addPointWithErrorBars(final int n, final double d, final double d2, final double d3, final double d4, final String string, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot.this._addPoint(n, d, d2, d3, d4, bl, true, false, string);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void addPointWithErrorBars(int n, double d, double d2, double d3, double d4, String string, boolean bl, boolean bl2) {
        if (bl2) {
            this._addPoint(n, d, d2, d3, d4, bl, true, true, string);
        } else {
            this.addPointWithErrorBars(n, d, d2, d3, d4, string, bl);
        }
    }

    public synchronized void clear(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot.this._clear(bl);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void clear(boolean bl, boolean bl2) {
        if (bl2) {
            this._clear(bl);
        } else {
            this.clear(bl);
        }
    }

    public synchronized void clear(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot.this._clear(n);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void clear(int n, boolean bl) {
        if (bl) {
            this._clear(n);
        } else {
            this.clear(n);
        }
    }

    public synchronized void erasePoint(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot.this._erasePoint(n, n2);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void erasePoint(int n, int n2, boolean bl) {
        if (bl) {
            this._erasePoint(n, n2);
        } else {
            this.erasePoint(n, n2);
        }
    }

    public synchronized void fillPlot() {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot.this._fillPlot();
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void fillPlot(boolean bl) {
        if (bl) {
            this._fillPlot();
        } else {
            this.fillPlot();
        }
    }

    public boolean getConnected() {
        return this._connected;
    }

    public boolean getImpulses() {
        return this._impulses;
    }

    public synchronized String getMarksStyle() {
        if (this._marks == 0) {
            return "none";
        }
        if (this._marks == 1) {
            return "points";
        }
        if (this._marks == 2) {
            return "dots";
        }
        if (this._marks == 3) {
            return "various";
        }
        return "pixels";
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public synchronized int getNumDataSets() {
        return this._points.size();
    }

    public void parseFile(String string, URL uRL) {
        this._firstInSet = true;
        this._sawFirstDataSet = false;
        super.parseFile(string, uRL);
    }

    public synchronized void read(InputStream inputStream) throws IOException {
        super.read(inputStream);
        this._firstInSet = true;
        this._sawFirstDataSet = false;
    }

    public synchronized void samplePlot() {
        Runnable runnable = new Runnable(){

            public void run() {
                Plot plot = Plot.this;
                synchronized (plot) {
                    Plot.this.clear(true);
                    Plot.this.setTitle("Sample plot");
                    Plot.this.setYRange(-4.0, 4.0);
                    Plot.this.setXRange(0.0, 100.0);
                    Plot.this.setXLabel("time");
                    Plot.this.setYLabel("value");
                    Plot.this.addYTick("-PI", -Math.PI);
                    Plot.this.addYTick("-PI/2", -1.5707963267948966);
                    Plot.this.addYTick("0", 0.0);
                    Plot.this.addYTick("PI/2", 1.5707963267948966);
                    Plot.this.addYTick("PI", Math.PI);
                    Plot.this.setMarksStyle("none");
                    Plot.this.setImpulses(true);
                    boolean bl = true;
                    int n = 0;
                    while (n <= 100) {
                        double d = n;
                        Plot.this.addPoint(0, d, 5.0 * Math.cos(Math.PI * (double)n / 20.0), "x", !bl);
                        Plot.this.addPoint(1, d, 4.5 * Math.cos(Math.PI * (double)n / 25.0), "x", !bl);
                        Plot.this.addPoint(2, d, 4.0 * Math.cos(Math.PI * (double)n / 30.0), "x", !bl);
                        Plot.this.addPoint(3, d, 3.5 * Math.cos(Math.PI * (double)n / 35.0), "x", !bl);
                        Plot.this.addPoint(4, d, 3.0 * Math.cos(Math.PI * (double)n / 40.0), "x", !bl);
                        Plot.this.addPoint(5, d, 2.5 * Math.cos(Math.PI * (double)n / 45.0), "x", !bl);
                        Plot.this.addPoint(6, d, 2.0 * Math.cos(Math.PI * (double)n / 50.0), "x", !bl);
                        Plot.this.addPoint(7, d, 1.5 * Math.cos(Math.PI * (double)n / 55.0), "x", !bl);
                        Plot.this.addPoint(8, d, 1.0 * Math.cos(Math.PI * (double)n / 60.0), "x", !bl);
                        Plot.this.addPoint(9, d, 0.5 * Math.cos(Math.PI * (double)n / 65.0), "x", !bl);
                        bl = false;
                        ++n;
                    }
                }
                Plot.this.repaint();
            }
        };
        this.deferIfNecessary(runnable);
    }

    public void setBars(boolean bl) {
        this._bars = bl;
    }

    public synchronized void setBars(double d, double d2) {
        this.barWidth = d;
        this._barOffset = d2;
        this._bars = true;
    }

    public void setConnected(boolean bl) {
        this._connected = bl;
    }

    public synchronized void setConnected(boolean bl, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        format.connected = bl;
        format.connectedUseDefault = false;
    }

    public synchronized void setImpulses(boolean bl) {
        this._impulses = bl;
    }

    public synchronized void setImpulses(boolean bl, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        format.impulses = bl;
        format.impulsesUseDefault = false;
    }

    public synchronized void setMarksStyle(String string) {
        if (string.equalsIgnoreCase("none")) {
            this._marks = 0;
        } else if (string.equalsIgnoreCase("points")) {
            this._marks = 1;
        } else if (string.equalsIgnoreCase("dots")) {
            this._marks = 2;
        } else if (string.equalsIgnoreCase("various")) {
            this._marks = 3;
        } else if (string.equalsIgnoreCase("pixels")) {
            this._marks = 4;
        }
    }

    public synchronized void setMarksStyle(String string, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        if (string.equalsIgnoreCase("none")) {
            format.marks = 0;
        } else if (string.equalsIgnoreCase("points")) {
            format.marks = 1;
        } else if (string.equalsIgnoreCase("dots")) {
            format.marks = 2;
        } else if (string.equalsIgnoreCase("various")) {
            format.marks = 3;
        } else if (string.equalsIgnoreCase("pixels")) {
            format.marks = 4;
        }
        format.marksUseDefault = false;
    }

    public void setNumSets(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of data sets (" + n + ") must be greater than 0.");
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._formats.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
            ++n2;
        }
    }

    public void setPointsPersistence(int n) {
        this._pointsPersistence = n;
    }

    public void setReuseDatasets(boolean bl) {
        this._reuseDatasets = bl;
    }

    public void setXPersistence(double d) {
        this._xPersistence = d;
    }

    public synchronized void writeData(PrintWriter printWriter) {
        super.writeData(printWriter);
        int n = 0;
        while (n < this._points.size()) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            Format format = (Format)this._formats.elementAt(n);
            if (!format.connectedUseDefault) {
                if (this._isConnected(n)) {
                    stringBuffer.append(" connected=\"yes\"");
                } else {
                    stringBuffer.append(" connected=\"no\"");
                }
            }
            if (!format.impulsesUseDefault) {
                if (format.impulses) {
                    stringBuffer.append(" stems=\"yes\"");
                } else {
                    printWriter.println(" stems=\"no\"");
                }
            }
            if (!format.marksUseDefault) {
                switch (format.marks) {
                    case 0: {
                        stringBuffer.append(" marks=\"none\"");
                    }
                    case 1: {
                        stringBuffer.append(" marks=\"points\"");
                    }
                    case 2: {
                        stringBuffer.append(" marks=\"dots\"");
                    }
                    case 3: {
                        stringBuffer.append(" marks=\"various\"");
                    }
                    case 4: {
                        stringBuffer.append(" marks=\"pixels\"");
                    }
                }
            }
            if ((string = this.getLegend(n)) != null) {
                stringBuffer.append(" name=\"" + this.getLegend(n) + "\"");
            }
            printWriter.println("<dataset" + stringBuffer.toString() + ">");
            Vector vector = (Vector)this._points.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                if (!plotPoint.connected) {
                    printWriter.print("<m ");
                } else {
                    printWriter.print("<p ");
                }
                printWriter.print("x=\"" + plotPoint.x + "\" y=\"" + plotPoint.y + "\"");
                if (plotPoint.errorBar) {
                    printWriter.print(" lowErrorBar=\"" + plotPoint.yLowEB + "\" highErrorBar=\"" + plotPoint.yHighEB + "\"");
                }
                printWriter.println("/>");
                ++n2;
            }
            printWriter.println("</dataset>");
            ++n;
        }
    }

    public synchronized void writeFormat(PrintWriter printWriter) {
        super.writeFormat(printWriter);
        if (this._reuseDatasets) {
            printWriter.println("<reuseDatasets/>");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._connected) {
            stringBuffer.append(" connected=\"no\"");
        }
        switch (this._marks) {
            case 1: {
                stringBuffer.append(" marks=\"points\"");
                break;
            }
            case 2: {
                stringBuffer.append(" marks=\"dots\"");
                break;
            }
            case 3: {
                stringBuffer.append(" marks=\"various\"");
                break;
            }
            case 4: {
                stringBuffer.append(" marks=\"pixels\"");
            }
        }
        if (this._impulses) {
            stringBuffer.append(" stems=\"yes\"");
        }
        if (stringBuffer.length() > 0) {
            printWriter.println("<default" + stringBuffer.toString() + "/>");
        }
        if (this._bars) {
            printWriter.println("<barGraph width=\"" + this.barWidth + "\" offset=\"" + this._barOffset + "\"/>");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void _checkDatasetIndex(int var1_1) {
        if (var1_1 >= 0) ** GOTO lbl7
        throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
lbl7:
            // 2 sources

            ** while (var1_1 >= this._points.size())
        }
lbl8:
        // 1 sources

    }

    protected void _drawBar(Graphics graphics, int n, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            long l3;
            int n2 = (int)((double)l - this.barWidth * this._xscale / 2.0 + (double)n * this._barOffset * this._xscale);
            int n3 = (int)((double)n2 + this.barWidth * this._xscale);
            if (n2 < this._ulx) {
                n2 = this._ulx;
            }
            if (n3 > this._lrx) {
                n3 = this._lrx;
            }
            if (n2 >= n3) {
                n3 = n2 + 1;
            }
            if ((long)this._lry < (l3 = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                l3 = this._lry;
            }
            if ((long)this._uly > l3) {
                l3 = this._uly;
            }
            if (this._yMin >= 0.0 || l2 <= l3) {
                graphics.fillRect(n2, (int)l2, n3 - n2, (int)(l3 - l2));
            } else {
                graphics.fillRect(n2, (int)l3, n3 - n2, (int)(l2 - l3));
            }
        }
    }

    protected void _drawErrorBar(Graphics graphics, int n, long l, long l2, long l3, boolean bl) {
        this._drawLine(graphics, n, l - 5L, l3, l + 5L, l3, bl);
        this._drawLine(graphics, n, l, l2, l, l3, bl);
        this._drawLine(graphics, n, l - 5L, l2, l + 5L, l2, bl);
    }

    protected void _drawImpulse(Graphics graphics, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            double d = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale);
            if ((double)this._lry < d) {
                d = this._lry;
            }
            if ((double)this._uly > d) {
                d = this._uly;
            }
            graphics.drawLine((int)l, (int)l2, (int)l, (int)d);
        }
    }

    protected void _drawLine(Graphics graphics, int n, long l, long l2, long l3, long l4, boolean bl) {
        if (bl) {
            if (!(l3 <= (long)this._ulx && l <= (long)this._ulx || l3 >= (long)this._lrx && l >= (long)this._lrx || l4 <= (long)this._uly && l2 <= (long)this._uly || l4 >= (long)this._lry && l2 >= (long)this._lry)) {
                if (l != l3) {
                    if (l3 < (long)this._ulx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._ulx - l3) / (l - l3));
                        l3 = this._ulx;
                    } else if (l3 > (long)this._lrx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._lrx - l3) / (l - l3));
                        l3 = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l4 < (long)this._uly) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._uly - l4) / (l2 - l4));
                        l4 = this._uly;
                    } else if (l4 > (long)this._lry) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._lry - l4) / (l2 - l4));
                        l4 = this._lry;
                    }
                }
                if (l != l3) {
                    if (l < (long)this._ulx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._ulx - l) / (l3 - l));
                        l = this._ulx;
                    } else if (l > (long)this._lrx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._lrx - l) / (l3 - l));
                        l = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l2 < (long)this._uly) {
                        l = (int)(l + (l3 - l) * ((long)this._uly - l2) / (l4 - l2));
                        l2 = this._uly;
                    } else if (l2 > (long)this._lry) {
                        l = (int)(l + (l3 - l) * ((long)this._lry - l2) / (l4 - l2));
                        l2 = this._lry;
                    }
                }
            }
            if (l3 >= (long)this._ulx && l3 <= (long)this._lrx && l4 >= (long)this._uly && l4 <= (long)this._lry && l >= (long)this._ulx && l <= (long)this._lrx && l2 >= (long)this._uly && l2 <= (long)this._lry) {
                graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
            }
        } else {
            graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl, Rectangle rectangle) {
        super._drawPlot(graphics, bl, rectangle);
        int n = this._points.size() - 1;
        while (n >= 0) {
            Vector vector = (Vector)this._points.elementAt(n);
            Vector<Integer> vector2 = new Vector<Integer>();
            int n2 = 0;
            while (n2 < vector.size()) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                if (!plotPoint.highlighted) {
                    this._drawPlotPoint(graphics, n, n2);
                } else {
                    vector2.add(new Integer(n2));
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector2.size()) {
                int n4 = (Integer)vector2.get(n3);
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(n4);
                if (plotPoint.highlighted) {
                    this._drawPlotPoint(graphics, n, n4);
                }
                ++n3;
            }
            --n;
        }
        this._showing = true;
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl || bl4) {
            int n2 = (int)l;
            int n3 = (int)l2;
            Format format = (Format)this._formats.elementAt(n);
            int n4 = this._marks;
            if (!format.marksUseDefault) {
                n4 = format.marks;
            }
            if (!bl4 && n4 != 3 && this._isConnected(n) && graphics instanceof EPSGraphics) {
                graphics.drawLine(n2 - 6, n3, n2 + 6, n3);
            } else {
                Color color;
                Color color2 = graphics.getColor();
                if (bl3) {
                    color = this.HIGHLIGHT_COLOR;
                    graphics.setColor(color);
                } else {
                    color = color2;
                }
                switch (n4) {
                    case 0: {
                        graphics.fillRect(n2 - 6, n3 - 6, 6, 6);
                        break;
                    }
                    case 1: {
                        if (bl2) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(n2 - 3, n3 - 3, 6, 6);
                            graphics.setColor(color);
                        }
                        graphics.fillOval(n2 - 1, n3 - 1, 3, 3);
                        break;
                    }
                    case 2: {
                        if (bl2) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(n2 - 4, n3 - 4, 8, 8);
                            graphics.setColor(color);
                        }
                        graphics.fillOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 3: {
                        if (bl2) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(n2 - 4, n3 - 4, 8, 8);
                            graphics.setColor(color);
                        }
                        int n5 = n % 10;
                        switch (n5) {
                            case 0: {
                                graphics.fillOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 1: {
                                graphics.drawLine(n2 - this._radius, n3 - this._radius, n2 + this._radius, n3 + this._radius);
                                graphics.drawLine(n2 + this._radius, n3 - this._radius, n2 - this._radius, n3 + this._radius);
                                break;
                            }
                            case 2: {
                                graphics.drawRect(n2 - this._radius + 1, n3 - this._radius + 1, this._diameter - 2, this._diameter - 2);
                                graphics.drawLine(n2 - this._radius + 1, n3 - this._radius + 1, n2 + this._radius - 1, n3 + this._radius - 1);
                                graphics.drawLine(n2 + this._radius - 1, n3 - this._radius + 1, n2 - this._radius + 1, n3 + this._radius - 1);
                                break;
                            }
                            case 3: {
                                int[] nArray = new int[4];
                                int[] nArray2 = new int[4];
                                nArray[0] = n2;
                                nArray2[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray2[1] = n3 + this._radius;
                                nArray[2] = n2 - this._radius;
                                nArray2[2] = n3 + this._radius;
                                nArray[3] = n2;
                                nArray2[3] = n3 - this._radius;
                                graphics.fillPolygon(nArray, nArray2, 4);
                                break;
                            }
                            case 4: {
                                int[] nArray = new int[5];
                                int[] nArray3 = new int[5];
                                nArray[0] = n2;
                                nArray3[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray3[1] = n3;
                                nArray[2] = n2;
                                nArray3[2] = n3 + this._radius;
                                nArray[3] = n2 - this._radius;
                                nArray3[3] = n3;
                                nArray[4] = n2;
                                nArray3[4] = n3 - this._radius;
                                graphics.drawPolygon(nArray, nArray3, 5);
                                break;
                            }
                            case 5: {
                                graphics.drawOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 6: {
                                graphics.drawLine(n2, n3 - this._radius, n2, n3 + this._radius);
                                graphics.drawLine(n2 - this._radius, n3, n2 + this._radius, n3);
                                break;
                            }
                            case 7: {
                                graphics.fillRect(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 8: {
                                int[] nArray = new int[4];
                                int[] nArray4 = new int[4];
                                nArray[0] = n2;
                                nArray4[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray4[1] = n3 + this._radius;
                                nArray[2] = n2 - this._radius;
                                nArray4[2] = n3 + this._radius;
                                nArray[3] = n2;
                                nArray4[3] = n3 - this._radius;
                                graphics.drawPolygon(nArray, nArray4, 4);
                                break;
                            }
                            case 9: {
                                int[] nArray = new int[5];
                                int[] nArray5 = new int[5];
                                nArray[0] = n2;
                                nArray5[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray5[1] = n3;
                                nArray[2] = n2;
                                nArray5[2] = n3 + this._radius;
                                nArray[3] = n2 - this._radius;
                                nArray5[3] = n3;
                                nArray[4] = n2;
                                nArray5[4] = n3 - this._radius;
                                graphics.fillPolygon(nArray, nArray5, 5);
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (bl2) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(n2 - 2, n3 - 2, 4, 4);
                            graphics.setColor(color);
                        }
                        graphics.fillRect(n2, n3, 1, 1);
                        break;
                    }
                    default: {
                        graphics.setColor(color2);
                    }
                }
            }
        }
    }

    protected boolean _parseLine(String string) {
        boolean bl = false;
        if (this._isConnected(this._currentdataset)) {
            bl = true;
        }
        if (super._parseLine(string)) {
            return true;
        }
        String string2 = new String(string.toLowerCase());
        if (string2.startsWith("marks:")) {
            String string3 = string.substring(6).trim();
            if (this._sawFirstDataSet) {
                this.setMarksStyle(string3, this._currentdataset);
            } else {
                this.setMarksStyle(string3);
            }
            return true;
        }
        if (string2.startsWith("numsets:")) {
            return true;
        }
        if (string2.startsWith("reusedatasets:")) {
            if (string2.indexOf("off", 16) >= 0) {
                this.setReuseDatasets(false);
            } else {
                this.setReuseDatasets(true);
            }
            return true;
        }
        if (string2.startsWith("dataset:")) {
            String string4;
            if (this._reuseDatasets && string2.length() > 0) {
                string4 = string.substring(8).trim();
                this._currentdataset = -1;
                int n = 0;
                while (n <= this._maxDataset) {
                    if (this.getLegend(n).compareTo(string4) == 0) {
                        this._currentdataset = n;
                    }
                    ++n;
                }
                if (this._currentdataset != -1) {
                    return true;
                }
                this._currentdataset = this._maxDataset;
            }
            this._firstInSet = true;
            this._sawFirstDataSet = true;
            ++this._currentdataset;
            if (string2.length() > 0 && (string4 = string.substring(8).trim()) != null && string4.length() > 0) {
                this.addLegend(this._currentdataset, string4);
            }
            this._maxDataset = this._currentdataset;
            return true;
        }
        if (string2.startsWith("lines:")) {
            if (string2.indexOf("off", 6) >= 0) {
                this.setConnected(false);
            } else {
                this.setConnected(true);
            }
            return true;
        }
        if (string2.startsWith("impulses:")) {
            if (this._sawFirstDataSet) {
                if (string2.indexOf("off", 9) >= 0) {
                    this.setImpulses(false, this._currentdataset);
                } else {
                    this.setImpulses(true, this._currentdataset);
                }
            } else if (string2.indexOf("off", 9) >= 0) {
                this.setImpulses(false);
            } else {
                this.setImpulses(true);
            }
            return true;
        }
        if (string2.startsWith("bars:")) {
            if (string2.indexOf("off", 5) >= 0) {
                this.setBars(false);
            } else {
                String string5;
                this.setBars(true);
                int n = string.indexOf(",", 5);
                String string6 = null;
                if (n > 0) {
                    string5 = string.substring(5, n).trim();
                    string6 = string.substring(n + 1).trim();
                } else {
                    string5 = string.substring(5).trim();
                }
                try {
                    Double d = new Double(string5);
                    double d2 = this._barOffset;
                    if (string6 != null) {
                        d2 = new Double(string6);
                    }
                    this.setBars(d, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string.startsWith("move:")) {
            bl = false;
            string = string.substring(5, string.length()).trim();
        } else if (string.startsWith("move")) {
            bl = false;
            string = string.substring(4, string.length()).trim();
        } else if (string.startsWith("draw:")) {
            string = string.substring(5, string.length()).trim();
        } else if (string.startsWith("draw")) {
            string = string.substring(4, string.length()).trim();
        }
        string = string.trim();
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.indexOf(" ");
        }
        if (n == -1) {
            n = string.indexOf("\t");
        }
        if (n > 0) {
            String string7 = string.substring(0, n).trim();
            String string8 = string.substring(n + 1).trim();
            int n2 = string8.indexOf(",");
            if (n2 == -1) {
                n2 = string8.indexOf(" ");
            }
            if (n2 == -1) {
                n2 = string8.indexOf("\t");
            }
            if (n2 > 0) {
                string = string8.substring(n2 + 1).trim();
                string8 = string8.substring(0, n2).trim();
            }
            try {
                Double d = new Double(string7);
                Double d3 = new Double(string8);
                if (n2 > 0) {
                    int n3 = string.indexOf(",");
                    if (n3 == -1) {
                        n3 = string.indexOf(" ");
                    }
                    if (n3 == -1) {
                        n2 = string.indexOf("\t");
                    }
                    if (n3 > 0) {
                        String string9 = string.substring(0, n3).trim();
                        String string10 = string.substring(n3 + 1).trim();
                        Double d4 = new Double(string9);
                        Double d5 = new Double(string10);
                        bl = this._addLegendIfNecessary(bl);
                        this.addPointWithErrorBars(this._currentdataset, d, d3, d4, d5, "x", bl);
                        return true;
                    }
                    bl = this._addLegendIfNecessary(bl);
                    this.addPoint(this._currentdataset, d, d3, "x", bl);
                    return true;
                }
                bl = this._addLegendIfNecessary(bl);
                this.addPoint(this._currentdataset, d, d3, "x", bl);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void _writeOldSyntax(PrintWriter printWriter) {
        super._writeOldSyntax(printWriter);
        if (this._reuseDatasets) {
            printWriter.println("ReuseDatasets: on");
        }
        if (!this._connected) {
            printWriter.println("Lines: off");
        }
        if (this._bars) {
            printWriter.println("Bars: " + this.barWidth + ", " + this._barOffset);
        }
        if (this._impulses) {
            printWriter.println("Impulses: on");
        }
        switch (this._marks) {
            case 1: {
                printWriter.println("Marks: points");
            }
            case 2: {
                printWriter.println("Marks: dots");
            }
            case 3: {
                printWriter.println("Marks: various");
            }
            case 4: {
                printWriter.println("Marks: pixels");
            }
        }
        int n = 0;
        while (n < this._points.size()) {
            String string = this.getLegend(n);
            if (string != null) {
                printWriter.println("DataSet: " + this.getLegend(n));
            } else {
                printWriter.println("DataSet:");
            }
            Format format = (Format)this._formats.elementAt(n);
            if (!format.impulsesUseDefault) {
                if (format.impulses) {
                    printWriter.println("Impulses: on");
                } else {
                    printWriter.println("Impulses: off");
                }
            }
            if (!format.marksUseDefault) {
                switch (format.marks) {
                    case 0: {
                        printWriter.println("Marks: none");
                    }
                    case 1: {
                        printWriter.println("Marks: points");
                    }
                    case 2: {
                        printWriter.println("Marks: dots");
                    }
                    case 3: {
                        printWriter.println("Marks: various");
                    }
                    case 4: {
                        printWriter.println("Marks: pixels");
                    }
                }
            }
            Vector vector = (Vector)this._points.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                if (!plotPoint.connected) {
                    printWriter.print("move: ");
                }
                if (plotPoint.errorBar) {
                    printWriter.println(plotPoint.x + ", " + plotPoint.y + ", " + plotPoint.yLowEB + ", " + plotPoint.yHighEB);
                } else {
                    printWriter.println(plotPoint.x + ", " + plotPoint.y);
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean _addLegendIfNecessary(boolean bl) {
        if (!(this._sawFirstDataSet && this._currentdataset >= 0 || this._reuseDatasets)) {
            this._sawFirstDataSet = true;
            ++this._currentdataset;
        }
        if (!this._sawFirstDataSet && this.getLegend(this._currentdataset) == null) {
            this._firstInSet = true;
            this._sawFirstDataSet = true;
            this.addLegend(this._currentdataset, new String("Set " + this._currentdataset));
        }
        if (this._firstInSet && !this._reuseDatasets) {
            bl = false;
            this._firstInSet = false;
        }
        return bl;
    }

    private void _addPoint(int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, String string) {
        int n2;
        this._checkDatasetIndex(n);
        if (this._xlog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (d2 <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * PlotBox._LOG10SCALE;
            if (bl2) {
                if (d3 <= 0.0 || d4 <= 0.0) {
                    System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d2);
                    return;
                }
                d3 = Math.log(d3) * PlotBox._LOG10SCALE;
                d4 = Math.log(d4) * PlotBox._LOG10SCALE;
            }
        }
        Vector vector = (Vector)this._points.elementAt(n);
        if (this._xPersistence > 0.0) {
            n2 = 0;
            while (n2 < vector.size()) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                if (d - plotPoint.originalx <= this._xPersistence) break;
                ++n2;
            }
            int n3 = 0;
            while (n3 < n2) {
                this.erasePoint(n, 0, bl3);
                ++n3;
            }
        }
        n2 = vector.size();
        PlotPoint plotPoint = new PlotPoint();
        plotPoint.originalx = d;
        if (this._wrap) {
            double d5 = this._wrapHigh - this._wrapLow;
            if (d < this._wrapLow) {
                d += d5 * Math.floor(1.0 + (this._wrapLow - d) / d5);
            } else if (d > this._wrapHigh && (d -= d5 * Math.floor(1.0 + (d - this._wrapHigh) / d5)) == this._wrapLow) {
                d = this._wrapHigh;
            }
        }
        if (d < this._xBottom) {
            this._xBottom = d;
        }
        if (d > this._xTop) {
            this._xTop = d;
        }
        if (d2 < this._yBottom) {
            this._yBottom = d2;
        }
        if (d2 > this._yTop) {
            this._yTop = d2;
        }
        plotPoint.x = d;
        plotPoint.y = d2;
        plotPoint.connected = bl && this._isConnected(n);
        plotPoint.objectID = string;
        if (bl2) {
            if (d3 < this._yBottom) {
                this._yBottom = d3;
            }
            if (d3 > this._yTop) {
                this._yTop = d3;
            }
            if (d4 < this._yBottom) {
                this._yBottom = d4;
            }
            if (d4 > this._yTop) {
                this._yTop = d4;
            }
            plotPoint.yLowEB = d3;
            plotPoint.yHighEB = d4;
            plotPoint.errorBar = true;
        }
        if (n2 == 0) {
            plotPoint.connected = false;
        } else if (this._wrap) {
            PlotPoint plotPoint2 = (PlotPoint)vector.elementAt(n2 - 1);
            if (plotPoint2.x > d) {
                plotPoint.connected = false;
            }
        }
        vector.addElement(plotPoint);
        if (this._pointsPersistence > 0 && n2 > this._pointsPersistence) {
            this.erasePoint(n, 0, bl3);
        }
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            if ((this._pointsPersistence > 0 || this._xPersistence > 0.0) && this.isDoubleBuffered()) {
                this.setDoubleBuffered(false);
                Container container = this.getParent();
                while (container != null) {
                    if (container instanceof JComponent) {
                        ((JComponent)container).setDoubleBuffered(false);
                    }
                    container = container.getParent();
                }
            }
            this._drawPlotPoint(graphics, n, vector.size() - 1);
        }
        if (this._wrap && d == this._wrapHigh) {
            this._addPoint(n, this._wrapLow, d2, d3, d4, false, bl2, bl3, "x");
        }
    }

    private void _clear(boolean bl) {
        super.clear(bl);
        this._currentdataset = -1;
        int n = this._points.size();
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._maxDataset = -1;
        this._firstInSet = true;
        this._sawFirstDataSet = false;
        this._xyInvalid = true;
        this._filename = null;
        if (bl) {
            this._showing = false;
            this._formats = new Vector();
            this._marks = 0;
            this._pointsPersistence = 0;
            this._xPersistence = 0.0;
            this._bars = false;
            this.barWidth = 0.5;
            this._barOffset = 0.05;
            this._connected = true;
            this._impulses = false;
            this._reuseDatasets = false;
        }
    }

    private void _clear(int n) {
        this._checkDatasetIndex(n);
        this._xyInvalid = true;
        Vector vector = (Vector)this._points.elementAt(n);
        this._points.setElementAt(new Vector(), n);
        this.repaint();
    }

    private void _drawPlotPoint(Graphics graphics, int n, int n2) {
        if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
            if (this._background == null) {
                graphics.setXORMode(this.getBackground());
            } else {
                graphics.setXORMode(this._background);
            }
        }
        if (this._usecolor) {
            int n3 = n % PlotBox._colors.length;
            graphics.setColor(PlotBox._colors[n3]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        long l3 = (Long)this._prevx.elementAt(n);
        long l4 = (Long)this._prevy.elementAt(n);
        if (plotPoint.connected) {
            this._drawLine(graphics, n, l2, l, l3, l4, true);
        }
        this._prevx.setElementAt(new Long(l2), n);
        this._prevy.setElementAt(new Long(l), n);
        Format format = (Format)this._formats.elementAt(n);
        if (format.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, l2, l, true);
            }
        } else if (format.impulses) {
            this._drawImpulse(graphics, l2, l, true);
        }
        int n4 = this._marks;
        if (!format.marksUseDefault) {
            n4 = format.marks;
        }
        if (n4 != 0) {
            this._drawPoint(graphics, n, l2, l, true, plotPoint.selected, plotPoint.highlighted);
        }
        if (this._bars) {
            this._drawBar(graphics, n, l2, l, true);
        }
        if (plotPoint.errorBar) {
            this._drawErrorBar(graphics, n, l2, (long)this._lry - (long)((plotPoint.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((plotPoint.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
            graphics.setPaintMode();
        }
    }

    private void _erasePoint(int n, int n2) {
        PlotPoint plotPoint;
        Vector vector;
        this._checkDatasetIndex(n);
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            int n3;
            Serializable serializable;
            if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
                if (this._background == null) {
                    graphics.setXORMode(this.getBackground());
                } else {
                    graphics.setXORMode(this._background);
                }
            }
            if (this._usecolor) {
                int n4 = n % PlotBox._colors.length;
                graphics.setColor(PlotBox._colors[n4]);
            } else {
                graphics.setColor(this._foreground);
            }
            vector = (Vector)this._points.elementAt(n);
            plotPoint = (PlotPoint)vector.elementAt(n2);
            long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
            long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
            if (n2 < vector.size() - 1) {
                serializable = (PlotPoint)vector.elementAt(n2 + 1);
                n3 = this._ulx + (int)((((PlotPoint)serializable).x - this._xMin) * this._xscale);
                int n5 = this._lry - (int)((((PlotPoint)serializable).y - this._yMin) * this._yscale);
                if (((PlotPoint)serializable).connected) {
                    this._drawLine(graphics, n, n3, n5, l2, l, true);
                }
                ((PlotPoint)serializable).connected = false;
            }
            serializable = (Format)this._formats.elementAt(n);
            if (serializable.impulsesUseDefault) {
                if (this._impulses) {
                    this._drawImpulse(graphics, l2, l, true);
                }
            } else if (serializable.impulses) {
                this._drawImpulse(graphics, l2, l, true);
            }
            n3 = this._marks;
            if (!serializable.marksUseDefault) {
                n3 = serializable.marks;
            }
            if (n3 != 0) {
                this._drawPoint(graphics, n, l2, l, true, plotPoint.selected, plotPoint.highlighted);
            }
            if (this._bars) {
                this._drawBar(graphics, n, l2, l, true);
            }
            if (plotPoint.errorBar) {
                this._drawErrorBar(graphics, n, l2, (long)this._lry - (long)((plotPoint.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((plotPoint.yHighEB - this._yMin) * this._yscale), true);
            }
            graphics.setColor(this._foreground);
            if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
                graphics.setPaintMode();
            }
        }
        if ((vector = (Vector)this._points.elementAt(n)) != null && (plotPoint = (PlotPoint)vector.elementAt(n2)) != null) {
            if (plotPoint.x == this._xBottom || plotPoint.x == this._xTop || plotPoint.y == this._yBottom || plotPoint.y == this._yTop) {
                this._xyInvalid = true;
            }
            vector.removeElementAt(n2);
        }
    }

    private void _fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -1.7976931348623157E308;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -1.7976931348623157E308;
            int n = 0;
            while (n < this._points.size()) {
                Vector vector = (Vector)this._points.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                    if (plotPoint.x < this._xBottom) {
                        this._xBottom = plotPoint.x;
                    }
                    if (plotPoint.x > this._xTop) {
                        this._xTop = plotPoint.x;
                    }
                    if (plotPoint.y < this._yBottom) {
                        this._yBottom = plotPoint.y;
                    }
                    if (plotPoint.y > this._yTop) {
                        this._yTop = plotPoint.y;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this._xyInvalid = false;
        if (this._bars) {
            if (this._yBottom > 0.0) {
                this._yBottom = 0.0;
            }
            if (this._yTop < 0.0) {
                this._yTop = 0.0;
            }
        }
        super.fillPlot();
    }

    private boolean _isConnected(int n) {
        if (n < 0) {
            return this._connected;
        }
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        if (format.connectedUseDefault) {
            return this._connected;
        }
        return format.connected;
    }

    private class Format
    implements Serializable {
        public boolean connected;
        public boolean connectedUseDefault = true;
        public boolean impulses;
        public boolean impulsesUseDefault = true;
        public int marks;
        public boolean marksUseDefault = true;

        private Format() {
        }
    }
}

