/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.GUIStringUtilities;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.gui.MessageHandler;
import ptolemy.gui.Query;
import ptolemy.gui.StatusBar;

public abstract class Top
extends JFrame {
    protected static File _directory = null;
    protected FileFilter _fileFilter = null;
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenuItem[] _fileMenuItems = new JMenuItem[]{new JMenuItem("Open File", 79), new JMenuItem("Open URL", 85), new JMenu("New"), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Print", 80), new JMenuItem("Close", 67), new JMenuItem("Exit", 88)};
    protected JMenu _helpMenu = new JMenu("Help");
    protected JMenuItem[] _helpMenuItems = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72)};
    protected JMenuBar _menubar = new JMenuBar();
    protected StatusBar _statusBar = new StatusBar();
    private File _file = null;
    private String _lastURL = "http://ptolemy.eecs.berkeley.edu/xml/models/";
    private static String _lastOverallURL = null;
    private boolean _modified = false;
    private boolean _menuPopulated = false;

    public Top() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Top.this._close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        GraphicalMessageHandler.setContext(this);
    }

    public void centerOnScreen() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        GraphicalMessageHandler.setContext(this);
    }

    public static String getLastOverallURL() {
        return _lastOverallURL;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void report(Exception exception) {
        this.report("", exception);
    }

    public void report(String string) {
        this._statusBar.setMessage(string);
    }

    public void report(String string, Exception exception) {
        this._statusBar.setMessage("Exception. " + string);
        MessageHandler.error(string, exception);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._statusBar != null) {
            this._statusBar.setBackground(color);
        }
    }

    public static void setLastOverallURL(String string) {
        _lastOverallURL = string;
    }

    public void setModified(boolean bl) {
        this._modified = bl;
    }

    public void pack() {
        if (!this._menuPopulated) {
            this._menuPopulated = true;
            this._fileMenu.setMnemonic(70);
            this._helpMenu.setMnemonic(72);
            this._fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this._fileMenuItems[2].setMnemonic(78);
            this._fileMenuItems[2].setEnabled(false);
            this._fileMenuItems[3].setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this._fileMenuItems[5].setAccelerator(KeyStroke.getKeyStroke(80, 2));
            if (this instanceof Printable || this instanceof Pageable) {
                this._fileMenuItems[5].setEnabled(true);
            } else {
                this._fileMenuItems[5].setEnabled(false);
            }
            this._fileMenuItems[6].setAccelerator(KeyStroke.getKeyStroke(87, 2));
            FileMenuListener fileMenuListener = new FileMenuListener();
            int n = 0;
            while (n < this._fileMenuItems.length) {
                this._fileMenuItems[n].setActionCommand(this._fileMenuItems[n].getText());
                this._fileMenuItems[n].addActionListener(fileMenuListener);
                this._fileMenu.add(this._fileMenuItems[n]);
                ++n;
            }
            this._menubar.add(this._fileMenu);
            HelpMenuListener helpMenuListener = new HelpMenuListener();
            int n2 = 0;
            while (n2 < this._helpMenuItems.length) {
                this._helpMenuItems[n2].setActionCommand(this._helpMenuItems[n2].getText());
                this._helpMenuItems[n2].addActionListener(helpMenuListener);
                this._helpMenu.add(this._helpMenuItems[n2]);
                ++n2;
            }
            this._addMenus();
            this._menubar.add(this._helpMenu);
            this.setJMenuBar(this._menubar);
            this.getContentPane().add((Component)this._statusBar, "South");
        }
        super.pack();
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy II " + this.getClass().getName() + "\n" + "By: Claudius Ptolemaeus, ptolemy@eecs.berkeley.edu\n" + "For more information, see\n" + "http://ptolemy.eecs.berkeley.edu/ptolemyII\n\n" + "Copyright (c) 1997-2001, " + "The Regents of the University of California.", "About Ptolemy II", 1);
    }

    protected void _addMenus() {
    }

    protected boolean _clear() {
        return this._queryForSave();
    }

    protected boolean _close() {
        if (this.isModified()) {
            if (this._queryForSave()) {
                this.dispose();
                return true;
            }
            return false;
        }
        this.dispose();
        return true;
    }

    protected void _exit() {
        if (this.isModified()) {
            if (this._queryForSave()) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    protected String _getName() {
        if (this._file == null) {
            return "Unnamed";
        }
        return this._file.getName();
    }

    protected void _help() {
        this._about();
    }

    protected void _open() {
        block7: {
            Object object;
            JFileChooser jFileChooser = new JFileChooser();
            if (this._fileFilter != null) {
                jFileChooser.addChoosableFileFilter(this._fileFilter);
            }
            jFileChooser.setDialogTitle("Select a model file.");
            if (_directory != null) {
                jFileChooser.setCurrentDirectory(_directory);
            } else {
                object = System.getProperty("user.dir");
                if (object != null) {
                    jFileChooser.setCurrentDirectory(new File((String)object));
                }
            }
            if (jFileChooser.showOpenDialog(this) == 0) {
                _directory = jFileChooser.getCurrentDirectory();
                try {
                    object = jFileChooser.getSelectedFile().getCanonicalFile();
                    this._read(((File)object).toURL());
                }
                catch (Exception exception) {
                    if (exception.getMessage() == null || exception.getMessage().startsWith("*** Canceled.")) break block7;
                    this.report("Error reading input", exception);
                }
            }
        }
    }

    protected void _openURL() {
        Query query = new Query();
        query.setTextWidth(60);
        query.addLine("url", "URL", this._lastURL);
        ComponentDialog componentDialog = new ComponentDialog((Frame)this, "Open URL", query);
        if (componentDialog.buttonPressed().equals("OK")) {
            _lastOverallURL = this._lastURL = query.getStringValue("url");
            try {
                URL uRL = new URL(this._lastURL);
                this._read(uRL);
            }
            catch (Exception exception) {
                this.report("Error reading URL:\n" + this._lastURL, exception);
            }
        }
    }

    protected void _print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this instanceof Pageable) {
            printerJob.setPageable((Pageable)((Object)this));
        } else if (this instanceof Printable) {
            PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
            printerJob.setPrintable((Printable)((Object)this), pageFormat);
        } else {
            return;
        }
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                MessageHandler.error("Printing Failed", exception);
            }
        }
    }

    protected abstract void _read(URL var1) throws Exception;

    protected boolean _save() {
        if (this._file != null) {
            try {
                this._writeFile(this._file);
                this.setModified(false);
                return true;
            }
            catch (IOException iOException) {
                this.report("Error writing file", iOException);
                return false;
            }
        }
        return this._saveAs();
    }

    protected boolean _saveAs() {
        JFileChooser jFileChooser = new JFileChooser();
        if (this._fileFilter != null) {
            jFileChooser.addChoosableFileFilter(this._fileFilter);
        }
        jFileChooser.setDialogTitle("Save as...");
        if (_directory != null) {
            jFileChooser.setCurrentDirectory(_directory);
        } else {
            String string = System.getProperty("user.dir");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        }
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string;
            int n2;
            this._file = jFileChooser.getSelectedFile();
            if (this._file.exists() && (n2 = JOptionPane.showOptionDialog(this, string = "Overwrite " + this._file.getName() + "?", "Save Changes?", 0, 3, null, null, null)) == 1) {
                return false;
            }
            this.setTitle(GUIStringUtilities.abbreviate(this._getName()));
            _directory = jFileChooser.getCurrentDirectory();
            return this._save();
        }
        return false;
    }

    protected abstract void _writeFile(File var1) throws IOException;

    private boolean _queryForSave() {
        Object[] objectArray = new Object[]{"Save", "Discard changes", "Cancel"};
        String string = "Save changes to " + GUIStringUtilities.split(this._getName()) + "?";
        int n = JOptionPane.showOptionDialog(this, string, "Save Changes?", 1, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            return this._save();
        }
        return n == 1;
    }

    class HelpMenuListener
    implements ActionListener {
        HelpMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicalMessageHandler.setContext(Top.this);
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            try {
                if (string.equals("About")) {
                    Top.this._about();
                } else if (string.equals("Help")) {
                    Top.this._help();
                }
            }
            catch (Exception exception) {
                MessageHandler.error("Help Menu Exception:", exception);
            }
            Top.this.repaint();
        }
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicalMessageHandler.setContext(Top.this);
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            try {
                if (string.equals("Open File")) {
                    Top.this._open();
                } else if (string.equals("Open URL")) {
                    Top.this._openURL();
                } else if (string.equals("Save")) {
                    Top.this._save();
                } else if (string.equals("SaveAs")) {
                    Top.this._saveAs();
                } else if (string.equals("Print")) {
                    Top.this._print();
                } else if (string.equals("Close")) {
                    Top.this._close();
                } else if (string.equals("Exit")) {
                    Top.this._exit();
                }
            }
            catch (Exception exception) {
                MessageHandler.error("File Menu Exception:", exception);
            }
            Top.this.repaint();
        }
    }
}

