/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import ptolemy.gui.GUIStringUtilities;
import ptolemy.gui.SwingWorker;

public class JTextAreaExec
extends JPanel {
    private ActionListener _clearListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ 5 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    JTextAreaExec.access$000(5.access$200(this.this$1)).setText(null);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        static /* synthetic */ JTextAreaExec access$200(5 var0) {
            return var0.JTextAreaExec.this;
        }
    };
    private ActionListener _interruptListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JTextAreaExec.this._cancelButton.setEnabled(false);
            JTextAreaExec.this.appendJTextArea("Cancel button was pressed");
            JTextAreaExec.this._worker.interrupt();
            JTextAreaExec.this._process.destroy();
            JTextAreaExec.this._enableStartButton();
        }
    };
    private ActionListener _startListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JTextAreaExec.this._startButton.setEnabled(false);
            JTextAreaExec.this._cancelButton.setEnabled(true);
            JTextAreaExec.this._statusBar.setText("Working...");
            JTextAreaExec.this._worker = new SwingWorker(this){
                private final /* synthetic */ 8 this$1;
                {
                    this.this$1 = var1_1;
                }

                public Object construct() {
                    return JTextAreaExec.access$900(8.access$800(this.this$1));
                }

                public void finished() {
                    JTextAreaExec.access$600(8.access$800(this.this$1));
                    JTextAreaExec.access$300(8.access$800(this.this$1)).setEnabled(false);
                    JTextAreaExec.access$1000(8.access$800(this.this$1), 0);
                    JTextAreaExec.access$100(8.access$800(this.this$1)).setText(this.get().toString());
                }
            };
            JTextAreaExec.this._worker.start();
        }

        static /* synthetic */ JTextAreaExec access$800(8 var0) {
            return var0.JTextAreaExec.this;
        }
    };
    private JButton _cancelButton;
    private JButton _clearButton;
    private List _commands = null;
    private JTextArea _jTextArea;
    private Process _process;
    private JProgressBar _progressBar;
    private JLabel _statusBar;
    private JButton _startButton;
    private SwingWorker _worker;

    public JTextAreaExec(String string, boolean bl) {
        Object object;
        this.setLayout(new BoxLayout(this, 1));
        this._jTextArea = new JTextArea("", 20, 100);
        this._jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._jTextArea);
        this.add(jScrollPane);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), string));
        this._progressBar = new JProgressBar();
        this._startButton = new JButton("Start");
        this._startButton.addActionListener(this._startListener);
        this._enableStartButton();
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.addActionListener(this._interruptListener);
        this._cancelButton.setEnabled(false);
        this._clearButton = new JButton("Clear");
        this._clearButton.addActionListener(this._clearListener);
        this._clearButton.setEnabled(true);
        Border border = BorderFactory.createEmptyBorder(0, 0, 5, 0);
        if (bl) {
            object = new JPanel();
            ((Container)object).add(this._startButton);
            ((Container)object).add(this._cancelButton);
            ((Container)object).add(this._clearButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add((Component)object);
            ((JComponent)object).setBorder(border);
            this._statusBar = new JLabel("Click Start to begin", 0);
        } else {
            this._statusBar = new JLabel("", 0);
        }
        this.add(this._progressBar);
        this.add(this._statusBar);
        this._statusBar.setAlignmentX(0.5f);
        object = this._progressBar.getBorder();
        this._progressBar.setBorder(BorderFactory.createCompoundBorder(border, (Border)object));
    }

    public void appendJTextArea(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JTextAreaExec.this._jTextArea.append(string + '\n');
                JTextAreaExec.this._jTextArea.setCaretPosition(JTextAreaExec.this._jTextArea.getText().length());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void cancel() {
        this._cancelButton.doClick();
    }

    public void clear() {
        this._clearButton.doClick();
        this.updateStatusBar("");
        this._updateProgressBar(0);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JTextAreaExec Example");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        jFrame.addWindowListener(windowAdapter);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("date");
        linkedList.add("sleep 5");
        linkedList.add("date");
        linkedList.add("javac");
        final JTextAreaExec jTextAreaExec = new JTextAreaExec("JTextAreaExec Tester", true);
        jTextAreaExec.setCommands(linkedList);
        jFrame.getContentPane().add(jTextAreaExec);
        jFrame.pack();
        jFrame.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jTextAreaExec.getStartButton().requestFocus();
                jTextAreaExec.start();
            }
        });
    }

    public JButton getStartButton() {
        return this._startButton;
    }

    public void setCommands(List list) {
        this._commands = list;
        this._enableStartButton();
    }

    public void start() {
        this._startButton.doClick();
    }

    public void updateStatusBar(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JTextAreaExec.this._statusBar.setText(string);
                JTextAreaExec.this._jTextArea.append(string + '\n');
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void _enableStartButton() {
        if (this._commands != null && this._commands.size() > 0) {
            this._startButton.setEnabled(true);
        } else {
            this._startButton.setEnabled(false);
        }
    }

    private Object _executeCommands() {
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                if (this._process != null) {
                    this._process.destroy();
                }
                this._progressBar.setMaximum(this._commands.size());
                int n = 0;
                Iterator iterator = this._commands.iterator();
                while (iterator.hasNext()) {
                    this._updateProgressBar(++n);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String[] stringArray = GUIStringUtilities.tokenizeForExec((String)iterator.next());
                    this.appendJTextArea("About to execute:\n");
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        this.appendJTextArea("\t" + stringArray[n2]);
                        if (stringBuffer.length() < 50) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append(stringArray[n2]);
                        }
                        ++n2;
                    }
                    if (stringBuffer.length() >= 50) {
                        stringBuffer.append(" . . .");
                    }
                    this._statusBar.setText("Executing: " + stringBuffer.toString());
                    this._process = runtime.exec(stringArray);
                    _StreamReaderThread _StreamReaderThread2 = new _StreamReaderThread(this._process.getErrorStream(), "ERROR", this);
                    _StreamReaderThread _StreamReaderThread3 = new _StreamReaderThread(this._process.getInputStream(), "OUTPUT", this);
                    _StreamReaderThread2.start();
                    _StreamReaderThread3.start();
                    try {
                        int n3 = this._process.waitFor();
                        JTextAreaExec jTextAreaExec = this;
                        synchronized (jTextAreaExec) {
                            this._process = null;
                        }
                        if (n3 == 0) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        this.appendJTextArea("InterruptedException: " + interruptedException);
                        throw interruptedException;
                    }
                }
                this.appendJTextArea("All Done.");
            }
            catch (IOException iOException) {
                this.appendJTextArea("IOException: " + iOException);
            }
        }
        catch (InterruptedException interruptedException) {
            this._process.destroy();
            this._updateProgressBar(0);
            return "Interrupted";
        }
        return "All Done";
    }

    private void _updateProgressBar(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                JTextAreaExec.this._progressBar.setValue(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static /* synthetic */ Object access$900(JTextAreaExec jTextAreaExec) {
        return jTextAreaExec._executeCommands();
    }

    static /* synthetic */ void access$1000(JTextAreaExec jTextAreaExec, int n) {
        jTextAreaExec._updateProgressBar(n);
    }

    private class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private String _streamType;
        private JTextAreaExec _jTextAreaExec;

        _StreamReaderThread(InputStream inputStream, String string, JTextAreaExec jTextAreaExec2) {
            this._inputStream = inputStream;
            this._streamType = string;
            this._jTextAreaExec = jTextAreaExec2;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this._jTextAreaExec.appendJTextArea(string);
                }
            }
            catch (IOException iOException) {
                this._jTextAreaExec.appendJTextArea("IOException: " + iOException);
            }
        }
    }
}

