/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.LinkedList;

public class GUIStringUtilities {
    private GUIStringUtilities() {
    }

    public static String abbreviate(String string) {
        if (string == null) {
            return "<Unnamed>";
        }
        if (string.length() < 80) {
            return string;
        }
        return string.substring(0, 37) + ". . ." + string.substring(string.length() - 38);
    }

    public static String split(String string) {
        if (string == null) {
            return "<Unnamed>";
        }
        if (string.length() < 80) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length() - 80) {
            stringBuffer.append(string.substring(n, n + 79) + "\n");
            n += 80;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String[] tokenizeForExec(String string) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.ordinaryChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        block6: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (bl) {
                        if (string2.length() > 0) {
                            string2 = string2 + " ";
                        }
                        string2 = string2 + string3 + streamTokenizer.sval;
                    } else {
                        string2 = string3 + streamTokenizer.sval;
                        linkedList.add(string2);
                    }
                    string3 = "";
                    break;
                }
                case -2: {
                    throw new RuntimeException("Internal error: Found TT_NUMBER: '" + streamTokenizer.nval + "'.  We should not be " + "tokenizing numbers");
                }
                case 10: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    string3 = new Character((char)streamTokenizer.ttype).toString();
                    if (!string3.equals("\"")) continue block6;
                    if (bl) {
                        linkedList.add(string2);
                    }
                    bl = !bl;
                    string3 = "";
                    string2 = "";
                }
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }
}

