/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.swing.JApplet;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.gui.MessageHandler;

public class BasicJApplet
extends JApplet {
    protected Color _background;

    public String getAppletInfo() {
        return "Ptolemy II swing-based applet.\nPtolemy II comes from UC Berkeley, Department of EECS.\nSee http://ptolemy.eecs.berkeley.edu/ptolemyII";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"background", "#RRGGBB", "color of the background"}};
        return stringArray;
    }

    public void init() {
        GraphicalMessageHandler.setContext(this);
        MessageHandler.setMessageHandler(new GraphicalMessageHandler());
        this._background = null;
        try {
            String string = this.getParameter("background");
            if (string != null) {
                this._background = Color.decode(string);
            }
        }
        catch (Exception exception) {
            this.report("Warning: background parameter failed: ", exception);
        }
        this.setBackground(this._background);
        this.getRootPane().setBackground(this._background);
        this.getContentPane().setBackground(this._background);
    }

    public void report(Exception exception) {
        this.report("Exception thrown by applet.", exception);
    }

    public void report(String string) {
        this.showStatus(string);
    }

    public void report(String string, Exception exception) {
        exception.printStackTrace();
        MessageHandler.error(string, exception);
        this.showStatus("exception occurred.");
    }

    protected String[][] _concatStringArrays(String[][] stringArray, String[][] stringArray2) {
        String[][] stringArray3 = new String[stringArray.length + stringArray2.length][];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected Color _getBackground() {
        return this._background;
    }

    protected String _stackTraceToString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

