/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import VOTableUtil.Info;
import VOTableUtil.Votable;
import com.tbf.xml.XmlElement;
import com.tbf.xml.XmlParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;

public class VOTableWrapper {
    Votable v = null;
    PrintWriter out;
    String error = null;

    public String getLastError() {
        return this.error;
    }

    public Votable getVotable() {
        return this.v;
    }

    public VOTableWrapper(String string, PrintWriter printWriter) {
        URL uRL;
        this.out = printWriter;
        InputStream inputStream = null;
        if (string.startsWith("http://")) {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                this.error = "Bad URL: " + string + "\n Exception is: " + exception;
                return;
            }
            try {
                inputStream = uRL.openStream();
            }
            catch (Exception exception) {
                this.error = "Cannot open URL: " + string + "\nException is: " + exception;
                return;
            }
        }
        try {
            inputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            this.error = "Cannot open file " + string + ":\n" + exception;
            return;
        }
        uRL = new XmlParser();
        XmlElement xmlElement = uRL.parse(inputStream);
        if (xmlElement == null) {
            Exception exception = uRL.getLastException();
            this.error = "XML parse error: " + exception;
            return;
        }
        this.v = new Votable(xmlElement);
        if (this.v == null) {
            this.error = "Cannot find VOTABLE element";
            return;
        }
        int n = 0;
        while (n < this.v.getInfoCount()) {
            Info info = this.v.getInfoAt(n);
            if (info.getName().equals("Error")) {
                this.error = info.getValue();
                this.v = null;
                return;
            }
            ++n;
        }
        if (printWriter != null) {
            printWriter.println("Parsing successful");
        }
    }
}

