/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import PrimArray.PrimArray;
import VOTableUtil.Binary;
import VOTableUtil.Data;
import VOTableUtil.Field;
import VOTableUtil.Fits;
import VOTableUtil.Table;
import VOTableUtil.Tabledata;
import VOTableUtil.Tr;
import com.jvt.votable.FieldAndData;
import com.jvt.votable.bucket;
import java.io.PrintWriter;
import java.util.Vector;

public class VOSingleTable {
    int recordCount = 0;
    int fieldCount = 0;
    Vector fieldsAndData = new Vector();
    String error = null;
    PrintWriter out;
    Table table;

    public String getLastError() {
        return this.error;
    }

    public Table getTable() {
        return this.table;
    }

    public VOSingleTable(Table table, PrintWriter printWriter) {
        Data data;
        this.out = printWriter;
        this.table = table;
        int n = 0;
        while (n < table.getFieldCount()) {
            data = table.getFieldAt(n);
            FieldAndData fieldAndData = new FieldAndData((Field)data);
            if (fieldAndData.error != null) {
                this.error = "Field " + n + " generated errors:\n" + fieldAndData.error;
                return;
            }
            this.fieldsAndData.addElement(fieldAndData);
            ++this.fieldCount;
            ++n;
        }
        data = table.getData();
        if (data == null) {
            this.error = "Cannot find DATA element";
            return;
        }
        if (data.isTabledata()) {
            this.parseTabledata(data.getTabledata());
        } else if (data.isFits()) {
            this.parseFits(data.getFits());
        } else if (data.isBinary()) {
            this.parseBinary(data.getBinary());
        } else {
            this.error = "Unknown DATA format!!";
            return;
        }
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public boolean isVariableLength(int n) {
        if (n < 0 || n >= this.fieldsAndData.size()) {
            return false;
        }
        FieldAndData fieldAndData = (FieldAndData)this.fieldsAndData.elementAt(n);
        return fieldAndData.variableLength;
    }

    public int primitiveCount(int n, int n2) {
        if (n < 0 || n >= this.fieldCount) {
            return -1;
        }
        FieldAndData fieldAndData = (FieldAndData)this.fieldsAndData.elementAt(n);
        if (fieldAndData.variableLength) {
            if (n2 < 0 || n2 >= this.recordCount) {
                return -1;
            }
            return fieldAndData.primCount.getInt(n2);
        }
        return fieldAndData.blockSize;
    }

    private void parseTabledata(Tabledata tabledata) {
        this.recordCount = tabledata.getTrCount();
        int n = 0;
        while (n < this.recordCount) {
            Tr tr = tabledata.getTrAt(n);
            if (tr.getTdCount() != this.fieldCount) {
                this.error = "Tabledata record " + n + ": " + tr.getTdCount() + " cells, should be " + this.fieldCount;
                return;
            }
            int n2 = 0;
            while (n2 < this.fieldCount) {
                FieldAndData fieldAndData = (FieldAndData)this.fieldsAndData.elementAt(n2);
                String string = tr.getTdAt(n2).getPCDATA();
                int n3 = fieldAndData.pa.storeFromString(string);
                if (fieldAndData.variableLength) {
                    if (n3 % fieldAndData.blockSize != 0) {
                        this.error = "Record " + n + " Field " + n2 + " has improper number of prims in table cell " + n3 + " is not a multiple of " + fieldAndData.blockSize;
                        return;
                    }
                    fieldAndData.primCount.storeFromInt(n3);
                    int n4 = n == 0 ? 0 : fieldAndData.primOffset.getInt(n - 1) + fieldAndData.primCount.getInt(n - 1);
                    fieldAndData.primOffset.storeFromInt(n4);
                } else if (n3 % fieldAndData.blockSize != 0) {
                    this.error = "Record " + n + " Field " + n2 + " has improper number of prims in table cell. Found=" + n3 + ", should be " + fieldAndData.blockSize;
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void parseFits(Fits fits) {
        this.error = "Data is FITS -- this is not implemented yet!";
    }

    private void parseBinary(Binary binary) {
        this.error = "Data is BINARY -- this is not implemented yet!";
    }

    public String getString(int n, int n2) {
        PrimArray primArray = ((FieldAndData)this.fieldsAndData.elementAt((int)n)).pa;
        boolean bl = primArray.getType() == 10;
        return this.concat(this.getStringArray(n, n2), !bl);
    }

    private String concat(String[] stringArray, boolean bl) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            if (bl && n > 0) {
                string = string + " ";
            }
            string = string + stringArray[n];
            ++n;
        }
        return string;
    }

    private bucket getOffsetCount(int n, int n2) {
        bucket bucket2 = new bucket();
        FieldAndData fieldAndData = (FieldAndData)this.fieldsAndData.elementAt(n);
        bucket2.pa = fieldAndData.pa;
        if (fieldAndData.variableLength) {
            bucket2.o = fieldAndData.primOffset.getInt(n2);
            bucket2.c = fieldAndData.primCount.getInt(n2);
        } else {
            bucket2.o = n2 * fieldAndData.blockSize;
            bucket2.c = fieldAndData.blockSize;
        }
        return bucket2;
    }

    public String[] getStringArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getStringArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public byte[] getByteArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getByteArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public byte[] getBitArray(int n, int n2) {
        return null;
    }

    public boolean[] getBooleanArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getBooleanArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public char[] getCharArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getCharArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public char[] getUnicodeCharArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getCharArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public double[] getDoubleArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getDoubleArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public double[] getDoubleComplexArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getDoubleComplexArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public float[] getFloatArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getFloatArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public float[] getFloatComplexArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getFloatComplexArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public int[] getIntArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getIntArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public long[] getLongArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getLongArray(bucket2.o, bucket2.o + bucket2.c);
    }

    public short[] getShortArray(int n, int n2) {
        bucket bucket2 = this.getOffsetCount(n, n2);
        return bucket2.pa.getShortArray(bucket2.o, bucket2.o + bucket2.c);
    }
}

