/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import cds.savot.model.FieldSet;
import cds.savot.model.LinkSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotData;
import cds.savot.model.SavotField;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import com.jvt.votable.Column;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.VOTableMetaDataExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import vowrite.VOTable;
import vowrite.VOTableField;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class SAVOTParser {
    private static final String[] _errorMsg = new String[]{"", "Error: No resource in VOTable.", "Error: No columns in VOTable.", "Error: No data in VOTable.", "Error: No table data in VOTable.", "Error: No rows in VOTable.", "Error: No table in VOTable."};
    private int _errorNum = 0;
    VOTableMetaDataExtractor vom = null;
    private static final int _type = SavotPullEngine.FULL;
    private PlotData _plotdata = null;
    private final String UCD_RA = "POS_EQ_RA_MAIN";
    private final String UCD_DEC = "POS_EQ_DEC_MAIN";
    private final String XML_ENCODING = "UTF-8";
    private static final char SEP_RA_DEC = ' ';
    private VOTable _votable = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;

    public SAVOTParser(String string) {
        try {
            URL uRL = new URL(string);
            SavotPullParser savotPullParser = new SavotPullParser(uRL, _type, "UTF-8");
            SavotVOTable savotVOTable = savotPullParser.getVOTable();
            this.readMetaData(savotVOTable);
            ResourceSet resourceSet = savotVOTable.getResources();
            if (resourceSet.getItemCount() <= 0) {
                this._errorNum = 1;
            } else {
                SavotResource savotResource = (SavotResource)resourceSet.getItemAt(0);
                this.getData(savotResource);
            }
        }
        catch (Exception exception) {
            System.out.println("Error in parsing VOTable at '" + string + "'. " + exception.toString());
            exception.printStackTrace();
        }
    }

    public SAVOTParser(InputStream inputStream) {
        try {
            SavotPullParser savotPullParser = new SavotPullParser(inputStream, _type, "UTF-8");
            SavotVOTable savotVOTable = savotPullParser.getVOTable();
            this.readMetaData(savotVOTable);
            ResourceSet resourceSet = savotVOTable.getResources();
            if (resourceSet.getItemCount() <= 0) {
                this._errorNum = 1;
            } else {
                SavotResource savotResource = (SavotResource)resourceSet.getItemAt(0);
                this.getData(savotResource);
            }
        }
        catch (Exception exception) {
            System.out.println("Error in parsing VOTable from given input.");
            exception.printStackTrace();
        }
    }

    public SAVOTParser(String string, boolean bl) {
        try {
            SavotPullParser savotPullParser = new SavotPullParser(string, _type);
            SavotVOTable savotVOTable = savotPullParser.getVOTable();
            this.readMetaData(savotVOTable);
            ResourceSet resourceSet = savotVOTable.getResources();
            if (resourceSet.getItemCount() <= 0) {
                this._errorNum = 1;
            } else {
                SavotResource savotResource = (SavotResource)resourceSet.getItemAt(0);
                this.getData(savotResource);
            }
        }
        catch (Exception exception) {
            System.out.println("Error in parsing VOTable at '" + string + "'. " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void readMetaData(SavotVOTable savotVOTable) {
        this.vom = new VOTableMetaDataExtractor(savotVOTable);
    }

    public VOTable getVOTableMetaData() {
        if (null != this.vom) {
            return this.vom.getVOTable();
        }
        return null;
    }

    public VOTableResource getVOTableResourceMetaData() {
        if (null != this.vom) {
            return this.vom.getVOTableResource();
        }
        return null;
    }

    public VOTableTable getVOTableTableMetaData() {
        if (null != this.vom) {
            return this.vom.getVOTableTable();
        }
        return null;
    }

    public PlotData getPlotData() {
        if (null == this._plotdata) {
            System.out.println(_errorMsg[this._errorNum]);
        }
        return this._plotdata;
    }

    private void getData(SavotResource savotResource) {
        try {
            if (null == savotResource) {
                this._errorNum = 1;
                return;
            }
            Object var2_2 = null;
            this._plotdata = new PlotData();
            String string = savotResource.getDescription();
            this._plotdata.setCatalogueName(string);
            TableSet tableSet = savotResource.getTables();
            if (tableSet.getItemCount() <= 0) {
                this._errorNum = 6;
                return;
            }
            SavotTable savotTable = (SavotTable)tableSet.getItemAt(0);
            ArrayList arrayList = this.getFieldData(savotTable);
            this._plotdata = this.getTableData(savotTable, arrayList);
            if (0 != this._errorNum) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addFieldData(Column column, SavotField savotField, int n) {
        String string = savotField.getUcd();
        String string2 = savotField.getUnit();
        String string3 = savotField.getDataType();
        String string4 = savotField.getName();
        if (!(null != string4 && string4.trim().length() > 0 || null != (string4 = savotField.getId()) && string4.trim().length() > 0)) {
            string4 = "Field " + (n + 1);
        }
        column.setName(string4);
        column.setUnit(string2);
        column.setUCD(string);
        column.setDatatype(string3);
        VOTableField vOTableField = new VOTableField();
        vOTableField.setName(string4);
        vOTableField.setUnit(string2);
        vOTableField.setUcd(string);
        vOTableField.setDataType(string3);
        vOTableField.setId(savotField.getId());
        vOTableField.setPrecision(savotField.getPrecision());
        vOTableField.setWidth(savotField.getWidth());
        vOTableField.setRef(savotField.getRef());
        vOTableField.setArraySize(savotField.getArraySize());
        vOTableField.setType(savotField.getType());
        vOTableField.setDescription(URLEncoder.encode(savotField.getDescription()));
        LinkSet linkSet = savotField.getLinks();
        vOTableField.addAllLink(VOTableMetaDataExtractor.extractLink(linkSet));
        column.setVOField(vOTableField);
    }

    private ArrayList getFieldData(SavotTable savotTable) {
        FieldSet fieldSet = savotTable.getFields();
        if (fieldSet.getItemCount() <= 0) {
            this._errorNum = 2;
        }
        ArrayList<FieldIndexType> arrayList = new ArrayList<FieldIndexType>();
        boolean bl = false;
        int n = 0;
        while (n < fieldSet.getItemCount()) {
            VOTableField vOTableField;
            Column column;
            SavotField savotField = (SavotField)fieldSet.getItemAt(n);
            String string = savotField.getDataType();
            String string2 = savotField.getUcd();
            if ("POS_EQ_RA_MAIN".equals(string2) || "POS_EQ_DEC_MAIN".equals(string2)) {
                if (string2.equals("POS_EQ_RA_MAIN")) {
                    if (this.isNumeric(string)) {
                        arrayList.add(new FieldIndexType(n, 0));
                    } else if (string.equals("char")) {
                        arrayList.add(new FieldIndexType(n, 1));
                    }
                }
                if (string2.equals("POS_EQ_DEC_MAIN")) {
                    if (this.isNumeric(string)) {
                        arrayList.add(new FieldIndexType(n, 0));
                    } else if (string.equals("char")) {
                        arrayList.add(new FieldIndexType(n, 2));
                    }
                }
                column = new PlotColumn();
                this.addFieldData(column, savotField, n);
                column.setDatatype("double");
                vOTableField = column.getVOField();
                vOTableField.setDataType("double");
                this._plotdata.addPlotColumn((PlotColumn)column);
            } else if (null != string) {
                if (this.isNumeric(string)) {
                    arrayList.add(new FieldIndexType(n, 0));
                    column = new PlotColumn();
                    this.addFieldData(column, savotField, n);
                    this._plotdata.addPlotColumn((PlotColumn)column);
                } else {
                    arrayList.add(new FieldIndexType(n, 3));
                    column = new DataDisplayColumn();
                    this.addFieldData(column, savotField, n);
                    vOTableField = column.getVOField();
                    if (vOTableField == null) {
                        System.out.println("the field is null");
                    }
                    this._plotdata.addDataDisplayColumn((DataDisplayColumn)column);
                }
            }
            ++n;
        }
        SAVOTParser.printFieldIndex(arrayList);
        return arrayList;
    }

    private boolean isNumeric(String string) {
        return string.equals("unsignedByte") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double");
    }

    private PlotData getTableData(SavotTable savotTable, ArrayList arrayList) {
        SavotData savotData = savotTable.getData();
        if (null == savotData) {
            this._errorNum = 3;
            return this._plotdata;
        }
        SavotTableData savotTableData = savotData.getTableData();
        if (null == savotTableData) {
            this._errorNum = 4;
            return this._plotdata;
        }
        TRSet tRSet = savotTableData.getTRs();
        if (null == tRSet || tRSet.getItemCount() <= 0) {
            this._errorNum = 5;
            return this._plotdata;
        }
        int n = 0;
        while (n < tRSet.getItemCount()) {
            TDSet tDSet = tRSet.getTDSet(n);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < arrayList.size()) {
                Serializable serializable;
                FieldIndexType fieldIndexType = (FieldIndexType)arrayList.get(n4);
                SavotTD savotTD = (SavotTD)tDSet.getItemAt(fieldIndexType.getIndex());
                String string = null == savotTD ? "" : savotTD.getContent();
                if (3 == fieldIndexType.getType()) {
                    if (null != (serializable = this._plotdata.getDataDisplayColumn(n3++))) {
                        ((DataDisplayColumn)serializable).addData(string);
                    }
                } else {
                    PlotColumn plotColumn;
                    serializable = this.extractColumnData(string, fieldIndexType.getType());
                    if (null != (plotColumn = this._plotdata.getPlotColumn(n2++))) {
                        plotColumn.addData((Double)serializable);
                    }
                }
                ++n4;
            }
            ++n;
        }
        return this._plotdata;
    }

    private Double extractRA(String string) {
        Double d = null;
        try {
            if (null == string || string.trim().length() == 0) {
                return d;
            }
            if ((string = string.trim()).indexOf(32) == string.lastIndexOf(32)) {
                float f = Float.parseFloat(string.substring(0, string.indexOf(32)));
                float f2 = Float.parseFloat(string.substring(string.indexOf(32) + 1));
                double d2 = (f + f2 / 60.0f) * 15.0f;
                d = new Double(d2);
            } else {
                float f = Float.parseFloat(string.substring(0, string.indexOf(32)));
                float f3 = Float.parseFloat(string.substring(string.indexOf(32) + 1, string.lastIndexOf(32)));
                float f4 = Float.parseFloat(string.substring(string.lastIndexOf(32) + 1));
                double d3 = (f + f3 / 60.0f + f4 / 3600.0f) * 15.0f;
                d = new Double(d3);
            }
        }
        catch (Exception exception) {
            d = null;
        }
        return d;
    }

    private Double extractDEC(String string) {
        Double d = null;
        int n = 1;
        int n2 = 0;
        try {
            if (null == string || string.trim().length() == 0) {
                return d;
            }
            if ((string = string.trim()).charAt(0) == '-') {
                n = -1;
                n2 = 1;
            }
            if (string.charAt(0) == '+') {
                n = 1;
                n2 = 1;
            }
            if (string.indexOf(32) == string.lastIndexOf(32)) {
                float f = Float.parseFloat(string.substring(n2, string.indexOf(32)));
                float f2 = Float.parseFloat(string.substring(string.indexOf(32) + 1));
                double d2 = (float)n * (f + f2 / 60.0f);
                d = new Double(d2);
            } else {
                float f = Float.parseFloat(string.substring(n2, string.indexOf(32)));
                float f3 = Float.parseFloat(string.substring(string.indexOf(32) + 1, string.lastIndexOf(32)));
                float f4 = Float.parseFloat(string.substring(string.lastIndexOf(32) + 1));
                double d3 = (float)n * (f + f3 / 60.0f + f4 / 3600.0f);
                d = new Double(d3);
            }
        }
        catch (Exception exception) {
            d = null;
        }
        return d;
    }

    private Double extractColumnData(String string, int n) {
        Double d = null;
        if (null == string || string.trim().length() <= 0) {
            d = null;
        } else {
            try {
                if (n == 1) {
                    d = this.extractRA(string);
                } else if (n == 2) {
                    d = this.extractDEC(string);
                } else if (n == 0) {
                    d = new Double(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                d = null;
            }
        }
        return d;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.out.println("Usage: java SAVOTParser <source> ");
        } else {
            SAVOTParser sAVOTParser = new SAVOTParser(stringArray[0], true);
            System.out.println("Getting data... ");
        }
    }

    private static void printVOTableData(PlotData plotData) {
        System.out.println("Printing Plot Data.");
        if (null != plotData) {
            System.out.println("Number of columns is " + plotData.getNumOfPlotColumns());
            int n = 0;
            while (n < plotData.getNumOfPlotColumns()) {
                PlotColumn plotColumn = plotData.getPlotColumn(n);
                System.out.println(plotColumn.getName());
                Double[] doubleArray = plotColumn.getData();
                int n2 = 0;
                while (n2 < doubleArray.length) {
                    System.out.println(doubleArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    private static void printFieldIndex(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            FieldIndexType fieldIndexType = (FieldIndexType)arrayList.get(n);
            ++n;
        }
    }

    private static void printPlotData(PlotData plotData) {
        if (null == plotData) {
            System.out.println("Plot data is null.");
            return;
        }
        System.out.println("Number of plot columns is = " + plotData.getNumOfPlotColumns());
        System.out.println("Number of data display columns is = " + plotData.getNumOfDataDisplayColumns());
        int n = 0;
        while (n < plotData.getNumOfDataDisplayColumns()) {
            DataDisplayColumn dataDisplayColumn = plotData.getDataDisplayColumn(n);
            System.out.println("Column name = " + dataDisplayColumn.getName());
            if (null != dataDisplayColumn) {
                int n2 = 0;
                while (n2 < dataDisplayColumn.getNumOfRows()) {
                    System.out.println(dataDisplayColumn.getData(n2));
                    ++n2;
                }
            }
            ++n;
        }
    }

    class FieldIndexType {
        public static final int TYPE_NUMERIC = 0;
        public static final int TYPE_RA = 1;
        public static final int TYPE_DEC = 2;
        public static final int TYPE_NONNUMERIC = 3;
        private int _index;
        private int _type;

        public FieldIndexType(int n, int n2) {
            this._index = n;
            this._type = n2;
        }

        public int getIndex() {
            return this._index;
        }

        public int getType() {
            return this._type;
        }
    }
}

