/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotFilter;
import java.io.Serializable;
import java.util.ArrayList;
import vowrite.VOTableField;

public class PlotData
implements Serializable {
    public static final String OBJECT_ID = "_OID";
    public static final String OBJECT_UCD = "ID_NUMBER";
    private int _objectIDColIndex = -1;
    private ArrayList _plotColumnList = new ArrayList();
    private ArrayList _plotFilterList = new ArrayList();
    private ArrayList _generalDataList = new ArrayList();
    private int _numOfRows = 0;
    private String _catalogueName;

    public void addPlotColumn(PlotColumn plotColumn) {
        if (null != plotColumn) {
            this._plotColumnList.add(plotColumn);
        }
    }

    public DataDisplayColumn getObjectIDColumn() {
        if (-1 == this._objectIDColIndex) {
            int n = 0;
            while (n < this._generalDataList.size()) {
                DataDisplayColumn dataDisplayColumn = (DataDisplayColumn)this._generalDataList.get(n);
                if (OBJECT_ID.equals(dataDisplayColumn.getName())) {
                    this._objectIDColIndex = n;
                    return dataDisplayColumn;
                }
                ++n;
            }
        } else if (this._objectIDColIndex >= 0 && this._objectIDColIndex < this._generalDataList.size()) {
            DataDisplayColumn dataDisplayColumn = (DataDisplayColumn)this._generalDataList.get(this._objectIDColIndex);
            return dataDisplayColumn;
        }
        return null;
    }

    public void addDataDisplayColumn(DataDisplayColumn dataDisplayColumn) {
        if (null != dataDisplayColumn) {
            this._generalDataList.add(dataDisplayColumn);
        }
    }

    public void addPlotFilter(PlotFilter plotFilter) {
        if (null != plotFilter) {
            this._plotFilterList.add(plotFilter);
        }
    }

    public int getNumOfPlotColumns() {
        return this._plotColumnList.size();
    }

    public int getNumOfDataDisplayColumns() {
        return this._generalDataList.size();
    }

    public int getNumOfFilters() {
        return this._plotFilterList.size();
    }

    public int getNumOfRows() {
        if (this._numOfRows <= 0 && this.getNumOfPlotColumns() > 0) {
            PlotColumn plotColumn = this.getPlotColumn(0);
            this._numOfRows = plotColumn.getNumOfRows();
        }
        return this._numOfRows;
    }

    public PlotFilter getPlotFilter(int n) {
        if (n < 0 || n >= this._plotFilterList.size()) {
            return null;
        }
        return (PlotFilter)this._plotFilterList.get(n);
    }

    public PlotColumn getPlotColumn(int n) {
        if (n < 0 || n >= this._plotColumnList.size()) {
            return null;
        }
        return (PlotColumn)this._plotColumnList.get(n);
    }

    public DataDisplayColumn getDataDisplayColumn(int n) {
        if (n < 0 || n >= this._generalDataList.size()) {
            return null;
        }
        return (DataDisplayColumn)this._generalDataList.get(n);
    }

    public String getCatalogueName() {
        return this._catalogueName;
    }

    public void setCatalogueName(String string) {
        this._catalogueName = string;
    }

    public boolean generateObjectIDColumn() {
        try {
            DataDisplayColumn dataDisplayColumn = new DataDisplayColumn();
            dataDisplayColumn.setName(OBJECT_ID);
            dataDisplayColumn.setUCD(OBJECT_UCD);
            int n = 0;
            while (n < this.getNumOfRows()) {
                dataDisplayColumn.addData("" + n);
                ++n;
            }
            VOTableField vOTableField = new VOTableField();
            vOTableField.setName(OBJECT_ID);
            vOTableField.setUcd(OBJECT_UCD);
            vOTableField.setType("hidden");
            vOTableField.setDataType("char");
            dataDisplayColumn.setVOField(vOTableField);
            this.addDataDisplayColumn(dataDisplayColumn);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getObjectIDColumnIndex() {
        if (-1 == this._objectIDColIndex) {
            int n = 0;
            while (n < this._generalDataList.size()) {
                DataDisplayColumn dataDisplayColumn = (DataDisplayColumn)this._generalDataList.get(n);
                if (OBJECT_ID.equals(dataDisplayColumn.getName())) {
                    this._objectIDColIndex = n;
                    return this._objectIDColIndex;
                }
                ++n;
            }
        }
        return this._objectIDColIndex;
    }
}

