/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.utils;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class JVTUtil {
    public static final String PLOT_FONT_PLAIN = "Helvetica-PLAIN-12";
    public static final String PLOT_FONT_BOLD = "Helvetica-BOLD-12";
    public static final String TITLE_FONT_BOLD = "Helvetica-BOLD-14";
    public static final String SUPERSCRIPT_FONT_PLAIN = "Helvetica-PLAIN-9";
    public static final String NO_FILTER = "All";
    public static final int MAX_ROWS_COUNT = 6;
    public static final int VOTABLE_TEXT_INPUT_WIDTH = 25;
    public static final String ZOOM_LABEL = "Zoom";
    public static final String SELECT_LABEL = "Select";
    public static final String UNSELECT_LABEL = "UnSelect";
    public static final int NO_OF_ROWS_DISPLAYED = 100;
    public static final boolean DISPLAYING_VOTABLE = false;
    public static final boolean VOTABLE_NOT_DISPLAYED = true;
    public static final boolean DISPLAYING_DATA = false;
    public static final boolean DATA_NOT_DISPLAYED = true;
    public static boolean SHOW_VOTABLE = true;
    public static boolean SHOW_DATA = true;
    public static final String[] COOSYS_NAME = new String[]{"Mollweide", "Aitoff", "Mercator", "Sinusoidal", "Simple"};
    public static final String[][] COOSYS_LEGEND = new String[][]{{"MOL(", ")"}, {"AIT(", ")"}, {"MER(", ")"}, {"SIN(", ")"}, {"SMP(", ")"}};
    public static double _LOG10SCALE = 1.0 / Math.log(10.0);

    public static void showWaitCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void showDefaultCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void usePlainFont(JComponent jComponent) {
        jComponent.setFont(Font.decode(PLOT_FONT_PLAIN));
    }

    public static void useBoldFont(JComponent jComponent) {
        jComponent.setFont(Font.decode(PLOT_FONT_BOLD));
    }

    public static String applyProperFormat(double d, DecimalFormat decimalFormat, DecimalFormat decimalFormat2) {
        if (Double.isNaN(d)) {
            return "Invalid number";
        }
        if (d < 1000.0 && d > 0.01 || d > -1000.0 && d < -0.01 || d == 0.0) {
            return decimalFormat.format(d);
        }
        return decimalFormat2.format(d);
    }

    public static String[] setNoDecimalDigits(double[] dArray) {
        double d = dArray[1] - dArray[0];
        DecimalFormat decimalFormat = new DecimalFormat("0.0000E0");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.0000");
        DecimalFormat decimalFormat3 = new DecimalFormat("0.000E0");
        DecimalFormat decimalFormat4 = new DecimalFormat("0.000");
        DecimalFormat decimalFormat5 = new DecimalFormat("0.00E0");
        DecimalFormat decimalFormat6 = new DecimalFormat("0.00");
        String[] stringArray = new String[2];
        if (d > 999.0) {
            stringArray[0] = JVTUtil.applyProperFormat(dArray[0], decimalFormat6, decimalFormat5);
            stringArray[1] = JVTUtil.applyProperFormat(dArray[1], decimalFormat6, decimalFormat5);
        } else if (d > 99.0 && d <= 999.0) {
            stringArray[0] = JVTUtil.applyProperFormat(dArray[0], decimalFormat4, decimalFormat3);
            stringArray[1] = JVTUtil.applyProperFormat(dArray[1], decimalFormat4, decimalFormat3);
        } else {
            stringArray[0] = JVTUtil.applyProperFormat(dArray[0], decimalFormat2, decimalFormat);
            stringArray[1] = JVTUtil.applyProperFormat(dArray[1], decimalFormat2, decimalFormat);
        }
        return stringArray;
    }

    public static String getInOriginalFormat(Double d, int n) {
        String string = "";
        if (null == d) {
            return string;
        }
        if (1 == n) {
            string = d.toString();
        } else {
            double d2 = d;
            if (2 == n) {
                short s = (short)d2;
                string = string + s;
            } else if (3 == n) {
                short s = (short)d2;
                string = string + s;
            } else if (4 == n) {
                int n2 = (int)d2;
                string = string + n2;
            } else if (5 == n) {
                long l = (long)d2;
                string = string + l;
            } else if (6 == n) {
                float f = (float)d2;
                string = string + f;
            } else if (7 == n) {
                string = string + d2;
            }
        }
        return string;
    }
}

