/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.statistics;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.Arrays;

public class StatsCalculator
extends Descriptive {
    private int errorNum = 0;

    public double findlinearcorrelation(double[] dArray, double[] dArray2) {
        if (dArray.length <= 0 || dArray2.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.sum(doubleArrayList);
        double d2 = Descriptive.sumOfSquares(doubleArrayList);
        double d3 = Descriptive.variance(doubleArrayList.size(), d, d2);
        double d4 = Descriptive.standardDeviation(d3);
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray2);
        double d5 = Descriptive.sum(doubleArrayList2);
        double d6 = Descriptive.sumOfSquares(doubleArrayList2);
        double d7 = Descriptive.variance(doubleArrayList2.size(), d5, d6);
        double d8 = Descriptive.standardDeviation(d7);
        double d9 = Descriptive.correlation(doubleArrayList, d4, doubleArrayList2, d8);
        return d9;
    }

    public double findmean(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.mean(doubleArrayList);
        return d;
    }

    public double findvariance(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.sum(doubleArrayList);
        double d2 = Descriptive.sumOfSquares(doubleArrayList);
        double d3 = Descriptive.variance(doubleArrayList.size(), d, d2);
        return d3;
    }

    public double findstddev(double[] dArray) {
        double d = this.findvariance(dArray);
        double d2 = Descriptive.standardDeviation(d);
        return d2;
    }

    public double findskew(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = this.findmean(dArray);
        double d2 = this.findstddev(dArray);
        double d3 = Descriptive.skew(doubleArrayList, d, d2);
        return d3;
    }

    public double findkurtosis(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = this.findmean(dArray);
        double d2 = this.findstddev(dArray);
        double d3 = Descriptive.kurtosis(doubleArrayList, d, d2);
        return d3;
    }

    public double findmin(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.min(doubleArrayList);
        return d;
    }

    public double findmax(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.max(doubleArrayList);
        return d;
    }

    public double findrange(double[] dArray) {
        if (dArray.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.max(doubleArrayList);
        double d2 = Descriptive.min(doubleArrayList);
        return d - d2;
    }

    public int findnoofobservations(double[] dArray) {
        return dArray.length;
    }

    public double findrankcorrelation(double[] dArray, double[] dArray2) {
        int n;
        double d;
        int n2;
        int n3;
        double d2;
        double d3;
        double[] dArray3 = dArray;
        if (dArray.length <= 0) {
            return 0.0;
        }
        double[] dArray4 = new double[dArray3.length];
        double[] dArray5 = new double[dArray3.length];
        int n4 = 0;
        while (n4 < dArray3.length) {
            dArray5[n4] = dArray3[n4];
            ++n4;
        }
        Arrays.sort(dArray5);
        n4 = 0;
        while (n4 < dArray5.length) {
            dArray4[n4] = n4 + 1;
            ++n4;
        }
        n4 = 0;
        while (n4 < dArray5.length - 1) {
            d3 = dArray5[n4];
            d2 = dArray4[n4];
            n3 = n4 + 1;
            n2 = 1;
            while (d3 == dArray5[n3]) {
                ++n2;
                d2 += dArray4[n3];
                if (++n3 == dArray5.length) break;
            }
            d = d2 / (double)n2;
            n = n3 - n2;
            while (n < n3) {
                dArray4[n] = d;
                ++n;
            }
            n4 = n3;
        }
        double[] dArray6 = new double[dArray4.length];
        n4 = 0;
        while (n4 < dArray4.length) {
            n3 = 0;
            while (n3 < dArray4.length) {
                if (dArray3[n4] == dArray5[n3]) {
                    dArray6[n4] = dArray4[n3];
                    break;
                }
                ++n3;
            }
            ++n4;
        }
        double[] dArray7 = dArray2;
        double[] dArray8 = new double[dArray7.length];
        double[] dArray9 = new double[dArray7.length];
        n4 = 0;
        while (n4 < dArray7.length) {
            dArray9[n4] = dArray7[n4];
            ++n4;
        }
        Arrays.sort(dArray9);
        n4 = 0;
        while (n4 < dArray9.length) {
            dArray8[n4] = n4 + 1;
            ++n4;
        }
        n4 = 0;
        while (n4 < dArray9.length - 1) {
            d3 = dArray9[n4];
            d2 = dArray8[n4];
            n3 = n4 + 1;
            n2 = 1;
            while (d3 == dArray9[n3]) {
                ++n2;
                d2 += dArray8[n3];
                if (++n3 == dArray9.length) break;
            }
            d = d2 / (double)n2;
            n = n3 - n2;
            while (n < n3) {
                dArray8[n] = d;
                ++n;
            }
            n4 = n3;
        }
        double[] dArray10 = new double[dArray8.length];
        n4 = 0;
        while (n4 < dArray8.length) {
            n3 = 0;
            while (n3 < dArray8.length) {
                if (dArray7[n4] == dArray9[n3]) {
                    dArray10[n4] = dArray8[n3];
                    break;
                }
                ++n3;
            }
            ++n4;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray6);
        double d4 = Descriptive.sum(doubleArrayList);
        double d5 = Descriptive.sumOfSquares(doubleArrayList);
        double d6 = Descriptive.variance(doubleArrayList.size(), d4, d5);
        double d7 = Descriptive.standardDeviation(d6);
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray10);
        double d8 = Descriptive.sum(doubleArrayList2);
        double d9 = Descriptive.sumOfSquares(doubleArrayList2);
        double d10 = Descriptive.variance(doubleArrayList2.size(), d8, d9);
        double d11 = Descriptive.standardDeviation(d10);
        double d12 = Descriptive.correlation(doubleArrayList, d7, doubleArrayList2, d11);
        return d12;
    }

    public double findt_linear(double[] dArray, double[] dArray2) {
        double d = this.findlinearcorrelation(dArray, dArray2);
        int n = this.findnoofobservations(dArray);
        double d2 = (1.0 - d + 1.0E-20) * (1.0 + d + 1.0E-20);
        double d3 = d * Math.sqrt((double)(n - 2) / d2);
        return d3;
    }

    public double findlinearcorprob(double[] dArray, double[] dArray2) {
        int n = this.findnoofobservations(dArray);
        int n2 = n - 2;
        double d = this.findt_linear(dArray, dArray2);
        double d2 = this.betai(0.5 * (double)n2, 0.5, (double)n2 / ((double)n2 + d * d));
        return d2;
    }

    public double findt_rank(double[] dArray, double[] dArray2) {
        double d = this.findrankcorrelation(dArray, dArray2);
        int n = this.findnoofobservations(dArray);
        double d2 = (1.0 - d) * (1.0 + d);
        double d3 = d * Math.sqrt((double)(n - 2) / d2);
        return d3;
    }

    public double findrankcorprob(double[] dArray, double[] dArray2) {
        int n = this.findnoofobservations(dArray);
        int n2 = n - 2;
        double d = this.findt_rank(dArray, dArray2);
        double d2 = this.betai(0.5 * (double)n2, 0.5, (double)n2 / ((double)n2 + d * d));
        return d2;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public double findpartialcorrelation(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length <= 0 || dArray2.length <= 0 || dArray3.length <= 0) {
            return 0.0;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        double d = Descriptive.sum(doubleArrayList);
        double d2 = Descriptive.sumOfSquares(doubleArrayList);
        double d3 = Descriptive.variance(doubleArrayList.size(), d, d2);
        double d4 = Descriptive.standardDeviation(d3);
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(dArray2);
        double d5 = Descriptive.sum(doubleArrayList2);
        double d6 = Descriptive.sumOfSquares(doubleArrayList2);
        double d7 = Descriptive.variance(doubleArrayList2.size(), d5, d6);
        double d8 = Descriptive.standardDeviation(d7);
        DoubleArrayList doubleArrayList3 = new DoubleArrayList(dArray3);
        double d9 = Descriptive.sum(doubleArrayList3);
        double d10 = Descriptive.sumOfSquares(doubleArrayList3);
        double d11 = Descriptive.variance(doubleArrayList3.size(), d9, d10);
        double d12 = Descriptive.standardDeviation(d11);
        double d13 = Descriptive.correlation(doubleArrayList, d4, doubleArrayList2, d8);
        double d14 = Descriptive.correlation(doubleArrayList2, d8, doubleArrayList3, d12);
        double d15 = Descriptive.correlation(doubleArrayList, d4, doubleArrayList3, d12);
        double d16 = d15 * d14;
        double d17 = d13 - d16;
        double d18 = Math.sqrt((1.0 - d15 * d15) * (1.0 - d14 * d14));
        double d19 = d17 / d18;
        return d19;
    }

    public double gammln(double d) {
        double d2;
        double[] dArray = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d3 = d2 = d;
        double d4 = d2 + 5.5;
        d4 -= (d2 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        int n = 0;
        while (n <= 5) {
            d5 += dArray[n] / (d3 += 1.0);
            ++n;
        }
        return -d4 + Math.log(2.5066282746310007 * d5 / d2);
    }

    public double betacf(double d, double d2, double d3) {
        double d4 = 1.0E-30;
        double d5 = 3.0E-7;
        int n = 100;
        double d6 = d + d2;
        double d7 = d + 1.0;
        double d8 = d - 1.0;
        double d9 = 1.0;
        double d10 = 1.0 - d6 * d3 / d7;
        if (Math.abs(d10) < d4) {
            d10 = d4;
        }
        double d11 = d10 = 1.0 / d10;
        int n2 = 1;
        while (n2 <= n) {
            int n3 = 2 * n2;
            double d12 = (double)n2 * (d2 - (double)n2) * d3 / ((d8 + (double)n3) * (d + (double)n3));
            if (Math.abs(d10 = 1.0 + d12 * d10) < d4) {
                d10 = d4;
            }
            if (Math.abs(d9 = 1.0 + d12 / d9) < d4) {
                d9 = d4;
            }
            d10 = 1.0 / d10;
            d11 *= d10 * d9;
            d12 = -(d + (double)n2) * (d6 + (double)n2) * d3 / ((d + (double)n3) * (d7 + (double)n3));
            if (Math.abs(d10 = 1.0 + d12 * d10) < d4) {
                d10 = d4;
            }
            if (Math.abs(d9 = 1.0 + d12 / d9) < d4) {
                d9 = d4;
            }
            d10 = 1.0 / d10;
            double d13 = d10 * d9;
            d11 *= d13;
            if (Math.abs(d13 - 1.0) < d5) break;
            ++n2;
        }
        if (n2 > n) {
            this.errorNum = 2;
        }
        return d11;
    }

    public double betai(double d, double d2, double d3) {
        double d4;
        if (d3 < 0.0 || d3 > 1.0) {
            this.errorNum = 1;
        }
        if (d3 == 0.0 || d3 == 1.0) {
            d4 = 0.0;
        } else {
            double d5 = this.gammln(d + d2);
            double d6 = this.gammln(d);
            double d7 = this.gammln(d2);
            d4 = Math.exp(d5 - d6 - d7 + d * Math.log(d3) + d2 * Math.log(1.0 - d3));
        }
        if (d3 < (d + 1.0) / (d + d2 + 2.0)) {
            return d4 * this.betacf(d, d2, d3) / d;
        }
        return 1.0 - d4 * this.betacf(d2, d, 1.0 - d3) / d2;
    }

    void printArray(double[] dArray) {
        System.out.println("Length of array is " + dArray.length);
        int n = 0;
        while (n < dArray.length) {
            System.out.println(dArray[n]);
            ++n;
        }
    }
}

