/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import com.jvt.applets.PlotVOApplet;
import com.jvt.applets.VOTableFilter;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotData;
import com.jvt.votable.SAVOTParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotDataDisplayDialog;
import ptolemy.plot.PlotFilterDialog;
import ptolemy.plot.PlotFormatter;
import ptolemy.plot.PlotStatisticsDialog;
import ptolemy.plot.PlotTransformerDialog;
import ptolemy.plot.PlotVotableDisplayDialog;

public class PlotButtons
implements ActionListener {
    private JComboBox _cmbDataX = null;
    private JComboBox _cmbDataY = null;
    private JComboBox _cmbFilters = null;
    private JCheckBox _chkLogX = null;
    private JCheckBox _chkLogY = null;
    private JCheckBox _chkOverlay = null;
    private JLabel _lblX = null;
    private JLabel _lblY = null;
    private JLabel _lblFilter = null;
    private JButton _btnPlot = null;
    private JButton _btnHist = null;
    private transient MouseListener _btnPlotMouseListener = null;
    private transient MouseListener _btnHistMouseListener = null;
    private JButton _browseButton = null;
    private JButton _loadButton = null;
    private ActionListener _browseButtonListener = null;
    private ActionListener _loadButtonListener = null;
    private JLabel _XCoord = null;
    private JLabel _YCoord = null;
    private JTextField _txtCoord1 = new JTextField("   Coordinates");
    private JTextField _txtCoord2 = new JTextField("   Coordinates");
    private JPanel _panelPlotArea = new JPanel();
    private JPanel _panelButtonsArea = new JPanel();
    private JPanel _panelButtons = new JPanel();
    private JPanel _buttons = new JPanel();
    private JPanel _mainPanel = new JPanel();
    private JPanel _panelXCoordinate;
    private JPanel _panelYCoordinate;
    JPanel _entirePanel;
    JScrollPane _mainScrollPane;
    private int _verticalscrollbar = 20;
    private int _horizontalscrollbar = 30;
    private JPanel _toolbarButtonsPanel;
    private String _selectedFile;
    private JTextField _selectedFileEntryBox;
    private JLabel _statusBar;
    private String _imagePath = "/ptolemy/plot/smallImg/";
    private Container _container;
    private Color _background;
    private PlotVOApplet _pva;
    private int _xcoordinate = 0;
    private int _ycoordinate = 0;
    private static final double TOOLBAR_CELLSPACING = 1.0;
    private int _northAnchor = 11;
    private int _northeastAnchor = 12;
    private int _northwestAnchor = 18;
    URL img;
    ImageIcon selectIcon;
    ImageIcon unselectIcon;
    ImageIcon zoomIcon;
    ImageIcon resetIcon;
    ImageIcon printIcon;
    ImageIcon connectAladinIcon;
    ImageIcon viewVotableIcon;
    ImageIcon saveIcon;
    ImageIcon helpIcon;
    ImageIcon fillIcon;
    ImageIcon formatIcon;
    ImageIcon statIcon;
    ImageIcon transIcon;
    ImageIcon filterIcon;
    ImageIcon clearSelectionIcon;
    ImageIcon dataIcon;
    ImageIcon printHighlightIcon;
    ImageIcon zoomHighlightIcon;
    ImageIcon selectHighlightIcon;
    ImageIcon unselectHighlightIcon;
    ImageIcon resetHighlightIcon;
    ImageIcon connectAladinHighlightIcon;
    ImageIcon viewVotableHighlightIcon;
    ImageIcon saveHighlightIcon;
    ImageIcon fillHighlightIcon;
    ImageIcon formatHighlightIcon;
    ImageIcon statHighlightIcon;
    ImageIcon transHighlightIcon;
    ImageIcon filterHighlightIcon;
    ImageIcon clearSelectionHighlightIcon;
    ImageIcon dataHighlightIcon;
    ImageIcon helpHighlightIcon;
    File _currentDirectory;
    private transient MouseListener _chkOverlayMouseListener = null;
    private transient MouseListener _chkLogXMouseListener = null;
    private transient MouseListener _chkLogYMouseListener = null;
    private transient JButton _fillButton = null;
    private transient ActionListener _fillButtonListener = null;
    private transient MouseListener _fillButtonMouseListener = null;
    private transient JButton _formatButton = null;
    private transient ActionListener _formatButtonListener = null;
    private transient MouseListener _formatButtonMouseListener = null;
    private transient JButton _statButton = null;
    private transient ActionListener _statButtonListener = null;
    private transient MouseListener _statButtonMouseListener = null;
    private transient JButton _transButton = null;
    private transient ActionListener _transButtonListener = null;
    private transient MouseListener _transButtonMouseListener = null;
    private transient JButton _filterButton = null;
    private transient ActionListener _filterButtonListener = null;
    private transient MouseListener _filterButtonMouseListener = null;
    private transient JButton _saveButton = null;
    private transient ActionListener _saveButtonListener = null;
    private transient MouseListener _saveButtonMouseListener = null;
    private transient JButton _printButton = null;
    private transient ActionListener _printButtonListener = null;
    private transient MouseListener _printButtonMouseListener = null;
    private transient JButton _resetButton = null;
    private transient ActionListener _resetButtonListener = null;
    private transient MouseListener _resetButtonMouseListener = null;
    private transient JButton _zoomButton = null;
    private transient ActionListener _zoomButtonListener = null;
    private transient MouseListener _zoomButtonMouseListener = null;
    private transient JButton _clearSelectionButton = null;
    private transient ActionListener _clearSelectionButtonListener = null;
    private transient MouseListener _clearSelectionButtonMouseListener = null;
    private transient JButton _dataButton = null;
    private transient ActionListener _dataButtonListener = null;
    private transient MouseListener _dataButtonMouseListener = null;
    private transient JButton _connectAladinButton = null;
    private transient ActionListener _connectAladinButtonListener = null;
    private transient MouseListener _connectAladinButtonMouseListener = null;
    private transient JButton _selectButton = null;
    private transient ActionListener _selectButtonListener = null;
    private transient MouseListener _selectMouseListener = null;
    private transient JButton _unselectButton = null;
    private transient ActionListener _unselectButtonListener = null;
    private transient MouseListener _unselectMouseListener = null;
    private transient JButton _viewVotableButton = null;
    private transient ActionListener _viewVotableButtonListener = null;
    private transient MouseListener _viewVotableMouseListener = null;
    private int _buttonMode = 1;

    public void init(Container container, Color color, PlotVOApplet plotVOApplet) {
        this._container = container;
        this._pva = plotVOApplet;
        this._background = color;
        this._panelButtonsArea = this.addButtons(this._pva.getColumnNames(), this._background);
        this.setUpContainer();
        this._btnPlot.addActionListener(this);
        this._btnPlotMouseListener = new StatusListener();
        this._btnPlot.addMouseListener(this._btnPlotMouseListener);
        this._btnHist.addActionListener(this);
        this._btnHistMouseListener = new StatusListener();
        this._btnHist.addMouseListener(this._btnHistMouseListener);
    }

    public void emptyCmbData() {
        this._cmbDataX.removeAllItems();
        this._cmbDataY.removeAllItems();
    }

    public void addDataItem(String string) {
        this._cmbDataX.addItem(string);
        this._cmbDataY.addItem(string);
    }

    public void emptyCmbFilter() {
        this._cmbFilters.removeAllItems();
    }

    public void addFilterItem(String string) {
        this._cmbFilters.addItem(string);
    }

    public boolean isOverlaySelected() {
        return this._chkOverlay.isSelected();
    }

    public int getSelectedCooSysIndex() {
        return 4;
    }

    public String getSelectedXColumn() {
        return (String)this._cmbDataX.getSelectedItem();
    }

    public int getSelectedXIndex() {
        return this._cmbDataX.getSelectedIndex();
    }

    public void setSelectedXIndex(int n) {
        this._cmbDataX.setSelectedIndex(n);
    }

    public String getSelectedFilter() {
        return (String)this._cmbFilters.getSelectedItem();
    }

    public int getSelectedFilterIndex() {
        return this._cmbFilters.getSelectedIndex();
    }

    public void setSelectedFilterIndex(int n) {
        this._cmbFilters.setSelectedIndex(n);
    }

    public String getSelectedYColumn() {
        return (String)this._cmbDataY.getSelectedItem();
    }

    public int getSelectedYIndex() {
        return this._cmbDataY.getSelectedIndex();
    }

    public void setSelectedYIndex(int n) {
        this._cmbDataY.setSelectedIndex(n);
    }

    public boolean isLogX() {
        return this._chkLogX.isSelected();
    }

    public boolean isLogY() {
        return this._chkLogY.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._btnPlot) {
            if (this._pva.getPlotData() != null) {
                this._pva.drawPlot();
                this._pva.clearSelectedPoints(true);
                this._selectButton.setEnabled(true);
                this._unselectButton.setEnabled(true);
            }
        } else if (actionEvent.getSource() == this._btnHist && this._pva.getPlotData() != null) {
            this._pva.drawHistogram(-1.0);
            this._selectButton.setEnabled(false);
            this._unselectButton.setEnabled(false);
        }
    }

    public void setUpContainer() {
        this._entirePanel = new JPanel(new BorderLayout());
        this._mainPanel.setLayout(new BorderLayout());
        this._mainPanel.setBackground(this._background);
        this._panelPlotArea.setBackground(this._background);
        this._panelPlotArea.add(this._pva.plot());
        this._entirePanel.setBackground(this._background);
        if (this._pva.isWebApp() && !this._pva.isSubApp()) {
            this._panelButtonsArea.setPreferredSize(new Dimension(130, 0));
            this._mainPanel.add((Component)this._panelButtonsArea, "East");
            this._mainPanel.add((Component)this._panelPlotArea, "West");
        } else {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = this.addVOTableInputPanel();
            JPanel jPanel4 = new JPanel();
            JPanel jPanel5 = new JPanel();
            jPanel4.setBackground(this._background);
            jPanel5.setBackground(this._background);
            jPanel.setBackground(this._background);
            jPanel2.setBackground(this._background);
            jPanel2.add((Component)this._panelPlotArea, "North");
            if (!this._pva.isSubApp()) {
                jPanel2.add((Component)jPanel3, "Center");
            }
            jPanel2.add((Component)jPanel4, "South");
            JPanel jPanel6 = this.addStatusBar();
            jPanel.add((Component)this._panelButtonsArea, "North");
            jPanel.add((Component)jPanel5, "South");
            this._mainPanel.add((Component)jPanel, "East");
            this._mainPanel.add((Component)jPanel2, "West");
            this._mainPanel.add((Component)jPanel6, "South");
        }
        this._container.add((Component)this._mainPanel, "Center");
        this._entirePanel.add((Component)this._mainPanel, "Center");
        this._mainScrollPane = new JScrollPane(this._entirePanel, this._verticalscrollbar, this._horizontalscrollbar);
        if (this._pva.isWebApp()) {
            this._container.add(this._entirePanel);
        } else {
            this._container.add(this._mainScrollPane);
        }
        if (!this._pva.isWebApp() || this._pva.getNumOfColumns() == 0) {
            // empty if block
        }
        this._buttonMode = 1;
    }

    private JPanel addVOTableInputPanel() {
        this._browseButton = new JButton("Browse...");
        this._loadButton = new JButton("Load");
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Load VOTable (File or URL) :");
        this._selectedFileEntryBox = new JTextField(25);
        this._selectedFileEntryBox.setBackground(Color.white);
        JVTUtil.usePlainFont(this._browseButton);
        JVTUtil.usePlainFont(jLabel);
        JVTUtil.usePlainFont(this._loadButton);
        this._browseButtonListener = new ButtonListener(this, this._pva.plot());
        this._browseButton.addActionListener(this._browseButtonListener);
        this._browseButton.setToolTipText("Browse a VOTable file");
        this._loadButtonListener = new ButtonListener(this, this._pva.plot());
        this._loadButton.addActionListener(this._loadButtonListener);
        this._loadButton.setToolTipText("Load VOTable for plotting");
        jPanel.setLayout(new FlowLayout());
        jLabel.setBackground(this._background);
        jPanel.setBackground(this._background);
        jPanel.add(jLabel);
        jPanel.add(this._selectedFileEntryBox);
        jPanel.add(this._browseButton);
        jPanel.add(this._loadButton);
        return jPanel;
    }

    private JPanel addStatusBar() {
        JPanel jPanel = new JPanel();
        this._statusBar = new JLabel("Load a VOTable for plotting.");
        JVTUtil.usePlainFont(this._statusBar);
        this._statusBar.setForeground(Color.black);
        jPanel.add(this._statusBar);
        return jPanel;
    }

    public void swapPanels() {
        this._pva.setUpPlotBoxSwap();
        this._container.removeAll();
        this._mainPanel.removeAll();
        this._panelPlotArea.remove(0);
        this.setUpContainer();
        this._container.invalidate();
        this._container.validate();
        this.updateListeners();
        this._zoomButton.setIcon(this.zoomHighlightIcon);
        this._selectButton.setIcon(this.selectIcon);
        this._unselectButton.setIcon(this.unselectIcon);
        this._buttonMode = 1;
    }

    public JPanel addButtons(String[] stringArray, Color color) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel(new BorderLayout());
        JPanel jPanel10 = new JPanel(new BorderLayout());
        JPanel jPanel11 = new JPanel(new BorderLayout());
        JPanel jPanel12 = new JPanel(new BorderLayout());
        JPanel jPanel13 = new JPanel(new BorderLayout());
        JPanel jPanel14 = new JPanel(new BorderLayout());
        JPanel jPanel15 = new JPanel(new BorderLayout());
        JPanel jPanel16 = new JPanel(new BorderLayout());
        JPanel jPanel17 = new JPanel(new BorderLayout());
        this._panelXCoordinate = new JPanel(new BorderLayout());
        this._panelYCoordinate = new JPanel(new BorderLayout());
        JPanel jPanel18 = new JPanel();
        this._cmbDataX = new JComboBox();
        this._cmbDataY = new JComboBox();
        this._cmbFilters = new JComboBox();
        this._cmbFilters.addItem("All");
        this._chkLogX = new JCheckBox("Log");
        this._chkLogXMouseListener = new StatusListener();
        this._chkLogX.addMouseListener(this._chkLogXMouseListener);
        this._chkLogY = new JCheckBox("Log");
        this._chkLogYMouseListener = new StatusListener();
        this._chkLogY.addMouseListener(this._chkLogYMouseListener);
        this._chkOverlay = new JCheckBox("Overlay");
        this._chkOverlayMouseListener = new StatusListener();
        this._chkOverlay.addMouseListener(this._chkOverlayMouseListener);
        this._lblX = new JLabel();
        this._lblY = new JLabel();
        this._lblFilter = new JLabel();
        this._btnPlot = new JButton("Plot");
        this._btnHist = new JButton("Histogram");
        this._btnPlot.setPreferredSize(new Dimension(100, 25));
        this._btnHist.setPreferredSize(new Dimension(100, 25));
        this._txtCoord1.setPreferredSize(new Dimension(80, 22));
        this._txtCoord2.setPreferredSize(new Dimension(80, 22));
        JVTUtil.usePlainFont(this._btnPlot);
        JVTUtil.usePlainFont(this._btnHist);
        JVTUtil.usePlainFont(this._chkLogX);
        JVTUtil.usePlainFont(this._chkLogY);
        JVTUtil.usePlainFont(this._chkOverlay);
        JVTUtil.usePlainFont(this._lblX);
        JVTUtil.usePlainFont(this._lblY);
        JVTUtil.usePlainFont(this._lblFilter);
        JVTUtil.usePlainFont(this._cmbDataX);
        JVTUtil.usePlainFont(this._cmbDataY);
        JVTUtil.usePlainFont(this._cmbFilters);
        int n = 0;
        n = 0;
        while (n < this._pva.getNumOfColumns()) {
            this._cmbDataX.addItem(stringArray[n]);
            this._cmbDataY.addItem(stringArray[n]);
            ++n;
        }
        this._cmbDataX.setMaximumRowCount(6);
        this._cmbDataY.setMaximumRowCount(6);
        this._cmbFilters.setMaximumRowCount(6);
        this._lblX.setText("X axis");
        this._lblY.setText("Y axis");
        this._lblFilter.setText("Filter    ");
        jPanel.add((Component)this._lblFilter, "West");
        jPanel2.add((Component)this._cmbFilters, "West");
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        jPanel3.setMaximumSize(new Dimension(100, 45));
        jPanel4.add((Component)this._lblX, "West");
        jPanel4.add((Component)this._chkLogX, "East");
        jPanel5.add((Component)this._cmbDataX, "Center");
        jPanel12.add((Component)jPanel4, "North");
        jPanel12.add((Component)jPanel5, "South");
        jPanel12.setMaximumSize(new Dimension(100, 55));
        jPanel7.add((Component)this._lblY, "West");
        jPanel7.add((Component)this._chkLogY, "East");
        jPanel8.add((Component)this._cmbDataY, "Center");
        jPanel13.add((Component)jPanel7, "North");
        jPanel13.add((Component)jPanel8, "South");
        jPanel13.setMaximumSize(new Dimension(100, 55));
        jPanel14.add((Component)this._chkOverlay, "West");
        jPanel15.add((Component)this._btnPlot, "North");
        jPanel15.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel15.add((Component)this._btnHist, "South");
        jPanel16.add((Component)jPanel14, "North");
        jPanel16.add((Component)jPanel15, "South");
        jPanel16.setMaximumSize(new Dimension(100, 90));
        this._XCoord = new JLabel("X");
        this._YCoord = new JLabel("Y");
        JVTUtil.usePlainFont(this._XCoord);
        JVTUtil.usePlainFont(this._YCoord);
        this._txtCoord1.setBackground(Color.lightGray);
        this._txtCoord1.setHorizontalAlignment(0);
        this._txtCoord1.setEditable(false);
        this._txtCoord2.setBackground(Color.lightGray);
        this._txtCoord2.setHorizontalAlignment(0);
        this._txtCoord2.setEditable(false);
        this._panelXCoordinate.add((Component)this._XCoord, "West");
        this._panelXCoordinate.add((Component)this._txtCoord1, "East");
        this._panelYCoordinate.add((Component)this._YCoord, "West");
        this._panelYCoordinate.add((Component)this._txtCoord2, "East");
        jPanel17.add((Component)this._panelXCoordinate, "Center");
        jPanel17.add((Component)this._panelYCoordinate, "South");
        jPanel17.setMaximumSize(new Dimension(100, 40));
        jPanel18.setLayout(new BoxLayout(jPanel18, 1));
        jPanel18.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel18.add(jPanel17);
        jPanel18.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel18.add(jPanel13);
        jPanel18.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel18.add(jPanel12);
        jPanel18.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel18.add(jPanel3);
        jPanel18.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel18.add(jPanel16);
        jPanel18.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel18.add(this._buttons);
        this._XCoord.setBackground(this._background);
        this._YCoord.setBackground(this._background);
        this._panelXCoordinate.setBackground(this._background);
        this._panelYCoordinate.setBackground(this._background);
        this._chkLogX.setBackground(this._background);
        this._chkLogY.setBackground(this._background);
        this._chkOverlay.setBackground(this._background);
        jPanel18.setBackground(this._background);
        jPanel4.setBackground(this._background);
        jPanel5.setBackground(this._background);
        jPanel6.setBackground(this._background);
        jPanel7.setBackground(this._background);
        jPanel.setBackground(this._background);
        jPanel2.setBackground(this._background);
        jPanel3.setBackground(this._background);
        jPanel8.setBackground(this._background);
        jPanel9.setBackground(this._background);
        jPanel10.setBackground(this._background);
        jPanel11.setBackground(this._background);
        jPanel15.setBackground(this._background);
        jPanel14.setBackground(this._background);
        jPanel16.setBackground(this._background);
        this._panelButtons.setBackground(this._background);
        jPanel12.setBackground(this._background);
        jPanel13.setBackground(this._background);
        jPanel3.setBackground(this._background);
        jPanel16.setBackground(this._background);
        jPanel17.setBackground(this._background);
        return jPanel18;
    }

    public void showCoordinates(String string, String string2) {
        this._txtCoord1.setText(string);
        this._txtCoord2.setText(string2);
    }

    public void updateListeners() {
        this._printButton.removeActionListener(this._printButtonListener);
        this._printButtonListener = new ButtonListener(this, this._pva.plot());
        this._printButton.addActionListener(this._printButtonListener);
        this._saveButton.removeActionListener(this._saveButtonListener);
        this._saveButtonListener = new ButtonListener(this, this._pva.plot());
        this._saveButton.addActionListener(this._saveButtonListener);
        this._fillButton.removeActionListener(this._fillButtonListener);
        this._fillButtonListener = new ButtonListener(this, this._pva.plot());
        this._fillButton.addActionListener(this._fillButtonListener);
        this._resetButton.removeActionListener(this._resetButtonListener);
        this._resetButtonListener = new ButtonListener(this, this._pva.plot());
        this._resetButton.addActionListener(this._resetButtonListener);
        this._formatButton.removeActionListener(this._formatButtonListener);
        this._formatButtonListener = new ButtonListener(this, this._pva.plot());
        this._formatButton.addActionListener(this._formatButtonListener);
        this._filterButton.removeActionListener(this._filterButtonListener);
        this._filterButtonListener = new ButtonListener(this, this._pva.plot());
        this._filterButton.addActionListener(this._filterButtonListener);
        this._transButton.removeActionListener(this._transButtonListener);
        this._transButtonListener = new ButtonListener(this, this._pva.plot());
        this._transButton.addActionListener(this._transButtonListener);
        this._statButton.removeActionListener(this._statButtonListener);
        this._statButtonListener = new ButtonListener(this, this._pva.plot());
        this._statButton.addActionListener(this._statButtonListener);
        this._zoomButton.removeActionListener(this._zoomButtonListener);
        this._zoomButtonListener = new ButtonListener(this, this._pva.plot());
        this._zoomButton.addActionListener(this._zoomButtonListener);
        this._clearSelectionButton.removeActionListener(this._clearSelectionButtonListener);
        this._clearSelectionButtonListener = new ButtonListener(this, this._pva.plot());
        this._clearSelectionButton.addActionListener(this._clearSelectionButtonListener);
        this._dataButton.removeActionListener(this._dataButtonListener);
        this._dataButtonListener = new ButtonListener(this, this._pva.plot());
        this._dataButton.addActionListener(this._dataButtonListener);
        this._connectAladinButton.removeActionListener(this._connectAladinButtonListener);
        this._connectAladinButtonListener = new ButtonListener(this, this._pva.plot());
        this._connectAladinButton.addActionListener(this._connectAladinButtonListener);
        this._selectButton.removeActionListener(this._selectButtonListener);
        this._selectButtonListener = new ButtonListener(this, this._pva.plot());
        this._selectButton.addActionListener(this._selectButtonListener);
        this._unselectButton.removeActionListener(this._unselectButtonListener);
        this._unselectButtonListener = new ButtonListener(this, this._pva.plot());
        this._unselectButton.addActionListener(this._unselectButtonListener);
        this._viewVotableButton.removeActionListener(this._viewVotableButtonListener);
        this._viewVotableButtonListener = new ButtonListener(this, this._pva.plot());
        this._viewVotableButton.addActionListener(this._viewVotableButtonListener);
        if (!this._pva.isWebApp()) {
            this._browseButton.removeActionListener(this._browseButtonListener);
            this._browseButtonListener = new ButtonListener(this, this._pva.plot());
            this._browseButton.addActionListener(this._browseButtonListener);
            this._loadButton.removeActionListener(this._loadButtonListener);
            this._loadButtonListener = new ButtonListener(this, this._pva.plot());
            this._loadButton.addActionListener(this._loadButtonListener);
        }
    }

    public synchronized void setButtons(boolean bl, Color color) {
        this._buttons.setMaximumSize(new Dimension(110, 150));
        this._buttons.setLayout(new BorderLayout());
        if (this._printButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "print.gif");
            if (this.img != null) {
                this.printIcon = new ImageIcon(this.img);
                this._printButton = new JButton(this.printIcon);
                this._printButton.setBorderPainted(false);
            } else {
                this._printButton = new JButton("P");
            }
            this._printButton.setToolTipText("Print the plot");
            this._printButtonListener = new ButtonListener(this, this._pva.plot());
            this._printButton.addActionListener(this._printButtonListener);
            this._printButtonMouseListener = new StatusListener();
            this._printButton.addMouseListener(this._printButtonMouseListener);
            this._printButton.setOpaque(true);
            this._printButton.setBackground(color);
        }
        this._printButton.setVisible(bl);
        if (this._saveButton == null) {
            this.img = this._pva.isWebApp() ? this.getClass().getResource(this._imagePath + "help.gif") : this.getClass().getResource(this._imagePath + "save.gif");
            if (this.img != null) {
                this.saveIcon = new ImageIcon(this.img);
                this._saveButton = new JButton(this.saveIcon);
                this._saveButton.setBorderPainted(false);
            } else {
                this._saveButton = new JButton("H");
            }
            if (this._pva.isWebApp()) {
                this._saveButton.setToolTipText("Show Help");
            } else {
                this._saveButton.setToolTipText("Save image as EPS");
            }
            this._saveButtonListener = new ButtonListener(this, this._pva.plot());
            this._saveButton.addActionListener(this._saveButtonListener);
            this._saveButtonMouseListener = new StatusListener();
            this._saveButton.addMouseListener(this._saveButtonMouseListener);
            this._saveButton.setBackground(color);
        }
        this._saveButton.setVisible(bl);
        if (this._resetButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "reset.gif");
            if (this.img != null) {
                this.resetIcon = new ImageIcon(this.img);
                this._resetButton = new JButton(this.resetIcon);
                this._resetButton.setBorderPainted(false);
            } else {
                this._resetButton = new JButton("R");
            }
            this._resetButton.setToolTipText("Reset X and Y ranges to their original values");
            this._resetButtonListener = new ButtonListener(this, this._pva.plot());
            this._resetButton.addActionListener(this._resetButtonListener);
            this._resetButtonMouseListener = new StatusListener();
            this._resetButton.addMouseListener(this._resetButtonMouseListener);
            this._resetButton.setBackground(color);
        }
        this._resetButton.setVisible(bl);
        if (this._fillButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "fill.gif");
            if (this.img != null) {
                this.fillIcon = new ImageIcon(this.img);
                this._fillButton = new JButton(this.fillIcon);
                this._fillButton.setBorderPainted(false);
            } else {
                this._fillButton = new JButton("F");
            }
            this._fillButton.setToolTipText("Show full data range");
            this._fillButtonListener = new ButtonListener(this, this._pva.plot());
            this._fillButton.addActionListener(this._fillButtonListener);
            this._fillButtonMouseListener = new StatusListener();
            this._fillButton.addMouseListener(this._fillButtonMouseListener);
            this._fillButton.setBackground(color);
        }
        this._fillButton.setVisible(bl);
        if (this._formatButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "format.gif");
            if (this.img != null) {
                this.formatIcon = new ImageIcon(this.img);
                this._formatButton = new JButton(this.formatIcon);
                this._formatButton.setBorderPainted(false);
            } else {
                this._formatButton = new JButton("S");
            }
            this._formatButton.setToolTipText("Format of the plot");
            this._formatButtonListener = new ButtonListener(this, this._pva.plot());
            this._formatButton.addActionListener(this._formatButtonListener);
            this._formatButtonMouseListener = new StatusListener();
            this._formatButton.addMouseListener(this._formatButtonMouseListener);
            this._formatButton.setBackground(color);
        }
        this._formatButton.setVisible(bl);
        if (this._statButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "stat.gif");
            if (this.img != null) {
                this.statIcon = new ImageIcon(this.img);
                this._statButton = new JButton(this.statIcon);
                this._statButton.setBorderPainted(false);
            } else {
                this._statButton = new JButton("S");
            }
            this._statButton.setToolTipText("Statistics for the plot");
            this._statButtonListener = new ButtonListener(this, this._pva.plot());
            this._statButton.addActionListener(this._statButtonListener);
            this._statButtonMouseListener = new StatusListener();
            this._statButton.addMouseListener(this._statButtonMouseListener);
            this._statButton.setBackground(color);
        }
        this._statButton.setVisible(bl);
        if (this._transButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "trans.gif");
            if (this.img != null) {
                this.transIcon = new ImageIcon(this.img);
                this._transButton = new JButton(this.transIcon);
                this._transButton.setBorderPainted(false);
            } else {
                this._transButton = new JButton("T");
            }
            this._transButton.setToolTipText("Transformations on the plot");
            this._transButtonListener = new ButtonListener(this, this._pva.plot());
            this._transButton.addActionListener(this._transButtonListener);
            this._transButtonMouseListener = new StatusListener();
            this._transButton.addMouseListener(this._transButtonMouseListener);
            this._transButton.setBackground(color);
        }
        this._transButton.setVisible(bl);
        if (this._filterButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "filter.gif");
            if (this.img != null) {
                this.filterIcon = new ImageIcon(this.img);
                this._filterButton = new JButton(this.filterIcon);
                this._filterButton.setBorderPainted(false);
            } else {
                this._filterButton = new JButton("F");
            }
            this._filterButton.setToolTipText("Filters on the plot");
            this._filterButtonListener = new ButtonListener(this, this._pva.plot());
            this._filterButton.addActionListener(this._filterButtonListener);
            this._filterButtonMouseListener = new StatusListener();
            this._filterButton.addMouseListener(this._filterButtonMouseListener);
            this._filterButton.setBackground(color);
        }
        this._filterButton.setVisible(bl);
        if (this._zoomButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "zoom_on.gif");
            if (this.img != null) {
                this.zoomHighlightIcon = new ImageIcon(this.img);
                this._zoomButton = new JButton(this.zoomHighlightIcon);
                this._zoomButton.setBorderPainted(false);
            } else {
                this._zoomButton = new JButton("Z");
            }
            this._zoomButton.setToolTipText("Zoom The Plot");
            this._zoomButtonListener = new ButtonListener(this, this._pva.plot());
            this._zoomButton.addActionListener(this._zoomButtonListener);
            this._zoomButtonMouseListener = new StatusListener();
            this._zoomButton.addMouseListener(this._zoomButtonMouseListener);
            this._zoomButton.setBackground(color);
        }
        this._zoomButton.setVisible(bl);
        if (this._clearSelectionButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "clear.gif");
            if (this.img != null) {
                this.clearSelectionIcon = new ImageIcon(this.img);
                this._clearSelectionButton = new JButton(this.clearSelectionIcon);
                this._clearSelectionButton.setBorderPainted(false);
            } else {
                this._clearSelectionButton = new JButton("C");
            }
            this._clearSelectionButton.setToolTipText("Clear Selection");
            this._clearSelectionButtonListener = new ButtonListener(this, this._pva.plot());
            this._clearSelectionButton.addActionListener(this._clearSelectionButtonListener);
            this._clearSelectionButtonMouseListener = new StatusListener();
            this._clearSelectionButton.addMouseListener(this._clearSelectionButtonMouseListener);
            this._clearSelectionButton.setBackground(color);
        }
        this._clearSelectionButton.setVisible(bl);
        if (this._dataButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "data.gif");
            if (this.img != null) {
                this.dataIcon = new ImageIcon(this.img);
                this._dataButton = new JButton(this.dataIcon);
                this._dataButton.setBorderPainted(false);
            } else {
                this._dataButton = new JButton("D");
            }
            this._dataButton.setToolTipText("View data ");
            this._dataButtonListener = new ButtonListener(this, this._pva.plot());
            this._dataButton.addActionListener(this._dataButtonListener);
            this._dataButtonMouseListener = new StatusListener();
            this._dataButton.addMouseListener(this._dataButtonMouseListener);
            this._dataButton.setBackground(color);
        }
        this._dataButton.setVisible(bl);
        if (this._connectAladinButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "aladin.gif");
            if (this.img != null) {
                this.connectAladinIcon = new ImageIcon(this.img);
                this._connectAladinButton = new JButton(this.connectAladinIcon);
                this._connectAladinButton.setBorderPainted(false);
            } else {
                this._connectAladinButton = new JButton("A");
            }
            this._connectAladinButton.setToolTipText("Launch Aladin");
            this._connectAladinButtonListener = new ButtonListener(this, this._pva.plot());
            this._connectAladinButton.addActionListener(this._connectAladinButtonListener);
            this._connectAladinButtonMouseListener = new StatusListener();
            this._connectAladinButton.addMouseListener(this._connectAladinButtonMouseListener);
            this._connectAladinButton.setBackground(color);
        }
        this._connectAladinButton.setVisible(bl);
        if (this._selectButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "select.gif");
            if (this.img != null) {
                this.selectIcon = new ImageIcon(this.img);
                this._selectButton = new JButton(this.selectIcon);
                this._selectButton.setBorderPainted(false);
            } else {
                this._selectButton = new JButton("S");
            }
            this._selectButton.setToolTipText("Select Points");
            this._selectButtonListener = new ButtonListener(this, this._pva.plot());
            this._selectButton.addActionListener(this._selectButtonListener);
            this._selectMouseListener = new StatusListener();
            this._selectButton.addMouseListener(this._selectMouseListener);
            this._selectButton.setBackground(color);
        }
        this._selectButton.setVisible(bl);
        if (this._unselectButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "unselect.gif");
            if (this.img != null) {
                this.unselectIcon = new ImageIcon(this.img);
                this._unselectButton = new JButton(this.unselectIcon);
                this._unselectButton.setBorderPainted(false);
            } else {
                this._unselectButton = new JButton("U");
            }
            this._unselectButton.setToolTipText("Remove selection on point");
            this._unselectButtonListener = new ButtonListener(this, this._pva.plot());
            this._unselectButton.addActionListener(this._unselectButtonListener);
            this._unselectMouseListener = new StatusListener();
            this._unselectButton.addMouseListener(this._unselectMouseListener);
            this._unselectButton.setBackground(color);
        }
        this._unselectButton.setVisible(bl);
        if (this._viewVotableButton == null) {
            this.img = this.getClass().getResource(this._imagePath + "votable.gif");
            if (this.img != null) {
                this.viewVotableIcon = new ImageIcon(this.img);
                this._viewVotableButton = new JButton(this.viewVotableIcon);
                this._viewVotableButton.setBorderPainted(false);
            } else {
                this._viewVotableButton = new JButton("V");
            }
            this._viewVotableButton.setToolTipText("Shows the VOTable ");
            this._viewVotableButtonListener = new ButtonListener(this, this._pva.plot());
            this._viewVotableButton.addActionListener(this._viewVotableButtonListener);
            this._viewVotableMouseListener = new StatusListener();
            this._viewVotableButton.addMouseListener(this._viewVotableMouseListener);
            this._viewVotableButton.setBackground(color);
        }
        this._viewVotableButton.setVisible(bl);
        this._buttons.add((Component)this.addToolbarButtons(), "North");
        this.setupIcons(this);
    }

    public void setupIcons(PlotButtons plotButtons) {
        this.resetHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "reset_on.gif"));
        this.zoomIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "zoom.gif"));
        this.selectHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "select_on.gif"));
        this.unselectHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "unselect_on.gif"));
        this.printHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "print_on.gif"));
        this.connectAladinHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "aladin_on.gif"));
        this.viewVotableHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "votable_on.gif"));
        this.saveHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "save_on.gif"));
        this.fillHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "fill_on.gif"));
        this.formatHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "format_on.gif"));
        this.statHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "stat_on.gif"));
        this.transHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "trans_on.gif"));
        this.filterHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "filter_on.gif"));
        this.clearSelectionHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "clear_on.gif"));
        this.dataHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "data_on.gif"));
        this.helpHighlightIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "help_on.gif"));
        this.helpIcon = new ImageIcon(plotButtons.getClass().getResource(this._imagePath + "help.gif"));
    }

    public void unselectVOTableDisplayButton() {
        this._viewVotableButton.setIcon(this.viewVotableIcon);
    }

    public void unselectDataDisplayButton() {
        this._dataButton.setIcon(this.dataIcon);
    }

    private JPanel addToolbarButtons() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._toolbarButtonsPanel = new JPanel(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = this._xcoordinate;
        gridBagConstraints.gridy = this._ycoordinate;
        gridBagConstraints.anchor = this._northeastAnchor;
        gridBagLayout.setConstraints(this._resetButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 1;
        gridBagConstraints.gridy = this._ycoordinate;
        gridBagConstraints.anchor = this._northAnchor;
        gridBagLayout.setConstraints(this._fillButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 2;
        gridBagConstraints.gridy = this._ycoordinate;
        gridBagConstraints.anchor = this._northwestAnchor;
        gridBagLayout.setConstraints(this._formatButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate;
        gridBagConstraints.gridy = this._ycoordinate + 1;
        gridBagConstraints.anchor = this._northeastAnchor;
        gridBagLayout.setConstraints(this._statButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 1;
        gridBagConstraints.gridy = this._ycoordinate + 1;
        gridBagConstraints.anchor = this._northAnchor;
        gridBagLayout.setConstraints(this._transButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 2;
        gridBagConstraints.gridy = this._ycoordinate + 1;
        gridBagConstraints.anchor = this._northwestAnchor;
        gridBagLayout.setConstraints(this._filterButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate;
        gridBagConstraints.gridy = this._ycoordinate + 2;
        gridBagConstraints.anchor = this._northeastAnchor;
        gridBagLayout.setConstraints(this._selectButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 1;
        gridBagConstraints.gridy = this._ycoordinate + 2;
        gridBagConstraints.anchor = this._northAnchor;
        gridBagLayout.setConstraints(this._unselectButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 2;
        gridBagConstraints.gridy = this._ycoordinate + 2;
        gridBagConstraints.anchor = this._northwestAnchor;
        gridBagLayout.setConstraints(this._zoomButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate;
        gridBagConstraints.gridy = this._ycoordinate + 3;
        gridBagConstraints.anchor = this._northeastAnchor;
        gridBagLayout.setConstraints(this._clearSelectionButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 1;
        gridBagConstraints.gridy = this._ycoordinate + 3;
        gridBagConstraints.anchor = this._northAnchor;
        gridBagLayout.setConstraints(this._dataButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 2;
        gridBagConstraints.gridy = this._ycoordinate + 3;
        gridBagConstraints.anchor = this._northwestAnchor;
        gridBagLayout.setConstraints(this._viewVotableButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate;
        gridBagConstraints.gridy = this._ycoordinate + 4;
        gridBagConstraints.anchor = this._northeastAnchor;
        gridBagLayout.setConstraints(this._printButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 1;
        gridBagConstraints.gridy = this._ycoordinate + 4;
        gridBagConstraints.anchor = this._northAnchor;
        gridBagLayout.setConstraints(this._saveButton, gridBagConstraints);
        gridBagConstraints.gridx = this._xcoordinate + 2;
        gridBagConstraints.gridy = this._ycoordinate + 4;
        gridBagConstraints.anchor = this._northwestAnchor;
        gridBagLayout.setConstraints(this._connectAladinButton, gridBagConstraints);
        this._toolbarButtonsPanel.add(this._resetButton);
        this._toolbarButtonsPanel.add(this._fillButton);
        this._toolbarButtonsPanel.add(this._formatButton);
        this._toolbarButtonsPanel.add(this._statButton);
        this._toolbarButtonsPanel.add(this._transButton);
        this._toolbarButtonsPanel.add(this._filterButton);
        this._toolbarButtonsPanel.add(this._selectButton);
        this._toolbarButtonsPanel.add(this._unselectButton);
        this._toolbarButtonsPanel.add(this._zoomButton);
        this._toolbarButtonsPanel.add(this._clearSelectionButton);
        this._toolbarButtonsPanel.add(this._dataButton);
        this._toolbarButtonsPanel.add(this._viewVotableButton);
        this._toolbarButtonsPanel.add(this._printButton);
        this._toolbarButtonsPanel.add(this._saveButton);
        this._toolbarButtonsPanel.add(this._connectAladinButton);
        return this._toolbarButtonsPanel;
    }

    public void setSelectedFile(String string) {
        this._selectedFile = string;
        this._selectedFileEntryBox.setText(this._selectedFile);
    }

    public String getSelectedFile() {
        this._selectedFile = this._selectedFileEntryBox.getText();
        return this._selectedFile;
    }

    public void setStatusText(String string) {
        this._statusBar.setText(string);
    }

    private void showStatusMessages(String string) {
        if (this._pva.isWebApp() && !this._pva.isSubApp()) {
            this._pva.showStatus(string);
        } else {
            this._statusBar.setText(string);
        }
    }

    class ButtonListener
    implements ActionListener {
        private PlotButtons _plotButtons;
        private PlotBox pb;

        public ButtonListener(PlotButtons plotButtons2, PlotBox plotBox) {
            this._plotButtons = plotButtons2;
            this.pb = plotBox;
        }

        public ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            Object object;
            Object object2;
            if (null == actionEvent) {
                return;
            }
            if (PlotButtons.this._pva.getPlotData() != null) {
                if (actionEvent.getSource() == PlotButtons.this._printButton) {
                    PlotButtons.this._printButton.setIcon(PlotButtons.this.printHighlightIcon);
                    this.pb.printPlotBox();
                } else if (actionEvent.getSource() == PlotButtons.this._formatButton) {
                    PlotButtons.this._formatButton.setIcon(PlotButtons.this.formatHighlightIcon);
                    object2 = new PlotFormatter(this.pb);
                    ((PlotFormatter)object2).openModal();
                    PlotButtons.this._formatButton.setIcon(PlotButtons.this.formatIcon);
                } else if (actionEvent.getSource() == PlotButtons.this._statButton) {
                    PlotButtons.this._statButton.setIcon(PlotButtons.this.statHighlightIcon);
                    object2 = new JPanel();
                    object = null;
                    if (object2 instanceof Frame) {
                        object = (Frame)object2;
                    }
                    serializable = new PlotStatisticsDialog(this.pb, (Frame)object, PlotButtons.this._pva, this._plotButtons);
                    PlotButtons.this._statButton.setIcon(PlotButtons.this.statIcon);
                } else if (actionEvent.getSource() == PlotButtons.this._saveButton) {
                    if (PlotButtons.this._pva.isWebApp()) {
                        PlotButtons.this._saveButton.setIcon(PlotButtons.this.helpHighlightIcon);
                    } else {
                        PlotButtons.this._saveButton.setIcon(PlotButtons.this.saveHighlightIcon);
                    }
                    if (!PlotButtons.this._pva.isSubApp()) {
                        PlotButtons.this._pva.showVOPlotFrame();
                    } else {
                        object2 = "VOPlot (VOTable Plotting tool)\n  Version 1.1 beta.\n\nDeveloped By :\n Persistent Systems (PSPL) and the Inter-University Centre for Astronomy and Astrophysics (IUCAA),India\n in collaboration with Centre de Donn\u00e9es astronomiques de Strasbourg (CDS).  ";
                        JOptionPane.showMessageDialog(null, object2, "About Us", 1);
                    }
                } else if (actionEvent.getSource() == PlotButtons.this._transButton) {
                    PlotButtons.this._transButton.setIcon(PlotButtons.this.transHighlightIcon);
                    object2 = new JPanel();
                    object = null;
                    if (object2 instanceof Frame) {
                        object = (Frame)object2;
                    }
                    serializable = new PlotTransformerDialog((Frame)object, PlotButtons.this._pva);
                    PlotButtons.this._transButton.setIcon(PlotButtons.this.transIcon);
                } else if (actionEvent.getSource() == PlotButtons.this._filterButton) {
                    PlotButtons.this._filterButton.setIcon(PlotButtons.this.filterHighlightIcon);
                    object2 = new JPanel();
                    object = null;
                    if (object2 instanceof Frame) {
                        object = (Frame)object2;
                    }
                    serializable = new PlotFilterDialog((Frame)object, PlotButtons.this._pva);
                    PlotButtons.this._filterButton.setIcon(PlotButtons.this.filterIcon);
                } else if (actionEvent.getSource() == PlotButtons.this._dataButton) {
                    PlotButtons.this._dataButton.setIcon(PlotButtons.this.dataHighlightIcon);
                    if (null != PlotButtons.this._pva.getPlotData() && JVTUtil.SHOW_DATA) {
                        object2 = new JPanel();
                        object = null;
                        if (object2 instanceof Frame) {
                            object = (Frame)object2;
                        }
                        serializable = new PlotDataDisplayDialog((Frame)object, PlotButtons.this._pva, this._plotButtons);
                    }
                } else if (actionEvent.getSource() == PlotButtons.this._viewVotableButton) {
                    PlotButtons.this._viewVotableButton.setIcon(PlotButtons.this.viewVotableHighlightIcon);
                    if (null != PlotButtons.this._pva.getPlotData() && JVTUtil.SHOW_VOTABLE) {
                        object2 = new JPanel();
                        object = null;
                        if (object2 instanceof Frame) {
                            object = (Frame)object2;
                        }
                        serializable = new PlotVotableDisplayDialog((Frame)object, PlotButtons.this._pva, this._plotButtons);
                    }
                } else if (actionEvent.getSource() == PlotButtons.this._connectAladinButton) {
                    PlotButtons.this._connectAladinButton.setIcon(PlotButtons.this.connectAladinHighlightIcon);
                    if (!PlotButtons.this._pva.isSubApp()) {
                        PlotButtons.this._pva.showAladinDialog();
                    } else {
                        object2 = "VOPlot (VOTable Plotting tool)\n  Version 1.1 beta.\n\nDeveloped By :\n Persistent Systems (PSPL) and the Inter-University Centre for Astronomy and Astrophysics (IUCAA),India\n in collaboration with Centre de Donn\u00e9es astronomiques de Strasbourg (CDS).  ";
                        JOptionPane.showMessageDialog(null, object2, "About Us", 1);
                    }
                    PlotButtons.this._connectAladinButton.setIcon(PlotButtons.this.connectAladinIcon);
                }
            }
            if (actionEvent.getSource() == PlotButtons.this._resetButton) {
                this.pb.resetAxes();
            } else if (actionEvent.getSource() == PlotButtons.this._fillButton) {
                this.pb.fillPlot();
            } else if (actionEvent.getSource() == PlotButtons.this._browseButton) {
                if (null == PlotButtons.this._currentDirectory) {
                    PlotButtons.this._currentDirectory = new File(System.getProperty("user.dir"));
                }
                object2 = new JFileChooser(PlotButtons.this._currentDirectory);
                ((JFileChooser)object2).addChoosableFileFilter(new VOTableFilter());
                int n = ((JFileChooser)object2).showOpenDialog(PlotButtons.this._pva);
                if (n == 0) {
                    serializable = ((JFileChooser)object2).getSelectedFile();
                    PlotButtons.this._currentDirectory = ((JFileChooser)object2).getCurrentDirectory();
                    PlotButtons.this.setSelectedFile(((File)serializable).getPath());
                }
            } else if (actionEvent.getSource() == PlotButtons.this._loadButton) {
                object2 = PlotButtons.this.getSelectedFile();
                if (null == object2 || ((String)object2).trim().length() <= 0) {
                    return;
                }
                object2 = ((String)object2).trim();
                this._plotButtons.setStatusText("");
                this._plotButtons.setStatusText("Parsing VOTable. Please wait.");
                JVTUtil.showWaitCursor(PlotButtons.this._pva);
                System.out.println("Parsing VOTable '" + (String)object2 + "'.");
                object = ((String)object2).startsWith("http://") || ((String)object2).startsWith("HTTP://") ? new SAVOTParser((String)object2) : new SAVOTParser((String)object2, true);
                serializable = ((SAVOTParser)object).getPlotData();
                PlotButtons.this._pva.setVOTable(((SAVOTParser)object).getVOTableMetaData());
                PlotButtons.this._pva.setResource(((SAVOTParser)object).getVOTableResourceMetaData());
                PlotButtons.this._pva.setTable(((SAVOTParser)object).getVOTableTableMetaData());
                PlotButtons.this._pva.clearSelectedPoints(true);
                PlotButtons.this._pva.showVOTableObject(null);
                if (null == serializable) {
                    this._plotButtons.setStatusText("Error while loading VOTable.");
                    PlotButtons.this._pva.showError("Could not load votable from '" + (String)object2 + "'.");
                } else if (((PlotData)serializable).getNumOfPlotColumns() <= 0) {
                    PlotVOApplet plotVOApplet = PlotButtons.this._pva;
                    PlotButtons.this._pva;
                    plotVOApplet.showError(PlotVOApplet._errorMsg[3]);
                } else {
                    this._plotButtons.setStatusText("Loaded VOTable '" + (String)object2 + "'.");
                    if (null == ((PlotData)serializable).getObjectIDColumn()) {
                        ((PlotData)serializable).generateObjectIDColumn();
                    }
                }
                PlotButtons.this._pva.setPlotData((PlotData)serializable);
                JVTUtil.showDefaultCursor(PlotButtons.this._pva);
            } else if (actionEvent.getSource() == PlotButtons.this._zoomButton) {
                PlotButtons.this._zoomButton.setIcon(PlotButtons.this.zoomHighlightIcon);
                PlotButtons.this._selectButton.setIcon(PlotButtons.this.selectIcon);
                PlotButtons.this._unselectButton.setIcon(PlotButtons.this.unselectIcon);
                object2 = "Zoom";
                PlotButtons.this._pva.repaint();
                this.pb.zoomSelect((String)object2);
                PlotButtons.this._buttonMode = 1;
            } else if (actionEvent.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this._pva.clearSelectedPoints(true);
            } else if (actionEvent.getSource() == PlotButtons.this._selectButton) {
                object2 = "Select";
                PlotButtons.this._pva.repaint();
                this.pb.zoomSelect((String)object2);
                PlotButtons.this._selectButton.setIcon(PlotButtons.this.selectHighlightIcon);
                PlotButtons.this._zoomButton.setIcon(PlotButtons.this.zoomIcon);
                PlotButtons.this._unselectButton.setIcon(PlotButtons.this.unselectIcon);
                PlotButtons.this._buttonMode = 2;
            } else if (actionEvent.getSource() == PlotButtons.this._unselectButton) {
                object2 = "UnSelect";
                PlotButtons.this._pva.repaint();
                this.pb.zoomSelect((String)object2);
                PlotButtons.this._unselectButton.setIcon(PlotButtons.this.unselectHighlightIcon);
                PlotButtons.this._zoomButton.setIcon(PlotButtons.this.zoomIcon);
                PlotButtons.this._selectButton.setIcon(PlotButtons.this.selectIcon);
                PlotButtons.this._buttonMode = 3;
            }
        }
    }

    class StatusListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PlotButtons.this._printButton) {
                PlotButtons.this.showStatusMessages("Print the graph.");
            } else if (mouseEvent.getSource() == PlotButtons.this._formatButton) {
                PlotButtons.this.showStatusMessages("Change plot properties.");
            } else if (mouseEvent.getSource() == PlotButtons.this._resetButton) {
                PlotButtons.this.showStatusMessages("Reset the graph back to its original dimensions.");
            } else if (mouseEvent.getSource() == PlotButtons.this._fillButton) {
                PlotButtons.this.showStatusMessages("View the entire data range in the graph.");
            } else if (mouseEvent.getSource() == PlotButtons.this._statButton) {
                PlotButtons.this.showStatusMessages("Apply statistical functions on the plotted data.");
            } else if (mouseEvent.getSource() == PlotButtons.this._saveButton) {
                if (PlotButtons.this._pva.isWebApp()) {
                    PlotButtons.this.showStatusMessages("Display the user guide.");
                } else {
                    PlotButtons.this.showStatusMessages("Save graph as EPS file.");
                }
            } else if (mouseEvent.getSource() == PlotButtons.this._transButton) {
                PlotButtons.this.showStatusMessages("Create new columns.");
            } else if (mouseEvent.getSource() == PlotButtons.this._filterButton) {
                PlotButtons.this.showStatusMessages("Create new data subsets.");
            } else if (mouseEvent.getSource() == PlotButtons.this._zoomButton) {
                PlotButtons.this.showStatusMessages("Zoom mode - Drag the left mouse button down to the right to zoom in.");
            } else if (mouseEvent.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this.showStatusMessages("Unselects all the selected points.");
            } else if (mouseEvent.getSource() == PlotButtons.this._dataButton) {
                PlotButtons.this.showStatusMessages("View plot data in table format.");
            } else if (mouseEvent.getSource() == PlotButtons.this._connectAladinButton) {
                PlotButtons.this.showStatusMessages("Launch Aladin using data in VOPlot.");
            } else if (mouseEvent.getSource() == PlotButtons.this._selectButton) {
                PlotButtons.this.showStatusMessages("Select mode - Drag the left mouse button down to the right to select points.");
            } else if (mouseEvent.getSource() == PlotButtons.this._unselectButton) {
                PlotButtons.this.showStatusMessages("Unselect mode - Drag the left mouse button down to the right to unselect points.");
            } else if (mouseEvent.getSource() == PlotButtons.this._viewVotableButton) {
                PlotButtons.this.showStatusMessages("View plot data in VOTable format.");
            } else if (mouseEvent.getSource() == PlotButtons.this._btnPlot) {
                PlotButtons.this.showStatusMessages("Draw scatter plot based on the selected X and Y columns.");
            } else if (mouseEvent.getSource() == PlotButtons.this._btnHist) {
                PlotButtons.this.showStatusMessages("Draw histogram based on the selected X column.");
            } else if (mouseEvent.getSource() == PlotButtons.this._chkOverlay) {
                PlotButtons.this.showStatusMessages("To overlay plot.");
            } else if (mouseEvent.getSource() == PlotButtons.this._chkLogX) {
                PlotButtons.this.showStatusMessages("Takes log of X column.");
            } else if (mouseEvent.getSource() == PlotButtons.this._chkLogY) {
                PlotButtons.this.showStatusMessages("Takes log of Y column.");
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (PlotButtons.this._pva.getPlotData() != null) {
                if (PlotButtons.this._buttonMode == 1) {
                    PlotButtons.this.showStatusMessages("You are currently in Zoom mode.");
                } else if (PlotButtons.this._buttonMode == 2) {
                    PlotButtons.this.showStatusMessages("You are currently in Select mode.");
                } else {
                    PlotButtons.this.showStatusMessages("You are currently in Unselect mode.");
                }
            } else {
                PlotButtons.this.showStatusMessages("No VOTable Loaded. ");
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PlotButtons.this._resetButton) {
                PlotButtons.this._resetButton.setIcon(PlotButtons.this.resetHighlightIcon);
            } else if (mouseEvent.getSource() == PlotButtons.this._fillButton) {
                PlotButtons.this._fillButton.setIcon(PlotButtons.this.fillHighlightIcon);
            } else if (mouseEvent.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this._clearSelectionButton.setIcon(PlotButtons.this.clearSelectionHighlightIcon);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PlotButtons.this._printButton) {
                PlotButtons.this._printButton.setIcon(PlotButtons.this.printIcon);
            } else if (mouseEvent.getSource() == PlotButtons.this._resetButton) {
                PlotButtons.this._resetButton.setIcon(PlotButtons.this.resetIcon);
            } else if (mouseEvent.getSource() == PlotButtons.this._fillButton) {
                PlotButtons.this._fillButton.setIcon(PlotButtons.this.fillIcon);
            } else if (mouseEvent.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this._clearSelectionButton.setIcon(PlotButtons.this.clearSelectionIcon);
            } else if (mouseEvent.getSource() == PlotButtons.this._connectAladinButton) {
                // empty if block
            }
        }
    }
}

