/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.IntProcedure;
import cern.colt.list.AbstractIntList;
import cern.colt.list.AbstractList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class IntArrayList
extends AbstractIntList {
    protected int[] elements;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int[] nArray) {
        this.elements(nArray);
    }

    public IntArrayList(int n) {
        this(new int[n]);
        this.setSizeRaw(0);
    }

    public void add(int n) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = n;
    }

    public void beforeInsert(int n, int n2) {
        if (this.size == n) {
            this.add(n2);
            return;
        }
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = n2;
        ++this.size;
    }

    public int binarySearchFromTo(int n, int n2, int n3) {
        return Sorting.binarySearchFromTo((int[])this.elements, (int)n, (int)n2, (int)n3);
    }

    public Object clone() {
        IntArrayList intArrayList = new IntArrayList((int[])this.elements.clone());
        intArrayList.setSizeRaw(this.size);
        return intArrayList;
    }

    public IntArrayList copy() {
        return (IntArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, int n3, int n4) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n5 = n4 - n3 + 1;
        int[] nArray = new int[n5];
        int[] nArray2 = this.elements;
        int n6 = n;
        while (n6 <= n2) {
            int n7 = nArray2[n6++] - n3;
            nArray[n7] = nArray[n7] + 1;
        }
        int n8 = n;
        int n9 = n3;
        int n10 = 0;
        while (n10 < n5) {
            int n11 = nArray[n10];
            if (n11 > 0) {
                if (n11 == 1) {
                    nArray2[n8++] = n9;
                } else {
                    int n12 = n8 + n11 - 1;
                    this.fillFromToWith(n8, n12, n9);
                    n8 = n12 + 1;
                }
            }
            ++n10;
            ++n9;
        }
    }

    public int[] elements() {
        return this.elements;
    }

    public AbstractIntList elements(int[] nArray) {
        this.elements = nArray;
        this.size = nArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity((int[])this.elements, (int)n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (this.size() != intArrayList.size()) {
            return false;
        }
        int[] nArray = this.elements();
        int[] nArray2 = intArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (nArray[n] == nArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(IntProcedure intProcedure) {
        int[] nArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (intProcedure.apply(nArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public int get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public int getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(int n, int n2, int n3) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n2, n3, this.size);
        int[] nArray = this.elements;
        int n4 = n2;
        while (n4 <= n3) {
            if (n == nArray[n4]) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public int lastIndexOfFromTo(int n, int n2, int n3) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n2, n3, this.size);
        int[] nArray = this.elements;
        int n4 = n3;
        while (n4 >= n2) {
            if (n == nArray[n4]) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    public AbstractIntList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new IntArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int[] nArray = new int[n2 - n + 1];
        System.arraycopy(this.elements, n, nArray, 0, n2 - n + 1);
        return new IntArrayList(nArray);
    }

    public boolean removeAll(AbstractIntList abstractIntList) {
        double d;
        if (!(abstractIntList instanceof IntArrayList)) {
            return super.removeAll(abstractIntList);
        }
        if (abstractIntList.size() == 0) {
            return false;
        }
        int n = abstractIntList.size() - 1;
        int n2 = 0;
        int[] nArray = this.elements;
        int n3 = this.size();
        double d2 = abstractIntList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            IntArrayList intArrayList = (IntArrayList)abstractIntList.clone();
            intArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (intArrayList.binarySearchFromTo(nArray[n4], 0, n) < 0) {
                    nArray[n2++] = nArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractIntList.indexOfFromTo(nArray[n5], 0, n) < 0) {
                    nArray[n2++] = nArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractIntList abstractIntList, int n3) {
        if (!(abstractIntList instanceof IntArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractIntList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractIntList.size());
            System.arraycopy(((IntArrayList)abstractIntList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractIntList abstractIntList) {
        double d;
        if (!(abstractIntList instanceof IntArrayList)) {
            return super.retainAll(abstractIntList);
        }
        int n = abstractIntList.size() - 1;
        int n2 = 0;
        int[] nArray = this.elements;
        int n3 = this.size();
        double d2 = abstractIntList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            IntArrayList intArrayList = (IntArrayList)abstractIntList.clone();
            intArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (intArrayList.binarySearchFromTo(nArray[n4], 0, n) >= 0) {
                    nArray[n2++] = nArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractIntList.indexOfFromTo(nArray[n5], 0, n) >= 0) {
                    nArray[n2++] = nArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        int[] nArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            nArray[n3++] = nArray[n2];
            nArray[n2--] = n4;
        }
    }

    public void set(int n, int n2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = n2;
    }

    public void setQuick(int n, int n2) {
        this.elements[n] = n2;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        int[] nArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            int n5 = nArray[n4];
            nArray[n4] = nArray[n3];
            nArray[n3] = n5;
            ++n3;
        }
    }

    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = this.elements[n];
        int n4 = this.elements[n];
        int[] nArray = this.elements;
        int n5 = n + 1;
        while (n5 <= n2) {
            int n6;
            if ((n6 = nArray[n5++]) > n4) {
                n4 = n6;
                continue;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double d = (double)n2 - (double)n + 1.0;
        double d2 = d * Math.log(d) / 0.6931471805599453;
        double d3 = (double)n4 - (double)n3 + 1.0;
        double d4 = Math.max(d3, d);
        if (d3 < 10000.0 && d4 < d2) {
            this.countSortFromTo(n, n2, n3, n4);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity((int[])this.elements, (int)this.size());
    }
}

