/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.savot.model.SavotField;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.xml.Field;
import cds.xml.VOTableConsumer;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class VOTable
implements XMLConsumer {
    private VOTableConsumer consumer;
    private XMLParser xmlparser;
    private Field field;
    private Field f;
    private int nField;
    private int nRA;
    private int nDE;
    private String fieldSub = null;
    private String tableSub = null;
    private String resourceSub = null;
    private boolean inLinkField = false;
    private boolean inTD = false;
    private boolean inDescription = false;
    private String error;
    private boolean knowFormat;
    private boolean flagSexa;
    private int columnCount = 0;
    private int column = 0;
    private SavotTR currentTR = new SavotTR();
    String data = "";
    private Hashtable fieldIDRef = new Hashtable();

    public VOTable(VOTableConsumer vOTableConsumer) {
        this.consumer = vOTableConsumer;
        this.xmlparser = new XMLParser(this);
    }

    protected void addFieldToHashtable(SavotField savotField) {
        this.fieldIDRef.put(savotField.getId(), savotField);
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        try {
            String string = new String(cArray, n, n2).trim();
            if (string.length() == 0) {
                return;
            }
            if (this.inLinkField) {
                if (this.f.refText == null) {
                    this.f.addInfo("refText", new String(cArray, n, n2));
                }
                return;
            }
            if (this.inDescription) {
                this.f.addInfo("DESCRIPTION", new String(cArray, n, n2));
                return;
            }
            if (this.inTD) {
                this.data = new String(cArray, n, n2);
                this.inTD = false;
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("characters : " + exception);
        }
    }

    public void endElement(String string) {
        try {
            if (string.equals("FIELD")) {
                this.fieldSub = null;
                if (this.f.name == null) {
                    this.f.name = this.f.ID;
                }
                this.memoFieldCoord();
                ++this.nField;
                this.consumer.setField(this.f);
            } else if (string.equals("DESCRIPTION")) {
                this.inDescription = false;
            } else if (string.equals("TABLE")) {
                this.tableSub = null;
                this.consumer.endTable();
            } else if (string.equals("TD")) {
                this.currentTR.getTDs().addItem(this.data);
                this.data = "";
                this.resourceSub = string;
            } else if (string.equals("RESOURCE")) {
                this.resourceSub = null;
                this.consumer.endResource();
            } else if (string.equals("LINK")) {
                this.inLinkField = false;
            } else if (string.equals("TR") && this.currentTR != null) {
                this.consumer.setRecord(this.currentTR, this.nRA, this.nDE);
            }
        }
        catch (Exception exception) {
            System.out.println("endElement : " + string + " " + exception);
            exception.fillInStackTrace();
        }
    }

    private String[] extractFromArray(String string) {
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, " ");
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
        }
        return stringArray;
    }

    public String getError() {
        return this.error != null ? this.error : this.xmlparser.getError();
    }

    private boolean isDE(String string) {
        char c;
        int n = string.indexOf("DE");
        if (n < 0) {
            n = string.indexOf("de");
        }
        if (n < 0) {
            n = string.indexOf("De");
        }
        if (n >= 0 && n + 2 < string.length() && ((c = string.charAt(n + 2)) == 's' || c == 'S')) {
            n = -1;
        }
        return n != -1;
    }

    private boolean isRA(String string) {
        return string.indexOf("RA") != -1 || string.indexOf("ra") != -1 || string.indexOf("Ra") != -1;
    }

    private void memoFieldCoord() {
        if (this.f.name == null) {
            return;
        }
        if (this.nRA < 0 && this.isRA(this.f.name)) {
            this.nRA = this.nField;
            if (this.f.unit != null) {
                this.knowFormat = true;
                if (this.f.unit.indexOf(104) >= 0) {
                    this.flagSexa = true;
                }
            }
        } else if (this.nDE < 0 && this.isDE(this.f.name)) {
            this.nDE = this.nField;
        }
    }

    public boolean parse(DataInputStream dataInputStream) throws Exception {
        this.error = null;
        return this.xmlparser.parse(dataInputStream) && this.error == null;
    }

    protected SavotField retrieveFiedFromRef(String string) {
        return (SavotField)this.fieldIDRef.get(string);
    }

    public void startElement(String string, Hashtable hashtable) {
        try {
            Object object;
            if (!this.xmlparser.in("VOTABLE")) {
                if (this.xmlparser.in("VOTABLE DESCRIPTION")) {
                    object = (String)hashtable.get("name");
                    this.resourceSub = string;
                } else if (this.xmlparser.in("VOTABLE INFO")) {
                    String string2;
                    object = (String)hashtable.get("name");
                    if (object != null && ((String)object).equals("Errors")) {
                        this.error = "Catalog not found";
                        return;
                    }
                    String string3 = (String)hashtable.get("ID");
                    if (string3 != null && string3.equals("Target") && (string2 = (String)hashtable.get("value")) != null) {
                        this.consumer.setTarget(string2);
                    }
                }
            }
            if (this.xmlparser.in("RESOURCE")) {
                if ((String)hashtable.get("ID") != null) {
                    this.consumer.startResource((String)hashtable.get("ID"));
                } else {
                    this.consumer.startResource((String)hashtable.get("name"));
                }
            } else if (this.xmlparser.in("RESOURCE TABLE")) {
                this.nField = 0;
                this.nRA = -1;
                this.nDE = -1;
                object = new SavotTable();
                ((SavotTable)object).setId((String)hashtable.get("ID"));
                ((SavotTable)object).setName((String)hashtable.get("name"));
                ((SavotTable)object).setRef((String)hashtable.get("ref"));
                this.consumer.startTable((SavotTable)object);
            } else if (this.xmlparser.in("TABLE FIELD")) {
                this.f = new Field(hashtable);
                ++this.columnCount;
            } else if (this.xmlparser.in("FIELD LINK")) {
                this.f.addInfo("href", (String)hashtable.get("href"));
                this.f.addInfo("gref", (String)hashtable.get("gref"));
                this.f.addInfo("refValue", (String)hashtable.get("content-type"));
                this.f.addInfo("refText", (String)hashtable.get("title"));
                this.inLinkField = true;
            } else if (this.xmlparser.in("TR")) {
                this.column = 0;
                this.currentTR = new SavotTR();
            }
            if (this.xmlparser.in("TD")) {
                this.inTD = true;
                this.resourceSub = string;
            } else if (this.xmlparser.in("FIELD DESCRIPTION")) {
                this.inDescription = true;
            } else if (!this.xmlparser.in("DATA")) {
                this.xmlparser.in("COOSYS");
            }
        }
        catch (Exception exception) {
            System.out.println("startElement : " + exception);
        }
    }
}

