/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Glu;
import cds.tools.CDSConstants;
import cds.tools.CDSLabel;
import cds.tools.CDSMethods;
import cds.vizier.VizieRQuery;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class VizieRPanel
extends Panel
implements CDSConstants {
    protected CDSLabel titre = null;
    protected TextField tauthor = new TextField(15);
    protected TextField ttarget = new TextField(15);
    protected TextField tradius = new TextField(15);
    protected Choice unit = new Choice();
    protected Choice coordinate = null;
    protected DataInputStream vizierStream = null;
    protected int outputMode = 1;
    protected List[] lk;
    protected List resultat = new List();
    protected String target = null;
    protected String radius = null;
    protected int nSection;
    static final String SUBMIT = "SUBMIT";
    static final String DEFAULT_TITRE = "... don't know which catalog ? Select the \npotentially interesting ones with words/keywords !";
    static final String TITRE = "Copyright CDS, a changer";
    static final int DEFAULTROWS = 6;
    VizieRQuery vq = null;
    protected BorderLayout borderLayout1 = new BorderLayout();
    private int oc = 0;

    public VizieRPanel(Glu glu, int n, boolean bl, String string, String string2, int n2) {
        try {
            this.outputMode = n;
            this.vq = new VizieRQuery();
            this.vq.setGLU(glu);
            if (!this.vq.metaDataQuery() || this.vq.getNameKey().size() == 0) {
                System.err.println("VizieR meta query error " + (this.vq.getMetaError() == null ? "" : this.vq.getMetaError()));
            }
            this.nSection = this.vq.getNameKey().size();
            this.setLayout(this.borderLayout1);
            this.makeForm(bl, string, string2, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    public TextField getAuthor() {
        return this.tauthor;
    }

    public List getList(int n) {
        return this.lk[n];
    }

    public int getListCount() {
        return this.lk.length;
    }

    public List getResultList() {
        return this.resultat;
    }

    public DataInputStream getResultStream() {
        return this.vq.getResultStream();
    }

    public Vector getResultVector() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.resultat.getItemCount()) {
            vector.addElement(this.resultat.getItem(n));
            ++n;
        }
        return vector;
    }

    private String getSectionName(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length && cArray[n] != '.') {
            ++n;
        }
        return n == cArray.length ? string : new String(cArray, n + 1, cArray.length - n - 1);
    }

    public String[] getSelection(String string) {
        try {
            if (string.compareTo("MISSION") == 0) {
                String[] stringArray = new String[this.vq.getvArchives().size()];
                int n = 0;
                while (n < this.vq.getvArchives().size()) {
                    stringArray[n] = new String((String)this.vq.getvArchives().elementAt(n));
                    ++n;
                }
                return stringArray;
            }
            if (string.compareTo("SURVEY") == 0) {
                String[] stringArray = new String[this.vq.getvSurveys().size()];
                int n = 0;
                while (n < this.vq.getvSurveys().size()) {
                    stringArray[n] = new String((String)this.vq.getvSurveys().elementAt(n));
                    ++n;
                }
                return stringArray;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(arrayIndexOutOfBoundsException);
        }
        return null;
    }

    protected static void makeAdd(Container container, Component component, String string) {
        try {
            container.add(component, string);
        }
        catch (Error error) {
            container.add(string, component);
        }
    }

    private void makeCursor(int n) {
        if (this.oc == n) {
            return;
        }
        VizieRPanel.makeCursor(this, n);
        if (this.resultat != null) {
            VizieRPanel.makeCursor(this.resultat, n);
        }
        VizieRPanel.makeCursor(this.tauthor, n);
        int n2 = 0;
        while (n2 < this.lk.length) {
            VizieRPanel.makeCursor(this.lk[n2], n);
            ++n2;
        }
        this.oc = n;
    }

    protected static void makeCursor(Component component, int n) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        if (component == null) {
            return;
        }
        ((Frame)component).setCursor(n == 1 ? 3 : (n == 2 ? 12 : (n == 3 ? 1 : (n == 4 ? 13 : (n == 5 ? 8 : (n == 6 ? 2 : 0))))));
    }

    protected void makeForm(boolean bl, String string, String string2, int n) {
        Serializable serializable;
        Label label;
        GridBagLayout gridBagLayout;
        Panel panel = null;
        Panel panel2 = null;
        Panel panel3 = null;
        Panel panel4 = null;
        Panel panel5 = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.titre = new CDSLabel(DEFAULT_TITRE, 1, CDSConstants.PLAIN);
        panel2 = new Panel();
        panel2.setLayout(new BorderLayout(3, 3));
        panel = new Panel();
        panel.setLayout(new BorderLayout(3, 3));
        panel.setFont(CDSConstants.BOLD);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(3, 3));
        VizieRPanel.makeAdd(panel, new Label("Author, free text...: "), "West");
        VizieRPanel.makeAdd(panel, this.tauthor, "Center");
        if (string == null && string2 == null) {
            panel3 = new Panel();
            gridBagLayout = new GridBagLayout();
            panel3.setLayout(gridBagLayout);
            panel3.setFont(CDSConstants.BOLD);
            label = new Label("Target ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel3.add(label);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.ipadx = 50;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.ttarget, gridBagConstraints);
            panel3.add(this.ttarget);
            this.coordinate = new Choice();
            this.coordinate.addItem("today");
            this.coordinate.addItem("J2000");
            this.coordinate.addItem("B1975");
            this.coordinate.addItem("B1950");
            this.coordinate.addItem("B1900");
            this.coordinate.addItem("B1875");
            this.coordinate.addItem("B1855");
            this.coordinate.addItem("Galactic");
            this.coordinate.addItem("Supergal.");
            this.coordinate.select("J2000");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.coordinate, gridBagConstraints);
            panel3.add(this.coordinate);
            label = new Label("Radius ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 8;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel3.add(label);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 10;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.tradius, gridBagConstraints);
            panel3.add(this.tradius);
            this.tradius.setText("10.0");
            this.unit = new Choice();
            this.unit.addItem("deg");
            this.unit.addItem("arcmin");
            this.unit.addItem("arcsec");
            this.unit.select("arcmin");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 11;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.unit, gridBagConstraints);
            panel3.add(this.unit);
        } else {
            if (string2 != null) {
                this.tradius.setText(string2);
            }
            if (string != null) {
                this.ttarget.setText(string);
            }
        }
        panel4 = new Panel();
        gridBagLayout = new GridBagLayout();
        panel4.setLayout(gridBagLayout);
        panel4.setFont(CDSConstants.BOLD);
        gridBagConstraints = new GridBagConstraints();
        this.lk = new List[this.nSection];
        label = null;
        int n2 = 0;
        while (n2 < this.nSection) {
            label = new Label();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(label, gridBagConstraints);
            label.setText(this.getSectionName((String)this.vq.getNameKey().elementAt(n2)));
            panel4.add(label);
            this.lk[n2] = n < 0 ? new List() : new List(n, true);
            serializable = (Vector)this.vq.gethKey().get((String)this.vq.getNameKey().elementAt(n2));
            Enumeration enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                this.lk[n2].addItem((String)enumeration.nextElement());
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            gridBagLayout.setConstraints(this.lk[n2], gridBagConstraints);
            panel4.add(this.lk[n2]);
            ++n2;
        }
        panel5 = new Panel();
        panel5.setLayout(new FlowLayout(2));
        panel5.setFont(CDSConstants.BOLD);
        VizieRPanel.makeAdd(panel6, this.titre, "North");
        VizieRPanel.makeAdd(panel6, panel, "Center");
        if (string == null && string2 == null && bl) {
            VizieRPanel.makeAdd(panel6, panel3, "South");
        }
        serializable = new Panel();
        ((Container)serializable).setLayout(new BorderLayout(3, 3));
        VizieRPanel.makeAdd((Container)serializable, panel4, "Center");
        VizieRPanel.makeAdd((Container)serializable, panel5, "South");
        VizieRPanel.makeAdd(this, panel6, "North");
        VizieRPanel.makeAdd(this, (Component)serializable, "Center");
        this.setTitre(this.target);
    }

    public void resetAll() {
        this.tauthor.setText("");
        if (this.ttarget != null) {
            this.ttarget.setText("");
            this.tradius.setText("10.0");
        }
        int n = 0;
        while (n < this.nSection) {
            VizieRPanel.resetList(this.lk[n]);
            ++n;
        }
    }

    public static void resetList(List list) {
        int n = 0;
        while (n < list.countItems()) {
            if (list.isSelected(n)) {
                list.deselect(n);
            }
            ++n;
        }
        list.makeVisible(0);
    }

    public void setLabel(String string) {
        this.titre.setText(string);
    }

    protected void setTitre(String string) {
        String string2 = null;
        String string3 = string2 = string == null ? DEFAULT_TITRE : "Click directly on the SUBMIT button to retrieve all VizieR catalogs around " + string + "\n" + " or include constraints below to reduce the number of matching catalogs.";
        if (string2 != null) {
            this.titre.setText(string2);
        } else {
            this.titre.setText("probleme");
        }
    }

    public boolean submit() {
        StringBuffer stringBuffer = new StringBuffer();
        this.waitCursor();
        int n = 0;
        while (n < this.nSection) {
            int[] nArray = this.lk[n].getSelectedIndexes();
            int n2 = 0;
            while (n2 < nArray.length) {
                CDSMethods.append(stringBuffer, (String)this.vq.getNameKey().elementAt(n), this.lk[n].getItem(nArray[n2]));
                ++n2;
            }
            ++n;
        }
        boolean bl = this.vq.submit(this.ttarget.getText(), this.tradius.getText(), this.unit.getSelectedItem(), this.tauthor.getText(), stringBuffer.toString(), this.outputMode, this.resultat);
        this.defaultCursor();
        return bl;
    }

    public boolean submit(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.waitCursor();
        int n = 0;
        while (n < this.nSection) {
            int[] nArray = this.lk[n].getSelectedIndexes();
            int n2 = 0;
            while (n2 < nArray.length) {
                CDSMethods.append(stringBuffer, (String)this.vq.getNameKey().elementAt(n), this.lk[n].getItem(nArray[n2]));
                ++n2;
            }
            ++n;
        }
        boolean bl = this.vq.submit(string, string2, this.unit.getSelectedItem(), this.coordinate.getSelectedItem(), this.tauthor.getText(), stringBuffer.toString(), this.outputMode, this.resultat);
        this.defaultCursor();
        return bl;
    }

    private void waitCursor() {
        this.makeCursor(1);
    }
}

