/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.pull;

import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotData;
import cds.savot.model.SavotDefinitions;
import cds.savot.model.SavotField;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotMax;
import cds.savot.model.SavotMin;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import java.io.DataInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;

public class SavotPullEngine {
    public static int FULL = 0;
    public static int SEQUENTIAL = 1;
    private static String VOTABLE = "VOTABLE";
    private static String TABLE = "TABLE";
    private static String FIELD = "FIELD";
    private static String TABLEDATA = "TABLEDATA";
    private static String DESCRIPTION = "DESCRIPTION";
    private static String DATA = "DATA";
    private static String RESOURCE = "RESOURCE";
    private static String PARAM = "PARAM";
    private static String DEFINITIONS = "DEFINITIONS";
    private static String LINK = "LINK";
    private static String INFO = "INFO";
    private static String TR = "TR";
    private static String TD = "TD";
    private static String COOSYS = "COOSYS";
    private static String SYSTEM = "SYSTEM";
    private static String ARRAYSIZE = "arraysize";
    private static String DATATYPE = "datatype";
    private static String EPOCH = "epoch";
    private static String EQUINOX = "equinox";
    private static String INCLUSIVE = "inclusive";
    private static String MAX = "max";
    private static String MIN = "min";
    private static String NAME = "name";
    private static String PRECISION = "precision";
    private static String REF = "ref";
    private static String TYPE = "type";
    private static String UCD = "ucd";
    private static String UNIT = "unit";
    private static String VALUE = "value";
    private static String WIDTH = "width";
    private static String ID = "ID";
    private static String CONTENTROLE = "content-role";
    private static String CONTENTTYPE = "content-type";
    private static String TITLE = "title";
    private static String HREF = "href";
    private static String GREF = "gref";
    private static String ACTION = "action";
    private SavotVOTable allResources = new SavotVOTable();
    private SavotResource currentResource = new SavotResource();
    private long rowCounter = 0L;
    private long resourceCounter = 0L;
    private long tableCounter = 0L;
    private long dataCounter = 0L;
    private boolean trace = false;
    private String previousName = null;
    private int previousEventType = 0;
    private Vector stack = new Vector();
    public Hashtable idRefLinks = new Hashtable();
    protected XmlPullParser parser = null;

    public SavotPullEngine(XmlPullParser parser, String file, int mode) {
        try {
            this.parser = parser;
            parser.setInput(new FileReader(file));
            if (mode == FULL) {
                this.parse(parser, mode);
            }
        }
        catch (IOException e) {
            System.out.println("SavotPullEngine : ".concat(String.valueOf(String.valueOf(e))));
        }
        catch (Exception f) {
            System.out.println("SavotPullEngine : ".concat(String.valueOf(String.valueOf(f))));
        }
    }

    public SavotPullEngine(XmlPullParser parser, URL url, int mode, String enc) {
        try {
            this.parser = parser;
            parser.setInput(new DataInputStream(url.openStream()), enc);
            if (mode == FULL) {
                this.parse(parser, mode);
            }
        }
        catch (IOException e) {
            System.out.println("SavotPullEngine : ".concat(String.valueOf(String.valueOf(e))));
        }
        catch (Exception f) {
            System.out.println("SavotPullEngine : ".concat(String.valueOf(String.valueOf(f))));
        }
    }

    public SavotPullEngine(XmlPullParser parser, InputStream instream, int mode, String enc) {
        try {
            this.parser = parser;
            parser.setInput(new DataInputStream(instream), enc);
            if (mode == FULL) {
                this.parse(parser, mode);
            }
        }
        catch (IOException e) {
            System.out.println("SavotPullEngine : ".concat(String.valueOf(String.valueOf(e))));
        }
        catch (Exception f) {
            System.out.println("SavotPullEngine : ".concat(String.valueOf(String.valueOf(f))));
        }
    }

    public void reset() {
        this.allResources = new SavotVOTable();
        this.currentResource = new SavotResource();
        this.rowCounter = 0L;
        this.resourceCounter = 0L;
        this.tableCounter = 0L;
        this.dataCounter = 0L;
        this.idRefLinks.clear();
        this.stack.removeAllElements();
    }

    private void onStack(SavotResource res) {
        this.stack.addElement(res);
    }

    private SavotResource offStack() {
        SavotResource res = (SavotResource)this.stack.lastElement();
        this.stack.removeElementAt(this.stack.size() - 1);
        return res;
    }

    public SavotResource parse(XmlPullParser parser, int parsingType) throws IOException {
        block163: {
            String name = new String();
            Vector<String> father = new Vector<String>();
            String currentMarkup = "XML";
            boolean resourceComplete = false;
            int includedResource = 0;
            SavotTable currentTable = new SavotTable();
            SavotField currentField = new SavotField();
            SavotParam currentParam = new SavotParam();
            SavotTR currentTR = new SavotTR();
            SavotTD currentTD = new SavotTD();
            SavotData currentData = new SavotData();
            SavotValues currentValues = new SavotValues();
            SavotTableData currentTableData = new SavotTableData();
            String currentDescription = new String();
            SavotLink currentLink = new SavotLink();
            SavotInfo currentInfo = new SavotInfo();
            SavotMin currentMin = new SavotMin();
            SavotMax currentMax = new SavotMax();
            SavotCoosys currentCoosys = new SavotCoosys();
            SavotDefinitions currentDefinitions = new SavotDefinitions();
            SavotResource innerResource = new SavotResource();
            try {
                int eventType = parser.getEventType();
                int previousDepth = 0;
                while (eventType != 1) {
                    switch (eventType) {
                        case 2: {
                            try {
                                name = parser.getName();
                                if (this.trace) {
                                    System.out.println("Name ---> ".concat(String.valueOf(String.valueOf(parser.getName()))));
                                }
                                if (name != null) {
                                    if (name.equalsIgnoreCase(VOTABLE)) {
                                        if (this.trace) {
                                            System.out.println("VOTABLE begin");
                                        }
                                        currentMarkup = VOTABLE;
                                    } else if (name.equalsIgnoreCase(DESCRIPTION)) {
                                        currentMarkup = DESCRIPTION;
                                        if (this.trace) {
                                            System.out.println("DESCRIPTION begin");
                                        }
                                    } else if (name.equalsIgnoreCase(RESOURCE)) {
                                        if (includedResource > 0) {
                                            this.onStack(this.currentResource);
                                            this.currentResource = new SavotResource();
                                        }
                                        ++includedResource;
                                        if (this.trace) {
                                            System.out.println("RESOURCE begin");
                                        }
                                        currentMarkup = RESOURCE;
                                        ++this.resourceCounter;
                                        if (parsingType == FULL || this.currentResource == null) {
                                            this.currentResource = new SavotResource();
                                        } else {
                                            this.currentResource.init();
                                        }
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, NAME) != null) {
                                                this.currentResource.setName(parser.getAttributeValue(null, NAME));
                                            }
                                            if (parser.getAttributeValue(null, TYPE) != null) {
                                                this.currentResource.setType(parser.getAttributeValue(null, TYPE));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                this.currentResource.setId(parser.getAttributeValue(null, ID));
                                                if (parsingType == FULL) {
                                                    this.idRefLinks.put(parser.getAttributeValue(null, ID), this.currentResource);
                                                }
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(TABLE)) {
                                        currentTable = new SavotTable();
                                        currentMarkup = TABLE;
                                        ++this.tableCounter;
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, NAME) != null) {
                                                currentTable.setName(parser.getAttributeValue(null, NAME));
                                            }
                                            if (parser.getAttributeValue(null, REF) != null) {
                                                currentTable.setRef(parser.getAttributeValue(null, REF));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                currentTable.setId(parser.getAttributeValue(null, ID));
                                                if (parsingType == FULL) {
                                                    this.idRefLinks.put(parser.getAttributeValue(null, ID), currentTable);
                                                    if (this.trace) {
                                                        System.out.println(parser.getAttributeValue(null, ID));
                                                    }
                                                }
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(FIELD)) {
                                        currentField = new SavotField();
                                        currentMarkup = FIELD;
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, UNIT) != null) {
                                                currentField.setUnit(parser.getAttributeValue(null, UNIT));
                                            }
                                            if (parser.getAttributeValue(null, DATATYPE) != null) {
                                                currentField.setDataType(parser.getAttributeValue(null, DATATYPE));
                                            }
                                            if (parser.getAttributeValue(null, PRECISION) != null) {
                                                currentField.setPrecision(parser.getAttributeValue(null, PRECISION));
                                            }
                                            if (parser.getAttributeValue(null, WIDTH) != null) {
                                                currentField.setWidth(parser.getAttributeValue(null, WIDTH));
                                            }
                                            if (parser.getAttributeValue(null, REF) != null) {
                                                currentField.setRef(parser.getAttributeValue(null, REF));
                                            }
                                            if (parser.getAttributeValue(null, NAME) != null) {
                                                currentField.setName(parser.getAttributeValue(null, NAME));
                                            }
                                            if (parser.getAttributeValue(null, UCD) != null) {
                                                currentField.setUcd(parser.getAttributeValue(null, UCD));
                                            }
                                            if (parser.getAttributeValue(null, ARRAYSIZE) != null) {
                                                currentField.setArraySize(parser.getAttributeValue(null, ARRAYSIZE));
                                            }
                                            if (parser.getAttributeValue(null, TYPE) != null) {
                                                currentField.setType(parser.getAttributeValue(null, TYPE));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                currentField.setId(parser.getAttributeValue(null, ID));
                                                this.idRefLinks.put(parser.getAttributeValue(null, ID), currentField);
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(TR)) {
                                        if (this.trace) {
                                            System.out.println("TR begin");
                                        }
                                        currentMarkup = TR;
                                        currentTR = new SavotTR();
                                    } else if (name.equalsIgnoreCase(TD)) {
                                        if (this.trace) {
                                            System.out.println("TD begin");
                                        }
                                        currentMarkup = TD;
                                        currentTD = new SavotTD();
                                        if (parser.getAttributeCount() != 0 && parser.getAttributeValue(null, REF) != null) {
                                            currentTD.setRef(parser.getAttributeValue(null, REF));
                                        }
                                        ++this.dataCounter;
                                    } else if (name.equalsIgnoreCase(DATA)) {
                                        currentData = new SavotData();
                                        currentMarkup = DATA;
                                    } else if (name.equalsIgnoreCase(TABLEDATA)) {
                                        currentTableData = new SavotTableData();
                                        currentMarkup = TABLEDATA;
                                    } else if (name.equalsIgnoreCase(PARAM)) {
                                        currentParam = new SavotParam();
                                        currentMarkup = PARAM;
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, UNIT) != null) {
                                                currentParam.setUnit(parser.getAttributeValue(null, UNIT));
                                            }
                                            if (parser.getAttributeValue(null, DATATYPE) != null) {
                                                currentParam.setDataType(parser.getAttributeValue(null, DATATYPE));
                                            }
                                            if (parser.getAttributeValue(null, PRECISION) != null) {
                                                currentParam.setPrecision(parser.getAttributeValue(null, PRECISION));
                                            }
                                            if (parser.getAttributeValue(null, UNIT) != null) {
                                                currentParam.setWidth(parser.getAttributeValue(null, WIDTH));
                                            }
                                            if (parser.getAttributeValue(null, REF) != null) {
                                                currentParam.setRef(parser.getAttributeValue(null, REF));
                                            }
                                            if (parser.getAttributeValue(null, NAME) != null) {
                                                currentParam.setName(parser.getAttributeValue(null, NAME));
                                            }
                                            if (parser.getAttributeValue(null, UCD) != null) {
                                                currentParam.setUcd(parser.getAttributeValue(null, UCD));
                                            }
                                            if (parser.getAttributeValue(null, VALUE) != null) {
                                                currentParam.setValue(parser.getAttributeValue(null, VALUE));
                                            }
                                            if (parser.getAttributeValue(null, ARRAYSIZE) != null) {
                                                currentParam.setArraySize(parser.getAttributeValue(null, ARRAYSIZE));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                currentParam.setId(parser.getAttributeValue(null, ID));
                                                this.idRefLinks.put(parser.getAttributeValue(null, ID), currentParam);
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(LINK)) {
                                        currentLink = new SavotLink();
                                        currentMarkup = LINK;
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, CONTENTROLE) != null) {
                                                currentLink.setContentRole(parser.getAttributeValue(null, CONTENTROLE));
                                            }
                                            if (parser.getAttributeValue(null, CONTENTTYPE) != null) {
                                                currentLink.setContentType(parser.getAttributeValue(null, CONTENTTYPE));
                                            }
                                            if (parser.getAttributeValue(null, TITLE) != null) {
                                                currentLink.setTitle(parser.getAttributeValue(null, TITLE));
                                            }
                                            if (parser.getAttributeValue(null, VALUE) != null) {
                                                currentLink.setValue(parser.getAttributeValue(null, VALUE));
                                            }
                                            if (parser.getAttributeValue(null, HREF) != null) {
                                                currentLink.setHref(parser.getAttributeValue(null, HREF));
                                            }
                                            if (parser.getAttributeValue(null, GREF) != null) {
                                                currentLink.setGref(parser.getAttributeValue(null, GREF));
                                            }
                                            if (parser.getAttributeValue(null, ACTION) != null) {
                                                currentLink.setAction(parser.getAttributeValue(null, ACTION));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                currentLink.setID(parser.getAttributeValue(null, ID));
                                                this.idRefLinks.put(parser.getAttributeValue(null, ID), currentLink);
                                            }
                                        }
                                        if (this.trace) {
                                            System.out.println("LINK");
                                        }
                                    } else if (name.equalsIgnoreCase(INFO)) {
                                        currentInfo = new SavotInfo();
                                        currentMarkup = INFO;
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, NAME) != null) {
                                                currentInfo.setName(parser.getAttributeValue(null, NAME));
                                            }
                                            if (parser.getAttributeValue(null, VALUE) != null) {
                                                currentInfo.setValue(parser.getAttributeValue(null, VALUE));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                currentInfo.setId(parser.getAttributeValue(null, ID));
                                                this.idRefLinks.put(parser.getAttributeValue(null, ID), currentInfo);
                                            }
                                        }
                                        if (this.trace) {
                                            System.out.println("INFO");
                                        }
                                    } else if (name.equalsIgnoreCase(MIN)) {
                                        if (this.trace) {
                                            System.out.println("MIN");
                                        }
                                        currentMarkup = MIN;
                                        currentMin = new SavotMin();
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, VALUE) != null) {
                                                currentMin.setValue(parser.getAttributeValue(null, VALUE));
                                            }
                                            if (parser.getAttributeValue(null, INCLUSIVE) != null) {
                                                currentMin.setInclusive(parser.getAttributeValue(null, INCLUSIVE));
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(MAX)) {
                                        currentMarkup = MAX;
                                        if (this.trace) {
                                            System.out.println("MAX");
                                        }
                                        currentMax = new SavotMax();
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, VALUE) != null) {
                                                currentMin.setValue(parser.getAttributeValue(null, VALUE));
                                            }
                                            if (parser.getAttributeValue(null, INCLUSIVE) != null) {
                                                currentMin.setInclusive(parser.getAttributeValue(null, INCLUSIVE));
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(COOSYS)) {
                                        currentMarkup = COOSYS;
                                        if (this.trace) {
                                            System.out.println("COOSYS");
                                        }
                                        currentCoosys = new SavotCoosys();
                                        if (parser.getAttributeCount() != 0) {
                                            if (parser.getAttributeValue(null, EQUINOX) != null) {
                                                currentCoosys.setEquinox(parser.getAttributeValue(null, EQUINOX));
                                            }
                                            if (parser.getAttributeValue(null, EPOCH) != null) {
                                                currentCoosys.setEpoch(parser.getAttributeValue(null, EPOCH));
                                            }
                                            if (parser.getAttributeValue(null, SYSTEM) != null) {
                                                currentCoosys.setSystem(parser.getAttributeValue(null, SYSTEM));
                                            }
                                            if (parser.getAttributeValue(null, ID) != null) {
                                                currentCoosys.setId(parser.getAttributeValue(null, ID));
                                                this.idRefLinks.put(parser.getAttributeValue(null, ID), currentCoosys);
                                            }
                                        }
                                    } else if (name.equalsIgnoreCase(DEFINITIONS)) {
                                        currentMarkup = DEFINITIONS;
                                        currentDefinitions = new SavotDefinitions();
                                        if (this.trace) {
                                            System.out.println("DEFINITIONS");
                                        }
                                    }
                                }
                                currentMarkup = name;
                            }
                            catch (Exception e) {
                                System.out.println("START_TAG : ".concat(String.valueOf(String.valueOf(e))));
                            }
                            break;
                        }
                        case 3: {
                            name = parser.getName();
                            try {
                                if (this.trace) {
                                    System.out.println("End ---> ".concat(String.valueOf(String.valueOf(name))));
                                }
                                if (name.equalsIgnoreCase(DESCRIPTION)) {
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(VOTABLE)) {
                                        this.allResources.setDescription(currentDescription);
                                        currentMarkup = "";
                                        break;
                                    }
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(RESOURCE)) {
                                        if (this.currentResource == null) {
                                            System.out.println("et oui");
                                        }
                                        this.currentResource.setDescription(currentDescription);
                                        currentMarkup = "";
                                        break;
                                    }
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(PARAM)) {
                                        currentParam.setDescription(currentDescription);
                                        currentMarkup = "";
                                        break;
                                    }
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(TABLE)) {
                                        currentTable.setDescription(currentDescription);
                                        currentMarkup = "";
                                        break;
                                    }
                                    if (!((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(FIELD)) break;
                                    currentField.setDescription(currentDescription);
                                    currentMarkup = "";
                                    break;
                                }
                                if (name.equalsIgnoreCase(TABLE)) {
                                    this.currentResource.getTables().addItem(currentTable);
                                    currentMarkup = "";
                                    if (!this.trace) break;
                                    System.out.println(currentTable.getName());
                                    break;
                                }
                                if (name.equalsIgnoreCase(FIELD)) {
                                    currentTable.getFields().addItem(currentField);
                                    currentMarkup = "";
                                    if (!this.trace) break;
                                    System.out.println("ADD field");
                                    break;
                                }
                                if (name.equalsIgnoreCase(TR)) {
                                    if (this.trace) {
                                        System.out.println("TR end");
                                    }
                                    currentMarkup = "";
                                    currentTableData.getTRs().addItem(currentTR);
                                    ++this.rowCounter;
                                    if (!this.trace) break;
                                    System.out.println("ADD row");
                                    break;
                                }
                                if (name.equalsIgnoreCase(DATA)) {
                                    currentMarkup = "";
                                    currentTable.setData(currentData);
                                    break;
                                }
                                if (name.equalsIgnoreCase(TD)) {
                                    currentMarkup = "";
                                    if (this.trace) {
                                        System.out.println("TD end");
                                    }
                                    currentTR.getTDs().addItem(currentTD);
                                    break;
                                }
                                if (name.equalsIgnoreCase(RESOURCE)) {
                                    if (this.trace) {
                                        System.out.println("RESOURCE end");
                                    }
                                    currentMarkup = "";
                                    if (includedResource > 1) {
                                        SavotResource tempo = this.currentResource;
                                        this.currentResource = this.offStack();
                                        this.currentResource.getResources().addItem(tempo);
                                    } else {
                                        if (parsingType == FULL) {
                                            this.allResources.getResources().addItem(this.currentResource);
                                        }
                                        resourceComplete = true;
                                    }
                                    --includedResource;
                                    break;
                                }
                                if (name.equalsIgnoreCase(TABLEDATA)) {
                                    currentMarkup = "";
                                    currentData.setTableData(currentTableData);
                                    if (!this.trace) break;
                                    System.out.println(currentTable.getName());
                                    break;
                                }
                                if (name.equalsIgnoreCase(COOSYS)) {
                                    currentMarkup = "";
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(DEFINITIONS)) {
                                        currentDefinitions.getCoosys().addItem(currentCoosys);
                                        if (!this.trace) break;
                                        System.out.println("COOSYS de DEFINITIONS father = ".concat(String.valueOf(String.valueOf(father))));
                                        break;
                                    }
                                    if (!((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(RESOURCE)) break;
                                    this.currentResource.getCoosys().addItem(currentCoosys);
                                    if (!this.trace) break;
                                    System.out.println("COOSYS de RESOURCE father = ".concat(String.valueOf(String.valueOf(father))));
                                    break;
                                }
                                if (name.equalsIgnoreCase(PARAM)) {
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(DEFINITIONS)) {
                                        currentDefinitions.getParams().addItem(currentParam);
                                        if (!this.trace) break;
                                        System.out.println("PARAM de DEFINITIONS father = ".concat(String.valueOf(String.valueOf(father))));
                                        break;
                                    }
                                    if (!((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(RESOURCE)) break;
                                    this.currentResource.getParams().addItem(currentParam);
                                    resourceComplete = true;
                                    if (!this.trace) break;
                                    System.out.println("PARAM de RESOURCE father = ".concat(String.valueOf(String.valueOf(father))));
                                    break;
                                }
                                if (name.equalsIgnoreCase(LINK)) {
                                    currentMarkup = "";
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(RESOURCE)) {
                                        this.currentResource.getLinks().addItem(currentLink);
                                        if (!this.trace) break;
                                        System.out.println("LINK de RESOURCE father = ".concat(String.valueOf(String.valueOf(father))));
                                        break;
                                    }
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(TABLE)) {
                                        currentTable.getLinks().addItem(currentLink);
                                        if (!this.trace) break;
                                        System.out.println("LINK de TABLE father = ".concat(String.valueOf(String.valueOf(father))));
                                        break;
                                    }
                                    if (!((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(FIELD)) break;
                                    currentField.getLinks().addItem(currentLink);
                                    if (!this.trace) break;
                                    System.out.println("LINK de FIELD father = ".concat(String.valueOf(String.valueOf(father))));
                                    break;
                                }
                                if (name.equalsIgnoreCase(INFO)) {
                                    currentMarkup = "";
                                    if (((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(VOTABLE)) {
                                        this.allResources.getInfos().addItem(currentInfo);
                                        if (!this.trace) break;
                                        System.out.println("INFO de INFO father = ".concat(String.valueOf(String.valueOf(father))));
                                        break;
                                    }
                                    if (!((String)father.elementAt(father.size() - 2)).equalsIgnoreCase(RESOURCE)) break;
                                    this.currentResource.getInfos().addItem(currentInfo);
                                    if (!this.trace) break;
                                    System.out.println("INFO de RESOURCE father = ".concat(String.valueOf(String.valueOf(father))));
                                    break;
                                }
                                if (!name.equalsIgnoreCase(DEFINITIONS)) break;
                                currentMarkup = "";
                                if (this.trace) {
                                    System.out.println("DEFINITIONS");
                                }
                                this.allResources.setDefinitions(currentDefinitions);
                            }
                            catch (Exception e) {
                                System.out.println(String.valueOf(String.valueOf(new StringBuffer("FATHER : ").append(father).append(" END_TAG (").append(name).append(") : ").append(e))));
                            }
                            break;
                        }
                        case 1: {
                            try {
                                if (!this.trace) break;
                                System.out.println("Document end reached!");
                            }
                            catch (Exception e) {
                                System.out.println("END_DOCUMENT : ".concat(String.valueOf(String.valueOf(e))));
                            }
                            break;
                        }
                        case 4: {
                            try {
                                if (currentMarkup.equalsIgnoreCase(TD)) {
                                    if (this.trace) {
                                        System.out.println("TD XXX: ".concat(String.valueOf(String.valueOf(parser.getText().trim()))));
                                    }
                                    currentTD.setContent(parser.getText().trim());
                                    break;
                                }
                                if (currentMarkup.equalsIgnoreCase(DESCRIPTION)) {
                                    if (this.trace) {
                                        System.out.println("DESCRIPTION : ".concat(String.valueOf(String.valueOf(parser.getText().trim()))));
                                    }
                                    currentDescription = parser.getText().trim();
                                    break;
                                }
                                if (currentMarkup.equalsIgnoreCase(MIN)) {
                                    if (!this.trace) break;
                                    System.out.println("MIN : ".concat(String.valueOf(String.valueOf(parser.getText().trim()))));
                                    break;
                                }
                                if (!currentMarkup.equalsIgnoreCase(MAX) || !this.trace) break;
                                System.out.println("MAX : ".concat(String.valueOf(String.valueOf(parser.getText().trim()))));
                            }
                            catch (Exception e) {
                                System.out.println("TEXT : ".concat(String.valueOf(String.valueOf(e))));
                            }
                            break;
                        }
                        default: {
                            if (!this.trace) break;
                            System.out.println(" ignoring some other (legacy) event at line : ".concat(String.valueOf(String.valueOf(parser.getLineNumber()))));
                            break;
                        }
                    }
                    previousDepth = parser.getDepth();
                    this.previousEventType = eventType;
                    this.previousName = name;
                    eventType = parser.next();
                    if (parser.getDepth() > previousDepth) {
                        father.addElement(parser.getName());
                    } else if (parser.getDepth() == previousDepth) {
                        if (((String)father.lastElement()).equals(parser.getName())) {
                            father.removeElementAt(father.size() - 1);
                            father.addElement(parser.getName());
                        }
                    } else {
                        father.removeElementAt(father.size() - 1);
                    }
                    if (this.trace) {
                        System.out.println("father = ".concat(String.valueOf(String.valueOf(father))));
                    }
                    if (parsingType != SEQUENTIAL || !resourceComplete) continue;
                    eventType = 1;
                }
            }
            catch (Exception f) {
                if (!this.trace) break block163;
                System.out.println("parse : ".concat(String.valueOf(String.valueOf(f))));
            }
        }
        return null;
    }

    public SavotResource getNextResource() {
        block2: {
            this.currentResource = null;
            try {
                this.parse(this.parser, SEQUENTIAL);
            }
            catch (IOException e) {
                if (!this.trace) break block2;
                System.out.println("getNextResource : ".concat(String.valueOf(String.valueOf(e))));
            }
        }
        return this.currentResource;
    }

    public SavotResource getNextTable() {
        this.currentResource = null;
        try {
            this.parse(this.parser, SEQUENTIAL);
        }
        catch (IOException e) {
            System.out.println("getNextTable : ".concat(String.valueOf(String.valueOf(e))));
        }
        return this.currentResource;
    }

    public SavotVOTable getVOTable() {
        return this.allResources;
    }

    public void sequentialTester() {
        do {
            this.currentResource = this.getNextResource();
        } while (this.currentResource != null);
    }

    public long getResourceCount() {
        return this.resourceCounter;
    }

    public long getTableCount() {
        return this.tableCounter;
    }

    public long getTRCount() {
        return this.rowCounter;
    }

    public long getDataCount() {
        return this.dataCounter;
    }

    public Hashtable getIdRefLinks() {
        return this.idRefLinks;
    }

    public SavotResource getResourceFromRef(String ref) {
        return (SavotResource)this.idRefLinks.get(ref);
    }

    public SavotField getFieldFromRef(String ref) {
        return (SavotField)this.idRefLinks.get(ref);
    }

    public SavotParam getParamFromRef(String ref) {
        return (SavotParam)this.idRefLinks.get(ref);
    }

    public SavotTable getTableFromRef(String ref) {
        return (SavotTable)this.idRefLinks.get(ref);
    }

    public SavotInfo getInfoFromRef(String ref) {
        return (SavotInfo)this.idRefLinks.get(ref);
    }

    public SavotValues getValuesFromRef(String ref) {
        return (SavotValues)this.idRefLinks.get(ref);
    }

    public SavotLink getLinkFromRef(String ref) {
        return (SavotLink)this.idRefLinks.get(ref);
    }

    public SavotCoosys getCoosysFromRef(String ref) {
        return (SavotCoosys)this.idRefLinks.get(ref);
    }

    public SavotVOTable getAllResources() {
        return this.allResources;
    }
}

