/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.io.EOFException;
import java.io.InputStream;

public final class Hdecomp {
    private static int SIZEBUF = 8192;
    private static byte[] buf = new byte[SIZEBUF];
    private static int ptBuf = 0;
    private static int maxBuf = 0;
    private static InputStream dis;
    private static double log2;
    private static int[] code_magic;
    private static int nx;
    private static int ny;
    private static int nel;
    private static int scale;
    private static int[] a;
    private static int buffer;
    private static int bits_to_go;
    private static int[] nbitplanes;

    static {
        log2 = Math.log(2.0);
        code_magic = new int[]{221, 153};
        nbitplanes = new int[3];
    }

    private static void decode() throws Exception {
        int n = 0;
        int n2 = 0;
        maxBuf = 0;
        ptBuf = 0;
        n = Hdecomp.getc();
        if (n != code_magic[0] || (n2 = Hdecomp.getc()) != code_magic[1]) {
            throw new Exception("Bad magic number");
        }
        nx = Hdecomp.getint();
        ny = Hdecomp.getint();
        nel = nx * ny;
        scale = Hdecomp.getint();
        a = new int[nel];
        int n3 = Hdecomp.getint();
        Hdecomp.nbitplanes[0] = Hdecomp.getc();
        Hdecomp.nbitplanes[1] = Hdecomp.getc();
        Hdecomp.nbitplanes[2] = Hdecomp.getc();
        Hdecomp.dodecode();
        Hdecomp.a[0] = n3;
    }

    public static byte[] decomp(InputStream inputStream) throws Exception {
        dis = inputStream;
        Hdecomp.decode();
        Hdecomp.undigitize();
        Hdecomp.hinv();
        return Hdecomp.getPixels();
    }

    private static void dodecode() throws Exception {
        int n = (nx + 1) / 2;
        int n2 = (ny + 1) / 2;
        Hdecomp.start_inputing_bits();
        Hdecomp.qtree_decode(0, ny, n, n2, nbitplanes[0]);
        Hdecomp.qtree_decode(n2, ny, n, ny / 2, nbitplanes[1]);
        Hdecomp.qtree_decode(ny * n, ny, nx / 2, n2, nbitplanes[1]);
        Hdecomp.qtree_decode(ny * n + n2, ny, nx / 2, ny / 2, nbitplanes[2]);
        if (Hdecomp.input_nbits(4) != 0) {
            System.err.println("dodecode: bad bit plane values\n");
            System.exit(-1);
        }
        Hdecomp.start_inputing_bits();
        int n3 = 0;
        while (n3 < nel) {
            int n4 = a[n3];
            if (n4 != 0 && Hdecomp.input_bit() != 0) {
                Hdecomp.a[n3] = -n4;
            }
            ++n3;
        }
    }

    private static byte[] getPixels() {
        byte[] byArray = new byte[nel * 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(a[n2] >> 8 & 0xFF);
            byArray[n + 1] = (byte)(a[n2++] & 0xFF);
            n += 2;
        }
        return byArray;
    }

    private static int getc() throws Exception {
        while (ptBuf == maxBuf) {
            ptBuf = 0;
            maxBuf = dis.read(buf, 0, buf.length);
            if (maxBuf != -1) continue;
            throw new EOFException();
        }
        return buf[ptBuf++] & 0xFF;
    }

    private static int getint() throws Exception {
        return Hdecomp.getc() << 24 | Hdecomp.getc() << 16 | Hdecomp.getc() << 8 | Hdecomp.getc();
    }

    private static void hinv() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = nx > ny ? nx : ny;
        if (n7 > 1 << (n = (int)(Math.log(n7) / log2 + 0.5))) {
            ++n;
        }
        int[] nArray = new int[(n7 + 1) / 2];
        int n8 = 1;
        int n9 = 1 << n - 1;
        int n10 = n9 << 1;
        int n11 = n9 << 2;
        int n12 = -n9;
        int n13 = n12 << 1;
        int n14 = n12 << 2;
        int n15 = n9 >> 1;
        int n16 = n10 >> 1;
        int n17 = n11 >> 1;
        int n18 = n15 - 1;
        int n19 = n16 - 1;
        int n20 = n17 - 1;
        Hdecomp.a[0] = a[0] + (a[0] >= 0 ? n17 : n20) & n14;
        int n21 = 1;
        int n22 = 1;
        int n23 = nx;
        int n24 = ny;
        int n25 = 1 << n;
        int n26 = n - 1;
        while (n26 >= 0) {
            int n27;
            int n28;
            n21 <<= 1;
            n22 <<= 1;
            if (n23 <= (n25 >>= 1)) {
                --n21;
            } else {
                n23 -= n25;
            }
            if (n24 <= n25) {
                --n22;
            } else {
                n24 -= n25;
            }
            if (n26 == 0) {
                n18 = 0;
                n8 = 2;
            }
            int n29 = 0;
            while (n29 < n21) {
                Hdecomp.unshuffle(ny * n29, n22, 1, nArray);
                ++n29;
            }
            int n30 = 0;
            while (n30 < n22) {
                Hdecomp.unshuffle(n30, n21, ny, nArray);
                ++n30;
            }
            int n31 = n21 % 2;
            int n32 = n22 % 2;
            n29 = 0;
            while (n29 < n21 - n31) {
                n28 = ny * n29;
                int n33 = n28 + ny;
                n30 = 0;
                while (n30 < n22 - n32) {
                    n5 = a[n28];
                    n4 = a[n33];
                    n3 = a[n28 + 1];
                    n2 = a[n33 + 1];
                    n4 = n4 + (n4 >= 0 ? n16 : n19) & n13;
                    n3 = n3 + (n3 >= 0 ? n16 : n19) & n13;
                    n2 = n2 + (n2 >= 0 ? n15 : n18) & n12;
                    n6 = n2 & n9;
                    n4 = n4 >= 0 ? n4 - n6 : n4 + n6;
                    n3 = n3 >= 0 ? n3 - n6 : n3 + n6;
                    n27 = (n2 ^ n4 ^ n3) & n10;
                    n5 = n5 >= 0 ? n5 + n6 - n27 : n5 + (n6 == 0 ? n27 : n6 - n27);
                    Hdecomp.a[n33 + 1] = n5 + n4 + n3 + n2 >> n8;
                    Hdecomp.a[n33] = n5 + n4 - n3 - n2 >> n8;
                    Hdecomp.a[n28 + 1] = n5 - n4 + n3 - n2 >> n8;
                    Hdecomp.a[n28] = n5 - n4 - n3 + n2 >> n8;
                    n28 += 2;
                    n33 += 2;
                    n30 += 2;
                }
                if (n32 != 0) {
                    n5 = a[n28];
                    n4 = a[n33];
                    n4 = (n4 >= 0 ? n4 + n16 : n4 + n19) & n13;
                    n27 = n4 & n10;
                    n5 = n5 >= 0 ? n5 - n27 : n5 + n27;
                    Hdecomp.a[n33] = n5 + n4 >> n8;
                    Hdecomp.a[n28] = n5 - n4 >> n8;
                }
                n29 += 2;
            }
            if (n31 != 0) {
                n28 = ny * n29;
                n30 = 0;
                while (n30 < n22 - n32) {
                    n5 = a[n28];
                    n3 = a[n28 + 1];
                    n3 = (n3 >= 0 ? n3 + n16 : n3 + n19) & n13;
                    n27 = n3 & n10;
                    n5 = n5 >= 0 ? n5 - n27 : n5 + n27;
                    Hdecomp.a[n28 + 1] = n5 + n3 >> n8;
                    Hdecomp.a[n28] = n5 - n3 >> n8;
                    n28 += 2;
                    n30 += 2;
                }
                if (n32 != 0) {
                    n5 = a[n28];
                    Hdecomp.a[n28] = n5 >> n8;
                }
            }
            n11 = n10;
            n10 = n9;
            n9 >>= 1;
            n13 = n12;
            n12 >>= 1;
            n16 = n15;
            n19 = n18;
            n18 = (n15 >>= 1) - 1;
            --n26;
        }
        nArray = null;
    }

    private static int input_bit() throws Exception {
        if (bits_to_go == 0) {
            buffer = Hdecomp.getc();
            bits_to_go = 8;
        }
        return buffer >> --bits_to_go & 1;
    }

    private static int input_huffman() throws Exception {
        int n = Hdecomp.input_nbits(3);
        if (n < 4) {
            return 1 << n;
        }
        n = Hdecomp.input_bit() | n << 1;
        if (n < 13) {
            switch (n) {
                case 8: {
                    return 3;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 10;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 15;
                }
            }
        }
        if ((n = Hdecomp.input_bit() | n << 1) < 31) {
            switch (n) {
                case 26: {
                    return 6;
                }
                case 27: {
                    return 7;
                }
                case 28: {
                    return 9;
                }
                case 29: {
                    return 11;
                }
                case 30: {
                    return 13;
                }
            }
        }
        if ((n = Hdecomp.input_bit() | n << 1) == 62) {
            return 0;
        }
        return 14;
    }

    private static int input_nbits(int n) throws Exception {
        if (bits_to_go < n) {
            buffer <<= 8;
            buffer |= Hdecomp.getc();
            bits_to_go += 8;
        }
        return buffer >> (bits_to_go -= n) & (1 << n) - 1;
    }

    private static void qtree_bitins(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        byte by;
        int n6;
        int n7;
        int n8 = n - 1;
        int n9 = n2 - 1;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n8) {
            n7 = n3 + n4 * n11;
            int n12 = n7 + n4;
            n6 = 0;
            while (n6 < n9) {
                by = byArray[n10];
                int n13 = n12 + 1;
                a[n13] = a[n13] | (by & 1) << n5;
                int n14 = n12;
                a[n14] = a[n14] | (by >> 1 & 1) << n5;
                int n15 = n7 + 1;
                a[n15] = a[n15] | (by >> 2 & 1) << n5;
                int n16 = n7;
                a[n16] = a[n16] | (by >> 3 & 1) << n5;
                n7 += 2;
                n12 += 2;
                ++n10;
                n6 += 2;
            }
            if (n6 < n2) {
                by = byArray[n10];
                int n17 = n12;
                a[n17] = a[n17] | (by >> 1 & 1) << n5;
                int n18 = n7;
                a[n18] = a[n18] | (by >> 3 & 1) << n5;
                ++n10;
            }
            n11 += 2;
        }
        if (n11 < n) {
            n7 = n3 + n4 * n11;
            n6 = 0;
            while (n6 < n9) {
                by = byArray[n10];
                int n19 = n7 + 1;
                a[n19] = a[n19] | (by >> 2 & 1) << n5;
                int n20 = n7;
                a[n20] = a[n20] | (by >> 3 & 1) << n5;
                n7 += 2;
                ++n10;
                n6 += 2;
            }
            if (n6 < n2) {
                int n21 = n7;
                a[n21] = a[n21] | (byArray[n10] >> 3 & 1) << n5;
                ++n10;
            }
        }
    }

    private static void qtree_copy(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte by;
        int n4;
        int n5;
        int n6 = n - 1;
        int n7 = n2 - 1;
        int n8 = (n + 1) / 2;
        int n9 = (n2 + 1) / 2;
        int n10 = n9 * (n8 - 1) + n9 - 1;
        int n11 = n8 - 1;
        while (n11 >= 0) {
            n5 = n3 * n11 + n9 - 1 << 1;
            n4 = n9 - 1;
            while (n4 >= 0) {
                byArray2[n5] = byArray[n10--];
                n5 -= 2;
                --n4;
            }
            --n11;
        }
        n11 = 0;
        while (n11 < n6) {
            n5 = n3 * n11;
            int n12 = n5 + n3;
            n4 = 0;
            while (n4 < n7) {
                by = byArray2[n5];
                byArray2[n12 + 1] = (byte)(by & 1);
                byArray2[n12] = (byte)(by >> 1 & 1);
                byArray2[n5 + 1] = (byte)(by >> 2 & 1);
                byArray2[n5] = (byte)(by >> 3 & 1);
                n5 += 2;
                n12 += 2;
                n4 += 2;
            }
            if (n4 < n2) {
                by = byArray2[n5];
                byArray2[n12] = (byte)(by >> 1 & 1);
                byArray2[n5] = (byte)(by >> 3 & 1);
            }
            n11 += 2;
        }
        if (n11 < n) {
            n5 = n3 * n11;
            n4 = 0;
            while (n4 < n7) {
                by = byArray2[n5];
                byArray2[n5 + 1] = (byte)(by >> 2 & 1);
                byArray2[n5] = (byte)(by >> 3 & 1);
                n5 += 2;
                n4 += 2;
            }
            if (n4 < n2) {
                byArray2[n5] = (byte)(byArray2[n5] >> 3 & 1);
            }
        }
    }

    private static void qtree_decode(int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6;
        int n7 = n3 > n4 ? n3 : n4;
        if (n7 > 1 << (n6 = (int)(Math.log(n7) / log2 + 0.5))) {
            ++n6;
        }
        int n8 = (n3 + 1) / 2;
        int n9 = (n4 + 1) / 2;
        byte[] byArray = new byte[n8 * n9];
        int n10 = n5 - 1;
        while (n10 >= 0) {
            int n11 = Hdecomp.input_nbits(4);
            if (n11 == 0) {
                Hdecomp.read_bdirect(n, n2, n3, n4, byArray, n10);
            } else {
                if (n11 != 15) {
                    throw new Exception("qtree_decode: bad format code " + n11);
                }
                byArray[0] = (byte)Hdecomp.input_huffman();
                int n12 = 1;
                int n13 = 1;
                int n14 = n3;
                int n15 = n4;
                int n16 = 1 << n6;
                int n17 = 1;
                while (n17 < n6) {
                    n12 <<= 1;
                    n13 <<= 1;
                    if (n14 <= (n16 >>= 1)) {
                        --n12;
                    } else {
                        n14 -= n16;
                    }
                    if (n15 <= n16) {
                        --n13;
                    } else {
                        n15 -= n16;
                    }
                    Hdecomp.qtree_expand(byArray, n12, n13, byArray);
                    ++n17;
                }
                Hdecomp.qtree_bitins(byArray, n3, n4, n, n2, n10);
            }
            --n10;
        }
        byArray = null;
    }

    private static void qtree_expand(byte[] byArray, int n, int n2, byte[] byArray2) throws Exception {
        Hdecomp.qtree_copy(byArray, n, n2, byArray2, n2);
        int n3 = n * n2 - 1;
        while (n3 >= 0) {
            if (byArray2[n3] != 0) {
                byArray2[n3] = (byte)Hdecomp.input_huffman();
            }
            --n3;
        }
    }

    private static void read_bdirect(int n, int n2, int n3, int n4, byte[] byArray, int n5) throws Exception {
        int n6 = (n3 + 1) / 2 * ((n4 + 1) / 2);
        int n7 = 0;
        while (n7 < n6) {
            byArray[n7] = (byte)Hdecomp.input_nbits(4);
            ++n7;
        }
        Hdecomp.qtree_bitins(byArray, n3, n4, n, n2, n5);
    }

    private static void start_inputing_bits() {
        bits_to_go = 0;
    }

    private static void undigitize() {
        if (scale <= 1) {
            return;
        }
        int n = nel - 1;
        while (n >= 0) {
            int n2 = n--;
            a[n2] = a[n2] * scale;
        }
    }

    private static void unshuffle(int n, int n2, int n3, int[] nArray) {
        int n4 = n3 << 1;
        int n5 = n2 + 1 >> 1;
        int n6 = 0;
        int n7 = n + n3 * n5;
        int n8 = n5;
        while (n8 < n2) {
            nArray[n6++] = a[n7];
            n7 += n3;
            ++n8;
        }
        int n9 = n + n3 * (n5 - 1);
        n7 = n + (n3 * (n5 - 1) << 1);
        n8 = n5 - 1;
        while (n8 >= 0) {
            Hdecomp.a[n7] = a[n9];
            n9 -= n3;
            n7 -= n4;
            --n8;
        }
        n6 = 0;
        n7 = n + n3;
        n8 = 1;
        while (n8 < n2) {
            Hdecomp.a[n7] = nArray[n6++];
            n7 += n4;
            n8 += 2;
        }
    }
}

