/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;

public class Astroframe {
    private Coo point;
    protected double equinox;
    protected byte frame;
    protected byte precision;
    protected byte oprecision;
    private byte status_coo;
    private byte status_frame;
    private double[][] matrix;
    public static final byte NONE = 0;
    public static final byte DEG = 1;
    public static final byte ARCMIN = 3;
    public static final byte ARCSEC = 5;
    public static final byte MAS = 8;
    public static final byte FK4 = 1;
    public static final byte FK5 = 5;
    public static final byte GAL = 2;
    public static final byte SGAL = 3;
    public static final byte SUPERGAL = 3;
    public static final byte ECL = 4;
    public static final byte ICRS = 6;
    private static final int ED_SIGN = 1;
    private static final int ED_DECIMAL = 16;
    private static final int ED_FRAME = 128;
    private static final int ED_FULL = 2;
    private static final int ED_SEXA = 32;
    private static final int ED_RA = 64;
    private static final int ED_COLON = 4;
    private static final int[] ed_opt;
    private static final String[] explain_frame;
    private static final String[] explain_precision;
    static final double[] default_equinox;
    public static final double Byr = 365.242198781;
    public static final double Jyr = 365.25;
    public static final double JD_J2000 = 2451545.0;
    public static final double JD_B1900 = 2415020.31352;
    private static double[] gf;
    private static double[] qf;
    private static final double PMF = 2.0626480624709636E7;
    protected static double[] A;
    private static double[] A1;
    protected static double[][] EM;
    protected static double[][] EM1;
    private static double[][] EM50;
    public static final double[][] gal_1950;
    public static final double[][] supergal;
    public static final double[][] gal_2000;

    static {
        int[] nArray = new int[7];
        nArray[1] = 64;
        nArray[2] = 16;
        nArray[3] = 16;
        nArray[4] = 16;
        nArray[5] = 64;
        nArray[6] = 80;
        ed_opt = nArray;
        explain_frame = new String[]{"NONE", "FK4", "Gal", "SGal", "Ecl", "FK5", "ICRS"};
        explain_precision = new String[]{"unknown", "1degree", "0.1degree", "1arcmin", "0.1arcmin", "1arcsec", "0.1arcsec", "10mas", "1mas", "0.1mas", "10{mu}as", "1{mu}as", "0.1{mu}as"};
        default_equinox = new double[]{2000.0, 1950.0, Double.NaN, Double.NaN, 2000.0, 2000.0, Double.NaN};
        gf = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7};
        qf = new double[]{1.0, 10.0, 60.0, 600.0, 3600.0, 36000.0, 360000.0, 3600000.0};
        A = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7, 0.001245, -0.00158, -6.59E-4};
        A1 = new double[]{-1.62255E-6, -3.2302E-7, -1.4003E-7};
        EM = new double[][]{{0.9999256782, -0.0111820611, -0.0048579477, 2.42395018E-6, -2.710663E-8, -1.177656E-8}, {0.011182061, 0.9999374784, -2.71765E-5, 2.710663E-8, 2.42397878E-6, -6.587E-11}, {0.0048579479, -2.71474E-5, 0.9999881997, 1.177656E-8, -6.582E-11, 2.42410173E-6}, {-5.51E-4, -0.238565, 0.435739, 0.99994704, -0.01118251, -0.00485767}, {0.238514, -0.002667, -0.008541, 0.01118251, 0.99995883, -2.718E-5}, {-0.435623, 0.012254, 0.002117, 0.00485767, -2.714E-5, 1.00000956}};
        EM1 = new double[][]{{0.9999256795, 0.0111814828, 0.0048590039, -2.4238984E-6, -2.710544E-8, -1.177742E-8}, {-0.0111814828, 0.9999374849, -2.71771E-5, 2.710544E-8, -2.42392702E-6, 6.585E-11}, {-0.004859004, -2.71557E-5, 0.9999881946, 1.177742E-8, 6.585E-11, -2.42404995E-6}, {-5.51E-4, 0.238509, -0.435614, 0.99990432, 0.01118145, 0.00485852}, {-0.23856, -0.002667, 0.012254, -0.01118145, 0.99991613, -2.717E-5}, {0.43573, -0.008541, 0.002117, -0.00485852, -2.716E-5, 0.99996684}};
        EM50 = new double[][]{{0.9999256795356672, -0.011181482799697, -0.0048590039655699}, {0.0111814828233251, 0.9999374848650175, -2.71557959449E-5}, {0.0048590038843768, -2.71771046587E-5, 0.9999881945682256}};
        gal_1950 = new double[][]{{-0.0669887394151508, -0.8727557658519927, -0.4835389146321842}, {0.4927284660753235, -0.4503469580199614, 0.7445846332830311}, {-0.8676008111514348, -0.1883746017229204, 0.4601997847838516}};
        double[][] dArrayArray = new double[3][];
        double[] dArray = new double[3];
        dArray[0] = -0.7357425748043749;
        dArray[1] = 0.6772612964138942;
        dArrayArray[0] = dArray;
        dArrayArray[1] = new double[]{-0.0745537783652337, -0.0809914713069767, 0.9939225903997749};
        dArrayArray[2] = new double[]{0.6731453021092076, 0.7312711658169645, 0.1100812622247821};
        supergal = dArrayArray;
        gal_2000 = new double[][]{{-0.054875539726, -0.87343710801, -0.483834985808}, {0.494109453312, -0.444829589425, 0.74698225181}, {-0.867666135858, -0.198076386122, 0.455983795705}};
    }

    public Astroframe() {
        this(5, 6, 2000.0);
    }

    public Astroframe(int n) {
        this(n, 6, default_equinox[n]);
    }

    public Astroframe(int n, double d) {
        this(n, 6, d);
    }

    public Astroframe(int n, double d, double d2, int n2, double d3) {
        this.equinox = Double.isNaN(d3) ? default_equinox[n] : d3;
        this.point = new Coo(d, d2);
        this.status_coo = (byte)3;
        this.equinox = d3;
        this.frame = (byte)n;
        this.precision = this.oprecision = (byte)n2;
    }

    public Astroframe(int n, int n2) {
        this(n, n2, default_equinox[n]);
    }

    public Astroframe(int n, int n2, double d) {
        this(n, 0.0, 90.0, n2, d);
        this.status_coo = 0;
    }

    public static final double B2J(double d) {
        return Astroframe.JD2J(Astroframe.B2JD(d));
    }

    public static final double B2JD(double d) {
        return 2415020.31352 + (d - 1900.0) * 365.242198781;
    }

    private static double[][] EulerMatrix(double d, double d2, double d3) {
        double[][] dArray = new double[3][3];
        dArray[0][2] = Coo.cosd(d);
        dArray[1][2] = Coo.sind(d);
        dArray[2][2] = Coo.cosd(d2);
        double d4 = Coo.sind(d2);
        dArray[2][0] = Coo.cosd(d3);
        dArray[2][1] = Coo.sind(d3);
        dArray[0][0] = dArray[2][0] * dArray[2][2] * dArray[0][2] - dArray[2][1] * dArray[1][2];
        dArray[1][0] = dArray[2][0] * dArray[2][2] * dArray[1][2] + dArray[2][1] * dArray[0][2];
        dArray[0][1] = -dArray[2][1] * dArray[2][2] * dArray[0][2] - dArray[2][0] * dArray[1][2];
        dArray[1][1] = -dArray[2][1] * dArray[2][2] * dArray[1][2] + dArray[2][0] * dArray[0][2];
        dArray[2][0] = dArray[2][0] * d4;
        dArray[2][1] = -dArray[2][1] * d4;
        dArray[0][2] = -d4 * dArray[0][2];
        dArray[1][2] = -d4 * dArray[1][2];
        return dArray;
    }

    public static final double J2B(double d) {
        return Astroframe.JD2B(Astroframe.J2JD(d));
    }

    public static final double J2JD(double d) {
        return 2451545.0 + (d - 2000.0) * 365.25;
    }

    public static final double JD2B(double d) {
        return 1900.0 + (d - 2415020.31352) / 365.242198781;
    }

    public static final double JD2J(double d) {
        return 2000.0 + (d - 2451545.0) / 365.25;
    }

    public void convert(Astroframe astroframe) {
        int n;
        if (this.equals(astroframe)) {
            return;
        }
        astroframe.precision = this.precision;
        if (this.frame == astroframe.frame) {
            if (Double.isNaN(default_equinox[this.frame])) {
                return;
            }
            if (this.equinox == astroframe.equinox) {
                this.fill_coo();
                astroframe.set(this.point.lon, this.point.lat);
                return;
            }
        }
        if (this.status_frame == 0) {
            n = astroframe.frame > 3 ? 2 : 1;
            this.fill_frame(n);
        }
        if (astroframe.status_frame == 0) {
            astroframe.fill_frame(this.status_frame);
        }
        if ((this.status_coo & 2) == 0) {
            this.fill_coo();
        }
        double[] dArray = new double[3];
        if (this.matrix == null) {
            dArray[0] = this.point.x;
            dArray[1] = this.point.y;
            dArray[2] = this.point.z;
        } else {
            n = 0;
            while (n < 3) {
                dArray[n] = this.matrix[0][n] * this.point.x + this.matrix[1][n] * this.point.y + this.matrix[2][n] * this.point.z;
                ++n;
            }
        }
        if (this.status_frame != astroframe.status_frame) {
            dArray = this.status_frame == 1 ? this.fk4to5z(dArray) : this.fk5to4z(dArray);
        }
        if (astroframe.matrix == null) {
            astroframe.point.x = dArray[0];
            astroframe.point.y = dArray[1];
            astroframe.point.z = dArray[2];
        } else {
            astroframe.point.x = astroframe.matrix[0][0] * dArray[0] + astroframe.matrix[0][1] * dArray[1] + astroframe.matrix[0][2] * dArray[2];
            astroframe.point.y = astroframe.matrix[1][0] * dArray[0] + astroframe.matrix[1][1] * dArray[1] + astroframe.matrix[1][2] * dArray[2];
            astroframe.point.z = astroframe.matrix[2][0] * dArray[0] + astroframe.matrix[2][1] * dArray[1] + astroframe.matrix[2][2] * dArray[2];
        }
        dArray[0] = astroframe.point.x;
        dArray[1] = astroframe.point.y;
        dArray[2] = astroframe.point.z;
        astroframe.status_coo = (byte)2;
    }

    private static int ed1(StringBuffer stringBuffer, double d, int n, int n2) {
        char c;
        int n3 = n - 1;
        int n4 = stringBuffer.length();
        double d2 = d;
        if ((n2 & 2) == 0) {
            d2 = Astroframe.rounded(d, n, (n2 & 0x20) != 0 ? qf : gf);
        } else {
            n3 = 10;
        }
        if ((n2 & 0x20) == 0 || n < 3) {
            return Coo.ed1(stringBuffer, d2, n3 + 4, n3, (n2 & 1) != 0);
        }
        char c2 = c = (n2 & 4) != 0 ? (char)':' : ' ';
        if ((n2 & 0x40) != 0) {
            ++n;
            d2 = d / 15.0;
            if ((n2 & 2) == 0) {
                d2 = Astroframe.rounded(d2, n, qf);
            }
        }
        if ((n2 & 1) != 0 && d2 >= 0.0) {
            stringBuffer.append('+');
        }
        if (d2 < 0.0) {
            stringBuffer.append('-');
            d2 = -d2;
        }
        int n5 = (int)d2;
        d2 -= (double)n5;
        int n6 = 1000;
        if ((n2 & 0x41) != 0) {
            n6 = 100;
        }
        if (n5 >= n6) {
            stringBuffer.append(n5 / n6);
            n5 %= n6;
        }
        while (n6 > 1) {
            stringBuffer.append((char)(48 + n5 / (n6 /= 10)));
            n5 %= n6;
        }
        n5 = (int)(d2 *= 60.0);
        d2 -= (double)n5;
        stringBuffer.append(c);
        stringBuffer.append((char)(48 + n5 / 10));
        stringBuffer.append((char)(48 + n5 % 10));
        if (n == 4) {
            n5 = (int)(d2 *= 10.0);
            stringBuffer.append('.');
            stringBuffer.append((char)(48 + n5));
        }
        if (n >= 5) {
            stringBuffer.append(c);
            n6 = n - 5;
            Coo.ed1(stringBuffer, d2 *= 60.0, n6 == 0 ? 2 : n6 + 3, n6, false);
        }
        return stringBuffer.length() - n4;
    }

    /*
     * Unable to fully structure code
     */
    private final int ed2(StringBuffer var1_1, int var2_2, int var3_3) {
        block19: {
            block20: {
                block17: {
                    block18: {
                        var4_4 = this.precision;
                        var5_5 = var3_3;
                        var9_6 = var1_1.length();
                        if ((this.status_coo & 1) == 0) {
                            this.fill_coo();
                        }
                        if (var2_2 > 0) {
                            if (var2_2 < 8) {
                                var2_2 = 8;
                            }
                            var7_7 = var2_2 / 2;
                            var6_8 = var2_2 - var7_7;
                        } else {
                            var7_7 = 0;
                            var6_8 = 0;
                        }
                        if ((var5_5 & 48) == 0) {
                            var5_5 |= Astroframe.ed_opt[this.frame] & 80;
                        }
                        if ((var5_5 & 16) == 0) break block17;
                        var5_5 &= -97;
                        if (var2_2 > 0 && var4_4 > var7_7 - 3) {
                            var4_4 = var7_7 - 3;
                        }
                        var8_9 = Astroframe.ed1(var1_1, this.point.lon, var4_4, var5_5);
                        if (var6_8 != 0) ** GOTO lbl28
                        var1_1.append(' ');
                        break block18;
lbl-1000:
                        // 1 sources

                        {
                            var1_1.append(' ');
                            ++var8_9;
lbl28:
                            // 2 sources

                            ** while (var8_9 < var6_8)
                        }
                    }
                    var8_9 = Astroframe.ed1(var1_1, this.point.lat, var4_4, var5_5 | 1);
                    break block19;
                }
                var5_5 |= 32 | Astroframe.ed_opt[this.frame] & 64;
                if (var7_7 > 0) {
                    var8_9 = var4_4 + 3;
                    if (var4_4 > 3) {
                        ++var8_9;
                    }
                    if (var4_4 > 5) {
                        ++var8_9;
                    }
                    while (var8_9 > var7_7) {
                        var8_9 = --var4_4 + 3;
                        if (var4_4 > 3) {
                            ++var8_9;
                        }
                        if (var4_4 <= 5) continue;
                        ++var8_9;
                    }
                }
                var8_9 = Astroframe.ed1(var1_1, this.point.lon, var4_4, var5_5);
                var5_5 &= -65;
                if (var6_8 != 0) ** GOTO lbl56
                var1_1.append(' ');
                break block20;
lbl-1000:
                // 1 sources

                {
                    var1_1.append(' ');
                    ++var8_9;
lbl56:
                    // 2 sources

                    ** while (var8_9 < var6_8)
                }
            }
            var8_9 = Astroframe.ed1(var1_1, this.point.lat, var4_4, var5_5 | 1);
        }
        while (var8_9 < var7_7) {
            var1_1.append(' ');
            ++var8_9;
        }
        if ((var5_5 & 130) != 0) {
            var1_1.append(" (");
            if ((var5_5 & 128) != 0) {
                var1_1.append(this.getFrame());
            }
            if ((var5_5 & 2) != 0) {
                var1_1.append((var5_5 & 128) == 0 ? " (" : " - ");
                var1_1.append(Astroframe.explain_precision[var4_4]);
                var1_1.append(" precision");
            }
            var1_1.append(')');
        }
        return var1_1.length() - var9_6;
    }

    public final int ed2(StringBuffer stringBuffer, String string) throws Exception {
        return this.ed2(stringBuffer, 0, Astroframe.getOptions(string));
    }

    public final int ed2(StringBuffer stringBuffer, String string, int n) throws Exception {
        return this.ed2(stringBuffer, n, Astroframe.getOptions(string));
    }

    private void fill_coo() {
        if (this.status_coo == 0) {
            System.err.println("++++Astroframe[" + this.getFrame() + "]: non-set position, North Pole assumed");
            this.point.x = 0.0;
            this.point.y = 0.0;
            this.point.z = 1.0;
            this.status_coo = (byte)2;
        }
        if ((this.status_coo & 2) == 0) {
            this.point.set(this.point.lon, this.point.lat);
            this.status_coo = (byte)(this.status_coo | 2);
        }
        if ((this.status_coo & 1) == 0) {
            this.point.set(this.point.x, this.point.y, this.point.z);
            this.status_coo = (byte)(this.status_coo | 1);
        }
    }

    private void fill_frame(int n) {
        switch (this.frame) {
            case 1: {
                this.status_frame = 1;
                if (this.equinox == 1950.0) {
                    if (this.matrix != null) {
                        this.matrix = null;
                    }
                    return;
                }
                double d = 0.05;
                double d2 = (this.equinox - 1950.0) / 1000.0;
                double d3 = d2 * (23042.53 + d * (139.73 + 0.06 * d) + d2 * (30.23 + 18.0 * d2 - 0.27 * d)) / 3600.0;
                double d4 = d3 + d2 * d2 * (79.27 + 0.66 * d + 0.32 * d2) / 3600.0;
                double d5 = d2 * (20046.85 - d * (85.33 + 0.37 * d) - d2 * (42.67 + 0.37 * d + 41.8 * d2)) / 3600.0;
                this.matrix = Astroframe.EulerMatrix(d4, d5, d3);
                break;
            }
            case 6: {
                this.equinox = 2000.0;
            }
            case 5: {
                this.status_frame = (byte)2;
                if (this.equinox == 2000.0) {
                    if (this.matrix != null) {
                        this.matrix = null;
                    }
                    return;
                }
                double d = 0.0;
                double d6 = (this.equinox - 2000.0) / 100.0;
                double d7 = 2306.2181 + (1.39656 - 1.39E-4 * d) * d;
                double d8 = (d7 + (0.30188 - 3.44E-4 * d + 0.017998 * d6) * d6) * d6 / 3600.0;
                double d9 = (d7 + (1.09468 + 6.6E-5 * d + 0.018203 * d6) * d6) * d6 / 3600.0;
                double d10 = (2004.3109 + (-0.8533 - 2.17E-4 * d) * d + (-0.42665 - 2.17E-4 * d - 0.041833 * d6) * d6) * d6 / 3600.0;
                this.matrix = Astroframe.EulerMatrix(d9, d10, d8);
                break;
            }
            case 2: {
                if (this.matrix == null) {
                    this.matrix = new double[3][3];
                }
                if (n == 1) {
                    System.arraycopy(gal_1950, 0, this.matrix, 0, gal_1950.length);
                    this.status_frame = 1;
                    break;
                }
                System.arraycopy(gal_2000, 0, this.matrix, 0, gal_2000.length);
                this.status_frame = (byte)2;
                break;
            }
            case 3: {
                if (n == 1) {
                    this.status_frame = 1;
                    this.matrix = Coo.prod(supergal, gal_1950);
                    break;
                }
                this.status_frame = (byte)2;
                this.matrix = Coo.prod(supergal, gal_2000);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Astroframe: frame not (yet) accepted: " + this.getFrame());
            }
        }
    }

    private double[] fk4to5z(double[] dArray) {
        double[] dArray2 = new double[3];
        double d = 50.0;
        d = dArray[0] * A[0] + dArray[1] * A[1] + dArray[2] * A[2];
        double d2 = dArray[0] - A[0] + d * dArray[0];
        double d3 = dArray[1] - A[1] + d * dArray[1];
        double d4 = dArray[2] - A[2] + d * dArray[2];
        dArray2[0] = EM50[0][0] * d2 + EM50[0][1] * d3 + EM50[0][2] * d4;
        dArray2[1] = EM50[1][0] * d2 + EM50[1][1] * d3 + EM50[1][2] * d4;
        dArray2[2] = EM50[2][0] * d2 + EM50[2][1] * d3 + EM50[2][2] * d4;
        return dArray2;
    }

    private double[] fk5to4z(double[] dArray) {
        double[] dArray2 = new double[3];
        double d = EM1[0][0] * dArray[0] + EM1[0][1] * dArray[1] + EM1[0][2] * dArray[2];
        double d2 = EM1[1][0] * dArray[0] + EM1[1][1] * dArray[1] + EM1[1][2] * dArray[2];
        double d3 = EM1[2][0] * dArray[0] + EM1[2][1] * dArray[1] + EM1[2][2] * dArray[2];
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = (d /= d4) * A[0] + (d2 /= d4) * A[1] + (d3 /= d4) * A[2];
        double d6 = 1.0 - d5;
        dArray2[0] = d * d6 + A[0];
        dArray2[1] = d2 * d6 + A[1];
        dArray2[2] = d3 * d6 + A[2];
        return dArray2;
    }

    public double[] getAngles() {
        double[] dArray = new double[2];
        if ((this.status_coo & 1) == 0) {
            this.fill_coo();
        }
        dArray[0] = this.point.lon;
        dArray[1] = this.point.lat;
        return dArray;
    }

    public final String getFrame() {
        switch (this.frame) {
            case 1: {
                return "B" + this.equinox;
            }
            case 5: {
                return "J" + this.equinox;
            }
            case 6: {
                return "ICRS";
            }
            case 4: {
                return "Ecl" + this.equinox;
            }
        }
        return explain_frame[this.frame];
    }

    public double getLat() {
        if ((this.status_coo & 1) == 0) {
            this.fill_coo();
        }
        return this.point.lat;
    }

    public double getLon() {
        if ((this.status_coo & 1) == 0) {
            this.fill_coo();
        }
        return this.point.lon;
    }

    private static int getOptions(String string) throws Exception {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            switch (cArray[n2]) {
                case 's': {
                    n |= 0x20;
                    break;
                }
                case ':': {
                    n |= 4;
                    break;
                }
                case 'd': {
                    n |= 0x10;
                    break;
                }
                case 'f': {
                    n |= 0x80;
                    break;
                }
                case 'F': {
                    n |= 0x82;
                    break;
                }
                default: {
                    throw new Exception("++++Astroframe, invalid edition option '" + cArray[n2] + "' in \"" + string + "\"");
                }
                case ' ': 
            }
            ++n2;
        }
        return n;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public double[] getUvector() {
        double[] dArray = new double[3];
        if ((this.status_coo & 2) == 0) {
            this.fill_coo();
        }
        dArray[0] = this.point.x;
        dArray[1] = this.point.y;
        dArray[2] = this.point.z;
        return dArray;
    }

    private static double rounded(double d, int n, double[] dArray) {
        double d2;
        int n2 = n - 1;
        double d3 = d;
        if (n2 < dArray.length) {
            d2 = dArray[n2];
        } else {
            int n3 = n2 - dArray.length;
            d2 = dArray[dArray.length - 1];
            while (n3 >= 0) {
                d2 *= 10.0;
                --n3;
            }
        }
        if (d < 0.0) {
            d2 = -d2;
        }
        if ((d3 = d + 0.5 / d2) < -180.0) {
            d3 += 360.0;
        }
        if (d3 >= 360.0) {
            d3 -= 360.0;
        }
        return d3;
    }

    public void set(double d, double d2) {
        this.point.lon = d;
        this.point.lat = d2;
        this.status_coo = 1;
    }

    public void set(double d, double d2, double d3) {
        this.point.x = d;
        this.point.y = d2;
        this.point.z = d3;
        this.status_coo = (byte)2;
    }

    public void set(String string) throws Exception {
        this.point.set(string, (ed_opt[this.frame] & 0x40) != 0);
        this.status_coo = (byte)3;
        this.precision = (byte)(1 + (this.point.dlon > this.point.dlat ? this.point.dlon : this.point.dlat));
    }

    public void setPrecision(int n) {
        this.precision = (byte)n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.ed2(stringBuffer, 0, 128);
        return String.valueOf(String.valueOf(stringBuffer));
    }

    public String toString(String string) throws Exception {
        return this.toString(string, 0);
    }

    public String toString(String string, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.ed2(stringBuffer, n, Astroframe.getOptions(string));
        return String.valueOf(String.valueOf(stringBuffer));
    }
}

