/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Plan;
import cds.aladin.ZoomView;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Panel;

public final class Zoom
extends Panel {
    static int[] mzn = new int[]{1, 1, 1, 1, 1, 1, 2};
    static int[] mzd = new int[]{64, 32, 16, 8, 4, 2, 3};
    static final int MINZOOM = mzn.length;
    static final int MAXZOOM = 7;
    ZoomView zoomView;
    Choice cZoom;
    Calque calque;
    Aladin aladin;

    protected Zoom(Calque calque, Aladin aladin) {
        this.aladin = aladin;
        this.calque = calque;
        this.zoomView = new ZoomView(aladin, calque);
        this.cZoom = new Choice();
        int n = 0;
        while (n < MINZOOM) {
            this.cZoom.addItem("Zoom " + mzn[n] + "/" + mzd[n] + "x");
            ++n;
        }
        n = 0;
        while (n < 7) {
            this.cZoom.addItem("Zoom " + (1 << n) + "x");
            ++n;
        }
        this.cZoom.select(MINZOOM);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.cZoom);
        this.setLayout(new BorderLayout(0, 0));
        Aladin.makeAdd(this, panel, "North");
        Aladin.makeAdd(this, this.zoomView, "South");
        this.resize(this.preferredSize());
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Choice) {
            this.zoomView.NewZoom();
            this.calque.view.repaint();
            return true;
        }
        return false;
    }

    protected boolean changeValue(int n, int n2, int n3) {
        int n4 = this.cZoom.getSelectedIndex();
        if (n4 + n < 0 || n4 + n >= MINZOOM + 7) {
            return false;
        }
        this.cZoom.select(n4 + n);
        this.zoomView.NewZoom(n2, n3, true);
        return true;
    }

    protected int getIndex() {
        return this.cZoom.getSelectedIndex();
    }

    protected int getIndex(String string) {
        int n = this.cZoom.countItems() - 1;
        while (n >= 0) {
            String string2 = this.cZoom.getItem(n).substring(5);
            if (string2.equals(string)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    protected void getMemo(Plan plan) {
        if (plan.zoom == -1) {
            this.zoomView.y = this.zoomView.x = this.zoomView.SIZE / 2;
            this.cZoom.select(MINZOOM);
        } else {
            this.zoomView.x = plan.xzoom;
            this.zoomView.y = plan.yzoom;
            this.cZoom.select(plan.zoom);
        }
        this.zoomView.repaint();
    }

    protected int getNbPixelDst() {
        int n = this.cZoom.getSelectedIndex();
        return n >= MINZOOM ? 1 << n - MINZOOM : mzn[n];
    }

    protected int getNbPixelSrc() {
        int n = this.cZoom.getSelectedIndex();
        return n >= MINZOOM ? 1 : mzd[n];
    }

    protected double getValue() {
        int n = this.cZoom.getSelectedIndex();
        if (n >= MINZOOM) {
            return 1 << n - MINZOOM;
        }
        return (double)mzn[n] / (double)mzd[n];
    }

    protected void setMemo(Plan plan) {
        plan.xzoom = this.zoomView.x;
        plan.yzoom = this.zoomView.y;
        plan.zoom = this.cZoom.getSelectedIndex();
    }

    protected boolean setZoom(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            return false;
        }
        this.cZoom.select(n);
        this.zoomView.NewZoom();
        this.calque.view.repaint();
        return true;
    }

    protected void wen(int n, int n2) {
        if (this.aladin.toolbox.tool[6].mode != -1) {
            return;
        }
        this.zoomView.wen(n, n2);
    }

    protected void wenOff() {
        if (this.aladin.toolbox.tool[6].mode != 1) {
            this.zoomView.wenOff();
        }
    }

    protected void wenOn() {
        if (this.aladin.toolbox.tool[6].mode == -1) {
            this.zoomView.wenOn();
        }
    }
}

