/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Glu;
import cds.aladin.MyLabel;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.tools.CDSConstants;
import cds.vizier.VizieRCatalogs;
import cds.vizier.VizieRList;
import cds.vizier.VizieRPanel;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;

public final class VizieRServer
extends Server
implements CDSConstants {
    static final String NOM = "VizieR\nCatalogs";
    static final String INFO = "CDS VizieR catalog service (>3000 astronomical catalogs)";
    static final String CATDESC = "Get info.";
    static final String TAGGLU = "VizieRXML.rm";
    VizieRList vizierlist;
    TextField catalog;
    TextField radius;
    MyLabel legende;
    Button getReadMe;
    boolean hasPreviousFocus = false;
    Vector vSurveys;
    Vector vArchives;
    ServerDialog serverDialog;
    VizieRPanel vp = null;
    Vector catalogs = new Vector();
    VizieRCatalogs vcl = null;
    Panel panelButtonRight = new Panel();
    Panel actions;

    protected VizieRServer(final Aladin aladin, Label label, ServerDialog serverDialog, Panel panel) {
        this.aladin = aladin;
        this.status = label;
        this.type = 1;
        this.nom = NOM;
        this.info = INFO;
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 0;
        this.actions = panel;
        this.serverDialog = serverDialog;
        this.panelButtonRight.setBackground(CDSConstants.BKGD);
        this.panelButtonRight.setFont(CDSConstants.BOLD);
        Button button = new Button("SUBMIT");
        button.setFont(CDSConstants.LBOLD);
        this.panelButtonRight.add(button);
        Label label2 = new Label("VizieR catalog service");
        label2.setFont(Aladin.LLITALIC);
        label2.setBounds(151, n, 300, 20);
        this.add(label2);
        Label label3 = new Label("Specify a target, and a catalog name or identification...");
        label3.setBounds(86, n += 25, 400, 20);
        this.add(label3);
        Panel panel2 = this.targetPanel(27, null, true, 5);
        panel2.setBounds(10, n += 20, 450, 30);
        n += 30;
        this.add(panel2);
        Label label4 = new Label("Catalog");
        label4.setFont(Aladin.LBOLD);
        int n2 = 55;
        label4.setBounds(10, n, n2, 30);
        this.add(label4);
        this.catalog = new TextField(26);
        this.catalog.setBounds(n2 + 15, n, 150, 30);
        this.add(this.catalog);
        Label label5 = new Label("Radius");
        label5.setFont(Aladin.LBOLD);
        label5.setBounds(289, n, n2, 30);
        this.add(label5);
        this.radius = new TextField("10 arcmin");
        this.radius.setBounds(347, n, 100, 30);
        n += 35;
        this.add(this.radius);
        this.setModeRad(1, this.radius);
        this.getReadMe = new Button(CATDESC);
        this.getReadMe.setFont(Aladin.BOLD);
        this.getReadMe.enable(true);
        this.getReadMe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = catalog.getText().trim();
                if (!string.equals("")) {
                    string = Glu.quote(string);
                    aladin.glu.showDocument("getReadMe", string);
                }
            }
        });
        this.vp = new VizieRPanel(aladin.glu, 1, false, null, null, 10);
        this.vp.setBounds(40, n, 400, 280);
        this.add(this.vp);
        String[] stringArray = this.vp.getSelection("SURVEY");
        this.vSurveys = new Vector();
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.vSurveys.addElement(stringArray[n3]);
            ++n3;
        }
        String[] stringArray2 = this.vp.getSelection("MISSION");
        this.vArchives = new Vector();
        int n4 = 0;
        while (n4 < stringArray2.length) {
            this.vArchives.addElement(stringArray2[n4]);
            ++n4;
        }
    }

    public boolean action(Event event, Object object) {
        if (CATDESC.equals(object)) {
            String string = this.catalog.getText().trim();
            if (string.equals("")) {
                this.aladin.message.warning("You must specify a catalog name (or number)");
                return true;
            }
            string = Glu.quote(string);
            this.waitCursor();
            this.aladin.glu.showDocument("getReadMe", string);
            this.defaultCursor();
            return true;
        }
        return false;
    }

    protected int creatPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = string3;
        if (string4 == null) {
            string4 = string6;
        }
        return this.creatVizieRPlane(string, string2, string6, string4, null);
    }

    protected int creatVizieRPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = String.valueOf(Glu.quote(string3)) + " " + Glu.quote(string) + " " + Glu.quote(string2);
        URL uRL = this.aladin.glu.getURL(TAGGLU, string6);
        if (uRL == null) {
            this.aladin.message.warning("Unknown server error", 1);
            return -1;
        }
        if (!this.verif(2, string, String.valueOf(string4) + " " + string2)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string4, string, String.valueOf(string4) + " " + string2);
    }

    protected void hideSFrame() {
    }

    protected void reaffiche() {
        this.hide();
        this.show();
    }

    protected void reset() {
        super.reset();
        this.rad[0].setText("10 arcmin");
        this.catalog.setText("");
        this.vp.resetAll();
    }

    public void submit() {
        Frame frame = this.getFrame(this);
        if (this.catalog.getText().compareTo("") == 0) {
            this.vp.submit(this.target.getText(), this.radius.getText());
            List list = this.vp.getResultList();
            this.catalogs.removeAllElements();
            int n = 0;
            while (n < list.getItemCount()) {
                this.catalogs.addElement(list.getItem(n));
                ++n;
            }
            if (this.vcl == null) {
                Button button = new Button("SUBMIT");
                button.setFont(CDSConstants.LBOLD);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VizieRServer.this.submit();
                        VizieRServer.this.vcl.resetCatList();
                        VizieRServer.this.catalog.setText("");
                    }
                });
                this.vcl = new VizieRCatalogs(this.catalog, this.getReadMe, this.catalogs, button);
            } else {
                this.vcl.show(this.catalogs);
            }
            if (this.target.getText().compareTo("") == 0) {
                this.vcl.setTitle(String.valueOf(this.catalogs.size()) + " catalog(s) found " + this.target.getText());
            } else {
                this.vcl.setTitle(String.valueOf(this.catalogs.size()) + " catalog(s) found around " + this.target.getText());
            }
            this.aladin.treeView.addBranch(this.target.getText(), this.radius.getText(), this);
            return;
        }
        String string = this.getTarget();
        if (string == null) {
            return;
        }
        String string2 = this.getRadius();
        if (string2.equals("")) {
            this.aladin.message.warning("You must specify the radius of your query");
            return;
        }
        String string3 = this.catalog.getText().trim();
        if (string3.equals("")) {
            this.aladin.message.warning("You must specify a catalog name (or number)");
            return;
        }
        String string4 = new String(string);
        this.waitCursor();
        this.creatPlane(string, string2, string3, null, null);
        this.catalog.setText("");
        this.defaultCursor();
    }
}

