/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.FluxConverter;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.xml.Field;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Vector;

public final class VOTableEISGenerator {
    static final String CR = System.getProperty("line.separator");
    static final String PREAMBLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + CR + "<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">";
    private int indentLevel = 0;
    private int shiftWidth = 4;
    private StringBuffer vot;
    private Source[] sources;
    int indexFreq;
    int indexFlux;
    int indexFluxErr;
    int indexBW;
    private static final Hashtable FREQUENCY = new Hashtable();
    private static final Hashtable FERROR = new Hashtable();
    private static final Hashtable ZP = new Hashtable();
    private static final Hashtable ZPERROR = new Hashtable();
    private static final Vector MAGCOL = new Vector();
    private static final Vector SEXUCD = new Vector();
    private static final Vector EISCCUCD = new Vector();
    private static final Vector EISSINGLEUCD = new Vector();
    private static final Field[] FIELDS = new Field[4];
    private static final String EIS_CC = "II/234";
    private static final String MAG = "mag";

    static {
        String[] stringArray = new String[]{"U", "B", "V", "R", "I", "J", "H", "K"};
        double[] dArray = new double[]{8.4735008E14, 6.5801681E14, 5.6119891E14, 4.6827938E14, 3.5125068E14, 2.4573152E14, 1.8392175E14, 1.3689153E14};
        double[] dArray2 = new double[]{6.7059927E13, 6.5353952E13, 4.7274337E13, 5.8333771E13, 2.8540404E13, 2.1451153E13, 1.7320239E13, 1.2188972E13};
        double[] dArray3 = new double[]{8.1321326, 9.0221171, 8.9015597, 8.7157219, 8.4577423, 8.0028097, 7.5215004, 7.0154499};
        double[] dArray4 = new double[8];
        EISCCUCD.addElement("PHOT_JHN_U");
        EISCCUCD.addElement("PHOT_JHN_B");
        EISCCUCD.addElement("PHOT_JHN_V");
        EISCCUCD.addElement("PHOT_COUS_R");
        EISCCUCD.addElement("PHOT_COUS_I");
        EISCCUCD.addElement("PHOT_JHN_J");
        EISCCUCD.addElement("PHOT_JHN_K");
        EISSINGLEUCD.addElement("PHOT_INT-MAG_U");
        EISSINGLEUCD.addElement("PHOT_INT-MAG_B");
        EISSINGLEUCD.addElement("PHOT_INT-MAG_V");
        EISSINGLEUCD.addElement("PHOT_INT-MAG_R");
        EISSINGLEUCD.addElement("PHOT_INT-MAG_I");
        int n = 0;
        while (n < stringArray.length) {
            MAGCOL.addElement(String.valueOf(stringArray[n]) + MAG);
            SEXUCD.addElement("PHOT_MAG_" + stringArray[n]);
            FREQUENCY.put("_" + stringArray[n], new Double(dArray[n]));
            FERROR.put("_" + stringArray[n], new Double(2.0 * dArray2[n]));
            ZP.put("_" + stringArray[n], new Double(dArray3[n]));
            ZPERROR.put("_" + stringArray[n], new Double(dArray4[n]));
            ++n;
        }
        VOTableEISGenerator.FIELDS[0] = new Field("frequency");
        VOTableEISGenerator.FIELDS[1] = new Field("delta frequency");
        VOTableEISGenerator.FIELDS[2] = new Field("flux");
        VOTableEISGenerator.FIELDS[3] = new Field("error on flux");
        VOTableEISGenerator.FIELDS[0].unit = "Hz";
        VOTableEISGenerator.FIELDS[1].unit = "Hz";
        VOTableEISGenerator.FIELDS[2].unit = "Jy";
        VOTableEISGenerator.FIELDS[3].unit = "Jy";
        VOTableEISGenerator.FIELDS[0].datatype = "float";
        VOTableEISGenerator.FIELDS[1].datatype = "float";
        VOTableEISGenerator.FIELDS[2].datatype = "float";
        VOTableEISGenerator.FIELDS[3].datatype = "float";
        VOTableEISGenerator.FIELDS[0].precision = "E5";
        VOTableEISGenerator.FIELDS[1].precision = "E5";
        VOTableEISGenerator.FIELDS[2].precision = "E5";
        VOTableEISGenerator.FIELDS[3].precision = "E5";
        VOTableEISGenerator.FIELDS[0].ucd = "OBS_FREQUENCY";
        VOTableEISGenerator.FIELDS[1].ucd = "INST_FILTER_FWHM";
        VOTableEISGenerator.FIELDS[2].ucd = "PHOT_FLUX_DENSITY";
        VOTableEISGenerator.FIELDS[3].ucd = "ERROR";
    }

    VOTableEISGenerator() {
        this(null);
    }

    VOTableEISGenerator(Source[] sourceArray) {
        this.sources = sourceArray;
        this.indexBW = -1;
        this.indexFluxErr = -1;
        this.indexFlux = -1;
        this.indexFreq = -1;
    }

    private String AB2Vega(String string, String string2) {
        double d;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
        String string3 = string2.substring(string2.length() - 1);
        if (string3.equals("U")) {
            return new Double(d - 0.8).toString();
        }
        if (string3.equals("B")) {
            return new Double(d + 0.11).toString();
        }
        if (string3.equals("V")) {
            return new Double(d).toString();
        }
        if (string3.equals("R")) {
            return new Double(d - 0.19).toString();
        }
        if (string3.equals("I")) {
            return new Double(d - 0.5).toString();
        }
        return "";
    }

    private void addAttribut(String string, String string2, boolean bl) {
        if (string != null) {
            if (bl) {
                string = UCDFilter.replace(string, "\"", "&quot;");
            }
            this.vot.append(" ").append((Object)new StringBuffer(string2)).append("=\"").append(string).append("\"").toString();
        }
    }

    private boolean case1(Source source) {
        this.indexFlux = source.findUCD("PHOT_FLUX_DENSITY");
        return this.indexFlux >= 0 && (this.indexFluxErr = source.findUCD("ERROR")) >= 0 && (this.indexFreq = source.findUCD("OBS_FREQUENCY")) >= 0 && (this.indexBW = source.findUCD("INST_FILTER_FWHM")) >= 0;
    }

    private boolean case2(Source source) {
        if (source.findUCD("ERROR") < 0) {
            return false;
        }
        Field[] fieldArray = source.leg.field;
        int n = 0;
        while (n < fieldArray.length) {
            if (EISCCUCD.contains(fieldArray[n].ucd)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean case3(Source source) {
        if (source.findUCD("ERROR") < 0) {
            return false;
        }
        Field[] fieldArray = source.leg.field;
        int n = 0;
        while (n < fieldArray.length) {
            if (SEXUCD.contains(fieldArray[n].ucd)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean case4(Source source) {
        int n = source.findColumn("e_Mtot");
        if (n <= 0 || source.findUCD("ERROR") < 0 || source.findColumn("Mtot") < 0) {
            return false;
        }
        Field[] fieldArray = source.leg.field;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (EISSINGLEUCD.contains(fieldArray[n2].ucd)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void doIndent() {
        int n = 0;
        while (n < this.indentLevel * this.shiftWidth) {
            this.vot.append(" ");
            ++n;
        }
    }

    private String getDataType(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        switch (string.charAt(0)) {
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'I': {
                return "int";
            }
            case 'L': {
                return "boolean";
            }
            case 'A': {
                return "char";
            }
        }
        return string;
    }

    private String getDeltaFreq(String string) {
        try {
            return ((Double)FERROR.get(string.substring(string.length() - 2))).toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private String getFieldValue(Source source, Field field) {
        int n = source.findColumn(field.name);
        if (n < 0) {
            return "";
        }
        return source.getValue(n);
    }

    private String getFlux(String string, String string2) {
        double d;
        if (string2 == null) {
            return null;
        }
        Double d2 = (Double)ZP.get(string.substring(string.length() - 2));
        try {
            d = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Float(FluxConverter.getFlux(d2, d)).toString();
    }

    private String getFluxError(String string, String string2, String string3, Source source) {
        if (string3 == null) {
            return null;
        }
        Double d = (Double)ZPERROR.get(string.substring(string.length() - 2));
        int n = source.findColumn("e_" + string2);
        if (n < 0) {
            return "";
        }
        String string4 = source.getValue(n);
        if (string4.length() == 0) {
            return "-1";
        }
        return new Float(FluxConverter.getFluxError(new Double(string3), d, new Double(string4))).toString();
    }

    private String getFrequency(String string) {
        try {
            return ((Double)FREQUENCY.get(string.substring(string.length() - 2))).toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private String getName(Source source) {
        int n = source.findUCD("ID_MAIN");
        if (n < 0) {
            return null;
        }
        return String.valueOf(source.getCatalogue()) + " " + source.getValue(n);
    }

    protected BufferedInputStream getOutput() {
        this.vot = new StringBuffer(200);
        this.vot.append(PREAMBLE);
        this.newLine();
        this.vot.append("<VOTABLE version=\"1.0\">");
        this.newLine();
        ++this.indentLevel;
        this.writeAllSources();
        this.vot.append("</VOTABLE>");
        return new BufferedInputStream(new ByteArrayInputStream(this.vot.toString().getBytes()));
    }

    private void newLine() {
        this.vot.append(CR);
    }

    protected void setSources(Source[] sourceArray) {
        this.sources = sourceArray;
    }

    private void writeAllSources() {
        boolean bl = false;
        this.doIndent();
        this.vot.append("<RESOURCE>");
        ++this.indentLevel;
        if (this.sources != null) {
            int n = 0;
            while (n < this.sources.length) {
                this.writeTable(this.sources[n]);
                ++n;
            }
        }
        --this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("</RESOURCE>");
        this.newLine();
    }

    private void writeCase1Values(Source source) {
        this.newLine();
        this.doIndent();
        this.vot.append("<TR>");
        ++this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("<TD>");
        this.vot.append(source.getValue(this.indexFreq));
        this.vot.append("</TD>");
        this.vot.append("<TD>");
        this.vot.append(source.getValue(this.indexBW));
        this.vot.append("</TD>");
        this.vot.append("<TD>");
        this.vot.append(source.getValue(this.indexFlux));
        this.vot.append("</TD>");
        String string = source.leg.field[this.indexFlux].name;
        String string2 = source.leg.field[this.indexFlux].ucd.toUpperCase();
        int n = source.findColumn("e_" + string);
        String string3 = n < 0 ? "" : source.getValue(n);
        this.vot.append("<TD>");
        this.vot.append(string3);
        this.vot.append("</TD>");
        --this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("</TR>");
    }

    private void writeCase2Values(Source source) {
        Field[] fieldArray = source.leg.field;
        int n = 0;
        while (n < fieldArray.length) {
            String string;
            String string2 = fieldArray[n].name;
            String string3 = fieldArray[n].ucd.toUpperCase();
            if (EISCCUCD.contains(string3) && source.findColumn("e_" + string2) >= 0 && (string = this.getFrequency(string3)) != null) {
                this.newLine();
                this.doIndent();
                this.vot.append("<TR>");
                ++this.indentLevel;
                this.newLine();
                this.doIndent();
                this.vot.append("<TD>");
                this.vot.append(string);
                this.vot.append("</TD>");
                String string4 = this.getDeltaFreq(string3);
                this.vot.append("<TD>");
                this.vot.append(string4);
                this.vot.append("</TD>");
                String string5 = source.getValue(n);
                String string6 = this.getFlux(string3, string5);
                this.vot.append("<TD>");
                this.vot.append(string6);
                this.vot.append("</TD>");
                this.vot.append("<TD>");
                this.vot.append(this.getFluxError(string3, string2, string6, source));
                this.vot.append("</TD>");
                --this.indentLevel;
                this.newLine();
                this.doIndent();
                this.vot.append("</TR>");
            }
            ++n;
        }
    }

    private void writeCase3Values(Source source) {
        Field[] fieldArray = source.leg.field;
        int n = 0;
        while (n < fieldArray.length) {
            String string;
            String string2 = fieldArray[n].name;
            String string3 = fieldArray[n].ucd.toUpperCase();
            if (SEXUCD.contains(string3) && source.findColumn("e_" + string2) >= 0 && (string = this.getFrequency(string3)) != null) {
                this.newLine();
                this.doIndent();
                this.vot.append("<TR>");
                ++this.indentLevel;
                this.newLine();
                this.doIndent();
                this.vot.append("<TD>");
                this.vot.append(string);
                this.vot.append("</TD>");
                String string4 = this.getDeltaFreq(string3);
                this.vot.append("<TD>");
                this.vot.append(string4);
                this.vot.append("</TD>");
                String string5 = source.getValue(n);
                String string6 = this.getFlux(string3, string5);
                this.vot.append("<TD>");
                this.vot.append(string6);
                this.vot.append("</TD>");
                this.vot.append("<TD>");
                this.vot.append(this.getFluxError(string3, string2, string6, source));
                this.vot.append("</TD>");
                --this.indentLevel;
                this.newLine();
                this.doIndent();
                this.vot.append("</TR>");
            }
            ++n;
        }
    }

    private void writeCase4Values(Source source) {
        Field[] fieldArray = source.leg.field;
        int n = 0;
        while (n < fieldArray.length) {
            String string;
            String string2 = fieldArray[n].name;
            String string3 = fieldArray[n].ucd.toUpperCase();
            if (EISSINGLEUCD.contains(string3) && source.findColumn("e_" + string2) >= 0 && (string = this.getFrequency(string3)) != null) {
                this.newLine();
                this.doIndent();
                this.vot.append("<TR>");
                ++this.indentLevel;
                this.newLine();
                this.doIndent();
                this.vot.append("<TD>");
                this.vot.append(string);
                this.vot.append("</TD>");
                String string4 = this.getDeltaFreq(string3);
                this.vot.append("<TD>");
                this.vot.append(string4);
                this.vot.append("</TD>");
                String string5 = this.AB2Vega(source.getValue(n), string3);
                String string6 = this.getFlux(string3, string5);
                this.vot.append("<TD>");
                this.vot.append(string6);
                this.vot.append("</TD>");
                this.vot.append("<TD>");
                this.vot.append(this.getFluxError(string3, string2, string6, source));
                this.vot.append("</TD>");
                --this.indentLevel;
                this.newLine();
                this.doIndent();
                this.vot.append("</TR>");
            }
            ++n;
        }
    }

    private void writeData(Source source) {
        this.newLine();
        this.doIndent();
        this.vot.append("<DATA>");
        ++this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("<TABLEDATA>");
        ++this.indentLevel;
        if (this.case1(source)) {
            this.writeCase1Values(source);
        } else if (this.case2(source)) {
            this.writeCase2Values(source);
        } else if (this.case3(source)) {
            this.writeCase3Values(source);
        } else if (this.case4(source)) {
            this.writeCase4Values(source);
        }
        --this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("</TABLEDATA>");
        --this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("</DATA>");
    }

    private void writeDescription() {
        int n = 0;
        while (n < FIELDS.length) {
            this.newLine();
            this.doIndent();
            this.vot.append("<FIELD");
            this.addAttribut(VOTableEISGenerator.FIELDS[n].name, "name", false);
            this.addAttribut(VOTableEISGenerator.FIELDS[n].ucd, "ucd", true);
            this.addAttribut(VOTableEISGenerator.FIELDS[n].unit, "unit", true);
            this.addAttribut(VOTableEISGenerator.FIELDS[n].datatype, "datatype", false);
            this.addAttribut(VOTableEISGenerator.FIELDS[n].precision, "precision", false);
            this.vot.append(">");
            this.newLine();
            this.doIndent();
            this.vot.append("</FIELD>");
            ++n;
        }
    }

    private void writeTable(Source source) {
        this.newLine();
        this.doIndent();
        int n = source.hashCode();
        String string = this.getName(source);
        if (string == null) {
            string = String.valueOf(n);
        }
        this.vot.append("<TABLE ID=\"" + n + "\" name=\"" + string + "\">");
        ++this.indentLevel;
        this.writeDescription();
        this.writeData(source);
        --this.indentLevel;
        this.newLine();
        this.doIndent();
        this.vot.append("</TABLE>");
    }
}

