/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.net.MalformedURLException;
import java.net.URL;

public class TreeLoader
extends Frame {
    Aladin a;
    Server[] server;
    Button[] button;
    TextField[] targetTF;
    TextField[] radiusTF;
    TextField noaoTarget;
    TextField noaoSize;
    Button noaoButton;
    TextField skyvTarget;
    TextField skyvSize;
    Button skyvButton;
    TextField filePathTF;
    Button browseFile;
    Button addFile;
    TextField urlTF;
    Button addURL;
    FileDialog fd;
    private static final String ADD2TREE = "Add to tree";
    private static final String BROWSE = "Browse ...";

    protected TreeLoader(Aladin aladin) {
        super("Tree loader");
        ((Component)this).setBackground(Aladin.BKGD);
        this.a = aladin;
        this.init();
        this.buildFrame();
        this.pack();
    }

    public boolean action(Event event, Object object) {
        int n;
        if (object.equals(BROWSE)) {
            this.showFileDialog();
            this.dispFileName();
            return true;
        }
        if (event.target.equals(this.noaoButton)) {
            String string = "http://archive.noao.edu/nvo/sim/voquery.php";
            this.a.treeView.addSIABranch(string, this.noaoTarget.getText(), this.noaoSize.getText(), "NOAO SIA Service");
            return true;
        }
        if (event.target.equals(this.skyvButton)) {
            String string = "http://skyview.gsfc.nasa.gov/cgi-bin/vo/sia.pl";
            this.a.treeView.addSIABranch(string, this.skyvTarget.getText(), this.skyvSize.getText(), "SkyView SIA Service");
            return true;
        }
        if (event.target.equals(this.addFile)) {
            URL uRL;
            try {
                uRL = new URL("file:" + this.filePathTF.getText());
            }
            catch (MalformedURLException malformedURLException) {
                this.a.message.warning("Invalid file path", 1);
                return true;
            }
            this.a.treeView.addBranch(uRL);
            return true;
        }
        if (event.target.equals(this.addURL)) {
            URL uRL = this.a.glu.getURL("Http", this.urlTF.getText(), true);
            if (uRL == null) {
                this.a.message.warning("Invalid url", 1);
                return true;
            }
            this.a.treeView.addBranch(uRL);
            return true;
        }
        if (object.equals(ADD2TREE) && (n = this.findIndex((Button)event.target)) >= 0) {
            this.a.treeView.addBranch(this.targetTF[n].getText(), this.radiusTF[n].getText(), this.server[n]);
        }
        return true;
    }

    private void buildFrame() {
        Label label;
        Label label2;
        Label label3;
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        int n = 0;
        while (n < this.server.length) {
            label3 = new Label(this.server[n].nom);
            label3.setFont(Aladin.BOLD);
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 0;
            gridBagLayout.setConstraints(label3, gridBagConstraints);
            panel.add(label3);
            label2 = new Label("Target");
            label2.setFont(Aladin.PLAIN);
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 1;
            gridBagLayout.setConstraints(label2, gridBagConstraints);
            panel.add(label2);
            this.targetTF[n] = new TextField(15);
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(this.targetTF[n], gridBagConstraints);
            panel.add(this.targetTF[n]);
            label = new Label("Radius");
            label.setFont(Aladin.PLAIN);
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 3;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            this.radiusTF[n] = new TextField("10 arcmin");
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 4;
            gridBagLayout.setConstraints(this.radiusTF[n], gridBagConstraints);
            panel.add(this.radiusTF[n]);
            this.button[n] = new Button(ADD2TREE);
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 5;
            gridBagLayout.setConstraints(this.button[n], gridBagConstraints);
            panel.add(this.button[n]);
            ++n;
        }
        if (Aladin.STANDALONE) {
            label3 = new Label("Local file");
            label3.setFont(Aladin.BOLD);
            gridBagConstraints.gridy = this.server.length;
            gridBagConstraints.gridx = 0;
            gridBagLayout.setConstraints(label3, gridBagConstraints);
            panel.add(label3);
            this.filePathTF = new TextField(20);
            gridBagConstraints.gridy = this.server.length;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints(this.filePathTF, gridBagConstraints);
            panel.add(this.filePathTF);
            this.browseFile = new Button(BROWSE);
            gridBagConstraints.gridy = this.server.length;
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.browseFile, gridBagConstraints);
            panel.add(this.browseFile);
            this.addFile = new Button(ADD2TREE);
            gridBagConstraints.gridy = this.server.length;
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.addFile, gridBagConstraints);
            panel.add(this.addFile);
        }
        label3 = new Label("URL");
        label3.setFont(Aladin.BOLD);
        gridBagConstraints.gridy = this.server.length + 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        panel.add(label3);
        this.urlTF = new TextField("http://", 30);
        gridBagConstraints.gridy = this.server.length + 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(this.urlTF, gridBagConstraints);
        panel.add(this.urlTF);
        this.addURL = new Button(ADD2TREE);
        gridBagConstraints.gridy = this.server.length + 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.addURL, gridBagConstraints);
        panel.add(this.addURL);
        label2 = new Label("NOAO SIA Service");
        label2.setFont(Aladin.BOLD);
        gridBagConstraints.gridy = this.server.length + 2;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        label = new Label("Target");
        label.setFont(Aladin.PLAIN);
        gridBagConstraints.gridy = this.server.length + 2;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.noaoTarget = new TextField(15);
        gridBagConstraints.gridy = this.server.length + 2;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this.noaoTarget, gridBagConstraints);
        panel.add(this.noaoTarget);
        Label label4 = new Label("Size");
        label4.setFont(Aladin.PLAIN);
        gridBagConstraints.gridy = this.server.length + 2;
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        panel.add(label4);
        this.noaoSize = new TextField("10 arcmin");
        gridBagConstraints.gridy = this.server.length + 2;
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.noaoSize, gridBagConstraints);
        panel.add(this.noaoSize);
        this.noaoButton = new Button(ADD2TREE);
        gridBagConstraints.gridy = this.server.length + 2;
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(this.noaoButton, gridBagConstraints);
        panel.add(this.noaoButton);
        Label label5 = new Label("SkyView SIA Service");
        label5.setFont(Aladin.BOLD);
        gridBagConstraints.gridy = this.server.length + 3;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label5, gridBagConstraints);
        panel.add(label5);
        label = new Label("Target");
        label.setFont(Aladin.PLAIN);
        gridBagConstraints.gridy = this.server.length + 3;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.skyvTarget = new TextField(15);
        gridBagConstraints.gridy = this.server.length + 3;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this.skyvTarget, gridBagConstraints);
        panel.add(this.skyvTarget);
        label4 = new Label("Size");
        label4.setFont(Aladin.PLAIN);
        gridBagConstraints.gridy = this.server.length + 3;
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        panel.add(label4);
        this.skyvSize = new TextField("10 arcmin");
        gridBagConstraints.gridy = this.server.length + 3;
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.skyvSize, gridBagConstraints);
        panel.add(this.skyvSize);
        this.skyvButton = new Button(ADD2TREE);
        gridBagConstraints.gridy = this.server.length + 3;
        gridBagConstraints.gridx = 5;
        gridBagLayout.setConstraints(this.skyvButton, gridBagConstraints);
        panel.add(this.skyvButton);
        this.add((Component)panel, "Center");
    }

    private void dispFileName() {
        String string = this.fd.getDirectory();
        String string2 = this.fd.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        this.filePathTF.setText(string3);
    }

    private int findIndex(Button button) {
        int n = 0;
        while (n < this.button.length) {
            if (this.button[n].equals(button)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
        }
        return super.handleEvent(event);
    }

    private void init() {
        this.server = new Server[2];
        this.server[0] = this.a.dialog.server[ServerDialog.ALADIN];
        this.server[1] = this.a.dialog.server[ServerDialog.VIZIER];
        this.radiusTF = new TextField[this.server.length];
        this.targetTF = new TextField[this.server.length];
        this.button = new Button[this.server.length];
    }

    private void showFileDialog() {
        if (this.fd == null || Aladin.JAVABEFORE118) {
            this.fd = new FileDialog((Frame)this, "", 0);
        } else {
            this.fd.setMode(0);
        }
        this.fd.setFile("");
        this.fd.show();
    }

    protected void updateTF(String string) {
        int n = 0;
        while (n < this.targetTF.length) {
            this.targetTF[n].setText(string);
            ++n;
        }
        this.noaoTarget.setText(string);
        this.skyvTarget.setText(string);
    }
}

