/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicNode;
import cds.aladin.Fov;
import cds.aladin.ResourceNode;
import cds.aladin.Server;
import cds.astro.Astroframe;
import cds.savot.model.FieldSet;
import cds.savot.model.InfoSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class TreeBuilder {
    static final int PARFILE = 0;
    static final int VOTABLE = 1;
    static final int VOTABLE_IDHA = 0;
    static final int VIZIER = 1;
    static final int SIAP = 2;
    private int indexCriteria = 0;
    private int indexValue = 1;
    private static final String SIAP_IMAGE_TITLE = "VOX:Image_Title";
    private static final String SIAP_RA = "POS_EQ_RA_MAIN";
    private static final String SIAP_DE = "POS_EQ_DEC_MAIN";
    private static final String SIAP_SCALE = "VOX:Image_Scale";
    private static final String SIAP_NAXIS = "VOX:Image_Naxis";
    private static final String SIAP_IMAGE_FORMAT = "VOX:Image_Format";
    private static final String SIAP_URL = "VOX:Image_AccessReference";
    private static final String SURVEY = "SRV";
    private static final String COLOR = "COL";
    private static final String ID = "ID";
    private static final String POSITION = "POS";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String RESOLUTION = "RES";
    private static final String IDSURVEY = "ObservingProgram";
    private static final String IDBAND = "Observation_Group";
    private static final String IDIMAGE = "Observation";
    private static final String IDMAPPING = "StorageMapping";
    private static final String CUTOUT = "CUTOUTS";
    double xVal;
    double yVal;
    double alphaVal;
    double deltaVal;
    String[] descFilter;
    double angleVal = 0.0;
    private int mode;
    private int type;
    private Server server = null;
    private static Color[] colTab = new Color[]{Color.green, Color.orange, Color.magenta, Color.cyan, Color.pink};
    private static int colorNb = 0;
    private ResourceNode nodeMemo;
    private Color fovColor;
    private double maxSize;
    private double pixSize;
    private Astroframe frame = new Astroframe();
    private InputStream is;
    private URL url;
    private String file;
    private SavotPullParser savotParser;
    private int nameIndex = 0;
    private String currentSurvey;
    private String currentColor;
    private FieldSet surveyFieldSet;
    private FieldSet bandFieldSet;
    private FieldSet imageFieldSet;
    private FieldSet filterFieldSet;
    private FieldSet mappingFieldSet;
    private Hashtable fieldSetMapping = new Hashtable();
    Hashtable ACSFilters = new Hashtable();

    TreeBuilder(InputStream inputStream, int n, int n2, Server server) {
        this.is = inputStream;
        this.mode = n;
        this.type = n2;
        this.server = server;
        this.createSavotParser();
    }

    TreeBuilder(String string, int n, int n2, Server server) {
        this.file = string;
        this.mode = n;
        this.type = n2;
        this.server = server;
        this.createSavotParser();
    }

    TreeBuilder(URL uRL, int n, int n2, Server server) {
        this.url = uRL;
        this.mode = n;
        this.type = n2;
        this.server = server;
        this.createSavotParser();
    }

    public static String URLDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+') {
                stringBuffer.append(" ");
                ++n;
                continue;
            }
            if (c == '%') {
                String string2 = string.substring(n + 1, n + 3);
                char c2 = (char)Integer.parseInt(string2, 16);
                stringBuffer.append(c2);
                n += 3;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected ResourceNode build() {
        this.detectFormat();
        if (this.type == 0) {
            return this.buildVotable();
        }
        if (this.type == 1) {
            return this.buildCatVotable();
        }
        if (this.type == 2) {
            return this.buildSIAPVotable();
        }
        return null;
    }

    private ResourceNode buildCatVotable() {
        if (this.savotParser == null) {
            return null;
        }
        ResourceNode resourceNode = new ResourceNode("root");
        resourceNode.type = 0;
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        ResourceSet resourceSet = savotVOTable.getResources();
        int n = 0;
        while (n < resourceSet.getItemCount()) {
            SavotResource savotResource = (SavotResource)resourceSet.getItemAt(n);
            ResourceNode resourceNode2 = new ResourceNode(savotResource.getName());
            resourceNode2.isLeaf = true;
            resourceNode2.type = 2;
            resourceNode2.catDesc = savotResource.getDescription();
            InfoSet infoSet = savotResource.getInfos();
            String[] stringArray = new String[infoSet.getItemCount()];
            String[] stringArray2 = new String[infoSet.getItemCount()];
            String string = null;
            int n2 = 0;
            while (n2 < infoSet.getItemCount()) {
                SavotInfo savotInfo = (SavotInfo)infoSet.getItemAt(n2);
                String string2 = savotInfo.getName();
                String string3 = savotInfo.getValue();
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                }
                if (string2.startsWith("kw.")) {
                    string2 = string2.substring(3);
                }
                if (string == null || !string2.equals(string)) {
                    stringArray2[n2] = string2;
                    stringArray[n2] = string3;
                    string = string2;
                } else {
                    stringArray2[n2] = "  \"   \"";
                    stringArray[n2] = string3;
                }
                ++n2;
            }
            resourceNode.addChild(resourceNode2);
            resourceNode2.description = stringArray2;
            resourceNode2.explanation = stringArray;
            ++n;
        }
        return resourceNode;
    }

    private ResourceNode buildSIAPVotable() {
        SavotField[] savotFieldArray;
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        ResourceSet resourceSet = savotVOTable.getResources();
        ResourceNode resourceNode = new ResourceNode("root");
        resourceNode.type = 1;
        SavotField[] savotFieldArray2 = null;
        int n = 0;
        while (n < resourceSet.getItemCount()) {
            savotFieldArray = (SavotField[])resourceSet.getItemAt(n);
            if (savotFieldArray.getType().equals("results")) {
                savotFieldArray2 = savotFieldArray;
                break;
            }
            ++n;
        }
        if (savotFieldArray2 == null) {
            return null;
        }
        savotFieldArray = this.createDescription(savotFieldArray2.getFieldSet(0));
        TRSet tRSet = savotFieldArray2.getData(0).getTableData().getTRs();
        ResourceNode[] resourceNodeArray = new ResourceNode[tRSet.getItemCount()];
        int n2 = 0;
        while (n2 < resourceNodeArray.length) {
            resourceNodeArray[n2] = this.createSIAPNode((SavotTR)tRSet.getItemAt(n2), savotFieldArray);
            resourceNode.addChild(resourceNodeArray[n2]);
            ++n2;
        }
        return resourceNode;
    }

    private ResourceNode buildVotable() {
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        ResourceSet resourceSet = savotVOTable.getResources();
        ResourceNode resourceNode = new ResourceNode("root");
        resourceNode.type = 0;
        int n = 0;
        while (n < resourceSet.getItemCount()) {
            this.processResource(resourceSet, n, resourceNode);
            ++n;
        }
        return resourceNode;
    }

    private SavotField[] createDescription(FieldSet fieldSet) {
        int n = fieldSet.getItemCount();
        SavotField[] savotFieldArray = new SavotField[n];
        int n2 = 0;
        while (n2 < n) {
            savotFieldArray[n2] = (SavotField)fieldSet.getItemAt(n2);
            ++n2;
        }
        return savotFieldArray;
    }

    private void createFov(ResourceNode resourceNode) {
        resourceNode.fov = new Fov(this.alphaVal, this.deltaVal, this.xVal, this.yVal, this.angleVal);
        this.angleVal = 0.0;
        if (resourceNode.getParent() != null) {
            resourceNode.fov.color = ((ResourceNode)resourceNode.getParent()).col;
        }
        if (resourceNode.cutout) {
            resourceNode.fov.cutout_x = resourceNode.fov.cutout_y = this.maxSize * this.pixSize;
        }
    }

    private ResourceNode createNode(SavotTR savotTR, int n, SavotField[] savotFieldArray, String string) {
        Object object;
        boolean bl = false;
        TDSet tDSet = savotTR.getTDs();
        int n2 = tDSet.getItemCount();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[savotFieldArray.length];
        int n3 = -1;
        int n4 = -1;
        String[] stringArray3 = new String[savotFieldArray.length];
        int n5 = 0;
        while (n5 < savotFieldArray.length) {
            String string2 = savotFieldArray[n5].getName();
            stringArray2[n5] = string2.length() > 0 ? string2 : savotFieldArray[n5].getId();
            stringArray3[n5] = savotFieldArray[n5].getId();
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            String string3;
            Object var18_17;
            stringArray[n6] = ((SavotTD)tDSet.getItemAt(n6)).getContent();
            try {
                try {
                    if (stringArray3[n6].equals("PixelSize")) {
                        this.pixSize = new Double(stringArray[n6]);
                    }
                    if (stringArray3[n6].equals("Size_alpha")) {
                        this.xVal = new Double(stringArray[n6]);
                    } else if (stringArray3[n6].equals("Size_delta")) {
                        this.yVal = new Double(stringArray[n6]);
                    } else if (stringArray3[n6].equals("alpha")) {
                        this.alphaVal = new Double(stringArray[n6]);
                        n4 = n6;
                    } else if (stringArray3[n6].equals("delta")) {
                        this.deltaVal = new Double(stringArray[n6]);
                        n3 = n6;
                    } else if (stringArray3[n6].equals("AP") || stringArray2[n6].equals("Position Angle")) {
                        this.angleVal = new Double(stringArray[n6]);
                    }
                }
                catch (Exception exception) {
                }
                var18_17 = null;
            }
            catch (Throwable throwable) {
                var18_17 = null;
                if (n6 < savotFieldArray.length && n6 != n4 && n6 != n3 && n6 != n) {
                    string3 = savotFieldArray[n6].getUnit();
                    if (stringArray[n6].length() > 0 && string3.length() > 0) {
                        int n7 = n6;
                        stringArray[n7] = String.valueOf(stringArray[n7]) + " " + string3;
                    }
                }
                throw throwable;
            }
            if (n6 < savotFieldArray.length && n6 != n4 && n6 != n3 && n6 != n) {
                string3 = savotFieldArray[n6].getUnit();
                if (stringArray[n6].length() > 0 && string3.length() > 0) {
                    int n8 = n6;
                    stringArray[n8] = String.valueOf(stringArray[n8]) + " " + string3;
                }
            }
            ++n6;
        }
        if (n4 >= 0 && n3 >= 0) {
            try {
                this.frame.set(String.valueOf(stringArray[n4]) + " " + stringArray[n3]);
                this.frame.setPrecision(6);
                object = this.frame.toString(":");
                int n9 = ((String)object).indexOf("+");
                if (n9 == -1) {
                    n9 = ((String)object).indexOf("-");
                }
                stringArray[n4] = ((String)object).substring(0, n9);
                stringArray[n3] = ((String)object).substring(n9);
            }
            catch (Exception exception) {}
        }
        object = new ResourceNode();
        ((ResourceNode)object).type = 1;
        ((ResourceNode)object).server = this.server;
        ((ResourceNode)object).description = stringArray2;
        ((ResourceNode)object).explanation = stringArray;
        if (n >= 0) {
            ((BasicNode)object).name = stringArray[n];
        }
        ((ResourceNode)object).cutout = bl;
        return object;
    }

    private ResourceNode createSIAPNode(SavotTR savotTR, SavotField[] savotFieldArray) {
        String[] stringArray;
        Object object;
        boolean bl = false;
        TDSet tDSet = savotTR.getTDs();
        int n = tDSet.getItemCount();
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[savotFieldArray.length];
        String string = null;
        String string2 = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String[] stringArray4 = new String[savotFieldArray.length];
        int n8 = 0;
        while (n8 < savotFieldArray.length) {
            String string3 = savotFieldArray[n8].getName();
            stringArray3[n8] = string3.length() > 0 ? string3 : savotFieldArray[n8].getId();
            stringArray4[n8] = savotFieldArray[n8].getId();
            ++n8;
        }
        int n9 = 0;
        while (n9 < n) {
            String string4;
            stringArray2[n9] = ((SavotTD)tDSet.getItemAt(n9)).getContent();
            try {
                try {
                    object = savotFieldArray[n9].getUcd();
                    if (((String)object).equalsIgnoreCase(SIAP_IMAGE_TITLE)) {
                        n2 = n9;
                    } else if (((String)object).equalsIgnoreCase(SIAP_RA)) {
                        n4 = n9;
                        this.alphaVal = new Double(stringArray2[n9]);
                    } else if (((String)object).equalsIgnoreCase(SIAP_DE)) {
                        n3 = n9;
                        this.deltaVal = new Double(stringArray2[n9]);
                    } else if (((String)object).equalsIgnoreCase(SIAP_URL)) {
                        n5 = n9;
                    } else if (((String)object).equalsIgnoreCase(SIAP_SCALE)) {
                        n7 = n9;
                        string = stringArray2[n9];
                    } else if (((String)object).equalsIgnoreCase(SIAP_NAXIS)) {
                        n6 = n9;
                        string2 = stringArray2[n9];
                    }
                }
                catch (Exception exception) {
                }
                stringArray = null;
            }
            catch (Throwable throwable) {
                stringArray = null;
                if (n9 < savotFieldArray.length && n9 != n4 && n9 != n3 && n9 != n5 && n9 != n2) {
                    string4 = savotFieldArray[n9].getUnit();
                    if (stringArray2[n9].length() > 0 && string4.length() > 0) {
                        int n10 = n9;
                        stringArray2[n10] = String.valueOf(stringArray2[n10]) + " " + string4;
                    }
                }
                throw throwable;
            }
            if (n9 < savotFieldArray.length && n9 != n4 && n9 != n3 && n9 != n5 && n9 != n2) {
                string4 = savotFieldArray[n9].getUnit();
                if (stringArray2[n9].length() > 0 && string4.length() > 0) {
                    int n11 = n9;
                    stringArray2[n11] = String.valueOf(stringArray2[n11]) + " " + string4;
                }
            }
            ++n9;
        }
        if (n4 >= 0 && n3 >= 0) {
            try {
                this.frame.set(String.valueOf(stringArray2[n4]) + " " + stringArray2[n3]);
                this.frame.setPrecision(6);
                object = this.frame.toString(":");
                int n12 = ((String)object).indexOf("+");
                if (n12 == -1) {
                    n12 = ((String)object).indexOf("-");
                }
                stringArray2[n4] = ((String)object).substring(0, n12);
                stringArray2[n3] = ((String)object).substring(n12);
            }
            catch (Exception exception) {}
        }
        object = new ResourceNode();
        ((ResourceNode)object).type = 1;
        ((ResourceNode)object).server = this.server;
        ((ResourceNode)object).description = stringArray3;
        ((ResourceNode)object).explanation = stringArray2;
        ((BasicNode)object).isLeaf = true;
        if (n2 >= 0) {
            ((BasicNode)object).name = stringArray2[n2];
        }
        ((ResourceNode)object).cutout = bl;
        if (n5 >= 0) {
            ((ResourceNode)object).location = stringArray2[n5];
        }
        this.xVal = 0.0;
        this.yVal = 0.0;
        if (n7 >= 0 && n6 >= 0) {
            String[] stringArray5 = this.split(string, ", ");
            stringArray = this.split(string2, ", ");
            if (stringArray.length >= 2 && stringArray5.length >= 2) {
                try {
                    this.xVal = Math.abs(new Double(stringArray5[0]) * new Double(stringArray[0]));
                    this.yVal = Math.abs(new Double(stringArray5[1]) * new Double(stringArray[1]));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.createFov((ResourceNode)object);
        return object;
    }

    private void createSavotParser() {
        if (this.url != null) {
            try {
                this.savotParser = new SavotPullParser(this.url, SavotPullEngine.FULL, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.savotParser = null;
            }
        } else if (this.file != null) {
            try {
                this.savotParser = new SavotPullParser(this.file, SavotPullEngine.FULL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.savotParser = null;
            }
        } else if (this.is != null) {
            this.savotParser = new SavotPullParser(this.is, SavotPullEngine.FULL, null);
        }
    }

    private void detectFormat() {
        if (this.type >= 0) {
            Aladin.trace(3, "detect format of " + this.file != null ? this.file : String.valueOf(String.valueOf(this.url)) + ": format was already specified");
            return;
        }
        SavotResource savotResource = (SavotResource)this.savotParser.getVOTable().getResources().getItemAt(0);
        String string = savotResource.getType();
        if (string == null) {
            string = "";
        }
        if (string.equals("results")) {
            this.type = 2;
            Aladin.trace(3, "detect format of " + this.file != null ? this.file : String.valueOf(String.valueOf(this.url)) + ": SIAP");
            return;
        }
        String string2 = savotResource.getId();
        if (string2 == null || string2.length() == 0) {
            string2 = savotResource.getName();
        }
        if (string2 != null && string2.equalsIgnoreCase(IDSURVEY)) {
            this.type = 0;
            Aladin.trace(3, "detect format of " + this.file != null ? this.file : String.valueOf(String.valueOf(this.url)) + ": VOTABLE_IDHA");
            return;
        }
        if (string.equals("meta")) {
            this.type = 1;
            Aladin.trace(3, "detect format of " + this.file != null ? this.file : String.valueOf(String.valueOf(this.url)) + ": VIZIER");
            return;
        }
        Aladin.trace(3, "format of " + this.file != null ? this.file : String.valueOf(String.valueOf(this.url)) + " could not be determined");
    }

    private SavotField[] getDescription(SavotResource savotResource) {
        SavotField[] savotFieldArray;
        String string = ((SavotTable)savotResource.getTables().getItemAt(0)).getId();
        String string2 = ((SavotTable)savotResource.getTables().getItemAt(0)).getRef();
        if (string.length() != 0) {
            savotFieldArray = this.createDescription(savotResource.getFieldSet(0));
            this.fieldSetMapping.put(string, savotFieldArray);
        } else {
            savotFieldArray = (SavotField[])this.fieldSetMapping.get(string2);
        }
        return savotFieldArray;
    }

    private static Color getNextColor() {
        float f = 0.3f * (float)colorNb + 0.05f;
        ++colorNb;
        return Color.getHSBColor((float)((double)f - Math.floor(f)), 0.7f, 1.0f);
    }

    private void processObsGroup(SavotResource savotResource, ResourceNode resourceNode) {
        TRSet tRSet = savotResource.getTRSet(0);
        int n = tRSet.getItemCount();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, SavotResource> hashtable2 = new Hashtable<String, SavotResource>();
        SavotResource savotResource2 = null;
        SavotResource savotResource3 = null;
        int n2 = 0;
        while (n2 < n) {
            TDSet tDSet = tRSet.getTDSet(n2);
            stringArray[n2] = tDSet.getContent(this.indexCriteria).replace('\"', ' ').trim().toLowerCase();
            stringArray2[n2] = tDSet.getContent(this.indexValue);
            hashtable.put(stringArray[n2], stringArray2[n2]);
            if (stringArray[n2].equals("filter")) {
                this.currentColor = stringArray2[n2];
            }
            ++n2;
        }
        if (resourceNode.sortCriteria == null) {
            resourceNode.sortCriteria = stringArray;
        }
        ResourceSet resourceSet = savotResource.getResources();
        int n3 = 0;
        while (n3 < resourceSet.getItemCount()) {
            SavotResource savotResource4 = (SavotResource)resourceSet.getItemAt(n3);
            if (savotResource4.getName().equalsIgnoreCase(IDIMAGE)) {
                savotResource3 = savotResource4;
            } else if (savotResource4.getName().equalsIgnoreCase(IDMAPPING)) {
                savotResource2 = savotResource4;
            } else {
                hashtable2.put(savotResource4.getName().toLowerCase(), savotResource4);
            }
            ++n3;
        }
        TRSet tRSet2 = savotResource3.getData(0).getTableData().getTRs();
        ResourceNode[] resourceNodeArray = new ResourceNode[tRSet2.getItemCount()];
        if (this.imageFieldSet == null) {
            this.imageFieldSet = savotResource3.getFieldSet(0);
        }
        SavotField[] savotFieldArray = this.getDescription(savotResource3);
        TRSet tRSet3 = savotResource2.getData(0).getTableData().getTRs();
        if (this.mappingFieldSet == null) {
            this.mappingFieldSet = savotResource2.getFieldSet(0);
        }
        SavotField[] savotFieldArray2 = this.getDescription(savotResource2);
        int n4 = 0;
        while (n4 < resourceNodeArray.length) {
            resourceNodeArray[n4] = this.createNode((SavotTR)tRSet2.getItemAt(n4), 0, savotFieldArray, IDIMAGE);
            resourceNodeArray[n4].criteriaVal = hashtable;
            if (savotResource2 != null) {
                TDSet tDSet = ((SavotTR)tRSet3.getItemAt(n4)).getTDs();
                int n5 = 0;
                while (n5 < tDSet.getItemCount()) {
                    String string;
                    SavotTD savotTD = (SavotTD)tDSet.getItemAt(n5);
                    String string2 = savotFieldArray2[n5].getId();
                    if (string2.length() == 0) {
                        string2 = savotFieldArray2[n5].getName();
                    }
                    if (string2.equalsIgnoreCase("Location") && (string = savotTD.getContent()) != null && string.length() > 0 && string.indexOf("ALADIN") <= 0) {
                        resourceNodeArray[n4].location = TreeBuilder.URLDecode(string);
                    }
                    if (string2.equalsIgnoreCase("Cutout") && savotTD.getContent().equals(CUTOUT)) {
                        resourceNodeArray[n4].cutout = true;
                    }
                    if (string2.equalsIgnoreCase("size")) {
                        this.maxSize = new Double(savotTD.getContent());
                    }
                    ++n5;
                }
            }
            resourceNodeArray[n4].isLeaf = true;
            resourceNodeArray[n4].survey = this.currentSurvey;
            resourceNodeArray[n4].color = this.currentColor;
            this.createFov(resourceNodeArray[n4]);
            ++n4;
        }
        this.sortAndCreate(resourceNodeArray, resourceNode, resourceNode.sortCriteria, hashtable2);
    }

    private void processResource(ResourceSet resourceSet, int n, ResourceNode resourceNode) {
        SavotResource savotResource = (SavotResource)resourceSet.getItemAt(n);
        SavotField[] savotFieldArray = null;
        String string = ((SavotTable)savotResource.getTables().getItemAt(0)).getId();
        String string2 = ((SavotTable)savotResource.getTables().getItemAt(0)).getRef();
        if (string.length() != 0) {
            if (string.equalsIgnoreCase(IDSURVEY)) {
                this.surveyFieldSet = savotResource.getFieldSet(0);
            } else if (string.equalsIgnoreCase(IDBAND)) {
                this.bandFieldSet = savotResource.getFieldSet(0);
            } else if (string.equalsIgnoreCase(IDIMAGE)) {
                this.imageFieldSet = savotResource.getFieldSet(0);
            }
        } else {
            string = string2;
        }
        savotFieldArray = this.getDescription(savotResource);
        if (string.equalsIgnoreCase(IDMAPPING)) {
            return;
        }
        TRSet tRSet = savotResource.getData(0).getTableData().getTRs();
        String string3 = savotResource.getName();
        int n2 = tRSet.getItemCount();
        this.nameIndex = string3.equalsIgnoreCase(IDBAND) ? 1 : 0;
        ResourceNode resourceNode2 = null;
        if (string3.equalsIgnoreCase(IDBAND) && n2 > 0) {
            this.processObsGroup(savotResource, resourceNode);
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            resourceNode2 = this.createNode((SavotTR)tRSet.getItemAt(n3), this.nameIndex, savotFieldArray, string3);
            resourceNode.addChild(resourceNode2);
            ++n3;
        }
        if (string.equalsIgnoreCase(IDSURVEY) && resourceNode2 != null) {
            this.currentSurvey = resourceNode2.explanation[0];
        }
        ResourceSet resourceSet2 = savotResource.getResources();
        int n4 = 0;
        while (n4 < resourceSet2.getItemCount()) {
            this.processResource(resourceSet2, n4, resourceNode2);
            ++n4;
        }
    }

    protected String searchTarget() {
        if (this.savotParser == null) {
            return null;
        }
        InfoSet infoSet = this.savotParser.getVOTable().getInfos();
        int n = 0;
        while (n < infoSet.getItemCount()) {
            SavotInfo savotInfo = (SavotInfo)infoSet.getItemAt(n);
            if (savotInfo.getId().equalsIgnoreCase("position")) {
                return savotInfo.getValue();
            }
            ++n;
        }
        return null;
    }

    private void sortAndCreate(ResourceNode[] resourceNodeArray, ResourceNode resourceNode, String[] stringArray, Hashtable hashtable) {
        if (resourceNodeArray.length == 0) {
            return;
        }
        Hashtable hashtable2 = resourceNodeArray[0].criteriaVal;
        ResourceNode resourceNode2 = resourceNode;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            string = (String)hashtable2.get(stringArray[n]);
            ResourceNode resourceNode3 = (ResourceNode)resourceNode2.getChild(string);
            if (resourceNode3 == null) {
                SavotResource savotResource = (SavotResource)hashtable.get(stringArray[n]);
                if (savotResource != null) {
                    resourceNode3 = this.createNode((SavotTR)savotResource.getData(0).getTableData().getTRs().getItemAt(0), -1, this.getDescription(savotResource), stringArray[n]);
                } else {
                    resourceNode3 = new ResourceNode();
                    resourceNode3.type = 1;
                }
                resourceNode3.name = string;
                resourceNode3.criteria = stringArray[n];
                resourceNode3.valueCriteria = string;
                resourceNode2.addChild(resourceNode3);
            }
            resourceNode2 = resourceNode3;
            ++n;
        }
        resourceNode2.col = TreeBuilder.getNextColor();
        int n2 = 0;
        while (n2 < resourceNodeArray.length) {
            resourceNode2.addChild(resourceNodeArray[n2]);
            resourceNodeArray[n2].col = resourceNodeArray[n2].fov.color = resourceNode2.col;
            ++n2;
        }
    }

    private String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }
}

