/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.ZoomView;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public final class Texte
extends Position {
    boolean inprogress;
    static Font F = Aladin.PLAIN;
    int dw;
    int dh;

    protected Texte(Plan plan) {
        super(plan);
    }

    protected Texte(Plan plan, double d, double d2) {
        super(plan, d, d2, 0.0, 0.0, 5, "");
        this.inprogress = true;
    }

    protected Texte(Plan plan, double d, double d2, String string) {
        super(plan, d, d2, 0.0, 0.0, 5, string);
        this.setWH();
    }

    protected Texte(Plan plan, Coord coord, String string) {
        super(plan, 0.0, 0.0, coord.al, coord.del, 10, string);
        this.setWH();
    }

    protected void draw(Graphics graphics, ZoomView zoomView, int n, int n2) {
        Point point = this.getViewCoord(zoomView, this.dw, this.dh);
        if (point.x < 0) {
            return;
        }
        point.x += n;
        point.y += n2;
        graphics.setFont(F);
        graphics.setColor(this.plan.c);
        graphics.drawString(this.id, point.x - this.dw, point.y + this.dh);
        if (this.inprogress) {
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            nArray[0] = point.x + this.dw + 2;
            nArray[1] = nArray[0] - 3;
            nArray[2] = nArray[0] + 3;
            nArray2[0] = point.y + this.dh - 2;
            nArray2[1] = nArray2[2] = nArray2[0] + 7;
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        if (this.select) {
            this.drawSelect(graphics, zoomView);
        }
    }

    protected Rectangle getClip(ZoomView zoomView) {
        Point point = this.getViewCoord(zoomView, this.dw, this.dh);
        if (this.select) {
            return new Rectangle(point.x - this.dw - 5 - 4, point.y - this.dh - 4, this.dw * 2 + 10 + 8, this.dh * 2 + 8 + 8);
        }
        return new Rectangle(point.x - this.dw - 5, point.y - this.dh, this.dw * 2 + 10, this.dh * 2 + 8);
    }

    protected void inProgress(boolean bl) {
        this.inprogress = bl;
    }

    protected boolean inside(double d, double d2, double d3) {
        double d4 = (double)this.dw / d3;
        double d5 = (double)this.dh / d3;
        return d >= this.x - d4 && d <= this.x + d4 && d2 >= this.y - d5 && d2 <= this.y + d5;
    }

    protected void setText(String string) {
        super.setText(string);
        this.setWH();
    }

    void setWH() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(F);
        this.dw = fontMetrics.stringWidth(this.id) / 2;
        this.dh = Position.HF / 2;
    }
}

