/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.Position;
import cds.aladin.UCDFilter;
import cds.aladin.ZoomView;
import cds.xml.Field;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Source
extends Position {
    static final String HCLIC = " - Click on it (or enclose it) to see the measurements";
    protected static final int CARRE = 0;
    protected static final int LOSANGE = 1;
    protected static final int CROIX = 2;
    protected static final int PLUS = 3;
    protected static final int POINT = 4;
    protected static final int DOT = 5;
    static final int MDS = 2;
    static final int L = 3;
    static final int[] LIMIT = new int[]{10, 50, 100, 500, 1500, 4000};
    static final String[] TYPENAME = new String[]{"square", "rhomb", "cross", "plus", "dot", "microdot"};
    protected int sourceType = 0;
    protected String info;
    protected Legende leg;
    private String oid = null;
    Aladin aladin;
    protected double[][][] values = new double[PlanFilter.LIMIT][][];
    boolean[] isSelected = new boolean[PlanFilter.LIMIT];
    Action[][] actions = new Action[PlanFilter.LIMIT][];
    boolean show;
    int dx;
    int dy;
    int dw;
    int dh;
    static int NOID = 0;
    boolean blinkState = false;

    protected Source(Plan plan, double d, double d2, double d3, double d4, int n, String string, String string2, Legende legende) {
        super(plan, d, d2, d3, d4, n, string);
        this.info = string2;
        this.leg = legende;
        this.aladin = plan.aladin;
    }

    protected Source(Plan plan, double d, double d2, String string, String string2) {
        super(plan, 0.0, 0.0, d, d2, 2, string);
        this.info = string2;
        this.aladin = plan.aladin;
    }

    protected Source(Plan plan, double d, double d2, String string, String string2, Legende legende) {
        super(plan, 0.0, 0.0, d, d2, 2, string);
        this.info = string2;
        this.leg = legende;
        this.aladin = plan.aladin;
    }

    protected void blink(Graphics graphics, ZoomView zoomView) {
        Point point = this.getViewCoord(zoomView, 3, 3);
        if (point.x < 0) {
            return;
        }
        this.blinkState ^= true;
        graphics.setColor(Color.red);
        graphics.setXORMode(Color.yellow);
        graphics.drawRect(point.x - 3 - 1, point.y - 3 - 1, 8, 8);
        graphics.drawRect(point.x - 3 - 2, point.y - 3 - 2, 10, 10);
        graphics.setPaintMode();
    }

    protected void deltaPosition(double d, double d2) {
    }

    protected void doDraw(Graphics graphics, Point point, Color color) {
        if (color == null) {
            graphics.setColor(this.plan.c);
        } else {
            graphics.setColor(color);
        }
        this.show = false;
        switch (this.sourceType) {
            case 0: {
                this.drawCarre(graphics, point);
                break;
            }
            case 2: {
                this.drawCroix(graphics, point);
                break;
            }
            case 3: {
                this.drawPlus(graphics, point);
                break;
            }
            case 1: {
                this.drawLosange(graphics, point);
                break;
            }
            case 4: {
                this.drawPoint(graphics, point);
                break;
            }
            case 5: {
                this.drawDot(graphics, point);
                break;
            }
        }
    }

    protected void draw(Graphics graphics, ZoomView zoomView, int n, int n2) {
        Point point = this.getViewCoord(zoomView, 3, 3);
        if (point.x < 0) {
            return;
        }
        point.x += n;
        point.y += n2;
        boolean bl = this.isSelected();
        boolean bl2 = this.noFilterInfluence();
        if (this.select && (bl2 || bl)) {
            graphics.setColor(Color.green);
            graphics.drawRect(point.x - 3 - 1, point.y - 3 - 1, 8, 8);
        }
        int n3 = this.nbFiltersOk();
        if (!bl2 && bl) {
            this.show = false;
            if (n3 == 0) {
                this.doDraw(graphics, point, this.plan.c);
            } else {
                int n4 = 0;
                while (n4 < PlanFilter.allFilters.length) {
                    PlanFilter planFilter = PlanFilter.allFilters[n4];
                    if (planFilter.isOn() && this.plan.influence[planFilter.numero] && this.isSelected[planFilter.numero] && planFilter.flagOk) {
                        if (this.actions[planFilter.numero] == null) {
                            return;
                        }
                        int n5 = 0;
                        while (n5 < this.actions[planFilter.numero].length) {
                            this.actions[planFilter.numero][n5].action(this, graphics, point, planFilter.numero, n5);
                            ++n5;
                        }
                    }
                    ++n4;
                }
            }
        } else if (bl2) {
            this.doDraw(graphics, point, this.plan.c);
        } else if (!bl && n3 == 0) {
            this.doDraw(graphics, point, this.plan.c);
        }
    }

    void drawCarre(Graphics graphics, Point point) {
        if (!this.withlabel) {
            graphics.drawRect(point.x - 3, point.y - 3, 6, 6);
        } else {
            if (this.dx == 0) {
                this.setD();
            }
            graphics.drawLine(point.x + 3, point.y - 3 + this.dy + 2, point.x + 3, point.y + 3);
            graphics.drawLine(point.x - 3, point.y + 3, point.x + 3, point.y + 3);
            graphics.drawLine(point.x - 3, point.y + 3, point.x - 3, point.y - 3);
            graphics.drawLine(point.x - 3, point.y - 3, point.x + 3 - this.dx - 2, point.y - 3);
            graphics.drawString(this.id, point.x + 3 - this.dx, point.y - 3 + this.dy);
        }
    }

    void drawCroix(Graphics graphics, Point point) {
        graphics.drawLine(point.x - 3, point.y - 3, point.x + 3, point.y + 3);
        graphics.drawLine(point.x - 3, point.y + 3, point.x + 3, point.y - 3);
        if (this.withlabel) {
            if (this.dx == 0) {
                this.setD();
            }
            graphics.drawString(this.id, point.x + 3, point.y + this.dy / 2);
        }
    }

    void drawDot(Graphics graphics, Point point) {
        graphics.drawLine(point.x, point.y, point.x, point.y);
        if (this.withlabel) {
            graphics.drawString(this.id, point.x + 2 - this.dx / 2, point.y - 2 + this.dy / 2);
        }
    }

    void drawLosange(Graphics graphics, Point point) {
        graphics.drawLine(point.x, point.y - 3, point.x + 3, point.y);
        graphics.drawLine(point.x + 3, point.y, point.x, point.y + 3);
        graphics.drawLine(point.x, point.y + 3, point.x - 3, point.y);
        graphics.drawLine(point.x - 3, point.y, point.x, point.y - 3);
        if (this.withlabel) {
            graphics.drawString(this.id, point.x + 3 - this.dx, point.y - 3 + this.dy);
        }
    }

    void drawPlus(Graphics graphics, Point point) {
        graphics.drawLine(point.x - 3, point.y, point.x + 3, point.y);
        graphics.drawLine(point.x, point.y - 3, point.x, point.y + 3);
        if (this.withlabel) {
            if (this.dx == 0) {
                this.setD();
            }
            graphics.drawString(this.id, point.x + 3 - this.dx / 2, point.y - 3 + this.dy / 2);
        }
    }

    void drawPoint(Graphics graphics, Point point) {
        graphics.drawLine(point.x - 1, point.y, point.x + 1, point.y);
        graphics.drawLine(point.x, point.y - 1, point.x, point.y + 1);
        if (this.withlabel) {
            graphics.drawString(this.id, point.x + 2 - this.dx / 2, point.y - 2 + this.dy / 2);
        }
    }

    protected int findColumn(String string) {
        String string2 = null;
        Field[] fieldArray = this.leg.field;
        boolean bl = string.indexOf("*") >= 0 || string.indexOf("?") >= 0;
        int n = 0;
        while (n < fieldArray.length) {
            string2 = fieldArray[n].name;
            if (string2 != null && this.match(string, string2, bl)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int findUCD(String string) {
        String string2 = null;
        Field[] fieldArray = this.leg.field;
        boolean bl = string.indexOf("*") >= 0 || string.indexOf("?") >= 0;
        int n = 0;
        while (n < fieldArray.length) {
            String string3;
            string2 = fieldArray[n].ucd;
            if (string2 != null && (!bl || (string3 = this.getValue(n)) != null && string3.trim().length() != 0) && this.match(string, string2, bl)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected String getCatalogue() {
        if (this.info != null) {
            int n;
            int n2;
            int n3 = this.info.indexOf("\t");
            if (n3 < 0) {
                return null;
            }
            String string = this.info.substring(0, n3);
            if (string.startsWith("<&") && (n2 = string.indexOf(124)) > 0 && (n = string.indexOf(62, n2 + 1)) >= 0) {
                string = string.substring(n2 + 1, n);
            }
            return string;
        }
        return null;
    }

    protected Rectangle getClip(ZoomView zoomView) {
        Point point = this.getViewCoord(zoomView, this.dw, this.dh);
        if (!this.withlabel) {
            if (this.select) {
                return new Rectangle(point.x - 3 - 2, point.y - 3 - 2, 10, 10);
            }
            return new Rectangle(point.x - 3, point.y - 3, 6, 6);
        }
        if (this.dx == 0) {
            this.setD();
        }
        if (this.select) {
            return new Rectangle(point.x - 3 - 2, point.y - 3 - this.dh - 2, this.dw + 6 + 4, this.dh + 6 + 4);
        }
        return new Rectangle(point.x - 3, point.y - 3 - this.dh, this.dw + 6, this.dh + 6);
    }

    protected static int getDefaultType(int n) {
        int n2 = 0;
        while (n2 < LIMIT.length && n > LIMIT[n2]) {
            ++n2;
        }
        if (n2 >= LIMIT.length - 1) {
            n2 = LIMIT.length - 2;
        }
        return n2;
    }

    protected String getOID() {
        return this.oid;
    }

    protected String getUnit(int n) {
        if (n < 0) {
            return "";
        }
        return this.leg.field[n].unit;
    }

    protected String getValue(int n) {
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.info, "\t");
        try {
            int n2;
            int n3;
            stringTokenizer.nextElement();
            int n4 = 0;
            while (n4 < n) {
                stringTokenizer.nextElement();
                ++n4;
            }
            string = stringTokenizer.nextElement().toString();
            if (string.startsWith("<&") && (n3 = string.indexOf(124)) > 0 && (n2 = string.indexOf(62, n3 + 1)) >= 0) {
                string = string.substring(n3 + 1, n2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        return string.trim();
    }

    protected void hide(Graphics graphics, ZoomView zoomView) {
        if (!this.show) {
            return;
        }
        this.show = false;
        if (this.blinkState) {
            this.blink(graphics, zoomView);
        }
    }

    void info(Aladin aladin) {
        aladin.mesure.setInfo(this);
    }

    protected boolean inside(double d, double d2, double d3) {
        double d4 = 3.0 / d3;
        return this.x <= d + d4 && this.x >= d - d4 && this.y <= d2 + d4 && this.y >= d2 - d4;
    }

    protected boolean isSelected() {
        int n = 0;
        while (n < PlanFilter.allFilters.length) {
            PlanFilter planFilter = PlanFilter.allFilters[n];
            if (planFilter.isOn() && this.isSelected[planFilter.numero]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean match(String string, String string2, boolean bl) {
        if (bl) {
            return UCDFilter.matchMask(string, string2);
        }
        return string2.equals(string);
    }

    private int nbFiltersOk() {
        int n = 0;
        int n2 = 0;
        while (n2 < PlanFilter.allFilters.length) {
            PlanFilter planFilter = PlanFilter.allFilters[n2];
            if (planFilter.isOn() && planFilter.flagOk && this.plan.influence[planFilter.numero]) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected boolean noFilterInfluence() {
        int n = 0;
        while (n < PlanFilter.allFilters.length) {
            PlanFilter planFilter = PlanFilter.allFilters[n];
            if (planFilter.isOn() && this.plan.influence[planFilter.numero]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void print(Graphics graphics, int n, int n2) {
        Point point = new Point(n, n2);
        boolean bl = this.withlabel;
        this.withlabel = false;
        graphics.setColor(this.plan.c);
        switch (this.sourceType) {
            case 0: {
                this.drawCarre(graphics, point);
                break;
            }
            case 2: {
                this.drawCroix(graphics, point);
                break;
            }
            case 3: {
                this.drawPlus(graphics, point);
                break;
            }
            case 1: {
                this.drawLosange(graphics, point);
                break;
            }
            case 4: {
                this.drawPoint(graphics, point);
                break;
            }
            case 5: {
                this.drawDot(graphics, point);
                break;
            }
        }
        this.withlabel = bl;
    }

    void setD() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Position.DF);
        this.dw = this.dx = fontMetrics.stringWidth(this.id) / 2;
        this.dh = this.dy = Position.HF / 2;
        if (this.dx > 3) {
            this.dx = 2;
            this.dw += this.dw - this.dx;
        }
        if (this.dy > 3) {
            this.dy = 2;
            this.dh += this.dh - this.dy;
        }
    }

    protected void setInfo(String string) {
        this.info = string;
        this.oid = "";
    }

    protected void setLegende(Legende legende) {
        this.leg = legende;
        this.oid = "";
    }

    protected String setOID() {
        this.oid = "Aladin." + ++NOID;
        return this.oid;
    }

    protected void setOID(String string) {
        this.oid = string;
    }

    protected void setPosition(double d, double d2) {
    }

    protected void setSourceType(int n) {
        this.sourceType = n;
    }

    protected void setText(String string) {
        super.setText(string);
        this.dw = 0;
    }

    protected void show(Graphics graphics, ZoomView zoomView) {
        if (this.show) {
            return;
        }
        this.show = true;
        if (!this.blinkState) {
            this.blink(graphics, zoomView);
        }
    }

    protected void status(Aladin aladin) {
        aladin.status.setText("\"" + this.id + "\"" + HCLIC);
    }
}

