/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinServer;
import cds.aladin.ArchivesServer;
import cds.aladin.Calque;
import cds.aladin.Coord;
import cds.aladin.FieldServer;
import cds.aladin.Glu;
import cds.aladin.LocalServer;
import cds.aladin.MyButton;
import cds.aladin.MyLabel;
import cds.aladin.MyPopup;
import cds.aladin.NEDServer;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.SelectDialog;
import cds.aladin.Server;
import cds.aladin.SimbadServer;
import cds.aladin.SurveysServer;
import cds.aladin.VizieRServer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public final class ServerDialog
extends Frame {
    static final int MAXSERVER = 10;
    static int ALADIN = 0;
    static int SIMBAD = 0;
    static int NED = 0;
    static int VIZIER = 0;
    static int FIELD = 0;
    static int LOCAL = 0;
    static final String SUBMIT = "SUBMIT";
    static final String RESET = "Reset";
    static final String CLEAR = "Clear";
    static final String CANCEL = "Close";
    static final String INFO = "Choose an image server or a data server\nand fill in the associated form drawn below";
    Server[] server;
    Panel mp;
    CardLayout card;
    SelectDialog selectDialog;
    Label status;
    MyButton[] buttons;
    int current = 0;
    int bcurrent = 0;
    Aladin aladin;
    Calque calque;

    protected ServerDialog(Aladin aladin) {
        Vector<Server> vector = new Vector<Server>();
        Panel panel = new Panel();
        this.setTitle("Server selector");
        ((Component)this).setBackground(Aladin.BKGD);
        this.aladin = aladin;
        this.calque = aladin.calque;
        this.setFont(Aladin.BOLD);
        this.status = new Label("");
        this.status.setFont(Aladin.BOLD);
        this.status.setForeground(Color.blue);
        vector.addElement(new AladinServer(aladin, this.status));
        this.addGluServer(vector, 0);
        vector.addElement(new LocalServer(aladin, this.status));
        VizieRServer vizieRServer = new VizieRServer(aladin, this.status, this, panel);
        vector.addElement(vizieRServer);
        vector.addElement(new SurveysServer(aladin, this.status, vizieRServer.vSurveys));
        vector.addElement(new ArchivesServer(aladin, this.status, vizieRServer.vArchives));
        vector.addElement(new SimbadServer(aladin, this.status));
        vector.addElement(new NEDServer(aladin, this.status));
        this.addGluServer(vector, 1);
        vector.addElement(new FieldServer(aladin, this.status));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        Aladin.makeAdd(panel2, new MyLabel(INFO, 1, Aladin.PLAIN), "Center");
        Aladin.makeAdd(panel2, new MyLabel(" \n Image servers:", 0, Aladin.BOLD), "West");
        Aladin.makeAdd(panel2, new MyLabel(" \nData servers : ", 1, Aladin.BOLD), "East");
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        panel3.setLayout(new GridLayout(0, 1));
        panel4.setLayout(new GridLayout(0, 1));
        this.server = new Server[vector.size()];
        this.buttons = new MyButton[vector.size()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.server.length) {
            this.server[n3] = (Server)vector.elementAt(n3);
            if (this.server[n3] instanceof LocalServer) {
                if (Aladin.STANDALONE) {
                    while (n < 5) {
                        panel3.add(new Canvas());
                        ++n;
                    }
                    panel3.add(new MyLabel(" \nFile access:", 1, Aladin.BOLD));
                }
                LOCAL = n3;
            } else if (this.server[n3] instanceof FieldServer) {
                while (n2 < 5) {
                    panel4.add(new Canvas());
                    ++n2;
                }
                panel4.add(new Canvas());
                FIELD = n3;
            } else if (this.server[n3] instanceof VizieRServer) {
                VIZIER = n3;
            } else if (this.server[n3] instanceof AladinServer) {
                ALADIN = n3;
            } else if (this.server[n3] instanceof NEDServer) {
                NED = n3;
            } else if (this.server[n3] instanceof SimbadServer) {
                SIMBAD = n3;
            }
            if (this.server[n3].myPopup == null && (Aladin.STANDALONE || !Aladin.STANDALONE && !(this.server[n3] instanceof LocalServer))) {
                if (this.server[n3].type == 0) {
                    this.buttons[n3] = new MyButton(aladin, this.status, 1, this.server[n3].nom, this.server[n3].info);
                    panel3.add(this.buttons[n3]);
                    ++n;
                } else {
                    this.buttons[n3] = new MyButton(aladin, this.status, 2, this.server[n3].nom, this.server[n3].info);
                    panel4.add(this.buttons[n3]);
                    ++n2;
                }
                this.buttons[n3].setAlwaysUp(false);
            }
            ++n3;
        }
        vector = null;
        this.buttons[this.bcurrent].push();
        this.setFont(Aladin.PLAIN);
        this.mp = new Panel();
        this.card = new CardLayout();
        this.mp.setLayout(this.card);
        n3 = 0;
        while (n3 < this.server.length) {
            if (this.server[n3] != null && (Aladin.STANDALONE || n3 != LOCAL)) {
                this.mp.add(this.server[n3].nom, this.server[n3]);
            }
            ++n3;
        }
        this.selectDialog = new SelectDialog(this, this.mp);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        Aladin.makeAdd(panel5, panel3, "West");
        Aladin.makeAdd(panel5, this.selectDialog, "Center");
        Aladin.makeAdd(panel5, panel4, "East");
        MyButton myButton = new MyButton(aladin, SUBMIT);
        panel.add(myButton);
        this.setFont(Aladin.BOLD);
        panel.add(new Button(RESET));
        panel.add(new Button(CLEAR));
        panel.add(new Button(CANCEL));
        panel.setFont(Aladin.BOLD);
        myButton.setFont(Aladin.LBOLD);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        Aladin.makeAdd(panel6, this.status, "Center");
        Aladin.makeAdd(panel6, panel, "East");
        this.setLayout(new BorderLayout(5, 5));
        Aladin.makeAdd(this, panel2, "North");
        Aladin.makeAdd(this, panel5, "Center");
        Aladin.makeAdd(this, panel6, "South");
        this.move(300, 200);
        this.pack();
    }

    public boolean action(Event event, Object object) {
        if ("Grab coord".equals(object)) {
            this.startGrabIt();
            return true;
        }
        if (CANCEL.equals(object)) {
            this.server[this.current].memTarget();
            this.aladin.message.hide();
            this.cache();
            return true;
        }
        if (CLEAR.equals(object)) {
            this.server[this.current].reset();
            return true;
        }
        if (SUBMIT.equals(object)) {
            this.server[this.current].submit();
            return true;
        }
        if (RESET.equals(object)) {
            this.server[this.current].reset();
            this.setTarget(this.current);
            return true;
        }
        this.server[this.current].memTarget();
        int n = 0;
        while (n < this.server.length) {
            if (this.server[n] != null && this.server[n].nom.equals(object)) {
                this.setTarget(n);
                this.current = n;
                this.bcurrent = this.server[n].myPopup != null ? this.findIndiceServer(this.server[n].myPopup) : n;
                this.selectDialog.repaint();
                this.popOtherButton();
                this.card.show(this.mp, this.server[n].nom);
                if (this.server[n] instanceof VizieRServer) {
                    ((VizieRServer)this.server[VIZIER]).hideSFrame();
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private void addGluServer(Vector vector, int n) {
        Enumeration enumeration = Glu.vGluServer.elements();
        int n2 = Glu.vGluServer.size() - 1;
        while (n2 >= 0) {
            Server server = (Server)Glu.vGluServer.elementAt(n2);
            if (server.type == n) {
                if (server.myPopup == null) {
                    vector.addElement(server);
                } else {
                    int n3 = vector.size() - 1;
                    while (n3 >= 0) {
                        Server server2 = (Server)vector.elementAt(n3);
                        if (server2.nom.equals(server.myPopup) && server2 instanceof MyPopup) break;
                        --n3;
                    }
                    if (n3 < 0) {
                        n3 = vector.size();
                        vector.addElement(new MyPopup(this.aladin, server.myPopup, n3, n == 0 ? 0 : 1));
                    }
                    ((MyPopup)vector.elementAt(n3)).addItem(server.nom);
                    vector.addElement(server);
                }
            }
            --n2;
        }
    }

    protected void cache() {
        ((VizieRServer)this.server[VIZIER]).hideSFrame();
        this.dispose();
    }

    private int findIndiceServer(String string) {
        int n = 0;
        while (n < this.server.length) {
            if (this.server[n].nom.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected String getDefaultRadius() {
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan == null || plan.projd == null) {
            return "";
        }
        return String.valueOf(Math.floor(plan.projd.rm / 2.0 * 1.4142));
    }

    protected String getDefaultTarget() {
        return Server.defaultTarget.trim();
    }

    protected int getServer(String string) {
        int n = 0;
        while (n < this.server.length) {
            if (this.server[n].is(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.cache();
        }
        return super.handleEvent(event);
    }

    protected boolean isGrabIt() {
        return this.server[this.current].coo != null && this.server[this.current].grab != null && this.server[this.current].grab.mode == -1;
    }

    void popOtherButton() {
        int n = 0;
        while (n < this.buttons.length) {
            if (n != this.bcurrent && this.buttons[n] != null) {
                this.buttons[n].pop();
            }
            ++n;
        }
    }

    protected void setGrab() {
        Plan plan = this.aladin.calque.getPlanRef();
        boolean bl = plan != null && plan.projd != null;
        int n = 0;
        while (n < this.server.length) {
            if (this.server[n] != null && this.server[n].grab != null) {
                this.server[n].grab.enable(bl);
            }
            ++n;
        }
    }

    protected void setGrabItCoord(int n, int n2) {
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan == null) {
            return;
        }
        Projection projection = plan.projd;
        if (projection == null) {
            return;
        }
        Point point = this.aladin.calque.zoom.zoomView.getPosition(n, n2);
        Coord coord = new Coord();
        coord.x = point.x;
        coord.y = point.y;
        projection.getCoord(coord);
        this.server[this.current].setTarget(coord.getSexa());
    }

    protected void setGrabItRadius(int n, int n2, int n3, int n4) {
        if (this.server[this.current].rad == null) {
            return;
        }
        if (Math.abs(n - n3) < 3 && Math.abs(n2 - n4) < 3) {
            return;
        }
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan == null) {
            return;
        }
        Projection projection = plan.projd;
        if (projection == null) {
            return;
        }
        Point point = this.aladin.calque.zoom.zoomView.getPosition(n, n2);
        Point point2 = this.aladin.calque.zoom.zoomView.getPosition(n3, n4);
        Coord coord = new Coord();
        coord.x = point.x;
        coord.y = point.y;
        projection.getCoord(coord);
        Coord coord2 = new Coord();
        coord2.x = point2.x;
        coord2.y = point2.y;
        projection.getCoord(coord2);
        this.server[this.current].setRadius(Coord.getUnit(Coord.getDist(coord, coord2)));
    }

    protected synchronized void setTarget(int n) {
        String string = null;
        Object var3_3 = null;
        Plan plan = null;
        String string2 = null;
        Object var6_6 = null;
        Coord coord = null;
        double d = 0.0;
        if (n == LOCAL) {
            return;
        }
        string = this.getDefaultTarget();
        if (string.length() == 0) {
            string = null;
        }
        if ((plan = this.aladin.calque.getPlanRef()) != null && plan.projd != null) {
            string2 = plan.objet;
            coord = new Coord();
            coord.al = plan.projd.raj;
            coord.del = plan.projd.dej;
            d = plan.projd.rm;
        }
        this.server[n].setTarget((String)(string != null ? string : (string2 != null ? string2 : (var3_3 != null ? var3_3 : ""))));
        if (d != 0.0) {
            this.server[n].setRad(d);
        }
    }

    public void show() {
        this.status.setText("");
        this.setTarget(this.current);
        super.show();
    }

    protected void startGrabIt() {
        if (this.server[this.current].grab == null || this.server[this.current].grab.mode != -1) {
            return;
        }
        Aladin.f.toFront();
    }

    protected void stopGrabIt() {
        MyButton myButton = this.server[this.current].grab;
        if (myButton != null) {
            Plan plan = this.aladin.calque.getPlanRef();
            myButton.enable(plan != null && plan.projd != null);
        }
        this.toFront();
    }
}

