/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.FilterProperties;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.Properties;
import cds.aladin.Slide;
import cds.aladin.Target;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public final class Select
extends Canvas
implements Runnable {
    static final String HELP_STACK = "Plane stack - click to see/mask it, or drag it to change its position";
    static final String HELP_EYE = "Eye view - click to activate all available planes";
    static final String HELP_REFIN = "Reference selector - indicate the current reference projection";
    static final String HELP_REFOUT = "Reference selector - click on it to select; this image as the new reference projection";
    static final String WAITMIN = "Please be patient...\nThis plane is under construction !";
    static final String NOPROJ = "These planes cannot be superimposed.\nRegions do not overlap !";
    Aladin a;
    Target target;
    PopupMenu popMenu;
    Vector slides = null;
    static boolean firstEye = true;
    boolean flagDrag = false;
    Plan currentPlan = null;
    int x;
    int y;
    int oldy;
    Polygon logo;
    Rectangle r;
    boolean flagRClip;
    int oldxDrag;
    int oldyDrag;
    boolean clinDoeil = false;
    Thread clin = null;
    boolean flagShift;
    Plan newRef = null;
    Plan planIn = null;
    Thread thread = null;
    static final int sizeLabel = 94;
    static final int gapL = 11;
    static final int gapB = 5;
    static final int DX = 35;
    static final int[] frX = new int[]{17, 11, 46, 40, 17};
    static final int[] frY = new int[]{1, 14, 14, 1, 1};
    static final int frMin = frX[1];
    static final int frMax = frX[2];
    static final int m = (frX[2] + frX[1]) / 2;
    static int[] o1x;
    static int[] o1y;
    static int[] o2x;
    static int[] o2y;
    static int[] o3x;
    static int[] o3y;
    static int o4d;
    static int o4xc;
    static int o4yc;
    static int eyeWidth;
    static int eyeHeight;
    int ws = frMax + 94;
    int hs;
    int hsp;
    Image img;
    Graphics g;
    MenuItem menuShow;
    MenuItem menuSelect;
    MenuItem menuRef;
    MenuItem menuDel;
    MenuItem menuDelAll;
    MenuItem menuColl;
    MenuItem menuCreatFold;
    MenuItem menuInsertFold;
    MenuItem menuProp;
    MenuItem menuFilter;
    Vector menuPlan = null;
    Plan memSupprPlan = null;
    static int folderN;
    private int oc = 0;

    static {
        int[] nArray = new int[9];
        nArray[1] = 10;
        nArray[2] = 22;
        nArray[3] = 36;
        nArray[4] = 36;
        nArray[5] = 22;
        nArray[6] = 10;
        o1x = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = 6;
        nArray2[1] = 2;
        nArray2[3] = 8;
        nArray2[4] = 11;
        nArray2[5] = 3;
        nArray2[6] = 5;
        nArray2[7] = 10;
        nArray2[8] = 6;
        o1y = nArray2;
        o2x = new int[]{2, 3, 12, 18, 24, 32, 36, 36, 32, 18, 6, 2, 2};
        o2y = new int[]{18, 18, 12, 10, 12, 18, 20, 24, 22, 24, 20, 22, 18};
        o3x = new int[]{6, 16, 22, 28, 30, 18, 6};
        o3y = new int[]{18, 12, 14, 19, 19, 21, 18};
        o4d = o3y[5] - o2y[3];
        o4xc = o2x[3] - o4d / 2;
        o4yc = (o2y[3] + o3y[5]) / 2 - o4d / 2;
        eyeWidth = o1x[3];
        eyeHeight = o2y[7];
        folderN = 0;
    }

    protected Select(Calque calque, Aladin aladin) {
        this.a = aladin;
        this.hs = Aladin.LSCREEN ? 291 : 200;
        this.hsp = this.hs - eyeHeight - 5;
        this.resize(this.ws, this.hs);
        this.createPopupMenu();
    }

    protected String Help() {
        return "!Plane stack\nControl the current projection according to the planes. \n \nA plane can be an image, a data chart or some additional graphic elements (see the menu Load...).The eye of the observer is at the top of the stack and sees the projection of all active planes in the ``view window''. A specific logo in the plane icon shows its type.\nThe status of a plane is specified by a little colored signal to the right of its name.\nThe target and radius of the current projection is displayed at the top of this window.\n \n- Click on a plane icon to ask to activate it according to   the current projection. Click on the eye to project all possible planes.\n- Click on a plane name to select it; then the tool buttons which are   authorized for this kind of plane are activated.   Maintain the Shift key to select several planes together\n- Click and drag the plane icons to change the order of the display in   the stack. The first image hides all planes underneath.";
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.menuCreatFold) {
            this.a.calque.newFolder(this.getDefaultFolderLabel());
        } else if (event.target == this.menuInsertFold) {
            this.insertFolder();
        } else if (event.target == this.menuDel) {
            this.a.calque.FreeSet();
        } else if (event.target == this.menuDelAll) {
            this.a.calque.FreeAll();
        } else if (event.target == this.menuRef) {
            this.a.calque.setPlanRef((Plan)this.menuPlan.elementAt(0));
        } else if (event.target == this.menuShow) {
            boolean bl = this.menuShow.getLabel().startsWith("Show");
            int n = this.menuPlan.size() - 1;
            while (n >= 0) {
                ((Plan)this.menuPlan.elementAt((int)n)).active = bl;
                --n;
            }
        } else if (event.target == this.menuSelect) {
            this.a.view.calque.selectAllObjectInPlans();
        } else if (event.target == this.menuFilter) {
            this.a.view.calque.newPlanFilter();
        } else if (event.target == this.menuColl) {
            boolean bl = this.menuShow.getLabel().startsWith("Coll");
            int n = this.menuPlan.size() - 1;
            while (n >= 0) {
                this.switchCollapseFolder((Plan)this.menuPlan.elementAt(n));
                --n;
            }
        } else if (event.target == this.menuProp) {
            if (this.a.properties == null) {
                Aladin.trace(1, "Creating the Propertie window");
                this.a.properties = new Properties(this.a);
            }
            if (this.a.filterProperties == null) {
                Aladin.trace(1, "Creating the FilterProperties window");
                this.a.filterProperties = new FilterProperties(this.a);
            }
            this.a.toolbox.tool[7].mode = -1;
            this.a.toolbox.repaint();
            this.a.properties.majProp();
            this.a.filterProperties.majProp();
        } else {
            return false;
        }
        this.a.calque.repaint();
        return true;
    }

    protected void afterYes() {
        if (this.memSupprPlan != null) {
            this.a.calque.unSelectAllPlan();
            this.memSupprPlan.selected = true;
            this.a.calque.FreeSet();
        }
        this.memSupprPlan = null;
    }

    private void blink() {
        if (!Slide.flagBlink) {
            return;
        }
        if (this.thread != null) {
            this.thread.stop();
        }
        Slide.blinkState ^= true;
        this.thread = new Thread(this);
        this.thread.setPriority(4);
        this.thread.start();
    }

    protected Plan createFolder(Plan plan) {
        int n = 0;
        while (n < this.a.calque.plan.length && this.a.calque.plan[n] != plan) {
            ++n;
        }
        int n2 = this.a.calque.newFolder(plan.objet == null ? this.getDefaultFolderLabel() : plan.objet);
        Plan plan2 = this.a.calque.plan[n2];
        this.permute(n2, n);
        return plan2;
    }

    private void createPopupMenu() {
        this.popMenu = new PopupMenu();
        this.menuShow = new MenuItem("Show");
        this.popMenu.add(this.menuShow);
        this.menuSelect = new MenuItem("Select all objects of the selected planes");
        this.popMenu.add(this.menuSelect);
        this.menuRef = new MenuItem("Take as the projection reference");
        this.popMenu.add(this.menuRef);
        this.menuDel = new MenuItem("Delete");
        this.popMenu.add(this.menuDel);
        this.menuDelAll = new MenuItem("Delete all planes...");
        this.popMenu.add(this.menuDelAll);
        this.popMenu.addSeparator();
        this.menuFilter = new MenuItem("Create a new filter");
        this.popMenu.add(this.menuFilter);
        this.popMenu.addSeparator();
        this.menuCreatFold = new MenuItem("Create a new folder");
        this.popMenu.add(this.menuCreatFold);
        this.menuInsertFold = new MenuItem("Insert in a new folder");
        this.popMenu.add(this.menuInsertFold);
        this.menuColl = new MenuItem("Collapse");
        this.popMenu.add(this.menuColl);
        this.popMenu.addSeparator();
        this.menuProp = new MenuItem("Properties of the selected plane");
        this.popMenu.add(this.menuProp);
        super.add(this.popMenu);
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    void drawEye(Graphics graphics, boolean bl) {
        if (firstEye) {
            int n = 0;
            while (n < o1x.length) {
                int n2 = n++;
                o1x[n2] = o1x[n2] + 11;
            }
            n = 0;
            while (n < o2x.length) {
                int n3 = n++;
                o2x[n3] = o2x[n3] + 11;
            }
            n = 0;
            while (n < o3x.length) {
                int n4 = n++;
                o3x[n4] = o3x[n4] + 11;
            }
            o4xc += 11;
            firstEye = false;
        }
        graphics.setColor(Color.black);
        graphics.fillPolygon(o1x, o1y, o1x.length);
        graphics.fillPolygon(o2x, o2y, o2x.length);
        if (bl) {
            graphics.setColor(Color.white);
            graphics.fillPolygon(o3x, o3y, o3x.length);
            graphics.setColor(Color.black);
            graphics.fillOval(o4xc, o4yc, o4d, o4d);
        }
    }

    protected void folder(Plan plan, Plan plan2) {
        if (plan2.type != 5) {
            return;
        }
        int n = 0;
        while (n < this.a.calque.plan.length && this.a.calque.plan[n] != plan2) {
            ++n;
        }
        if (n >= this.a.calque.plan.length - 1) {
            return;
        }
        plan2 = this.a.calque.plan[n + 1];
        this.permute(plan, plan2);
    }

    private String getDefaultFolderLabel() {
        return "Fold. " + ++folderN;
    }

    protected Plan getPlan(int n) {
        Slide slide = this.getSlide(n);
        return slide == null ? null : slide.getPlan();
    }

    protected Slide getSlide(int n) {
        if (this.slides == null) {
            return null;
        }
        Enumeration enumeration = this.slides.elements();
        while (enumeration.hasMoreElements()) {
            Slide slide = (Slide)enumeration.nextElement();
            if (!slide.in(n)) continue;
            return slide;
        }
        return null;
    }

    protected Slide getSousSlide(int n) {
        if (this.slides == null) {
            return null;
        }
        Enumeration enumeration = this.slides.elements();
        while (enumeration.hasMoreElements()) {
            Slide slide = (Slide)enumeration.nextElement();
            if (!slide.sous(n)) continue;
            return slide;
        }
        return null;
    }

    private void handCursor() {
        this.makeCursor(2);
    }

    public boolean handleEvent(Event event) {
        if (Aladin.inHelp) {
            if (event.id == 504) {
                this.a.help.setText(this.Help());
            }
            return true;
        }
        return super.handleEvent(event);
    }

    protected boolean inEye(int n, int n2) {
        return n - 11 < eyeWidth && n2 < eyeHeight;
    }

    private void insertFolder() {
        Enumeration enumeration = this.menuPlan.elements();
        Plan plan = (Plan)enumeration.nextElement();
        Plan plan2 = this.createFolder(plan);
        while (true) {
            this.permute(plan, plan2);
            plan2 = plan;
            if (!enumeration.hasMoreElements()) {
                return;
            }
            plan = (Plan)enumeration.nextElement();
        }
    }

    private void makeCursor(int n) {
        if (this.oc == n) {
            return;
        }
        Aladin.makeCursor(this, n);
        this.oc = n;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.a.message.hide();
        if (this.a.msgOn) {
            this.a.endMsg();
        }
        boolean bl = this.flagShift = event.shiftDown() || event.controlDown();
        if (event.modifiers != 0 && !this.flagShift) {
            this.showPopMenu(n, n2);
            return true;
        }
        if (this.inEye(n, n2)) {
            this.a.calque.activeRSPlan();
            this.a.calque.view.repaint();
            this.clinDoeil = true;
            this.repaint();
            return true;
        }
        this.currentPlan = this.getPlan(n2);
        if (this.currentPlan == null) {
            return true;
        }
        this.x = n;
        this.y = n2;
        this.oldy = n2;
        if (n < frMin) {
            if (!this.planOk(this.currentPlan) || this.currentPlan.ref) {
                return true;
            }
            if (this.currentPlan.type != 1 && !event.shiftDown()) {
                return true;
            }
            this.newRef = this.currentPlan;
            this.repaint();
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (n < 11 || this.currentPlan == null) {
            return true;
        }
        if (Math.abs(this.oldy - n2) >= 4) {
            this.flagDrag = true;
            this.x = n;
            this.y = n2;
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.defaultCursor();
        this.planIn = null;
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        Slide slide = this.getSlide(n2);
        Plan plan = slide == null ? null : slide.getPlan();
        this.planIn = null;
        if (slide != null && slide.inLogo(n)) {
            if (plan == null) {
                this.handCursor();
            } else if (plan.type != 0) {
                this.moveCursor();
            } else {
                this.defaultCursor();
            }
            this.a.status.setText(HELP_STACK);
            return true;
        }
        if (this.inEye(n, n2)) {
            this.handCursor();
            this.a.status.setText(HELP_EYE);
            return true;
        }
        if (plan == null) {
            this.defaultCursor();
            return true;
        }
        if (slide != null && slide.inRef(n)) {
            if (plan.ref || plan.type == 1) {
                this.handCursor();
                if (plan.ref) {
                    this.a.status.setText(HELP_REFIN);
                } else {
                    this.a.status.setText(HELP_REFOUT);
                }
                return true;
            }
            this.defaultCursor();
            return false;
        }
        this.planIn = plan;
        if (plan.type != 0) {
            if (!plan.flagOk && plan.error == null) {
                this.waitCursor();
            } else {
                this.handCursor();
            }
            plan.getInfo();
        } else {
            this.defaultCursor();
            this.a.status.setText("");
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        boolean bl = false;
        this.x = n;
        this.y = n2;
        if (this.flagDrag) {
            this.flagDrag = false;
            this.oldxDrag = -1;
            Slide slide = this.getSousSlide(n2);
            if (slide == null) {
                this.repaint();
                return true;
            }
            Plan plan = slide.getPlan();
            if (this.currentPlan != plan) {
                this.permute(this.currentPlan, plan);
                this.a.calque.view.repaint();
                this.a.calque.zoom.zoomView.repaint();
            }
            this.repaint();
            return true;
        }
        Slide slide = this.getSlide(n2);
        if (slide == null) {
            return true;
        }
        Plan plan = slide.getPlan();
        if (this.newRef != null) {
            if (this.a.calque.setPlanRef(plan)) {
                plan.active = true;
                if (plan.projd != null) {
                    this.a.calque.activeAllPlan();
                }
                this.a.calque.view.newView();
                bl = true;
            }
            this.newRef = null;
        } else if (slide.inLogo(n) && plan.type != 0) {
            if (plan.type == 5) {
                if (event.clickCount > 1) {
                    this.switchCollapseFolder(plan);
                } else {
                    this.switchActiveFolder(plan);
                }
            } else if (plan.type == 6) {
                plan.active ^= true;
                ((PlanFilter)plan).updateState();
            } else {
                if (!this.planOk(plan)) {
                    return true;
                }
                if (!(plan.projd == null && plan.ref || plan.isViewable())) {
                    this.a.message.warning(NOPROJ);
                    return true;
                }
                plan.active ^= true;
                if (plan.type == 2 && plan.active) {
                    PlanFilter.updatePlan(plan);
                }
            }
            bl = true;
        }
        int n3 = 0;
        if (plan.type == 0) {
            return true;
        }
        this.planOk(plan);
        if (plan.type == 1 && ((PlanImage)plan).o != null) {
            this.a.calque.view.selectOne(((PlanImage)plan).o);
        }
        int n4 = 0;
        while (n4 < this.a.calque.plan.length) {
            if (this.a.calque.plan[n4].selected) {
                ++n3;
                if (this.a.calque.plan[n4].type == 0) {
                    this.a.calque.plan[n4].active = false;
                    if (this.flagShift) {
                        this.a.calque.plan[n4].selected = false;
                    }
                }
                if (!this.flagShift) {
                    this.a.calque.plan[n4].selected = false;
                }
            }
            ++n4;
        }
        plan.selected = this.flagShift ? n3 <= 1 || !plan.selected : true;
        if (!this.flagShift && plan.type == 0) {
            plan.active = true;
        }
        if (bl) {
            this.a.calque.repaint();
        } else {
            this.repaint();
            this.a.toolbox.toolMode();
        }
        return false;
    }

    private void moveCursor() {
        this.makeCursor(4);
    }

    void moveLogo(Graphics graphics) {
        this.logo = new Polygon(frX, frY, frX.length);
        int n = m;
        int n2 = (frY[1] + frY[0]) / 2;
        int n3 = 0;
        while (n3 < this.logo.npoints) {
            int n4 = n3;
            this.logo.xpoints[n4] = this.logo.xpoints[n4] + (this.x - n);
            int n5 = n3++;
            this.logo.ypoints[n5] = this.logo.ypoints[n5] + (this.y - n2);
        }
        int n6 = frX[2] - frX[1] + 8;
        int n7 = frY[1] - frY[0] + 8;
        graphics.clipRect(this.oldxDrag - 4, this.oldyDrag - 4, n6, n7);
        this.oldxDrag = this.x - (m - frX[1]) - 1;
        this.oldyDrag = this.y - n2 - 1;
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.img == null || this.g == null || this.img.getWidth(this) != this.size().width || this.img.getHeight(this) != this.size().height) {
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.img, 0, 0, null);
        if (this.flagDrag) {
            graphics.drawPolygon(this.logo);
        }
        if (this.clinDoeil) {
            this.drawEye(graphics, false);
            this.flagRClip = false;
            this.clinDoeil = false;
            this.repaint(400L);
        }
        this.blink();
    }

    public void permute(int n, int n2) {
        this.permute(n, n2, 1);
    }

    public void permute(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n < n2 ? 1 : -1;
        if (n4 == -1) {
            ++n2;
        }
        Plan[] planArray = this.a.calque.plan;
        synchronized (planArray) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = n4 == -1 ? n + n6 : n;
                int n8 = n4 == -1 ? n2 + n6 : n2;
                Plan plan = this.a.calque.plan[n7];
                while (n7 != n8) {
                    this.a.calque.plan[n7] = this.a.calque.plan[n7 + n4];
                    int n9 = n7 + n4;
                    n7 += n4;
                }
                this.a.calque.plan[n8] = plan;
                ++n6;
            }
        }
    }

    public void permute(Plan plan, Plan plan2) {
        int n;
        Plan[] planArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        n5 = plan2.folder;
        if (plan2.type == 5) {
            ++n5;
        }
        if (plan.type == 5) {
            planArray = this.a.calque.getFolderPlan(plan);
            int n6 = n5 - plan.folder;
            plan.folder += n6;
            n = 0;
            while (n < planArray.length) {
                planArray[n].folder += n6;
                ++n;
            }
            n4 = planArray.length + 1;
        } else {
            plan.folder = n5;
        }
        planArray = this.a.calque.plan;
        synchronized (planArray) {
            n = 0;
            while (n < this.a.calque.plan.length) {
                if (plan == this.a.calque.plan[n]) {
                    n2 = n;
                } else if (plan2 == this.a.calque.plan[n]) {
                    n3 = n;
                }
                ++n;
            }
            this.permute(n2, n3, n4);
        }
        if (plan.type == 2) {
            PlanFilter.updatePlan(plan, n2, n3);
            return;
        }
        if (plan2.type == 2) {
            PlanFilter.updatePlan(plan2, n3, n2);
            return;
        }
        if (plan.type == 6) {
            ((PlanFilter)plan).positionChange();
        }
        if (plan2.type == 6) {
            ((PlanFilter)plan2).positionChange();
        }
    }

    protected boolean planOk(Plan plan) {
        if (plan.type != 0 && plan.type != 6 && !plan.flagOk) {
            if (plan.error == null) {
                String string = plan.type == 1 ? "Please be patient...\nThis plane is under construction !\n \n" + ((PlanImage)plan).getStatus() : WAITMIN;
                this.a.message.warning(string);
            } else {
                this.a.message.yesOrNo(this, String.valueOf(plan.error) + "\nDo you want to remove this plan ?");
                this.memSupprPlan = plan;
            }
            return false;
        }
        return true;
    }

    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {}
        this.repaint();
        this.thread.stop();
    }

    protected void selectPlan(int n) {
        int n2 = 0;
        while (n2 < this.a.calque.plan.length) {
            this.a.calque.plan[n2].selected = false;
            ++n2;
        }
        this.a.calque.plan[n].selected = true;
    }

    protected void setTarget(Target target) {
        this.target = target;
    }

    private void showPopMenu(int n, int n2) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        this.menuPlan = new Vector(10);
        int n3 = 0;
        while (n3 < this.a.calque.plan.length) {
            if (this.a.calque.plan[n3].selected) {
                this.menuPlan.addElement(this.a.calque.plan[n3]);
                bl = bl && this.a.calque.plan[n3].active;
                boolean bl6 = bl4 = bl4 && this.a.calque.plan[n3].type == 5;
                if (this.a.calque.plan[n3].type == 2) {
                    bl5 = true;
                }
                bl2 = bl2 && this.a.calque.isCollapsed(this.a.calque.plan[n3]);
                bl3 = this.a.calque.canBeRef(n3) && !this.a.calque.plan[n3].ref && this.a.calque.plan[n3].flagOk;
            }
            ++n3;
        }
        boolean bl7 = bl3 = bl3 && this.menuPlan.size() == 1;
        if (!bl) {
            this.menuShow.setLabel("Show the selected planes");
        } else {
            this.menuShow.setLabel("Hide the selected planes");
        }
        if (!bl2) {
            this.menuColl.setLabel("Collapse the selected folders");
        } else {
            this.menuColl.setLabel("Expand the selected folders");
        }
        this.menuColl.setEnabled(bl4 && this.menuPlan.size() > 0);
        this.menuInsertFold.setEnabled(this.menuPlan.size() > 0);
        this.menuSelect.setEnabled(bl5);
        this.menuRef.setEnabled(bl3);
        this.menuProp.setEnabled(this.menuPlan.size() == 1);
        this.menuShow.setEnabled(this.menuPlan.size() > 0);
        this.menuDel.setEnabled(this.menuPlan.size() > 0);
        this.menuDelAll.setEnabled(this.menuPlan.size() > 0);
        this.popMenu.show(this, n, n2);
    }

    private void switchActiveFolder(Plan plan) {
        Plan[] planArray = this.a.calque.getFolderPlan(plan);
        if (planArray == null || planArray.length == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n < planArray.length) {
            if (planArray[n].active) {
                ++n2;
            }
            ++n;
        }
        boolean bl = n2 != planArray.length;
        n = 0;
        while (n < planArray.length) {
            planArray[n].active = bl;
            ++n;
        }
        plan.active = bl;
    }

    private void switchCollapseFolder(Plan plan) {
        Plan[] planArray = this.a.calque.getFolderPlan(plan);
        if (planArray == null || planArray.length == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < planArray.length) {
            if (planArray[n].folder == plan.folder + 1) {
                ++n3;
                if (planArray[n].collapse) {
                    ++n2;
                }
            }
            ++n;
        }
        boolean bl = n2 != n3;
        n = 0;
        while (n < planArray.length) {
            if (!bl) {
                if (planArray[n].folder == plan.folder + 1) {
                    planArray[n].collapse = bl;
                }
            } else {
                planArray[n].collapse = bl;
            }
            ++n;
        }
    }

    public void update(Graphics graphics) {
        int n;
        this.ws = this.size().width;
        this.hs = this.size().height;
        this.hsp = this.hs - eyeHeight - 5;
        if (this.img == null || this.img.getWidth(this) != this.ws || this.img.getHeight(this) != this.hs) {
            if (this.g != null) {
                this.g.dispose();
            }
            this.img = this.createImage(this.ws, this.hs);
            this.g = this.img.getGraphics();
            this.g.setColor(Aladin.LGRAY);
            this.g.fillRect(0, 0, this.ws, this.hs);
            this.g.setColor(Color.black);
            this.g.drawLine(0, 0, 0, this.hs - 1);
            this.g.setColor(Color.white);
            this.g.drawLine(0, this.hs - 1, this.ws - 1, this.hs - 1);
            this.g.drawLine(this.ws - 1, this.hs - 1, this.ws - 1, 0);
        }
        if (this.flagDrag) {
            this.moveLogo(graphics);
            return;
        }
        this.g.setColor(Aladin.LGRAY);
        this.g.fillRect(1, 1, this.ws - 2, this.hs - 2);
        this.g.clipRect(1, 1, this.ws - 2, this.hs - 2);
        this.drawEye(this.g, true);
        this.writeTitle(this.g);
        int n2 = this.a.calque.getIndexPlanBase();
        int n3 = n = n2 >= 0 && this.a.calque.plan[n2] instanceof PlanImageRGB ? n2 : -1;
        if (n2 < 0) {
            n2 = this.a.calque.plan.length;
        }
        Slide.setBlink(false);
        this.slides = new Vector(20);
        int n4 = this.hs - 22;
        int n5 = this.hs - 2;
        int n6 = this.a.calque.getLastVisiblePlan() - 1;
        while (n6 >= 0 && n4 > eyeHeight) {
            Slide slide = new Slide(this.a.calque.plan[n6]);
            this.slides.addElement(slide);
            if (n2 == n6) {
                n5 = n4;
            }
            n4 = slide.draw(this.g, n4, n, this.newRef == this.a.calque.plan[n6] || this.newRef == null && this.a.calque.plan[n6].ref);
            --n6;
        }
        if (this.newRef != null) {
            this.paint(graphics);
            return;
        }
        this.target.repaint();
        if (this.a.properties != null) {
            this.a.properties.majProp();
        }
        if (this.a.filterProperties != null) {
            this.a.filterProperties.majProp();
        }
        if (this.a.frameCM != null) {
            this.a.frameCM.majCM();
        }
        if (this.a.frameContour != null) {
            this.a.frameContour.majContour();
        }
        if (this.a.frameRGB != null) {
            this.a.frameRGB.majRGB();
        }
        if (this.planIn != null) {
            this.planIn.getInfo();
        }
        this.paint(graphics);
    }

    private void waitCursor() {
        this.makeCursor(1);
    }

    void writeTitle(Graphics graphics) {
        Plan plan = this.a.calque.getPlanRef();
        if (plan == null || plan.objet == null) {
            return;
        }
        graphics.setFont(Aladin.LBOLD);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics(Aladin.LBOLD);
        int n = this.ws - (11 + eyeWidth);
        int n2 = fontMetrics.stringWidth(plan.objet);
        if (n2 > n) {
            graphics.setFont(Aladin.ITALIC);
            fontMetrics = graphics.getFontMetrics(Aladin.BOLD);
            n2 = fontMetrics.stringWidth(plan.objet);
        }
        if (n2 > 94) {
            return;
        }
        int n3 = (11 + eyeWidth + this.ws) / 2 - n2 / 2;
        graphics.drawString(plan.objet, n3, eyeHeight - 5);
    }
}

