/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Calib;
import cds.aladin.Coord;

public final class Projection {
    static final int NO = 0;
    static final int ALADIN = 1;
    static final int WCS = 2;
    static final int SIMPLE = 3;
    static final int QUADRUPLET = 4;
    static final String[] NAME = new String[]{"-", "Aladin reduction", "WCS reduction", "Simple reduction", "Matching star red."};
    protected double raj;
    protected double dej;
    protected double alphai;
    protected double deltai;
    protected double cx;
    protected double cy;
    protected double rm;
    protected double r;
    protected double rot;
    protected boolean sym;
    protected int t;
    protected double fct;
    protected int type;
    String label = null;
    Coord[] coo;
    Calib c;

    protected Projection(int n, Calib calib) {
        this.c = calib;
        this.adjustParamByCalib(calib);
        this.type = n;
        this.label = Projection.getName(n, 0);
    }

    protected Projection(Projection projection) {
        this.c = projection.c;
        this.adjustParamByCalib(this.c);
    }

    protected Projection(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, int n2) {
        this.c = new Calib(d, d2, d4, d5, d6, d3, d7, n2, bl);
        this.adjustParamByCalib(this.c);
        this.type = n;
        this.label = string;
        if (this.label == null) {
            this.label = Projection.getName(n, n2);
        }
    }

    protected void adjustParamByCalib(Calib calib) {
        try {
            Coord coord = calib.getProjCenter();
            this.cx = coord.x;
            this.cy = coord.y;
            this.alphai = coord.al;
            this.deltai = coord.del;
            coord = calib.getImgCenter();
            this.raj = coord.al;
            this.dej = coord.del;
        }
        catch (Exception exception) {
            System.out.println("Projection error: " + exception);
        }
        double d = calib.getImgWidth();
        double d2 = calib.getImgHeight();
        this.rm = d2 > d ? d2 * 60.0 : d * 60.0;
        this.rm = (double)((int)(this.rm * 10.0)) / 10.0;
        this.r = calib.getImgSize().width;
        this.rot = calib.getProjRot();
        this.sym = calib.getProjSym();
        this.t = calib.getProjSys();
    }

    protected boolean agree(Projection projection, double d) {
        if (projection == null) {
            return false;
        }
        if (this == projection) {
            return true;
        }
        Coord coord = new Coord();
        coord.al = projection.raj;
        coord.del = projection.dej;
        Coord coord2 = new Coord();
        coord2.al = this.raj;
        coord2.del = this.dej;
        double d2 = Coord.getDist(coord, coord2);
        double d3 = (this.rm + projection.rm) * Math.sqrt(2.0) / 120.0;
        if (d < 1.0) {
            d3 /= d;
        }
        return d2 <= d3;
    }

    protected void flip(int n) {
        if (n == 0 || n == 2) {
            this.c = this.c.flipBU();
        }
        if (n == 1 || n == 2) {
            this.c = this.c.flipRL();
        }
        this.adjustParamByCalib(this.c);
    }

    protected Coord getCoord(Coord coord) {
        try {
            this.c.GetCoord(coord);
        }
        catch (Exception exception) {
            coord.del = 0.0;
            coord.al = 0.0;
        }
        return coord;
    }

    protected static int getDefaultType(double d) {
        return d < 2.0 ? 1 : (d < 60.0 ? 4 : 3);
    }

    protected static String getName(int n, int n2) {
        return n == 3 ? Calib.getProj()[n2] : NAME[n];
    }

    protected Coord getXY(Coord coord) {
        this.c.GetXY(coord);
        return coord;
    }

    protected boolean isModifiable() {
        return this.type == 3 || this.type == 4 || this.type == 2;
    }

    protected void modify(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, int n2) {
        this.c = new Calib(d, d2, d4, d5, d6, d3, d7, n2, bl);
        this.adjustParamByCalib(this.c);
        this.type = n;
        if (string == null) {
            string = Projection.getName(n, n2);
        }
        this.coo = null;
    }

    protected void modify(String string, Calib calib) {
        if (string == null) {
            string = Projection.getName(this.type, this.t);
        }
        this.label = string;
        this.type = 2;
        this.coo = this.coo;
        this.c = calib;
        this.coo = null;
        this.adjustParamByCalib(calib);
    }

    protected void modify(String string, Coord[] coordArray) {
        if (string == null) {
            string = Projection.getName(this.type, this.t);
        }
        this.label = string;
        this.type = 4;
        this.coo = coordArray;
        int n = 0;
        while (n < coordArray.length) {
            System.out.println(String.valueOf(n) + ") xy=(" + coordArray[n].x + "," + coordArray[n].y + " ra,de=" + coordArray[n].getSexa());
            ++n;
        }
        this.c = this.c.recalibrate(coordArray);
        this.adjustParamByCalib(this.c);
    }

    protected void resize(int n) {
        try {
            this.c = this.c.resize(n);
        }
        catch (Exception exception) {
            return;
        }
        this.adjustParamByCalib(this.c);
    }

    protected void resize(int n, double d, double d2, int n2, int n3) {
        this.c = this.c.resize(n, d, d2, n2, n3);
        this.adjustParamByCalib(this.c);
    }

    protected static double round(double d) {
        return Math.ceil(d * 10.0) / 10.0;
    }

    public String toString() {
        return String.valueOf(this.label) + "(" + this.type + ":" + this.t + ")" + Projection.round(this.alphai) + "," + Projection.round(this.deltai) + "=>" + (int)this.cx + "," + (int)this.cy + " " + this.rm + "/" + this.r + " " + (this.rot != 0.0 ? "rot=" + this.rot + "deg " : "") + (this.sym ? "RA_symetry " : "");
    }
}

