/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinServer;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.GreyMemory;
import cds.aladin.HeaderFits;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanImageRGB;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ZoomView;
import cds.image.Hdecomp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class PlanImage
extends Plan {
    static String PS = System.getProperty("file.separator");
    static final int MAXCM = 3;
    static final int CMGRAY = 0;
    static final int CMBB = 1;
    static final int CMA = 2;
    protected static final int VIDEO_NORMAL = 0;
    protected static final int VIDEO_INVERSE = 1;
    protected static final int ALADIN = 0;
    protected static final int LOCAL = 1;
    protected static final int OTHER = 2;
    protected static final int COMPUTED = 3;
    protected static final int UNDEF = 0;
    protected static final int FULL = 1;
    protected static final int LOW = 2;
    protected static final int PLATE = 3;
    protected static final int STAND = 4;
    protected static final int UNKNOWN = 0;
    protected static final int JPEG = 1;
    protected static final int FITS = 2;
    protected static final int HFITS = 3;
    protected static final int GFITS = 4;
    protected static final int MRCOMP = 5;
    protected static final int RGB = 6;
    protected byte[] pixels;
    protected ColorModel cm;
    protected int typeCM;
    protected int[] cmControl;
    protected HeaderFits headerFits;
    protected int width;
    protected int height;
    protected int video;
    Objet o;
    protected boolean autocut;
    protected int fmt;
    protected int res;
    protected int orig;
    PushbackInputStream dis;
    GZIPInputStream gzis;
    static int number = 0;
    String status;
    String progress;
    boolean flagAutoCropping;
    static final String[] SOLAR = new String[]{"moon", "lune", "sun", "soleil", "mercury", "mercure", "venus", "mars", "jupiter", "saturn", "saturne", "uranus", "neptune", "pluto", "pluton", "aladin", "milky way", "J2000", "sky", "io"};
    int offsetLoad;
    int tailleLoad;

    protected PlanImage(Aladin aladin) {
        int[] nArray = new int[3];
        nArray[1] = 128;
        nArray[2] = 255;
        this.cmControl = nArray;
        this.o = null;
        this.autocut = true;
        this.fmt = 0;
        this.res = 0;
        this.orig = 0;
        this.dis = null;
        this.gzis = null;
        this.flagAutoCropping = false;
        this.offsetLoad = -1;
        this.tailleLoad = -1;
        this.aladin = aladin;
        this.type = 1;
        this.c = Color.black;
        this.flagOk = true;
        this.active = true;
    }

    protected PlanImage(Aladin aladin, int n, URL uRL, String string, String string2, String string3, String string4, int n2, int n3, boolean bl, Objet objet) {
        int[] nArray = new int[3];
        nArray[1] = 128;
        nArray[2] = 255;
        this.cmControl = nArray;
        this.o = null;
        this.autocut = true;
        this.fmt = 0;
        this.res = 0;
        this.orig = 0;
        this.dis = null;
        this.gzis = null;
        this.flagAutoCropping = false;
        this.offsetLoad = -1;
        this.tailleLoad = -1;
        this.u = uRL;
        this.Suite(aladin, n, string, string2, string3, string4, n2, n3, bl, objet);
    }

    protected PlanImage(Aladin aladin, String string, boolean bl) {
        int[] nArray = new int[3];
        nArray[1] = 128;
        nArray[2] = 255;
        this.cmControl = nArray;
        this.o = null;
        this.autocut = true;
        this.fmt = 0;
        this.res = 0;
        this.orig = 0;
        this.dis = null;
        this.gzis = null;
        this.flagAutoCropping = false;
        this.offsetLoad = -1;
        this.tailleLoad = -1;
        int n = 2;
        boolean bl2 = false;
        int n2 = string.lastIndexOf(PS);
        String string2 = n2 >= 0 ? string.substring(n2 + 1) : string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            if (string.endsWith(".MRC")) {
                n = 5;
                this.dis = new PushbackInputStream(fileInputStream);
            } else {
                fileInputStream.close();
                this.u = new URL("file:" + new File(string).getCanonicalPath());
                Aladin.trace(3, "Opening file: [" + string + "]");
                Aladin.trace(3, "Corresponding URL: [" + this.u + "]");
            }
        }
        catch (Exception exception) {
            String string3 = String.valueOf(string) + " error !\n" + exception;
            aladin.message.warning(string3, 1);
            return;
        }
        this.Suite(aladin, 1, string2, null, "", "Local file [" + string + "]", n, 0, bl, null);
    }

    protected void Free() {
        this.close(this.dis, this.gzis);
        this.headerFits = null;
        this.pixels = null;
        this.height = -1;
        this.width = -1;
        this.pourcent = -1.0;
        this.tailleLoad = -1;
        this.cm = null;
        this.res = 0;
        this.fmt = 0;
        this.typeCM = 0;
        this.video = 0;
        PlanImage.changeEtat();
        super.Free();
    }

    void Suite(Aladin aladin, int n, String string, String string2, String string3, String string4, int n2, int n3, boolean bl, Objet objet) {
        this.aladin = aladin;
        this.orig = n;
        this.objet = string2;
        this.param = string3;
        this.fmt = n2;
        this.res = n3;
        this.from = string4;
        this.autocut = bl;
        this.type = 1;
        this.setLabel(string);
        this.c = Color.black;
        aladin.calque.unSelectAllPlan();
        this.selected = true;
        this.video = 0;
        if (n3 == 4) {
            this.autocut = true;
            this.fmt = 2;
        }
        this.autocut = true;
        this.runme = new Thread(this);
        this.runme.setPriority(4);
        this.runme.start();
    }

    boolean cacheImageFits(PushbackInputStream pushbackInputStream, GZIPInputStream gZIPInputStream) throws Exception {
        int n;
        Date date;
        this.width = -1;
        this.height = -1;
        Object var4_3 = null;
        int n2 = 2;
        byte[] byArray = null;
        int[] nArray = null;
        Aladin.trace(2, "Loading FITS image");
        if (this.headerFits == null) {
            this.headerFits = new HeaderFits(pushbackInputStream, gZIPInputStream);
        }
        int n3 = this.headerFits.getIntFromHeader("BITPIX  ");
        n2 = this.headerFits.getIntFromHeader("NAXIS   ");
        if (n2 <= 1) {
            Aladin.error = "Only one dimension => Not an image !";
            this.error = "Only one dimension => Not an image !";
            this.aladin.message.warning(this.error, 1);
            return false;
        }
        this.width = this.headerFits.getIntFromHeader("NAXIS1  ");
        if (this.width <= 0) {
            return false;
        }
        this.height = this.headerFits.getIntFromHeader("NAXIS2  ");
        if (this.height <= 0) {
            return false;
        }
        int n4 = Math.abs(n3) / 8;
        int n5 = this.width * this.height * n4;
        this.pourcent = 0.0;
        Date date2 = new Date();
        if (this.headerFits.isHCOMP()) {
            Aladin.trace(2, "Hdecompressing");
            this.fmt = 3;
            byArray = Hdecomp.decomp(pushbackInputStream);
            if (n4 > 1) {
                nArray = new int[this.width * this.height];
            }
            date = new Date();
            n = (int)(date.getTime() - date2.getTime());
            date2 = date;
            Aladin.trace(3, " => Hdecompressing in " + n + " ms");
        } else {
            this.offsetLoad = 0;
            this.tailleLoad = n5;
            int n6 = n5 / 1000;
            int n7 = 0;
            int n8 = n5;
            boolean bl = true;
            int n9 = 0;
            if (n6 < this.width) {
                n6 = this.width;
            }
            while (bl) {
                try {
                    ++n9;
                    byArray = new byte[n8];
                    this.pixels = new byte[(this.width - 2 * n7) * (this.height - 2 * n7)];
                    bl = false;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    switch (n9) {
                        case 1: {
                            byArray = null;
                            System.gc();
                            break;
                        }
                        case 2: {
                            n7 = this.width / 100;
                            break;
                        }
                        default: {
                            n7 = (int)((double)n7 * 1.4);
                            System.gc();
                        }
                    }
                    n8 = (this.width - 2 * n7) * (this.height - 2 * n7) * n4;
                    if (n7 <= this.width / 2) continue;
                    throw new OutOfMemoryError();
                }
            }
            if (n6 > byArray.length) {
                n6 = byArray.length;
            }
            if (n9 > 2) {
                System.gc();
            }
            date = new Date();
            n = (int)(date.getTime() - date2.getTime());
            date2 = date;
            Aladin.trace(3, " => Allocating (" + n8 + "b) in " + n + " ms");
            if (n7 == 0) {
                while (this.offsetLoad < n5) {
                    if (n5 - this.offsetLoad < n6) {
                        n6 = n5 - this.offsetLoad;
                    }
                    if (gZIPInputStream != null) {
                        PlanImage.gzipReadFully(gZIPInputStream, byArray, this.offsetLoad, n6);
                    } else {
                        PlanImage.streamReadFully(pushbackInputStream, byArray, this.offsetLoad, n6);
                    }
                    this.offsetLoad += n6;
                    this.pourcent = (double)this.offsetLoad * 66.0 / (double)this.tailleLoad;
                }
            } else {
                this.aladin.message.warning("Image too large for your configuration\nan auto-cropping will be applied !\n.Original size (" + this.width + "x" + this.height + ")\n" + ".Pixels kept (" + (this.width - 2 * n7) + "x" + (this.height - 2 * n7) + ")\n", 1);
                this.flagAutoCropping = true;
                int n10 = n4 * (this.width * n7 + n7);
                int n11 = n4 * (this.width * (this.height - n7) - n7);
                byte[] byArray2 = null;
                byte[] byArray3 = new byte[n6];
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                while (this.offsetLoad < n5) {
                    switch (n14) {
                        case 0: {
                            if (n10 - this.offsetLoad < n6) {
                                n6 = n10 - this.offsetLoad;
                            }
                            byArray2 = byArray3;
                            n12 = 0;
                            break;
                        }
                        case 1: {
                            n6 = n4 * (this.width - 2 * n7);
                            byArray2 = byArray;
                            n12 = n13;
                            n13 += n6;
                            n14 = 2;
                            break;
                        }
                        case 2: {
                            n6 = n4 * (2 * n7);
                            byArray2 = byArray3;
                            n12 = 0;
                            n14 = 1;
                            break;
                        }
                    }
                    int n15 = gZIPInputStream != null ? PlanImage.gzipReadFully(gZIPInputStream, byArray2, n12, n6) : PlanImage.streamReadFully(pushbackInputStream, byArray2, n12, n6);
                    this.offsetLoad += n6;
                    if (n14 == 0 && this.offsetLoad >= n10) {
                        n14 = 1;
                    } else if (this.offsetLoad >= n11) break;
                    this.pourcent = (double)n13 * 66.0 / (double)n11;
                }
                byArray3 = null;
                this.width -= 2 * n7;
                this.height -= 2 * n7;
            }
        }
        date = new Date();
        n = (int)(date.getTime() - date2.getTime());
        date2 = date;
        Aladin.trace(3, " => Reading in " + n + " ms");
        this.pixels = this.getPix8Bits(this.pixels, byArray, n3, this.width, this.height);
        date = new Date();
        n = (int)(date.getTime() - date2.getTime());
        date2 = date;
        Aladin.trace(3, " => Setting in 8bits/autocut in " + n + " ms");
        byArray = null;
        PlanImage.invImageLine(this.width, this.height, this.pixels);
        this.cm = this.creatDefaultCM();
        this.pourcent = 99.0;
        return true;
    }

    boolean cacheImageFits(URL uRL) throws Exception {
        Date date = new Date();
        try {
            this.dis = new PushbackInputStream(uRL.openStream());
        }
        catch (Exception exception) {
            return false;
        }
        Date date2 = new Date();
        int n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Waiting server during " + n + " ms");
        return this.cacheImageFits(this.dis, null);
    }

    synchronized boolean cacheImageJpeg(URL uRL) {
        ImageProducer imageProducer;
        Object object;
        Date date = new Date();
        Aladin.trace(2, "Loading JPEG image");
        try {
            object = uRL.openConnection();
            imageProducer = (ImageProducer)((URLConnection)object).getContent();
        }
        catch (Exception exception) {
            imageProducer = null;
        }
        if (imageProducer == null) {
            Aladin.trace(3, "Cannot get JPEG image source by getSource()... use getImage()");
            object = this.aladin.getToolkit().getImage(uRL);
            MediaTracker mediaTracker = new MediaTracker(this.aladin);
            mediaTracker.addImage((Image)object, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("cacheImageJpeg error: " + interruptedException);
                return false;
            }
            imageProducer = ((Image)object).getSource();
        }
        Date date2 = new Date();
        int n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Waiting server during " + n + " ms");
        this.pourcent = 10.0;
        this.pixels = new byte[this.width * this.height];
        object = new GreyMemory(imageProducer, this.pixels);
        if (!((GreyMemory)object).waitImage()) {
            return false;
        }
        this.pourcent = 66.0;
        date2 = new Date();
        n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Loading in " + n + " ms");
        this.pixels = this.getPix8Bits(null, this.pixels, 8, this.width, this.height);
        date2 = new Date();
        n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Autocutting in " + n + " ms");
        this.cm = this.creatDefaultCM();
        this.pourcent = 99.0;
        return true;
    }

    static synchronized void changeEtat() {
        PlanImage.changeEtat(0);
    }

    static synchronized void changeEtat(int n) {
        number = n == 0 ? (number % 2 == 0 ? (number += 2) : ++number) : (number % 2 == 0 ? ++number : (number += 2));
    }

    private void close(PushbackInputStream pushbackInputStream, GZIPInputStream gZIPInputStream) {
        try {
            if (pushbackInputStream != null) {
                pushbackInputStream.close();
                pushbackInputStream = null;
            }
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
                gZIPInputStream = null;
            }
        }
        catch (Exception exception) {}
    }

    protected ColorModel creatDefaultCM() {
        return this.creatDefaultCM(this.inverseCM());
    }

    protected ColorModel creatDefaultCM(boolean bl) {
        byte[] byArray = new byte[256];
        if (bl) {
            int n = 0;
            while (n < 256) {
                byArray[n] = (byte)(~n);
                ++n;
            }
            this.video = 1;
        } else {
            int n = 0;
            while (n < 256) {
                byArray[n] = (byte)n;
                ++n;
            }
            this.video = 0;
        }
        return new IndexColorModel(8, 256, byArray, byArray, byArray);
    }

    protected static String describeFmtRes(int n, int n2) {
        String string;
        String string2;
        String string3 = n == 6 ? "none (composed image)" : (n == 1 ? "Jpeg" : (string2 = n == 2 || n == 3 || n == 4 || n == 5 ? "Fits" : null));
        String string4 = n == 3 ? "Hcompressed" : (n == 4 ? "gzipped" : (string = n == 5 ? "MR compressed" : null));
        String string5 = n2 == 1 ? "Full resolution" : (n2 == 2 ? "Low resolution" : (n2 == 3 ? "Plate view" : (n2 == 4 ? "(Aladin standalone image)" : null)));
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(String.valueOf(string2) + " ");
        }
        if (string != null) {
            stringBuffer.append(String.valueOf(string) + " ");
        }
        if (stringBuffer.length() > 0 && n != 6) {
            stringBuffer.append("format ");
        }
        if (string5 != null) {
            stringBuffer.append("- " + string5);
        }
        return stringBuffer.toString();
    }

    protected void drawBord(Graphics graphics, int n, int n2) {
        Coord coord;
        ZoomView zoomView = this.aladin.calque.zoom.zoomView;
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan == null || plan.projd == null) {
            return;
        }
        Projection projection = plan.projd;
        graphics.setColor(this.aladin.view.getInfoColor());
        try {
            coord = this.projd.c.getImgCenter();
        }
        catch (Exception exception) {
            return;
        }
        double d = coord.x;
        double d2 = coord.y;
        Point[] pointArray = new Point[4];
        int n3 = 0;
        while (n3 < 4) {
            Coord coord2 = new Coord();
            int n4 = n3 < 2 ? -1 : 1;
            int n5 = n3 == 1 || n3 == 2 ? 1 : -1;
            coord2.x = coord.x + (double)n4 * d;
            coord2.y = coord.y + (double)n5 * d2;
            this.projd.getCoord(coord2);
            projection.getXY(coord2);
            pointArray[n3] = zoomView.getViewCoord(coord2.x, coord2.y);
            if (n3 > 0) {
                graphics.drawLine(pointArray[n3 - 1].x + n, pointArray[n3 - 1].y + n2, pointArray[n3].x + n, pointArray[n3].y + n2);
            }
            if (n3 == 3) {
                graphics.drawLine(pointArray[n3].x + n, pointArray[n3].y + n2, pointArray[0].x + n, pointArray[0].y + n2);
                graphics.drawString(this.label, pointArray[0].x + n, pointArray[0].y - 4 + n2);
            }
            ++n3;
        }
    }

    protected void flip(int n) {
        if (n == 0 || n == 2) {
            PlanImage.invImageLine(this.width, this.height, this.pixels);
        }
        if (n == 1 || n == 2) {
            PlanImage.invImageRow(this.width, this.height, this.pixels);
        }
        this.projd.flip(n);
        PlanImage.changeEtat();
        int n2 = 0;
        while (n2 < this.aladin.calque.plan.length) {
            this.aladin.calque.plan[n2].flagProj = false;
            ++n2;
        }
        this.aladin.calque.view.newView();
        this.aladin.calque.repaint();
    }

    private boolean getCalibration() throws Exception {
        Object object;
        Calib calib = null;
        this.status = "- Look for image/calibration";
        this.progress = "in progress...";
        try {
            String string = Glu.quote(this.objet);
            string = this.res == 0 ? String.valueOf(string) + " FULL" : String.valueOf(string) + " " + PlanImage.getResolution(this.res);
            if (this.param != null && this.param.length() > 0) {
                string = String.valueOf(string) + " " + Glu.quote(this.param);
            }
            URL uRL = this.aladin.glu.getURL(Glu.debugTag("Calibration"), string, false, false);
            object = new DataInputStream(uRL.openStream());
            calib = new Calib((DataInputStream)object);
            ((FilterInputStream)object).close();
            this.status = String.valueOf(this.status) + ": ok\n";
            this.progress = "";
        }
        catch (Exception exception) {
            this.status = String.valueOf(this.status) + ": fail\n";
            this.progress = "";
            Aladin.error = " Image server error\n \n" + this.getStatus() + "\n" + exception;
            this.close(this.dis, this.gzis);
            return false;
        }
        double d = (double)((int)(calib.widtha * 600.0)) / 10.0;
        if (d <= 0.0) {
            this.status = String.valueOf(this.status) + ": error\n";
            this.progress = "";
            Aladin.error = "calibration error\n \n" + this.getStatus();
            this.close(this.dis, this.gzis);
            return false;
        }
        object = calib.getImgSize();
        this.width = ((Dimension)object).width;
        this.height = ((Dimension)object).height;
        this.status = String.valueOf(this.status) + "- Download the image";
        this.progress = "in progress...";
        boolean bl = this.fmt == 2 ? this.cacheImageFits(this.u) : this.cacheImageJpeg(this.u);
        if (this.flagAutoCropping) {
            calib.cropping(this.width, this.height);
        }
        if (!bl) {
            this.status = String.valueOf(this.status) + ": fail\n";
            this.progress = "";
            Aladin.error = "image format unknown or server error\n \n" + this.getStatus();
            this.close(this.dis, this.gzis);
            return false;
        }
        this.status = String.valueOf(this.status) + ": ok\n";
        this.progress = "";
        this.setNewProjD(new Projection(1, calib));
        return bl;
    }

    protected int getEtat() {
        return number;
    }

    protected static int getFmt(String string) {
        return string.equalsIgnoreCase("FITS") ? 2 : (string.equalsIgnoreCase("GFITS") ? 4 : (string.equalsIgnoreCase("HFITS") ? 3 : (string.equalsIgnoreCase("MRCOMP") ? 5 : (string.equalsIgnoreCase("JPEG") ? 1 : 0))));
    }

    protected static String getFormat(int n) {
        return n == 1 ? "JPEG" : (n == 2 ? "FITS" : (n == 4 ? "GFITS" : (n == 3 ? "HFITS" : (n == 5 ? "MRCOMP" : "UNKNOWN"))));
    }

    private String getFullLabel() {
        if (this.objet != null && this.objet.indexOf(this.label) >= 0) {
            return this.objet;
        }
        if (this.objet != null && this.label.indexOf(this.objet) >= 0) {
            return this.label;
        }
        return String.valueOf(this.objet == null ? "" : String.valueOf(this.objet) + " - ") + this.label;
    }

    protected void getInfo() {
        String string;
        if (this.type == 0) {
            super.getInfo();
            return;
        }
        if (!this.flagOk && this.error == null) {
            string = String.valueOf(this.getFullLabel()) + this.getOffsetLoad();
        } else {
            string = this.getFullLabel();
            String string2 = this.survey();
            if (string2.length() > 0) {
                string2 = " - " + string2;
            }
            string = this.error != null ? String.valueOf(string) + " *** Error *** " + this.error : String.valueOf(string) + string2 + " - " + PlanImage.describeFmtRes(this.fmt, this.res);
        }
        this.aladin.status.setText(string);
    }

    private final int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    protected String getLabel() {
        int n;
        int n2 = (int)this.getPourcent();
        int n3 = n = this instanceof PlanImageRGB ? 0 : 5;
        if (n2 > 0) {
            return String.valueOf(this.label.length() > n ? this.label.substring(0, n) : this.label) + "..  " + n2 + "%";
        }
        return super.getLabel();
    }

    private int getMarge(int n, int n2, int n3, int n4) {
        double d = 4.0;
        double d2 = -2 * (n2 + n3);
        double d3 = n2 * n3 - n / n4;
        double d4 = (-d2 - Math.sqrt(d2 * d2 - 4.0 * d * d3)) / (2.0 * d);
        if ((d4 += d4 % (double)n4) < 0.0 || d4 > (double)(n2 / 2)) {
            d4 = -1.0;
        }
        return (int)d4;
    }

    private int[] getMinMaxBean(int[] nArray) {
        double d = 0.003;
        double d2 = 0.999;
        int[] nArray2 = new int[2];
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            n2 += nArray[n];
            ++n;
        }
        nArray2[1] = -1;
        nArray2[0] = -1;
        n = 0;
        int n3 = 0;
        while (n < nArray.length) {
            double d3 = (double)(n3 += nArray[n]) / (double)n2;
            if (nArray2[0] == -1) {
                if (d3 > d) {
                    nArray2[0] = n;
                }
            } else if (d3 > d2) {
                nArray2[1] = n;
                break;
            }
            ++n;
        }
        if (nArray2[0] == -1 || nArray2[1] == -1) {
            System.err.println("Image autocut problem => no autocut applied");
            nArray2[0] = 0;
            nArray2[1] = nArray.length - 1;
        }
        return nArray2;
    }

    private String getOffsetLoad() {
        if (this.tailleLoad == -1) {
            return " - in progress...";
        }
        return " - " + (int)this.pourcent + "% of " + this.tailleLoad / 1024 + "KB ...";
    }

    private byte[] getPix8Bits(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        return this.getPix8Bits(byArray, byArray2, n, n2, n3, 0.0, 0.0, 0);
    }

    private byte[] getPix8Bits(byte[] byArray, byte[] byArray2, int n, int n2, int n3, double d, double d2, int n4) {
        double d3;
        int n5;
        int n6;
        boolean bl = false;
        boolean bl2 = n4 > 0;
        Aladin.trace(3, "getPix8Bits: bitpix=" + n + " size=(" + n2 + "," + n3 + ") autocut=" + this.autocut);
        if (!this.autocut && n == 8) {
            return byArray2;
        }
        if (byArray == null) {
            byArray = new byte[n2 * n3];
        }
        this.pourcent = 66.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl3 = true;
        long l = 0L;
        long l2 = 0L;
        int n7 = n6 = (int)((double)n2 * 0.05);
        while (n7 < n3 - n6) {
            n5 = n6;
            while (n5 < n2 - n6) {
                d3 = this.getPixVal(byArray2, n, n7 * n2 + n5);
                if (!(Double.isNaN(d3) || bl2 && (d3 < d || d3 > d2))) {
                    if (bl3) {
                        d6 = d7 = d3;
                        d5 = d7;
                        d4 = d7;
                        bl3 = false;
                    }
                    if (d6 > d3) {
                        d6 = d3;
                        l = 1L;
                    } else if (d4 < d3) {
                        d4 = d3;
                        l2 = 1L;
                    } else if (d3 == d6) {
                        ++l;
                    } else if (d3 == d4) {
                        ++l2;
                    }
                    if (d3 < d7 && d3 > d6 || d7 == d6) {
                        d7 = d3;
                    } else if (d3 > d5 && d3 < d4 || d5 == d4) {
                        d5 = d3;
                    }
                }
                ++n5;
            }
            ++n7;
        }
        Aladin.trace(3, "min=" + d6 + "(" + l + ")/" + d7 + " max=" + d4 + "(" + l2 + ")/" + d5);
        long l3 = (n2 - 2 * n6) * (n3 - 2 * n6);
        if (d7 - d6 > d5 - d7 && d7 != Double.MAX_VALUE && d7 != d4) {
            d6 = d7;
        }
        if (d4 - d5 > d5 - d7 && d5 != Double.MIN_VALUE && d5 != d6) {
            d4 = d5;
        }
        if (this.autocut) {
            this.pourcent = 80.0;
            int n8 = 10000;
            double d8 = (d4 - d6) / (double)n8;
            Aladin.trace(3, "image autocut for: min=" + d6 + " max=" + d4 + " nbean=" + n8 + " beansize=" + d8);
            int[] nArray = new int[n8];
            n7 = n6;
            while (n7 < n3 - n6) {
                int n9 = n6;
                while (n9 < n2 - n6) {
                    d3 = this.getPixVal(byArray2, n, n7 * n2 + n9);
                    n5 = (int)((d3 - d6) / d8);
                    if (n5 == nArray.length) {
                        --n5;
                    }
                    if (n5 < nArray.length && n5 >= 0) {
                        int n10 = n5;
                        nArray[n10] = nArray[n10] + 1;
                    }
                    ++n9;
                }
                ++n7;
            }
            int[] nArray2 = this.getMinMaxBean(nArray);
            d5 = d4;
            d7 = d6;
            d5 = (double)nArray2[1] * d8 + d7;
            d7 += (double)nArray2[0] * d8;
            Aladin.trace(3, "image autocut: beanMin=" + nArray2[0] + " beanMax=" + nArray2[1] + " => min=" + d6 + " max=" + d4);
            if (nArray2[0] > nArray2[1] - 5 && n4 < 10) {
                if (d7 > d6) {
                    d6 = d7;
                }
                if (d5 < d4) {
                    d4 = d5;
                }
                return this.getPix8Bits(byArray, byArray2, n, n2, n3, d6, d4, n4 + 1);
            }
            d6 = d7;
            d4 = d5;
        }
        this.pourcent = 90.0;
        double d9 = 256.0 / (d4 - d6);
        n7 = 0;
        while (n7 < byArray.length) {
            d3 = this.getPixVal(byArray2, n, n7);
            byArray[n7] = (byte)(d3 <= d6 ? 0 : (d3 >= d4 ? 255 : (int)((d3 - d6) * d9) & 0xFF));
            ++n7;
        }
        return byArray;
    }

    private final double getPixVal(byte[] byArray, int n, int n2) {
        switch (n) {
            case 8: {
                return byArray[n2] & 0xFF;
            }
            case 16: {
                return byArray[n2 *= 2] << 8 | byArray[n2 + 1] & 0xFF;
            }
            case 32: {
                return this.getInt(byArray, n2 * 4);
            }
            case -32: {
                return Float.intBitsToFloat(this.getInt(byArray, n2 * 4));
            }
            case -64: {
                long l = (long)this.getInt(byArray, n2 *= 8) << 32 | (long)this.getInt(byArray, n2 + 1) & 0xFFFFFFFFFFFFFFFFL;
                return Double.longBitsToDouble(l);
            }
        }
        return 0.0;
    }

    protected void getPixels(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n + n3 > this.width) {
            n7 = n + n3 - this.width;
            n3 -= n7;
        }
        if (n2 + n4 > this.height) {
            n6 = n2 + n4 - this.height;
            n4 -= n6;
        }
        int n8 = n2;
        int n9 = n2 + n4;
        while (n8 < n9) {
            System.arraycopy(this.pixels, n8 * this.width + n, byArray, n5, n3);
            n5 += n3 + n7;
            ++n8;
        }
    }

    protected static int getRes(String string) {
        return string.equalsIgnoreCase("FULL") ? 1 : (string.equalsIgnoreCase("LOW") ? 2 : (string.equalsIgnoreCase("PLATE") ? 3 : (string.equalsIgnoreCase("STAND") ? 4 : 0)));
    }

    protected static String getResolution(int n) {
        return n == 1 ? "FULL" : (n == 2 ? "LOW" : (n == 3 ? "PLATE" : (n == 4 ? "STAND" : "UNDEF")));
    }

    protected String getStatus() {
        return String.valueOf(this.status) + ": " + this.progress;
    }

    protected static int gzipReadFully(GZIPInputStream gZIPInputStream, byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        try {
            int n5;
            while ((n5 = gZIPInputStream.read(byArray, n3, n4)) != n4 && n5 != 0) {
                n3 += n5;
                n4 -= n5;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return n2;
    }

    protected static void invImageLine(int n, int n2, byte[] byArray) {
        byte[] byArray2 = new byte[n];
        int n3 = n2 / 2 - 1;
        while (n3 >= 0) {
            int n4 = n3 * n;
            int n5 = (n2 - n3 - 1) * n;
            System.arraycopy(byArray, n4, byArray2, 0, n);
            System.arraycopy(byArray, n5, byArray, n4, n);
            System.arraycopy(byArray2, 0, byArray, n5, n);
            --n3;
        }
    }

    protected static void invImageRow(int n, int n2, byte[] byArray) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * n;
            int n5 = n / 2 - 1;
            while (n5 >= 0) {
                int n6 = n4 + n - n5 - 1;
                byte by = byArray[n4 + n5];
                byArray[n4 + n5] = byArray[n6];
                byArray[n6] = by;
                --n5;
            }
            ++n3;
        }
    }

    protected boolean inverseCM() {
        return true;
    }

    protected static boolean isSolar(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        int n = 0;
        while (n < SOLAR.length) {
            if (string.equalsIgnoreCase(SOLAR[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void loadSolarObject() {
        this.height = 500;
        this.width = 500;
        this.cacheImageJpeg(this.u);
        this.status = "The CDS is dedicated to\nthe extra solar system objects\nonly\n";
        this.aladin.message.warning(this.status);
        this.progress = "";
        this.error = "No astronomical reduction";
        System.out.println("!!! " + this.error);
    }

    protected void newCM(Object object) {
        this.aladin.view.dynamicCM(object);
    }

    private boolean openUrlImage() {
        this.status = "Load the archive image";
        this.progress = "in progress...";
        Aladin.trace(3, "Load archive image at: " + this.u);
        try {
            this.dis = new PushbackInputStream(this.u.openStream());
        }
        catch (Exception exception) {
            Aladin.trace(3, "Second try for opening the stream due to: " + exception + "...");
            try {
                this.dis = new PushbackInputStream(this.u.openStream());
            }
            catch (Exception exception2) {
                if (this.u != null) {
                    System.err.println("Pb with: " + this.u);
                }
                Aladin.error = "Server not reached or HTTP error";
                this.error = "Server not reached or HTTP error";
                this.aladin.message.warning(this.error, 1);
                this.close(this.dis, this.gzis);
                return false;
            }
        }
        try {
            int n = this.dis.read();
            this.dis.unread(n);
            if (n == 31) {
                Aladin.trace(3, "Loading in gzip...");
                this.gzis = new GZIPInputStream(this.dis);
                this.dis = null;
            }
        }
        catch (Exception exception) {}
        this.fmt = this.dis != null ? 2 : (this.gzis != null ? 4 : this.fmt);
        return true;
    }

    protected static boolean sameFmtRes(Plan plan, Plan plan2) {
        PlanImage planImage;
        PlanImage planImage2;
        try {
            planImage2 = (PlanImage)plan;
            planImage = (PlanImage)plan2;
        }
        catch (Exception exception) {
            return false;
        }
        if (planImage2 == null && planImage == null) {
            return true;
        }
        if (planImage2 == null || planImage == null) {
            return false;
        }
        return planImage2.fmt == planImage.fmt && planImage2.res == planImage.res;
    }

    protected void setCM(Object object) {
        this.cm = (ColorModel)object;
        PlanImage.changeEtat(1);
        this.aladin.view.endDynamicCM();
    }

    protected static byte[] streamReadFully(InputStream inputStream) {
        byte[] byArray;
        int n = 8192;
        Vector<byte[]> vector = new Vector<byte[]>(10);
        Vector<Integer> vector2 = new Vector<Integer>(10);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            byArray = new byte[n];
            while ((n2 = inputStream.read(byArray)) != -1) {
                ++n4;
                vector.addElement(byArray);
                vector2.addElement(new Integer(n2));
                n3 += n2;
                if (n2 < n) {
                    n6 = n2;
                }
                byArray = new byte[n];
            }
        }
        catch (Exception exception) {}
        byte[] byArray2 = new byte[n3];
        n5 = vector.size();
        n4 = 0;
        n2 = 0;
        while (n4 < n5) {
            byArray = (byte[])vector.elementAt(n4);
            n3 = (Integer)vector2.elementAt(n4);
            System.arraycopy(byArray, 0, byArray2, n2, n3);
            n2 += n3;
            ++n4;
        }
        return byArray2;
    }

    protected static int streamReadFully(PushbackInputStream pushbackInputStream, byte[] byArray) throws Exception {
        return PlanImage.streamReadFully(pushbackInputStream, byArray, 0, byArray.length);
    }

    protected static int streamReadFully(PushbackInputStream pushbackInputStream, byte[] byArray, int n, int n2) throws Exception {
        int n3 = n;
        int n4 = n2;
        DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);
        dataInputStream.readFully(byArray, n3, n4);
        return n2;
    }

    protected String survey() {
        if (this.orig == 0 && (this.param == null || this.param.trim().length() == 0)) {
            return "default image (DSS-I/STScI)";
        }
        if (this.orig == 0) {
            return AladinServer.whichQualifier(this.param).trim();
        }
        return this.param;
    }

    protected boolean waitForPlan() {
        try {
            if (PlanImage.isSolar(this.objet)) {
                this.loadSolarObject();
            } else if (this.orig == 0 && this.res != 4) {
                if (!this.getCalibration()) {
                    return false;
                }
            } else {
                Calib calib = null;
                if (this.orig == 1) {
                    this.status = "Load the local image";
                    this.progress = "in progress...";
                }
                if (this.fmt != 5 && !this.openUrlImage()) {
                    return false;
                }
                if (this.fmt != 2 && this.fmt != 3 && this.fmt != 4) {
                    this.close(this.dis, this.gzis);
                    return false;
                }
                boolean bl = this.cacheImageFits(this.dis, this.gzis);
                if (!bl) {
                    this.status = String.valueOf(this.status) + ": fail\n";
                    this.progress = "";
                    this.close(this.dis, this.gzis);
                    return false;
                }
                this.status = String.valueOf(this.status) + ": ok\n";
                this.progress = "";
                try {
                    calib = new Calib(this.headerFits);
                    if (this.flagAutoCropping) {
                        calib.cropping(this.width, this.height);
                    }
                }
                catch (Exception exception) {
                    this.error = "No astronomical reduction";
                    this.progress = "";
                    this.aladin.message.warning(this.error, 1);
                }
                if (calib != null) {
                    this.co = calib.getImgCenter();
                    this.setNewProjD(new Projection(2, calib));
                    if (this.objet == null) {
                        this.objet = this.co.getSexa();
                        Server.setDefaultTarget(this.objet);
                    } else {
                        this.co = null;
                    }
                }
            }
            this.close(this.dis, this.gzis);
            PlanImage.changeEtat();
            if (this.aladin.msgOn) {
                this.aladin.endMsg();
            }
            this.aladin.message.hideWait();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.error = Aladin.error != null ? Aladin.error : exception.toString();
            this.aladin.message.warning(this.error, 1);
            this.close(this.dis, this.gzis);
            return false;
        }
        catch (Error error) {
            error.printStackTrace();
            this.error = Aladin.error = error.toString();
            this.aladin.message.warning(String.valueOf(this.error) + " ", 1);
            this.close(this.dis, this.gzis);
            return false;
        }
        return true;
    }

    protected static void waitImage(ImageObserver imageObserver, Image image) {
        while (image.getWidth(imageObserver) < 0 || image.getHeight(imageObserver) < 0) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }
}

