/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Champ;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Ligne;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanObjet;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Texte;
import cds.aladin.View;
import cds.astro.Coo;
import cds.astro.Proj3;

public final class PlanField
extends Plan {
    private static final int CFH12K = 0;
    private static final int EPICMOS = 1;
    private static final int EPICPN = 2;
    private static final int WFPC2 = 3;
    private static final int MEGACAM = 4;
    private static final int MEGAPRIME = 5;
    private static final int ACS = 6;
    private static String[] INSTR = new String[]{"CFH12K", "EPICMOS", "EPICpn", "WFPC2", "MEGACAM", "MEGAPRIME", "ACS"};
    private int instr;
    private boolean flagRoll;
    private double roll;
    private static final double ACS_RA = 0.03403737070403737;
    private static final double ACS_DE = 0.017018685352018684;
    private static final double[] ACS_DRA = new double[]{-1.7772277227722773, -1.7772277227722773};
    private static final double[] ACS_DDE = new double[]{-2.346534653465347, -3.346534653465347};
    private static final double ACS_RD = 0.0;
    private static final double EPICMOS_RA = 0.18166666666666667;
    private static final double EPICMOS_DE = 0.18166666666666667;
    private static final double[] EPICMOS_DRA = new double[]{-1.5, -1.5, -0.5, -0.5, -0.5, 0.5, 0.5};
    private static final double[] EPICMOS_DDE;
    private static final double EPICMOS_RD = 0.25;
    private static final double EPICPN_RA = 0.07333333333333333;
    private static final double EPICPN_DE = 0.22666666666666666;
    private static final double[] EPICPN_DRA;
    private static final double[] EPICPN_DDE;
    private static final double EPICPN_RD = 0.25;
    private static final double CFH12K_RA = 0.11719111111111111;
    private static final double CFH12K_DE = 0.23438222222222221;
    private static final double[] CFH12K_DRA;
    private static final double[] CFH12K_DDE;
    private static final double[] CFH12K_GAPRA;
    private static final double[] CFH12K_GAPDE;
    private static final double CFH12K_RD = 0.0;
    private static final double CFH12K_ORA = -0.004166666666666667;
    private static final double CFH12K_ODE = 0.008333333333333333;
    private static final String[] CFH12K_CCD;
    private static final double MEGACAM_RA = 0.10638222222222223;
    private static final double MEGACAM_DE = 0.23956777777777777;
    private static final double[] MEGACAM_DRA;
    private static final double[] MEGACAM_DDE;
    private static final double[] MEGACAM_GAPRA;
    private static final double[] MEGACAM_GAPDE;
    private static final double MEGACAM_RD = 0.5;
    private static final double MEGACAM_ORA = 0.004166666666666667;
    private static final double MEGACAM_ODE = -0.005694444444444445;
    private static final String[] MEGACAM_CCD;
    private static final double MEGAGUI_RA = 0.3425;
    private static final double MEGAGUI_DE = 0.24736111111111111;
    private static final double[] MEGAGUI_DRA;
    private static final double[] MEGAGUI_DDE;
    private static final double[] MEGAGUI_GAPRA;
    private static final double[] MEGAGUI_GAPDE;
    private static final String[] MEGAGUI_BOX;
    boolean flagGuider;

    static {
        double[] dArray = new double[7];
        dArray[0] = -1.0;
        dArray[2] = -1.5;
        dArray[3] = -0.5;
        dArray[4] = 0.5;
        dArray[5] = -1.0;
        EPICMOS_DDE = dArray;
        double[] dArray2 = new double[12];
        dArray2[0] = -3.0;
        dArray2[1] = -2.0;
        dArray2[2] = -1.0;
        dArray2[4] = 1.0;
        dArray2[5] = 2.0;
        dArray2[6] = -3.0;
        dArray2[7] = -2.0;
        dArray2[8] = -1.0;
        dArray2[10] = 1.0;
        dArray2[11] = 2.0;
        EPICPN_DRA = dArray2;
        double[] dArray3 = new double[12];
        dArray3[0] = -1.0;
        dArray3[1] = -1.0;
        dArray3[2] = -1.0;
        dArray3[3] = -1.0;
        dArray3[4] = -1.0;
        dArray3[5] = -1.0;
        EPICPN_DDE = dArray3;
        double[] dArray4 = new double[12];
        dArray4[0] = -3.0;
        dArray4[1] = -2.0;
        dArray4[2] = -1.0;
        dArray4[4] = 1.0;
        dArray4[5] = 2.0;
        dArray4[6] = -3.0;
        dArray4[7] = -2.0;
        dArray4[8] = -1.0;
        dArray4[10] = 1.0;
        dArray4[11] = 2.0;
        CFH12K_DRA = dArray4;
        double[] dArray5 = new double[12];
        dArray5[0] = -1.0;
        dArray5[1] = -1.0;
        dArray5[2] = -1.0;
        dArray5[3] = -1.0;
        dArray5[4] = -1.0;
        dArray5[5] = -1.0;
        CFH12K_DDE = dArray5;
        CFH12K_GAPRA = new double[]{-15.0, -9.0, -3.0, 3.0, 9.0, 15.0, -15.0, -9.0, -3.0, 3.0, 9.0, 15.0};
        CFH12K_GAPDE = new double[]{-3.0, -3.0, -3.0, -3.0, -3.0, -3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0};
        CFH12K_CCD = new String[]{"06", "07", "08", "09", "10", "11", "00", "01", "02", "03", "04", "05"};
        MEGACAM_DRA = new double[]{-4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5};
        double[] dArray6 = new double[36];
        dArray6[0] = -2.0;
        dArray6[1] = -2.0;
        dArray6[2] = -2.0;
        dArray6[3] = -2.0;
        dArray6[4] = -2.0;
        dArray6[5] = -2.0;
        dArray6[6] = -2.0;
        dArray6[7] = -2.0;
        dArray6[8] = -2.0;
        dArray6[9] = -1.0;
        dArray6[10] = -1.0;
        dArray6[11] = -1.0;
        dArray6[12] = -1.0;
        dArray6[13] = -1.0;
        dArray6[14] = -1.0;
        dArray6[15] = -1.0;
        dArray6[16] = -1.0;
        dArray6[17] = -1.0;
        dArray6[27] = 1.0;
        dArray6[28] = 1.0;
        dArray6[29] = 1.0;
        dArray6[30] = 1.0;
        dArray6[31] = 1.0;
        dArray6[32] = 1.0;
        dArray6[33] = 1.0;
        dArray6[34] = 1.0;
        dArray6[35] = 1.0;
        MEGACAM_DDE = dArray6;
        double[] dArray7 = new double[36];
        dArray7[0] = -56.0;
        dArray7[1] = -42.0;
        dArray7[2] = -28.0;
        dArray7[3] = -14.0;
        dArray7[5] = 14.0;
        dArray7[6] = 28.0;
        dArray7[7] = 42.0;
        dArray7[8] = 56.0;
        dArray7[9] = -56.0;
        dArray7[10] = -42.0;
        dArray7[11] = -28.0;
        dArray7[12] = -14.0;
        dArray7[14] = 14.0;
        dArray7[15] = 28.0;
        dArray7[16] = 42.0;
        dArray7[17] = 56.0;
        dArray7[18] = -56.0;
        dArray7[19] = -42.0;
        dArray7[20] = -28.0;
        dArray7[21] = -14.0;
        dArray7[23] = 14.0;
        dArray7[24] = 28.0;
        dArray7[25] = 42.0;
        dArray7[26] = 56.0;
        dArray7[27] = -56.0;
        dArray7[28] = -42.0;
        dArray7[29] = -28.0;
        dArray7[30] = -14.0;
        dArray7[32] = 14.0;
        dArray7[33] = 28.0;
        dArray7[34] = 42.0;
        dArray7[35] = 56.0;
        MEGACAM_GAPRA = dArray7;
        MEGACAM_GAPDE = new double[]{-88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5};
        MEGACAM_CCD = new String[]{"35", "34", "33", "32", "31", "30", "29", "28", "27", "26", "25", "24", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "12", "11", "10", "09", "08", "07", "06", "05", "04", "03", "02", "01", "00"};
        MEGAGUI_DRA = new double[]{-0.5, -0.5};
        double[] dArray8 = new double[2];
        dArray8[0] = -1.0;
        MEGAGUI_DDE = dArray8;
        MEGAGUI_GAPRA = new double[2];
        MEGAGUI_GAPDE = new double[]{-1739.9, 1739.9};
        MEGAGUI_BOX = new String[]{"S", "N"};
    }

    protected PlanField(Aladin aladin, String string, double d, String string2, String string3) {
        this.aladin = aladin;
        this.type = 4;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string2);
        this.pcat = new PlanObjet(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.unSelectAllPlan();
        this.selected = true;
        this.objet = null;
        this.setInstr(string3);
        if (string.length() == 0 || View.notCoord(string)) {
            this.active = false;
            this.flagOk = false;
            this.roll = d;
            if (string.length() > 0) {
                this.objet = string;
            }
        } else {
            Coord coord;
            try {
                coord = new Coord(string);
            }
            catch (Exception exception) {
                Aladin.error = "Unknown object";
                this.error = "Unknown object";
                return;
            }
            this.active = true;
            this.flagOk = true;
            this.setCenter(coord.al, coord.del, d);
        }
    }

    public static final double cosd(double d) {
        return Math.cos(d * (Math.PI / 180));
    }

    protected String getCenter() {
        return this.pcat.nb_o == 0 ? "0 +0" : this.aladin.localisation.toString(((Position)this.pcat.o[0]).raj, ((Position)this.pcat.o[0]).dej);
    }

    protected void getInfo() {
        this.aladin.status.setText(String.valueOf(this.label) + " - reference coordinates: " + this.getCenter());
    }

    protected String getRoll() {
        if (!this.flagRoll) {
            return "0.0";
        }
        return String.valueOf(this.roll);
    }

    protected boolean isRollable() {
        return this.flagRoll;
    }

    protected void memTarget() {
    }

    protected void reset() {
        this.selectAll(false);
        this.setCenter(((Position)this.pcat.o[0]).raj, ((Position)this.pcat.o[0]).dej, this.roll);
        this.selectAll(true);
    }

    private void selectAll(boolean bl) {
        int n = 0;
        while (n < this.pcat.nb_o) {
            Position position = (Position)this.pcat.o[n];
            position.select = bl;
            if (this.aladin.view.vselobj.contains(position)) {
                if (!bl) {
                    this.aladin.view.vselobj.removeElement(position);
                }
            } else if (bl) {
                this.aladin.view.vselobj.addElement(position);
            }
            ++n;
        }
    }

    private void setACS(double d, double d2, double d3) {
        this.flagRoll = true;
        this.roll = d3;
        this.setCCD(d, d2, d3, 0.03403737070403737, 0.017018685352018684, ACS_DRA, ACS_DDE, null, null, 0.0);
    }

    void setCCD(double d, double d2, double d3, double d4, double d5, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d6) {
        int n;
        double d7;
        double d8;
        int n2 = 0;
        switch (this.instr) {
            case 0: 
            case 4: 
            case 5: {
                double d9 = this.instr == 0 ? -0.004166666666666667 : 0.004166666666666667;
                double d10 = this.instr == 0 ? 0.008333333333333333 : -0.005694444444444445;
                d8 = d;
                d7 = d2;
                d -= d9 / PlanField.cosd(d2);
                d2 -= d10;
                n = dArray.length;
                break;
            }
            default: {
                d8 = d;
                d7 = d2;
                n = 0;
            }
        }
        if (this.pcat.o != null) {
            Objet[] objetArray = this.pcat.o;
            this.pcat.nb_o = objetArray.length + dArray.length * 5 + n;
            this.pcat.o = new Objet[this.pcat.nb_o];
            System.arraycopy(objetArray, 0, this.pcat.o, 0, objetArray.length);
            n2 = objetArray.length;
        } else {
            this.pcat.nb_o = dArray.length * 5 + 1 + n;
            this.pcat.o = new Objet[this.pcat.nb_o];
            n2 = 1;
            this.pcat.o[0] = d6 > 0.0 ? new Champ((Plan)this, new Coord(d8, d7), d6) : new Champ((Plan)this, new Coord(d8, d7));
        }
        Proj3 proj3 = new Proj3(1, d, d2);
        double d11 = proj3.getX();
        double d12 = proj3.getY();
        int n3 = this.pcat.nb_o - n;
        double d13 = 0.0;
        double d14 = 0.0;
        if (d3 != 0.0) {
            d13 = Coo.cosd(d3);
            d14 = Coo.sind(d3);
        }
        int n4 = 0;
        while (n4 < dArray.length) {
            int n5 = 0;
            while (n5 < 5) {
                Ligne ligne = new Ligne(this);
                this.pcat.o[n2] = ligne;
                double d15 = dArray3 == null ? 0.0 : dArray3[n4] / 3600.0;
                double d16 = dArray4 == null ? 0.0 : dArray4[n4] / 3600.0;
                double d17 = d11 + PlanField.tand((dArray[n4] + (n5 == 1 || n5 == 2 ? 1.0 : 0.0)) * d4 + d15);
                double d18 = d12 + PlanField.tand((dArray2[n4] + (n5 == 2 || n5 == 3 ? 1.0 : 0.0)) * d5 + d16);
                if (d3 != 0.0) {
                    double d19 = d17 * d13 + d18 * d14;
                    double d20 = -d17 * d14 + d18 * d13;
                    d17 = d19;
                    d18 = d20;
                }
                proj3.computeAngles(d17, d18);
                ligne.raj = proj3.getLon();
                ligne.dej = proj3.getLat();
                switch (this.instr) {
                    case 0: 
                    case 4: 
                    case 5: {
                        if (n5 != 0) break;
                        String string = new String();
                        switch (this.instr) {
                            case 0: {
                                string = CFH12K_CCD[n4];
                                break;
                            }
                            case 4: 
                            case 5: {
                                string = this.flagGuider ? MEGAGUI_BOX[n4] : MEGACAM_CCD[n4];
                                break;
                            }
                        }
                        Texte texte = new Texte(this, 0.0, 0.0, string);
                        texte.dej = ligne.dej + 0.011111111111111112;
                        texte.raj = ligne.raj + 0.011111111111111112 / PlanField.cosd(texte.dej);
                        this.pcat.o[n3++] = texte;
                        break;
                    }
                }
                if (n5 > 0) {
                    ligne.debligne = (Ligne)this.pcat.o[n2 - 1];
                }
                if (n5 < 4) {
                    ligne.finligne = (Ligne)this.pcat.o[n2 + 1];
                }
                ++n5;
                ++n2;
            }
            ++n4;
        }
    }

    private void setCFH12K(double d, double d2) {
        this.flagRoll = false;
        this.roll = 0.0;
        this.setCCD(d, d2, 0.0, 0.11719111111111111, 0.23438222222222221, CFH12K_DRA, CFH12K_DDE, CFH12K_GAPRA, CFH12K_GAPDE, 0.0);
    }

    protected synchronized boolean setCenter(double d, double d2) {
        if (this.flagOk) {
            return false;
        }
        this.setCenter(d, d2, this.roll);
        this.active = true;
        this.aladin.calque.repaint();
        return true;
    }

    protected void setCenter(double d, double d2, double d3) {
        this.projd = new Projection(null, 3, d, d2, this.instr == 3 ? 5 : (this.instr == 6 ? 10 : 45), 250.0, 250.0, 500.0, 0.0, false, 0);
        this.flagProj = false;
        this.pcat.o = null;
        switch (this.instr) {
            case 4: {
                this.setMEGACAM(d, d2);
                break;
            }
            case 5: {
                this.setMEGAPRIME(d, d2);
                break;
            }
            case 0: {
                this.setCFH12K(d, d2);
                break;
            }
            case 1: {
                this.setEPICMOS(d, d2, d3);
                break;
            }
            case 2: {
                this.setEPICPN(d, d2, d3);
                break;
            }
            case 3: {
                this.setWFPC2(d, d2, d3);
                break;
            }
            case 6: {
                this.setACS(d, d2, d3);
                break;
            }
        }
        this.flagOk = true;
    }

    private void setEPICMOS(double d, double d2, double d3) {
        this.flagRoll = true;
        this.roll = d3;
        this.setCCD(d, d2, d3, 0.18166666666666667, 0.18166666666666667, EPICMOS_DRA, EPICMOS_DDE, null, null, 0.25);
    }

    private void setEPICPN(double d, double d2, double d3) {
        this.flagRoll = true;
        this.roll = d3;
        this.setCCD(d, d2, d3, 0.07333333333333333, 0.22666666666666666, EPICPN_DRA, EPICPN_DDE, null, null, 0.25);
    }

    private void setInstr(String string) {
        int n = 0;
        while (n < INSTR.length) {
            if (INSTR[n].equals(string)) {
                this.instr = n;
                return;
            }
            ++n;
        }
        this.instr = -1;
    }

    private void setMEGACAM(double d, double d2) {
        this.flagRoll = false;
        this.roll = 0.0;
        this.setCCD(d, d2, 0.0, 0.10638222222222223, 0.23956777777777777, MEGACAM_DRA, MEGACAM_DDE, MEGACAM_GAPRA, MEGACAM_GAPDE, 0.5);
    }

    private void setMEGAPRIME(double d, double d2) {
        this.flagRoll = false;
        this.roll = 0.0;
        this.setCCD(d, d2, 0.0, 0.10638222222222223, 0.23956777777777777, MEGACAM_DRA, MEGACAM_DDE, MEGACAM_GAPRA, MEGACAM_GAPDE, 0.5);
        this.flagGuider = true;
        this.setCCD(d, d2, 0.0, 0.3425, 0.24736111111111111, MEGAGUI_DRA, MEGAGUI_DDE, MEGAGUI_GAPRA, MEGAGUI_GAPDE, 0.0);
        this.flagGuider = false;
    }

    private void setWFPC2(double d, double d2, double d3) {
        this.flagRoll = true;
        this.roll = d3;
        Proj3 proj3 = new Proj3(1, d, d2);
        this.pcat.nb_o = 10;
        this.pcat.o = new Objet[10];
        this.pcat.o[0] = new Champ((Plan)this, new Coord(d, d2));
        proj3.computeXY(d, d2);
        double d4 = proj3.getX();
        double d5 = proj3.getY();
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl = true;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d3 != 0.0) {
            d8 = Coo.cosd(d3);
            d9 = Coo.sind(d3);
        }
        int n = 1;
        while (n <= 9) {
            Ligne ligne = new Ligne(this);
            this.pcat.o[n] = ligne;
            if (n == 1 || n == 8 || n == 9) {
                d6 = d4 + PlanField.tand(0.01861111111111111);
            } else if (n == 2 || n == 3) {
                d6 = d4 + PlanField.tand(-0.02347222222222222);
            } else if (n == 4 || n == 5) {
                d6 = d4 + PlanField.tand(-0.012361111111111111);
            } else if (n == 6 || n == 7) {
                d6 = d4 + PlanField.tand(-0.0030555555555555557);
            }
            if (n == 1 || n == 2 || n == 9) {
                d7 = d5 + PlanField.tand(-0.0175);
            } else if (n == 4 || n == 3) {
                d7 = d5 + PlanField.tand(0.0030555555555555557);
            } else if (n == 6 || n == 5) {
                d7 = d5 + PlanField.tand(0.0125);
            } else if (n == 7 || n == 8) {
                d7 = d5 + PlanField.tand(0.024166666666666666);
            }
            if (d3 != 0.0) {
                double d10 = d6 * d8 + d7 * d9;
                double d11 = -d6 * d9 + d7 * d8;
                d6 = d10;
                d7 = d11;
            }
            proj3.computeAngles(d6, d7);
            ligne.raj = proj3.getLon();
            ligne.dej = proj3.getLat();
            if (n > 1) {
                ligne.debligne = (Ligne)this.pcat.o[n - 1];
            }
            if (n < 9) {
                ligne.finligne = (Ligne)this.pcat.o[n + 1];
            }
            ++n;
        }
    }

    public static final double tand(double d) {
        return Math.tan(d * (Math.PI / 180));
    }
}

