/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanFilter;
import cds.aladin.PlanImage;
import cds.aladin.PlanObjet;
import cds.aladin.Projection;
import java.awt.Color;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Plan
implements Runnable {
    static final String NOREDUCTION = "No astronomical reduction";
    static final int NO = 0;
    static final int IMAGE = 1;
    static final int CATALOG = 2;
    static final int TOOL = 3;
    static final int FIELD = 4;
    static final int FOLDER = 5;
    static final int FILTER = 6;
    static String[] Tp = new String[]{"", "Image", "Catalog", "Tool", "FoV", "Scale", "Folder", "Filter"};
    protected int type;
    protected int folder;
    protected boolean collapse;
    protected String objet;
    protected String label;
    protected String param;
    protected Coord co;
    protected Thread sr;
    protected Color c;
    protected Projection projd;
    protected Hashtable projD = null;
    protected String from;
    boolean[] influence = new boolean[PlanFilter.LIMIT];
    boolean flagOk;
    boolean active;
    boolean selected;
    boolean ref;
    Projection proj;
    boolean flagProj;
    String error;
    boolean flagLocal;
    protected boolean xyLock;
    int xzoom;
    int yzoom;
    int zoom = -1;
    PlanObjet pcat;
    Thread runme;
    URL u;
    Aladin aladin;
    double pourcent;

    protected void Free() {
        this.type = 0;
        this.param = null;
        this.label = null;
        this.error = null;
        this.objet = null;
        this.co = null;
        this.projd = null;
        this.proj = null;
        this.projD = null;
        if (this.sr != null) {
            this.sr.stop();
        }
        this.sr = null;
        this.pcat = null;
        this.xyLock = false;
        this.flagProj = false;
        this.ref = false;
        this.active = false;
        this.selected = false;
        this.flagOk = false;
        this.collapse = false;
        this.zoom = 0;
        this.folder = 0;
        System.gc();
    }

    protected boolean equals(Plan plan) {
        if (!this.theSame(plan.type, plan.objet, plan.param)) {
            return false;
        }
        if (this instanceof PlanImage && plan instanceof PlanImage && !PlanImage.sameFmtRes(this, plan)) {
            return false;
        }
        if (this.error == null && plan.error != null || this.error != null && plan.error == null) {
            return false;
        }
        if (this.error != null && plan.error != null && !this.error.equals(plan.error)) {
            return false;
        }
        if (this.flagOk != plan.flagOk) {
            return false;
        }
        return this.projd == plan.projd;
    }

    protected Plan[] getAvailablePlanRef() {
        Plan[] planArray;
        int n;
        Vector<Object> vector = new Vector<Object>();
        if (this.type == 1) {
            vector.addElement(this);
        } else {
            n = 0;
            while (n < this.aladin.calque.plan.length) {
                planArray = this.aladin.calque.plan[n];
                if ((planArray.type == 1 || planArray.type == 2) && this.aladin.calque.canBeRef(n) && planArray.flagOk && this.projd != null && this.projd.agree(planArray.projd, 1.0)) {
                    vector.addElement(planArray);
                }
                ++n;
            }
        }
        n = vector.size();
        planArray = new Plan[n];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (n2 < n) {
            planArray[n2] = (Plan)enumeration.nextElement();
            ++n2;
        }
        return planArray;
    }

    protected Projection[] getAvailableProj() {
        Enumeration<Object> enumeration;
        Vector<Projection> vector = new Vector<Projection>();
        if (this.projD != null) {
            enumeration = this.projD.keys();
            while (enumeration.hasMoreElements()) {
                Projection projection = (Projection)this.projD.get(enumeration.nextElement());
                vector.addElement(projection);
            }
        }
        int n = vector.size();
        Projection[] projectionArray = new Projection[n];
        enumeration = vector.elements();
        int n2 = 0;
        while (n2 < n) {
            projectionArray[n2] = (Projection)enumeration.nextElement();
            ++n2;
        }
        return projectionArray;
    }

    protected void getInfo() {
        this.aladin.status.setText("");
    }

    protected String getLabel() {
        if (this.error == null && !this.flagOk) {
            return String.valueOf(this.label) + "...";
        }
        return this.label;
    }

    protected double getPourcent() {
        return this.pourcent;
    }

    protected boolean isViewable() {
        if (this.type == 0) {
            return false;
        }
        if (this.type == 3 || this.type == 6 || this.xyLock && this.error != null) {
            return true;
        }
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan != null && plan.projd != null && !plan.projd.agree(this.projd, this.aladin.calque.zoom.getValue())) {
            return false;
        }
        return plan == null || plan == this || this.projd != null && plan.projd != null;
    }

    protected void planReady(boolean bl) {
        if (!bl) {
            this.error = Aladin.error;
            this.aladin.calque.select.repaint();
            this.aladin.toolbox.toolMode();
            return;
        }
        if (!this.isViewable() || this.type == 1) {
            this.aladin.calque.setPlanRef(this);
        }
        this.active = true;
        if (this.aladin.calque.noSelected()) {
            this.selected = true;
        }
        this.pourcent = -1.0;
        this.flagOk = true;
        if (this.type == 2) {
            PlanFilter.newPlan(this);
            if (this.aladin.filterProperties != null) {
                this.aladin.filterProperties.notifyNewPlan();
            }
        }
        if (this.aladin.dialog != null) {
            this.aladin.dialog.setGrab();
        }
        this.aladin.calque.repaint();
    }

    public void run() {
        Aladin.trace(1, "Creating the " + Tp[this.type] + " plane " + this.label);
        this.planReady(this.waitForPlan());
    }

    protected void setFrom(String string) {
        this.from = string;
    }

    protected void setLabel(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\n') {
                cArray[n] = 32;
            }
            ++n;
        }
        this.label = new String(cArray);
    }

    protected void setNewProjD(Projection projection) {
        if (this.projD == null) {
            this.projD = new Hashtable();
        }
        this.projD.put(projection.label, projection);
        this.projd = projection;
        if (this.error != null && this.error.equals(NOREDUCTION)) {
            this.error = null;
        }
    }

    protected boolean setZoom(String string) {
        int n = this.aladin.calque.zoom.getIndex(string.trim());
        if (n == -1) {
            return false;
        }
        this.zoom = n;
        this.xzoom = this.yzoom = this.aladin.calque.zoom.zoomView.SIZE / 2;
        return true;
    }

    public void stop() {
        this.runme.stop();
        this.runme = null;
    }

    protected boolean theSame(int n, String string, String string2) {
        return this.theSame(n, string, string2, null);
    }

    protected boolean theSame(int n, String string, String string2, String string3) {
        if (n != this.type) {
            return false;
        }
        if (string != null && this.objet != null && !this.objet.equals(string)) {
            return false;
        }
        if (string2 != null && this.param != null && !string2.equals(this.param)) {
            return false;
        }
        if (string3 != null) {
            String string4 = "";
            switch (n) {
                case 1: {
                    PlanImage planImage = (PlanImage)this;
                    string4 = String.valueOf(planImage.fmt) + "/" + planImage.res;
                    break;
                }
            }
            if (!string3.equals(string4)) {
                return false;
            }
        }
        return true;
    }

    protected boolean waitForPlan() {
        return false;
    }
}

