/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.HeaderFits;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IDHAGenerator
extends Frame {
    private static final String[] FIELD_NAME = new String[]{"CentralPoint_RA", "CentralPoint_DE", "Size_alpha", "Size_delta", "Position Angle"};
    private static final String[] FIELD_ID = new String[]{"alpha", "delta", "Size_alpha", "Size_delta", "AP"};
    private static final String[] FIELD_MORE = new String[]{"ucd=\"POS_EQ_RA_MAIN\"  datatype=\"float\" unit=\"deg\"", "ucd=\"POS_EQ_DEC_MAIN\"  datatype=\"float\" unit=\"deg\"", "ucd=\"INST_DET_SIZE\" datatype=\"float\" unit=\"deg\"", "ucd=\"INST_DET_SIZE\" datatype=\"float\" unit=\"deg\"", "ucd=\"POS_POS-ANG\" datatype=\"float\" unit=\"deg\""};
    private List progList;
    private TextField newProgTF;
    private Button addProgBtn;
    private List grpList;
    private TextField newGrpTF;
    private Button addGrpBtn;
    private List fileList;
    private Button addFileBtn;
    private Button deleteFileBtn;
    private TextField[] imageValues;
    private Button updateImageValBtn;
    private TextField newCritClassTF;
    private Button addCritClassBtn;
    private Choice critValChoice;
    private TextField critValTF;
    private Button critValBtn;
    private Button showXMLBtn;
    private Button saveXMLBtn;
    private Button scanDirBtn;
    private Vector progs = new Vector();
    private ObsProg currentProg;
    private ObsGroup currentGroup;
    private Image currentImage;
    private static final String allFiles = "*";
    static final String CR = System.getProperty("line.separator");

    IDHAGenerator() {
        super("IDHA generator");
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildMainPanel(), "Center");
        this.add((Component)this.buildBottomPanel(), "South");
        this.pack();
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.addProgBtn)) {
            this.addObsProg(this.newProgTF.getText());
            this.newProgTF.setText("");
        } else if (event.target.equals(this.addGrpBtn)) {
            this.addObsGrp();
        } else if (event.target.equals(this.updateImageValBtn)) {
            this.updateImageValues();
        } else if (event.target.equals(this.addCritClassBtn)) {
            this.addCriteriaClass(this.newCritClassTF.getText());
            this.newCritClassTF.setText("");
        } else if (event.target.equals(this.critValBtn)) {
            int n;
            if (this.currentGroup != null && (n = this.critValChoice.getSelectedIndex()) > 0) {
                this.currentGroup.criteriaValues.put(this.critValChoice.getItem(n), this.critValTF.getText());
            }
        } else if (event.target.equals(this.critValChoice)) {
            if (this.currentGroup != null) {
                String string = this.critValChoice.getSelectedItem();
                String string2 = (String)this.currentGroup.criteriaValues.get(string);
                if (string2 != null) {
                    this.critValTF.setText(string2);
                } else {
                    this.critValTF.setText("");
                }
            }
        } else if (event.target.equals(this.addFileBtn)) {
            if (this.currentGroup != null) {
                this.addFile();
            }
        } else if (event.target.equals(this.deleteFileBtn)) {
            this.deleteFile();
        } else if (event.target.equals(this.scanDirBtn)) {
            this.scanDirectory();
        } else if (event.target.equals(this.showXMLBtn)) {
            this.showXML();
        } else if (event.target.equals(this.saveXMLBtn)) {
            this.saveXML();
        }
        return true;
    }

    private void addCriteriaClass(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.currentProg == null) {
            return;
        }
        if (this.currentProg.criteriaClasses.indexOf(string) < 0) {
            this.currentProg.criteriaClasses.addElement(string);
            this.critValChoice.add(string);
        }
    }

    private void addFile() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Choose a file or a directory", 0);
        fileDialog.setFile(allFiles);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        Image image = null;
        if (string2.equals(allFiles) && string != null) {
            File file = new File(string);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(String.valueOf(string) + stringArray[n]);
                image = new Image(file2);
                this.currentGroup.images.add(image);
                this.processImage(image);
                this.fileList.add(file2.getName());
                ++n;
            }
        } else {
            File file = new File(string3);
            image = new Image(file);
            this.currentGroup.images.add(image);
            this.processImage(image);
            this.fileList.add(file.getName());
        }
    }

    private void addObsGrp() {
        if (this.currentProg != null) {
            ObsGroup obsGroup = new ObsGroup("Group" + this.currentProg.groups.size());
            this.currentProg.groups.addElement(obsGroup);
            this.grpList.add(obsGroup.name);
            if (this.currentGroup == null) {
                this.currentGroup = obsGroup;
                this.grpList.select(0);
            }
        }
    }

    private ObsProg addObsProg(String string) {
        if (string.length() > 0) {
            ObsProg obsProg = new ObsProg(string);
            this.progs.addElement(obsProg);
            this.progList.add(obsProg.name);
            if (this.currentProg == null) {
                this.currentProg = obsProg;
                this.progList.select(0);
            }
            return obsProg;
        }
        return null;
    }

    private Panel buildBottomPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.scanDirBtn = new Button("Scan directory");
        panel.add(this.scanDirBtn);
        this.showXMLBtn = new Button("Show XML");
        panel.add(this.showXMLBtn);
        this.saveXMLBtn = new Button("Save XML in file");
        panel.add(this.saveXMLBtn);
        return panel;
    }

    private Panel buildFileDetailsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Details of current file");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.imageValues = new TextField[FIELD_NAME.length];
        int n = 0;
        while (n < FIELD_NAME.length) {
            Label label2 = new Label(FIELD_NAME[n]);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(label2, gridBagConstraints);
            panel.add(label2);
            this.imageValues[n] = new TextField(15);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.imageValues[n], gridBagConstraints);
            panel.add(this.imageValues[n]);
            ++n;
        }
        this.updateImageValBtn = new Button("Update image infos");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.updateImageValBtn, gridBagConstraints);
        panel.add(this.updateImageValBtn);
        return panel;
    }

    private Panel buildFilePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Files within current group");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.fileList = new List(15);
        this.fileList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                IDHAGenerator.this.updateImage(IDHAGenerator.this.fileList.getSelectedIndex());
            }
        });
        gridBagLayout.setConstraints(this.fileList, gridBagConstraints);
        panel.add(this.fileList);
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        this.addFileBtn = new Button("Add ...");
        panel2.add(this.addFileBtn);
        this.deleteFileBtn = new Button("Delete");
        panel2.add(this.deleteFileBtn);
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel.add(panel2);
        return panel;
    }

    private Panel buildGroupPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Observation Groups");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.grpList = new List(10);
        this.grpList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                IDHAGenerator.this.updateGroup(IDHAGenerator.this.grpList.getSelectedIndex());
            }
        });
        gridBagLayout.setConstraints(this.grpList, gridBagConstraints);
        panel.add(this.grpList);
        this.addGrpBtn = new Button("Add group");
        gridBagLayout.setConstraints(this.addGrpBtn, gridBagConstraints);
        panel.add(this.addGrpBtn);
        this.critValChoice = new Choice();
        this.critValChoice.add("       ----     ");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.critValChoice, gridBagConstraints);
        panel.add(this.critValChoice);
        this.critValTF = new TextField(10);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.critValTF, gridBagConstraints);
        panel.add(this.critValTF);
        this.critValBtn = new Button("Set value");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.critValBtn, gridBagConstraints);
        panel.add(this.critValBtn);
        return panel;
    }

    private Panel buildMainPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 10, 5));
        panel.add(this.buildProgPanel());
        panel.add(this.buildGroupPanel());
        panel.add(this.buildFilePanel());
        panel.add(this.buildFileDetailsPanel());
        return panel;
    }

    private Panel buildProgPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Observation Programs");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.progList = new List(15);
        this.progList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                IDHAGenerator.this.updateProg(IDHAGenerator.this.progList.getSelectedIndex());
            }
        });
        gridBagLayout.setConstraints(this.progList, gridBagConstraints);
        panel.add(this.progList);
        this.newProgTF = new TextField(10);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.newProgTF, gridBagConstraints);
        panel.add(this.newProgTF);
        this.addProgBtn = new Button("Add");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.addProgBtn, gridBagConstraints);
        panel.add(this.addProgBtn);
        this.newCritClassTF = new TextField(10);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.newCritClassTF, gridBagConstraints);
        panel.add(this.newCritClassTF);
        this.addCritClassBtn = new Button("Add criteria");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.addCritClassBtn, gridBagConstraints);
        panel.add(this.addCritClassBtn);
        return panel;
    }

    private void deleteFile() {
        int n = this.fileList.getSelectedIndex();
        if (n >= 0) {
            this.fileList.remove(n);
            this.currentGroup.images.removeElementAt(n);
        }
    }

    private void fillObsProg(ObsProg obsProg, Vector vector, File file, int n) {
        File[] fileArray = this.getDirs(file);
        if (fileArray == null || fileArray.length == 0) {
            ObsGroup obsGroup = new ObsGroup("group" + obsProg.groups.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                obsGroup.criteriaValues.put(obsProg.criteriaClasses.elementAt(n2), vector.elementAt(n2));
                ++n2;
            }
            String[] stringArray = file.list();
            int n3 = 0;
            while (n3 < stringArray.length) {
                Image image = new Image(new File(file, stringArray[n3]));
                obsGroup.images.addElement(image);
                this.processImage(image);
                ++n3;
            }
            obsProg.groups.addElement(obsGroup);
        } else {
            String string = "criteria" + n;
            if (obsProg.criteriaClasses.indexOf(string) < 0) {
                obsProg.criteriaClasses.addElement(string);
                System.out.println("Adding constraint " + string);
            }
            int n4 = 0;
            while (n4 < fileArray.length) {
                Vector vector2 = new Vector();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(enumeration.nextElement());
                }
                vector2.addElement(fileArray[n4].getName());
                System.out.println("Adding constraint value " + fileArray[n4].getName());
                this.fillObsProg(obsProg, vector2, fileArray[n4], n + 1);
                ++n4;
            }
        }
    }

    private StringBuffer generateXML() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>" + CR + "<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">");
        stringBuffer.append(String.valueOf(CR) + "<VOTABLE>");
        Enumeration enumeration = this.progs.elements();
        while (enumeration.hasMoreElements()) {
            ObsProg obsProg = (ObsProg)enumeration.nextElement();
            stringBuffer.append(String.valueOf(CR) + "<RESOURCE name=\"ObservingProgram\">");
            if (bl) {
                stringBuffer.append(String.valueOf(CR) + "<TABLE ID=\"ObservingProgram\">");
                stringBuffer.append(String.valueOf(CR) + "<FIELD ID=\"Name\" name=\"Name\" datatype=\"char\" ucd=\"ID_SURVEY\" /> ");
                bl = false;
            } else {
                stringBuffer.append(String.valueOf(CR) + "<TABLE ref=\"ObservingProgram\">");
            }
            stringBuffer.append(String.valueOf(CR) + "<DATA><TABLEDATA>");
            stringBuffer.append(String.valueOf(CR) + "<TR><TD>" + obsProg.name + "</TD></TR>");
            stringBuffer.append(String.valueOf(CR) + "</TABLEDATA></DATA>");
            stringBuffer.append(String.valueOf(CR) + "</TABLE>");
            Enumeration enumeration2 = obsProg.groups.elements();
            while (enumeration2.hasMoreElements()) {
                Object object;
                Object object2;
                ObsGroup obsGroup = (ObsGroup)enumeration2.nextElement();
                stringBuffer.append(String.valueOf(CR) + "<RESOURCE name=\"Observation_Group\">");
                if (bl2) {
                    stringBuffer.append(String.valueOf(CR) + "<TABLE ID=\"Observation_Group\">");
                    stringBuffer.append(String.valueOf(CR) + "<FIELD ID=\"Selection_Criterion\" name=\"Selection_Criterion\" datatype=\"char\" />");
                    stringBuffer.append(String.valueOf(CR) + "<FIELD ID=\"Selection-Range\" name=\"Selection-Range\" datatype=\"char\" />");
                    bl2 = false;
                } else {
                    stringBuffer.append(String.valueOf(CR) + "<TABLE ref=\"Observation_Group\">");
                }
                stringBuffer.append(String.valueOf(CR) + "<DATA><TABLEDATA>");
                Enumeration enumeration3 = obsProg.criteriaClasses.elements();
                while (enumeration3.hasMoreElements()) {
                    object2 = (String)enumeration3.nextElement();
                    stringBuffer.append(String.valueOf(CR) + "<TR><TD>" + (String)object2 + "</TD><TD>" + obsGroup.criteriaValues.get(object2) + "</TD></TR>");
                }
                if (obsProg.criteriaClasses.size() == 0) {
                    stringBuffer.append(String.valueOf(CR) + "<TR><TD>Group</TD><TD>" + obsGroup.name + "</TD></TR>");
                }
                stringBuffer.append(String.valueOf(CR) + "</TABLEDATA></DATA>");
                stringBuffer.append(String.valueOf(CR) + "</TABLE>");
                stringBuffer.append(String.valueOf(CR) + "<RESOURCE name=\"Observation\">");
                if (bl3) {
                    stringBuffer.append(String.valueOf(CR) + "<TABLE ID=\"Observation\">");
                    stringBuffer.append(String.valueOf(CR) + "<FIELD ID=\"Observation_Name\" name=\"Observation_Name\" datatype=\"char\" ucd=\"ID_IMAGE\" />");
                    int n = 0;
                    while (n < FIELD_ID.length) {
                        stringBuffer.append(String.valueOf(CR) + "<FIELD ID=\"" + FIELD_ID[n] + "\" name=\"" + FIELD_NAME[n] + "\" " + FIELD_MORE[n] + " />");
                        ++n;
                    }
                    bl3 = false;
                } else {
                    stringBuffer.append(String.valueOf(CR) + "<TABLE ref=\"Observation\">");
                }
                stringBuffer.append(String.valueOf(CR) + "<DATA><TABLEDATA>");
                object2 = obsGroup.images.elements();
                while (object2.hasMoreElements()) {
                    object = (Image)object2.nextElement();
                    stringBuffer.append(String.valueOf(CR) + "<TR>");
                    stringBuffer.append("<TD>" + ((Image)object).file.getName() + "</TD>");
                    int n = 0;
                    while (n < ((Image)object).values.length) {
                        stringBuffer.append("<TD>" + ((Image)object).values[n] + "</TD>");
                        ++n;
                    }
                    stringBuffer.append(String.valueOf(CR) + "</TR>");
                }
                stringBuffer.append(String.valueOf(CR) + "</TABLEDATA></DATA>");
                stringBuffer.append(String.valueOf(CR) + "</TABLE>");
                stringBuffer.append(String.valueOf(CR) + "</RESOURCE>");
                stringBuffer.append(String.valueOf(CR) + "<RESOURCE name=\"StorageMapping\">");
                if (bl4) {
                    stringBuffer.append(String.valueOf(CR) + "<TABLE ID=\"StorageMapping\">");
                    stringBuffer.append(String.valueOf(CR) + "<FIELD ref=\"Observation_Name\" />");
                    stringBuffer.append(String.valueOf(CR) + "<FIELD ID=\"Location\" name=\"Location\" datatype=\"char\" />");
                    bl4 = false;
                } else {
                    stringBuffer.append(String.valueOf(CR) + "<TABLE ref=\"StorageMapping\">");
                }
                stringBuffer.append(String.valueOf(CR) + "<DATA><TABLEDATA>");
                object = obsGroup.images.elements();
                while (object.hasMoreElements()) {
                    String string;
                    File file = ((Image)object.nextElement()).file;
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = "";
                    }
                    stringBuffer.append(String.valueOf(CR) + "<TR><TD>" + file.getName() + "</TD><TD>file:/" + string + "</TD></TR>");
                }
                stringBuffer.append(String.valueOf(CR) + "</TABLEDATA></DATA>");
                stringBuffer.append(String.valueOf(CR) + "</TABLE>");
                stringBuffer.append(String.valueOf(CR) + "</RESOURCE>");
                stringBuffer.append(String.valueOf(CR) + "</RESOURCE>");
            }
            stringBuffer.append(String.valueOf(CR) + "</RESOURCE>");
        }
        stringBuffer.append(String.valueOf(CR) + "</VOTABLE>");
        return stringBuffer;
    }

    private File[] getDirs(File file) {
        String[] stringArray = file.list();
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                vector.addElement(file2);
            }
            ++n;
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
            System.exit(0);
        }
        return super.handleEvent(event);
    }

    public static void main(String[] stringArray) {
        IDHAGenerator iDHAGenerator = new IDHAGenerator();
        iDHAGenerator.show();
    }

    private void processImage(Image image) {
        Coord coord;
        HeaderFits headerFits = null;
        try {
            headerFits = new HeaderFits(new PushbackInputStream(new FileInputStream(image.file)), null);
        }
        catch (Exception exception) {
            System.err.println("Error : could not create HeaderFits object");
            return;
        }
        Calib calib = null;
        try {
            calib = new Calib(headerFits);
        }
        catch (Exception exception) {
            System.err.println("Error : could not create Calib object");
            return;
        }
        try {
            coord = calib.getImgCenter();
        }
        catch (Exception exception) {
            System.err.println("Error while retrieving image center");
            coord = null;
        }
        if (coord != null) {
            image.values[0] = Float.toString((float)coord.al);
            image.values[1] = Float.toString((float)coord.del);
        }
        image.values[2] = Float.toString((float)calib.getImgWidth());
        image.values[3] = Float.toString((float)calib.getImgHeight());
        image.values[4] = Float.toString((float)calib.getProjRot());
    }

    private void saveXML() {
        FileDialog fileDialog = new FileDialog((Frame)this, "", 1);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        File file = new File(string3);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            dataOutputStream.writeBytes(this.generateXML().toString());
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error while writing file !!");
            iOException.printStackTrace();
        }
    }

    private void scanDirectory() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Go into the start directory", 0);
        fileDialog.setFile(allFiles);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        File file = new File(string);
        System.out.println("Setting start directory: " + file);
        File[] fileArray = this.getDirs(file);
        System.out.println("Retrieving Observing programs directories: " + fileArray.length + " directories found");
        int n = 0;
        while (n < fileArray.length) {
            String string4 = fileArray[n].getName();
            System.out.println("Adding Observation Program " + string4);
            ObsProg obsProg = this.addObsProg(string4);
            this.fillObsProg(obsProg, new Vector(), fileArray[n], 0);
            ++n;
        }
        this.currentProg = null;
    }

    private void showXML() {
        StringBuffer stringBuffer = this.generateXML();
        System.out.println(stringBuffer);
    }

    private void updateGroup(int n) {
        ObsGroup obsGroup = this.currentGroup;
        this.currentGroup = (ObsGroup)this.currentProg.groups.elementAt(n);
        if (this.currentGroup != obsGroup) {
            this.critValChoice.select(0);
            this.critValTF.setText("");
            this.currentImage = null;
            int n2 = 0;
            while (n2 < FIELD_NAME.length) {
                this.imageValues[n2].setText("");
                ++n2;
            }
            this.fileList.removeAll();
            Enumeration enumeration = this.currentGroup.images.elements();
            while (enumeration.hasMoreElements()) {
                this.fileList.add(((Image)enumeration.nextElement()).file.getName());
            }
        }
    }

    private void updateImage(int n) {
        Image image = this.currentImage;
        this.currentImage = (Image)this.currentGroup.images.elementAt(n);
        if (this.currentImage != image) {
            int n2 = 0;
            while (n2 < this.currentImage.values.length) {
                this.imageValues[n2].setText(this.currentImage.values[n2]);
                ++n2;
            }
        }
    }

    private void updateImageValues() {
        if (this.currentImage == null) {
            return;
        }
        int n = 0;
        while (n < FIELD_NAME.length) {
            this.currentImage.values[n] = this.imageValues[n].getText();
            ++n;
        }
    }

    private void updateProg(int n) {
        ObsProg obsProg = this.currentProg;
        this.currentProg = (ObsProg)this.progs.elementAt(n);
        if (this.currentProg != obsProg) {
            this.grpList.removeAll();
            Enumeration enumeration = this.currentProg.groups.elements();
            while (enumeration.hasMoreElements()) {
                this.grpList.add(((ObsGroup)enumeration.nextElement()).name);
            }
            this.currentGroup = null;
            this.currentImage = null;
            int n2 = 0;
            while (n2 < FIELD_NAME.length) {
                this.imageValues[n2].setText("");
                ++n2;
            }
            this.fileList.removeAll();
            this.critValChoice.removeAll();
            this.critValChoice.add("       ----     ");
            Enumeration enumeration2 = this.currentProg.criteriaClasses.elements();
            while (enumeration2.hasMoreElements()) {
                this.critValChoice.add((String)enumeration2.nextElement());
            }
            this.critValTF.setText("");
        }
    }

    class ObsProg {
        Vector groups = new Vector();
        Vector criteriaClasses = new Vector();
        String name;

        ObsProg(String string) {
            this.name = string;
        }
    }

    class ObsGroup {
        Vector images = new Vector();
        Hashtable criteriaValues = new Hashtable();
        String name;

        ObsGroup(String string) {
            this.name = string;
        }
    }

    class Image {
        File file;
        String[] values;

        Image(File file) {
            this.file = file;
            this.values = new String[FIELD_ID.length];
            int n = 0;
            while (n < this.values.length) {
                this.values[n] = "";
                ++n;
            }
        }
    }
}

