/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanImage;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public final class HeaderFits
extends Frame {
    StringBuffer memoHeaderFits = null;
    TextArea ta;
    boolean flagHCOMP;
    protected Hashtable header;
    int sizeHeader = 0;
    String key;
    String value;

    protected HeaderFits(PushbackInputStream pushbackInputStream, GZIPInputStream gZIPInputStream) throws Exception {
        this.makeTA();
        this.readHeader(pushbackInputStream, gZIPInputStream);
    }

    protected HeaderFits(String string) {
        if (string.length() % 2880 == 0 && string.indexOf(10) < 0) {
            this.makeTA();
            this.readHeader(string);
        } else {
            this.readFreeHeader(string);
        }
    }

    private void appendMHF(String string) {
        if (this.memoHeaderFits == null) {
            this.memoHeaderFits = new StringBuffer();
        }
        this.memoHeaderFits.append(String.valueOf(string.trim()) + "\n");
    }

    protected double getDoubleFromHeader(String string) throws NumberFormatException, NullPointerException {
        String string2 = (String)this.header.get(string.trim());
        double d = Double.valueOf(this.trimDouble(string2));
        return d;
    }

    protected String getHeader() {
        return this.memoHeaderFits.toString();
    }

    protected int getIntFromHeader(String string) throws NumberFormatException, NullPointerException {
        String string2 = (String)this.header.get(string.trim());
        int n = Integer.parseInt(string2.trim());
        return n;
    }

    protected int getSizeHeader() {
        return this.sizeHeader;
    }

    protected String getStringFromHeader(String string) throws NullPointerException {
        return (String)this.header.get(string.trim());
    }

    private String getValue(byte[] byArray) {
        int n = 9;
        while (n < 80) {
            if (byArray[n] == 47) break;
            ++n;
        }
        return new String(byArray, 0, 9, n - 9).trim();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)this).hide();
        }
        return super.handleEvent(event);
    }

    protected boolean isHCOMP() {
        return this.flagHCOMP;
    }

    private void makeTA() {
        ((Component)this).setBackground(Aladin.BKGD);
        this.ta = new TextArea(50, 70);
        this.ta.setFont(Aladin.COURIER);
        Aladin.makeAdd(this, this.ta, "Center");
        this.move(50, 50);
        this.pack();
    }

    protected boolean readFreeHeader(String string) {
        Aladin.trace(3, "Reading FITS header from a free string");
        this.header = new Hashtable();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=/");
            String string2 = stringTokenizer2.nextToken().trim();
            String string3 = stringTokenizer2.nextToken().trim();
            this.header.put(string2, string3);
        }
        return true;
    }

    protected boolean readHeader(PushbackInputStream pushbackInputStream, GZIPInputStream gZIPInputStream) throws Exception {
        int n = 2880;
        int n2 = 80;
        int n3 = 0;
        this.sizeHeader = 0;
        boolean bl = true;
        Aladin.trace(3, "Reading FITS header");
        byte[] byArray = new byte[n2];
        this.header = new Hashtable();
        try {
            while (true) {
                if (gZIPInputStream != null) {
                    PlanImage.gzipReadFully(gZIPInputStream, byArray, 0, n2);
                } else {
                    PlanImage.streamReadFully(pushbackInputStream, byArray);
                }
                String string = new String(byArray, 0, 0, 8);
                if (n3 == 0 && !string.equals("SIMPLE  ")) {
                    throw new Exception();
                }
                this.appendMHF(new String(byArray, 0));
                this.sizeHeader += n2;
                ++n3;
                if (string.equals("END     ")) break;
                if (byArray[8] != 61) continue;
                String string2 = this.getValue(byArray);
                this.header.put(string.trim(), string2);
            }
            int n4 = 0;
            if (gZIPInputStream == null) {
                n4 = pushbackInputStream.read();
                if (n4 != 221) {
                    pushbackInputStream.unread(n4);
                } else {
                    this.flagHCOMP = true;
                    pushbackInputStream.unread(n4);
                    return true;
                }
            }
            this.flagHCOMP = false;
            int n5 = n - this.sizeHeader % n;
            if (n5 != n) {
                byte[] byArray2 = new byte[n5];
                if (gZIPInputStream != null) {
                    PlanImage.gzipReadFully(gZIPInputStream, byArray2, 0, n5);
                } else {
                    PlanImage.streamReadFully(pushbackInputStream, byArray2);
                }
                this.sizeHeader += n5;
            }
        }
        catch (Exception exception) {
            if (n3 == 0) {
                Aladin.error = "Remote server message:\n" + new String(byArray, 0);
            } else {
                Aladin.error = "Fits header error (line " + (n3 + 1) + ")";
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
            }
            throw new Exception();
        }
        return true;
    }

    protected boolean readHeader(String string) {
        int n = 80;
        byte[] byArray = new byte[n];
        char[] cArray = string.toCharArray();
        Aladin.trace(3, "Reading FITS header");
        this.header = new Hashtable();
        int n2 = 0;
        while (cArray.length - n2 >= n) {
            int n3 = 0;
            while (n3 < n) {
                byArray[n3] = (byte)cArray[n3 + n2];
                ++n3;
            }
            this.appendMHF(new String(byArray, 0));
            String string2 = new String(byArray, 0, 0, 8);
            if (string2.substring(0, 3).equals("END")) break;
            if (byArray[8] == 61) {
                String string3 = this.getValue(byArray);
                this.header.put(string2.trim(), string3);
            }
            n2 += n;
        }
        return true;
    }

    protected void seeHeaderFits() {
        this.ta.setText("");
        this.ta.appendText(this.getHeader());
        this.show();
    }

    private String trimDouble(String string) {
        char c;
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            c = cArray[n];
            if (c == '+' || c == '-' || c == '.' || c >= '0' && c <= '9') break;
            ++n;
        }
        int n2 = cArray.length - 1;
        while (n2 >= n) {
            c = cArray[n2];
            if (c >= '0' && c <= '9' || c == '.') {
                ++n2;
                break;
            }
            --n2;
        }
        return new String(cArray, n, n2 - n);
    }
}

