/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyLabel;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public final class FrameRGB
extends Frame {
    static final String R = "R";
    static final String G = "G";
    static final String B = "B";
    static final String X = "best resolution";
    static final String SUBMIT = "CREATE";
    static final String RESET = "Reset";
    static final String HELP = "Caveat";
    static final String CANCEL = "Close";
    static final String HELPSTRING = "The Aladin Java resampling is based on the nearest pixel.\nEach pixel of the sampling reference image is converted in coordinates\naccording to its astrometric solution. These coordinates are\nconverted in pixel coordinates in the two others images using their\nrespective astrometric solution. The corresponding pixel values\nare taken without any linear or others methods. It is typically\nthe \"winner takes all\" algorithm.\n \nWARNING: Before interpreting what you see in terms\nof \"color differences\" be cautious that:\n \n1) If the spatial resolutions are really different,\nchoosing the best resolution image as reference image\nwill lead to large areas of pixels showing artificially\nthe color chosen for the low resolution image.\n \n2) Even in the case of similar resolutions,\ndiscrepencies in the astrometries lead to  artificial color\njumps at location of bright objects which can mask\nreal color effects.";
    Aladin a;
    boolean flagHide = true;
    Choice cR;
    Choice cG;
    Choice cB;
    PlanImage[] choicePlan;
    CheckboxGroup cbg;
    Checkbox cbDiff;
    Checkbox cbX;

    protected FrameRGB(Aladin aladin) {
        super("RGB image generator");
        ((Component)this).setBackground(Aladin.BKGD);
        this.a = aladin;
        if (!Aladin.LSCREEN) {
            this.move(400, 300);
        } else {
            this.move(800, 400);
        }
        this.choicePlan = new PlanImage[0];
        this.createPanel();
    }

    public boolean action(Event event, Object object) {
        if (CANCEL.equals(object)) {
            this.hide();
        } else if (SUBMIT.equals(object)) {
            PlanImage planImage = this.getPlan(this.cR);
            PlanImage planImage2 = this.getPlan(this.cB);
            PlanImage planImage3 = this.getPlan(this.cG);
            String string = this.cbg.getCurrent().getLabel();
            PlanImage planImage4 = string.equals(R) ? planImage : (string.equals(B) ? planImage2 : (string.equals(G) ? planImage3 : null));
            boolean bl = this.cbDiff.isEnabled() && this.cbDiff.getState();
            this.a.calque.newPlanImageRGB(planImage, planImage3, planImage2, planImage4, bl);
        } else if (HELP.equals(object)) {
            this.a.message.info(HELPSTRING);
        } else if (RESET.equals(object)) {
            this.reset();
        } else if (event.target instanceof Choice) {
            this.adjustCbDiff();
        }
        return true;
    }

    private void adjustCbDiff() {
        boolean bl;
        int n = (this.cR.getSelectedIndex() > 0 ? 1 : 0) + (this.cG.getSelectedIndex() > 0 ? 1 : 0) + (this.cB.getSelectedIndex() > 0 ? 1 : 0);
        boolean bl2 = this.cbDiff.isEnabled();
        boolean bl3 = bl = n == 2;
        if (bl2 == bl) {
            return;
        }
        if (bl) {
            this.cbDiff.enable();
        } else {
            this.cbDiff.disable();
        }
    }

    private void adjustImageChoice(Choice choice) {
        this.adjustImageChoice(choice, 0);
    }

    private void adjustImageChoice(Choice choice, int n) {
        int n2 = choice.getSelectedIndex();
        String string = n2 >= 0 ? choice.getItem(n2) : null;
        choice.removeAll();
        this.setItems(choice);
        if (n2 >= 0) {
            choice.select(string);
        } else {
            choice.select(n < choice.countItems() ? n : 0);
        }
    }

    private void createPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        MyLabel myLabel = new MyLabel("Specify two or three images as color components,\nchoose the reference image for the re-sampling and\npress the CREATE button to create a RGB image plane.", 1, Aladin.ITALIC);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(myLabel, gridBagConstraints);
        panel.add(myLabel);
        Label label = new Label("1) Red:");
        label.setForeground(Color.red);
        label.setFont(Aladin.BOLD);
        Label label2 = new Label("2) Green:");
        label2.setForeground(Color.green);
        label2.setFont(Aladin.BOLD);
        Label label3 = new Label("3) Blue:");
        label3.setForeground(Color.blue);
        label3.setFont(Aladin.BOLD);
        Label label4 = new Label("   Sampling ref:");
        this.cR = new Choice();
        this.cR.setFont(Aladin.BOLD);
        this.cG = new Choice();
        this.cG.setFont(Aladin.BOLD);
        this.cB = new Choice();
        this.cB.setFont(Aladin.BOLD);
        this.cbg = new CheckboxGroup();
        Checkbox checkbox = new Checkbox(R);
        checkbox.setCheckboxGroup(this.cbg);
        Checkbox checkbox2 = new Checkbox(G);
        checkbox2.setCheckboxGroup(this.cbg);
        Checkbox checkbox3 = new Checkbox(B);
        checkbox3.setCheckboxGroup(this.cbg);
        this.cbX = new Checkbox(X);
        this.cbX.setCheckboxGroup(this.cbg);
        this.cbg.setCurrent(this.cbX);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(this.cR, gridBagConstraints);
        panel.add(this.cR);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(this.cG, gridBagConstraints);
        panel.add(this.cG);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        panel.add(label3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(this.cB, gridBagConstraints);
        panel.add(this.cB);
        Panel panel2 = new Panel();
        panel2.add(label4);
        panel2.add(checkbox);
        panel2.add(checkbox2);
        panel2.add(checkbox3);
        panel2.add(this.cbX);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel.add(panel2);
        this.cbDiff = new Checkbox("images substractions");
        this.cbDiff.disable();
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbDiff, gridBagConstraints);
        panel.add(this.cbDiff);
        gridBagConstraints.fill = 1;
        Panel panel3 = this.valid();
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        panel.add(panel3);
        Aladin.makeAdd(this, panel, "Center");
        this.pack();
    }

    private PlanImage[] getPlan() {
        Vector<Plan> vector = new Vector<Plan>();
        int n = 0;
        while (n < this.a.calque.plan.length) {
            if (this.a.calque.plan[n].type == 1 && this.a.calque.plan[n].flagOk && this.a.calque.plan[n].error == null && !(this.a.calque.plan[n] instanceof PlanImageRGB)) {
                vector.addElement(this.a.calque.plan[n]);
            }
            ++n;
        }
        PlanImage[] planImageArray = new PlanImage[vector.size()];
        Enumeration enumeration = vector.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            planImageArray[n] = (PlanImage)enumeration.nextElement();
            ++n;
        }
        return planImageArray;
    }

    private PlanImage getPlan(Choice choice) {
        int n = choice.getSelectedIndex() - 1;
        if (n < 0) {
            return null;
        }
        return this.choicePlan[n];
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    public void hide() {
        this.flagHide = true;
        this.a.toolbox.tool[11].mode = 1;
        this.a.toolbox.toolMode();
        this.a.toolbox.repaint();
        super.hide();
    }

    protected void majRGB() {
        if (this.a.toolbox.tool[11].mode == -1) {
            PlanImage[] planImageArray = this.getPlan();
            if (!this.flagHide && planImageArray.length == this.choicePlan.length) {
                return;
            }
            this.show();
        } else {
            this.hide();
        }
    }

    private void reset() {
        this.cR.select(0);
        this.cG.select(0);
        this.cB.select(0);
        this.cbg.setCurrent(this.cbX);
    }

    private void setItems(Choice choice) {
        choice.addItem("-- none --");
        int n = 0;
        while (n < this.choicePlan.length) {
            choice.addItem(String.valueOf(this.choicePlan[n].label) + " - \"" + this.choicePlan[n].objet + "\"");
            ++n;
        }
    }

    public void show() {
        this.choicePlan = this.getPlan();
        boolean bl = this.choicePlan.length == 3;
        this.adjustImageChoice(this.cR, bl ? 3 : 0);
        this.adjustImageChoice(this.cG, bl ? 2 : 0);
        this.adjustImageChoice(this.cB, bl ? 1 : 0);
        if (this.flagHide) {
            super.show();
        }
        this.adjustCbDiff();
        this.flagHide = false;
    }

    protected Panel valid() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.setFont(Aladin.LBOLD);
        panel.add(new Button(SUBMIT));
        panel.add(new Button(RESET));
        panel.add(new Button(HELP));
        panel.add(new Button(CANCEL));
        return panel;
    }
}

