/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ContourPlot;
import cds.aladin.Couleur;
import cds.aladin.Curseur;
import cds.aladin.Histogramme;
import cds.aladin.MyLabel;
import cds.aladin.PlanContour;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;

public final class FrameContour
extends Frame {
    static final String CLOSE = "Close";
    static final String RESET = "Reset";
    static final String SUBMIT = "Get Contour";
    static final String NEWLEVEL = "New Level";
    static final String SHOWHELP = "Show HELP";
    static final String HIDEHELP = "Hide HELP";
    static final String SMOOTHINFO = "Smoothing decreases the size of the original picture\nThis allows a faster computation and a reduction \nof the number of control points";
    static final String NOISEINFO = "When active, reduces the noise in the contours by \ncomputing a running average\n(doesn't reduce the number of pixels)";
    static final String ZOOMINFO = "Choose whether contours are computed on\nthe whole image or on the current view";
    static final Font HELPFONT = new Font("Monospaced", 0, 10);
    boolean showHelp = false;
    boolean flagHide = true;
    Panel p;
    Label lab1 = new Label(" Smooth level");
    MyLabel smoothInfo = new MyLabel("Smoothing decreases the size of the original picture\nThis allows a faster computation and a reduction \nof the number of control points", 1, HELPFONT);
    MyLabel noiseInfo = new MyLabel("When active, reduces the noise in the contours by \ncomputing a running average\n(doesn't reduce the number of pixels)", 1, HELPFONT);
    MyLabel zoomInfo = new MyLabel("Choose whether contours are computed on\nthe whole image or on the current view", 1, HELPFONT);
    Button helpBtn;
    Checkbox cb;
    Checkbox noisecb;
    PlanImage pimg;
    Choice nbLevelsChoice;
    Choice smooothLevelChoice;
    CheckboxGroup cGroup;
    Checkbox currentZoomOnly;
    Panel pHist;
    private Color[] couleurs = null;
    private int[] indicesCouleurs = null;
    static final String TITRE = "Contours plotting";
    private double[] levels;
    Aladin a;
    Curseur curs;
    int etat = -1;

    protected FrameContour(Aladin aladin) {
        super(TITRE);
        ((Component)this).setBackground(Aladin.BKGD);
        this.a = aladin;
        this.pimg = (PlanImage)this.a.calque.getPlanBase();
        this.move(350, 200);
        this.curs = new Curseur();
        this.initCouleurs();
        this.fillCouleurTriangle();
    }

    public boolean action(Event event, Object object) {
        if (CLOSE.equals(object)) {
            this.hide();
        } else if (RESET.equals(object)) {
            this.reset();
        } else if (this.nbLevelsChoice.equals(event.target)) {
            this.curs.nbNiveaux = 0;
            int n = Integer.parseInt(this.nbLevelsChoice.getSelectedItem());
            int[] nArray = FrameContour.generateLevels(n);
            int n2 = 0;
            while (n2 < nArray.length) {
                this.curs.addCurseur(nArray[n2]);
                ++n2;
            }
        } else if (this.cb.equals(event.target)) {
            this.adjustsmooothLevelChoice();
        } else if (this.helpBtn.equals(event.target)) {
            this.showHelp ^= true;
            if (this.showHelp) {
                this.helpBtn.setLabel(HIDEHELP);
            } else {
                this.helpBtn.setLabel(SHOWHELP);
            }
            this.smoothInfo.setVisible(this.showHelp);
            this.noiseInfo.setVisible(this.showHelp);
            this.zoomInfo.setVisible(this.showHelp);
            if (this.showHelp) {
                this.move(this.getLocation().x, 70);
            } else {
                this.move(this.getLocation().x, 200);
            }
            this.pack();
        } else if (SUBMIT.equals(object)) {
            this.hide();
            ContourPlot contourPlot = new ContourPlot();
            this.parseLevels();
            int n = this.a.calque.newPlanContour("Contours", this.levels, contourPlot, this.cb.getState(), Integer.parseInt(this.smooothLevelChoice.getSelectedItem()), this.currentZoomOnly.getState(), this.noisecb.getState(), this.couleurs);
            this.initCouleurs();
            this.fillCouleurTriangle();
            this.curs.repaint();
        } else if (NEWLEVEL.equals(object)) {
            this.curs.addCurseur();
        }
        return true;
    }

    private void adjustsmooothLevelChoice() {
        if (!this.cb.getState()) {
            this.smooothLevelChoice.disable();
            this.lab1.disable();
        } else {
            this.smooothLevelChoice.enable();
            this.lab1.enable();
        }
    }

    private void createPanel() {
        if (this.p != null) {
            this.remove(this.p);
        }
        this.setLayout(new BorderLayout(5, 5));
        this.p = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        Label label = new Label(TITRE, 1);
        label.setFont(Aladin.LBOLD);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.p.add(label);
        MyLabel myLabel = new MyLabel("Choose the level values");
        gridBagLayout.setConstraints(myLabel, gridBagConstraints);
        this.p.add(myLabel);
        this.pHist = new Panel();
        this.pHist.setLayout(new FlowLayout(1));
        Histogramme histogramme = new Histogramme(this.pimg);
        this.pHist.add(histogramme);
        gridBagLayout.setConstraints(this.pHist, gridBagConstraints);
        this.p.add(this.pHist);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.add(this.curs);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.p.add(panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(new Label("Generate"));
        this.nbLevelsChoice = new Choice();
        int n = 2;
        while (n <= 10) {
            this.nbLevelsChoice.add(new Integer(n).toString());
            ++n;
        }
        int n2 = 12;
        while (n2 <= 20) {
            this.nbLevelsChoice.add(new Integer(n2).toString());
            n2 += 2;
        }
        this.nbLevelsChoice.select("4");
        panel2.add(this.nbLevelsChoice);
        panel2.add(new Label("levels evenly spaced"));
        this.action(new Event(this.nbLevelsChoice, 501, this.nbLevelsChoice), this.nbLevelsChoice);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.p.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        panel3.add(new Label("Manually add a"));
        panel3.add(new Button(NEWLEVEL));
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        this.p.add(panel3);
        this.smoothInfo.setVisible(this.showHelp);
        gridBagLayout.setConstraints(this.smoothInfo, gridBagConstraints);
        this.p.add(this.smoothInfo);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(1));
        this.cb = new Checkbox("Use smoothing", null, false);
        this.cb.setState(true);
        this.smooothLevelChoice = new Choice();
        this.smooothLevelChoice.add(new Integer(2).toString());
        this.smooothLevelChoice.add(new Integer(3).toString());
        this.smooothLevelChoice.add(new Integer(4).toString());
        this.smooothLevelChoice.select("2");
        this.smooothLevelChoice.enable();
        this.lab1.enable();
        panel4.add(this.cb);
        panel4.add(this.lab1);
        panel4.add(this.smooothLevelChoice);
        gridBagLayout.setConstraints(panel4, gridBagConstraints);
        this.p.add(panel4);
        this.noiseInfo.setVisible(this.showHelp);
        gridBagLayout.setConstraints(this.noiseInfo, gridBagConstraints);
        this.p.add(this.noiseInfo);
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout(1));
        this.noisecb = new Checkbox("Reduce noise", null, true);
        panel5.add(this.noisecb);
        gridBagLayout.setConstraints(panel5, gridBagConstraints);
        this.p.add(panel5);
        this.zoomInfo.setVisible(this.showHelp);
        gridBagLayout.setConstraints(this.zoomInfo, gridBagConstraints);
        this.p.add(this.zoomInfo);
        this.currentZoomOnly = new Checkbox("Consider only current zoom", false);
        gridBagLayout.setConstraints(this.currentZoomOnly, gridBagConstraints);
        this.p.add(this.currentZoomOnly);
        this.helpBtn = new Button(this.showHelp ? HIDEHELP : SHOWHELP);
        gridBagLayout.setConstraints(this.helpBtn, gridBagConstraints);
        this.p.add(this.helpBtn);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout(2));
        panel6.add(new Button(SUBMIT));
        panel6.add(new Button(RESET));
        panel6.add(new Button(CLOSE));
        gridBagLayout.setConstraints(panel6, gridBagConstraints);
        this.p.add(panel6);
        this.add("Center", this.p);
        this.pack();
        this.show();
        this.flagHide = false;
    }

    private void fillCouleurTriangle() {
        int n = 0;
        while (n < this.curs.couleurTriangle.length) {
            this.curs.couleurTriangle[n] = this.couleurs[n];
            ++n;
        }
    }

    protected static int[] generateLevels(int n) {
        int n2 = 0;
        int n3 = 255;
        int[] nArray = new int[n];
        double d = (n3 - n2) / (n + 1);
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = (int)(d + d * (double)n4);
            ++n4;
        }
        return nArray;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    public void hide() {
        this.a.toolbox.tool[12].mode = this.a.calque.getPlanBase() != null ? 1 : 0;
        this.a.toolbox.repaint();
        this.flagHide = true;
        this.etat = -1;
        super.hide();
    }

    private void initCouleurs() {
        if (this.couleurs == null) {
            this.couleurs = new Color[20];
        }
        Color color = PlanContour.getNextColor(this.a.calque);
        Color[] colorArray = Couleur.getBrighterColors(color, 4);
        int n = 0;
        while (n < this.couleurs.length) {
            this.couleurs[n] = colorArray[n % colorArray.length];
            ++n;
        }
    }

    protected void majContour() {
        if (this.a.toolbox.tool[12].mode == -1) {
            PlanImage planImage = (PlanImage)this.a.calque.getPlanBase();
            if (planImage != null && planImage.flagOk && !(planImage instanceof PlanImageRGB)) {
                int n = planImage.getEtat();
                if (this.showHelp) {
                    this.move(350, 70);
                } else {
                    this.move(350, 200);
                }
                if (this.etat != n) {
                    this.etat = n;
                    this.pimg = planImage;
                    this.createPanel();
                }
            }
            return;
        }
        this.hide();
    }

    private void parseLevels() {
        this.levels = new double[this.curs.nbNiveaux];
        int n = 0;
        while (n < this.curs.nbNiveaux) {
            this.levels[n] = this.curs.niveaux[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.levels.length) {
            double d = this.levels[n2];
            Color color = this.couleurs[n2];
            int n3 = n2 + 1;
            while (n3 < this.levels.length) {
                if (this.levels[n3] < d) {
                    double d2 = d;
                    d = this.levels[n3];
                    this.levels[n3] = d2;
                    Color color2 = color;
                    color = this.couleurs[n3];
                    this.couleurs[n3] = color2;
                    this.couleurs[n2] = color;
                }
                ++n3;
            }
            this.levels[n2] = d;
            ++n2;
        }
    }

    protected void reset() {
        this.curs.reset();
        this.curs.niveaux[0] = 100;
        this.curs.nbNiveaux = 1;
    }

    public void show() {
        this.initCouleurs();
        this.fillCouleurTriangle();
        super.show();
        this.flagHide = false;
    }
}

