/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ColorMap;
import cds.aladin.MyLabel;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.image.IndexColorModel;

public final class FrameCM
extends Frame {
    static final String TITRE = "Color map fixer";
    static final String REVERSE = "Reverse";
    static final String CM = "BB/A/Gray";
    static final String PREVIOUS = "Prev.";
    static final String RESET = "Reset";
    static final String CLOSE = "Close";
    static final String HELP = "Help";
    static final String METHODE = "Move the three triangles to adjust\nthe color map according to\nthe image color histogram";
    static final String MESSAGE = "This histogram represents the number count \nof each pixel value (in a logarithm scale).\n \nThe polyline overlayed on its histogram shows the poly-linear mapping\nfrom the pixel values to their corresponding color intensities.\n \nThe three triangles allows you to control this mapping :\n  .the left one adjusts the cut-low pixel value,\n  .the right one adjusts the cut-hight pixel value,\n  .the middle one adjusts the dynamic mapping.\n \nYou can move the triangles by clicking/dragging them or\nwith the arrow keys after having pointed the relevant triangle.\n \nAn excerpt of the image in the frame view shows you\nimmediately the result comparatively to the previous mapping.";
    PlanImage pimg;
    Aladin aladin;
    ColorMap cm = null;
    ColorMap cm2 = null;
    ColorMap cm3 = null;
    Panel p = null;
    boolean flagHide = true;
    int etat;

    protected FrameCM(Aladin aladin) {
        super(TITRE);
        this.aladin = aladin;
        super.show();
        this.move(400, 300);
        ((Component)this).setBackground(Aladin.BKGD);
        super.hide();
    }

    public boolean action(Event event, Object object) {
        if (CLOSE.equals(object)) {
            this.dispose();
        } else if (PREVIOUS.equals(object)) {
            this.previous();
        } else if (RESET.equals(object)) {
            this.reset();
        } else if (REVERSE.equals(object)) {
            this.reverse();
        } else if (HELP.equals(object)) {
            this.aladin.message.info(MESSAGE);
        } else if (CM.equals(object)) {
            this.changeCM();
        }
        System.gc();
        return true;
    }

    private void changeCM() {
        ++this.pimg.typeCM;
        if (this.pimg.typeCM >= 3) {
            this.pimg.typeCM = 0;
        }
        this.cm.repaint();
        this.setCM(this.cm.getCM());
    }

    public void dispose() {
        if (this.flagHide) {
            return;
        }
        this.memoControl();
        this.aladin.toolbox.tool[9].mode = this.aladin.calque.getPlanBase() != null ? 1 : 0;
        this.aladin.toolbox.repaint();
        this.flagHide = true;
        this.etat = -1;
        super.dispose();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
        }
        return super.handleEvent(event);
    }

    protected void majCM() {
        if (this.aladin.toolbox.tool[9].mode == -1) {
            this.memoControl();
            PlanImage planImage = (PlanImage)this.aladin.calque.getPlanBase();
            if (planImage != null && planImage.flagOk) {
                int n = planImage.getEtat();
                if (this.etat == -1 || this.etat != n && n % 2 != 1) {
                    this.etat = n;
                    this.showCM(planImage);
                }
            }
            return;
        }
        this.dispose();
    }

    private void memoControl() {
        if (this.pimg == null) {
            return;
        }
        if (this.pimg instanceof PlanImageRGB) {
            int n = 0;
            while (n < 3) {
                PlanImageRGB planImageRGB = (PlanImageRGB)this.pimg;
                if (planImageRGB.Red != null) {
                    planImageRGB.RGBControl[n] = this.cm.triangle[n];
                }
                if (planImageRGB.Green != null) {
                    planImageRGB.RGBControl[3 + n] = this.cm2.triangle[n];
                }
                if (planImageRGB.Blue != null) {
                    planImageRGB.RGBControl[6 + n] = this.cm3.triangle[n];
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < 3) {
                this.pimg.cmControl[n] = this.cm.triangle[n];
                ++n;
            }
        }
    }

    private void previous() {
        if (this.pimg instanceof PlanImageRGB) {
            if (((PlanImageRGB)this.pimg).Red != null) {
                this.cm.previous();
                ((PlanImageRGB)this.pimg).filterRGB(this.cm.triangle, 0);
            }
            if (((PlanImageRGB)this.pimg).Green != null) {
                this.cm2.previous();
                ((PlanImageRGB)this.pimg).filterRGB(this.cm.triangle, 1);
            }
            if (((PlanImageRGB)this.pimg).Blue != null) {
                this.cm3.previous();
                ((PlanImageRGB)this.pimg).filterRGB(this.cm.triangle, 2);
            }
            this.aladin.view.repaint();
            this.repaint();
            this.aladin.calque.zoom.zoomView.repaint();
        } else {
            this.cm.previous();
            this.setCM(this.cm.getCM());
        }
    }

    private void reset() {
        if (this.pimg instanceof PlanImageRGB) {
            if (((PlanImageRGB)this.pimg).Red != null) {
                this.cm.reset();
            }
            if (((PlanImageRGB)this.pimg).Green != null) {
                this.cm2.reset();
            }
            if (((PlanImageRGB)this.pimg).Blue != null) {
                this.cm3.reset();
            }
            ((PlanImageRGB)this.pimg).createImgRGB();
            this.aladin.view.repaint();
            this.aladin.calque.zoom.zoomView.repaint();
        } else {
            this.cm.reset();
            this.setCM(this.cm.getCM());
        }
    }

    private void reverse() {
        this.pimg.video = this.pimg.video == 0 ? 1 : 0;
        if (this.pimg instanceof PlanImageRGB) {
            if (((PlanImageRGB)this.pimg).Red != null) {
                this.cm.pimg.video = this.pimg.video;
                this.cm.repaint();
            }
            if (((PlanImageRGB)this.pimg).Green != null) {
                this.cm2.pimg.video = this.pimg.video;
                this.cm2.repaint();
            }
            if (((PlanImageRGB)this.pimg).Blue != null) {
                this.cm3.pimg.video = this.pimg.video;
                this.cm3.repaint();
            }
            ((PlanImageRGB)this.pimg).inverseRGB();
            this.aladin.view.repaint();
            this.aladin.calque.zoom.zoomView.repaint();
        } else {
            this.cm.repaint();
            this.setCM(this.cm.getCM());
        }
    }

    private void setCM(IndexColorModel indexColorModel) {
        this.pimg.setCM(indexColorModel);
        this.pimg.aladin.calque.zoom.zoomView.setCM(indexColorModel);
    }

    protected void showCM(PlanImage planImage) {
        boolean bl = false;
        this.pimg = planImage;
        if (this.p != null) {
            this.remove(this.p);
        } else {
            bl = true;
        }
        this.p = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        MyLabel myLabel = new MyLabel("Color map fixer\nfor " + planImage.objet, 1);
        myLabel.setFont(Aladin.LBOLD);
        gridBagLayout.setConstraints(myLabel, gridBagConstraints);
        this.p.add(myLabel);
        Panel panel = new Panel();
        MyLabel myLabel2 = new MyLabel(METHODE);
        gridBagLayout.setConstraints(myLabel2, gridBagConstraints);
        panel.add(myLabel2);
        panel.add(new Button(HELP));
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.p.add(panel);
        if (planImage instanceof PlanImageRGB) {
            if (((PlanImageRGB)planImage).Red != null) {
                this.cm = new ColorMap(planImage, 0);
                gridBagLayout.setConstraints(this.cm, gridBagConstraints);
                this.p.add(this.cm);
            }
            if (((PlanImageRGB)planImage).Green != null) {
                this.cm2 = new ColorMap(planImage, 1);
                gridBagLayout.setConstraints(this.cm2, gridBagConstraints);
                this.p.add(this.cm2);
            }
            if (((PlanImageRGB)planImage).Blue != null) {
                this.cm3 = new ColorMap(planImage, 2);
                gridBagLayout.setConstraints(this.cm3, gridBagConstraints);
                this.p.add(this.cm3);
            }
        } else {
            this.cm = new ColorMap(planImage, -1);
            gridBagLayout.setConstraints(this.cm, gridBagConstraints);
            this.p.add(this.cm);
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(2));
        panel2.add(new Button(REVERSE));
        if (!(planImage instanceof PlanImageRGB)) {
            panel2.add(new Button(CM));
        }
        panel2.add(new Button(PREVIOUS));
        panel2.add(new Button(RESET));
        panel2.add(new Button(CLOSE));
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.p.add(panel2);
        this.add("Center", this.p);
        this.pack();
        this.show();
        this.toFront();
        if (bl) {
            this.setResizable(false);
        }
        this.flagHide = false;
    }
}

