/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FilterHelp;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.Properties;
import cds.aladin.Source;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class FilterProperties
extends Frame
implements MouseListener {
    private static final String SELECT = "Select";
    private static final String EXPORT = "Export";
    private static final String UCD = "Open UCD Browser";
    private static final String FILTERHELP = "Help on syntax";
    private static final String FILTERMANUAL = "Get Manual";
    private static final String SAVEFILTER = "Save filter";
    private static final String LOADFILTER = "Load filter";
    private static final String PICKCOLUMN = "*Pick a column*";
    private static final String PICKUCD = "*Pick a UCD*";
    private static final String SHAPEFUNC = "*Shape functions*";
    private static final String COLORFUNC = "*Color functions*";
    private static final String URLUCD = "http://vizier.u-strasbg.fr/UCD/UCD/java/";
    private static final String[] UCDBASE = new String[]{"CLASS*", "PHOT*"};
    FileDialog fd = null;
    Aladin aladin;
    PlanFilter plan;
    String oscript;
    String olabel;
    private Panel panel;
    private int hcmemo = 0;
    private boolean flagHide = true;
    private boolean computeCol = true;
    private boolean pickUCDMode = false;
    private boolean pickColumnMode = false;
    private TextField label;
    private TextArea filterDef;
    private String saveDef;
    private Choice predefFilters;
    private PopupMenu popup;
    private Menu columnMenu;
    private Menu currentUcdMenu;
    private Label titre;
    private int oldIndex = 0;

    protected FilterProperties(Aladin aladin) {
        super("Filter");
        ((Component)this).setBackground(Aladin.BKGD);
        this.aladin = aladin;
        super.show();
        if (!Aladin.LSCREEN) {
            this.move(400, 300);
        } else {
            this.move(800, 400);
        }
        super.hide();
    }

    public boolean action(Event event, Object object) {
        if ("Apply".equals(object)) {
            this.apply();
        } else if ("Close".equals(object)) {
            this.hide();
        } else if (event.target instanceof MenuItem) {
            if (object.equals(PICKCOLUMN)) {
                this.pickColumnMode = true;
                this.pickUCDMode = false;
            } else if (object.equals(PICKUCD)) {
                this.pickUCDMode = true;
                this.pickColumnMode = false;
            } else {
                MenuItem menuItem = (MenuItem)event.target;
                this.filterDef.insert(menuItem.getActionCommand(), this.filterDef.getCaretPosition());
            }
        } else if (this.predefFilters != null && this.predefFilters.equals(event.target)) {
            int n = this.predefFilters.getSelectedIndex();
            if (this.oldIndex == 0) {
                this.saveDef = this.filterDef.getText();
            }
            this.oldIndex = n;
            if (n == 0) {
                this.filterDef.setText(this.saveDef);
            } else if (n - 1 < PlanFilter.PREDEFFILTERS.length) {
                this.filterDef.setText(PlanFilter.PREDEFFILTERS[n - 1]);
            } else {
                this.filterDef.setText(PlanFilter.saveFilters[n - 1 - PlanFilter.PREDEFFILTERS.length]);
            }
        } else if (FILTERMANUAL.equals(object)) {
            this.aladin.glu.showDocument("Aladin.filterManual", "");
        } else if (FILTERHELP.equals(object)) {
            FilterHelp filterHelp = FilterHelp.getInstance();
            if (!filterHelp.isShowing()) {
                filterHelp.show();
            }
            filterHelp.toFront();
        } else if (SAVEFILTER.equals(object)) {
            this.showFileDialog(1);
            this.saveFilter();
        } else if (LOADFILTER.equals(object)) {
            this.showFileDialog(0);
            this.loadFilter();
        }
        return true;
    }

    private void apply() {
        this.plan.label = this.label.getText();
        this.plan.updateDefinition(this.filterDef.getText(), this.label.getText());
        this.filterDef.setText(this.plan.script);
        this.majPredefFilters(this.plan);
        this.label.setText(this.plan.label);
        this.titre.setText("Properties of the filter ``" + this.plan.label + "''");
        this.saveDef = this.filterDef.getText();
        this.aladin.view.repaint();
        this.aladin.calque.select.repaint();
    }

    protected boolean clickInMesure(Source source, int n) {
        if (!this.isShowing()) {
            return false;
        }
        if (n >= source.leg.field.length) {
            return true;
        }
        if (this.pickColumnMode) {
            String string = source.leg.field[n].name;
            string = string != null ? string : "";
            this.filterDef.insert("${" + string + "}", this.filterDef.getCaretPosition());
            this.pickColumnMode = false;
            return true;
        }
        if (this.pickUCDMode) {
            String string = source.leg.field[n].ucd;
            string = string != null ? string : "";
            this.filterDef.insert("$[" + string + "]", this.filterDef.getCaretPosition());
            this.pickUCDMode = false;
            return true;
        }
        return false;
    }

    private void createPopup() {
        MenuItem menuItem;
        this.popup = new PopupMenu();
        this.columnMenu = new Menu("-- Choose a column --");
        Menu menu = new Menu("-- Choose a UCD --");
        Menu menu2 = new Menu("-- Choose an action");
        this.popup.add(this.columnMenu);
        this.popup.add(menu);
        this.popup.add(menu2);
        Menu menu3 = new Menu("Frequenly used UCDs");
        int n = 0;
        while (n < UCDBASE.length) {
            menuItem = new MenuItem(UCDBASE[n]);
            menuItem.setActionCommand("$[" + UCDBASE[n] + "]");
            menu3.add(menuItem);
            ++n;
        }
        this.currentUcdMenu = new Menu("UCDs in loaded catalogs");
        menu.add(PICKUCD);
        menu.add("-");
        menu.add(menu3);
        menu.add(this.currentUcdMenu);
        Menu menu4 = new Menu("Shape functions");
        Menu menu5 = new Menu("Color functions");
        menuItem = new MenuItem(String.valueOf("ellipse".toUpperCase()) + "(semi-maj. axis, semi-minor axis, pos. angle)");
        menuItem.setActionCommand("draw ellipse(,,)");
        menu4.add(menuItem);
        menuItem = new MenuItem(String.valueOf("circle".toUpperCase()) + "(parameter)");
        menuItem.setActionCommand("draw circle()");
        menu4.add(menuItem);
        menuItem = new MenuItem(String.valueOf("fillcircle".toUpperCase()) + "(parameter)");
        menuItem.setActionCommand("draw fillcircle()");
        menu4.add(menuItem);
        menuItem = new MenuItem(String.valueOf("pm".toUpperCase()) + "(proper motion RA, proper motion Dec)");
        menuItem.setActionCommand("draw pm(,)");
        menu4.add(menuItem);
        menu4.add("-");
        int n2 = 0;
        while (n2 < Action.NOPARAMSHAPE.length) {
            menuItem = new MenuItem(Action.NOPARAMSHAPE[n2]);
            menuItem.setActionCommand("draw " + Action.NOPARAMSHAPE[n2]);
            menu4.add(menuItem);
            ++n2;
        }
        menuItem = new MenuItem(String.valueOf("rgb".toUpperCase()) + "(red param., green param., blue param.)");
        menuItem.setActionCommand("draw rgb(,,)");
        menu5.add(menuItem);
        menuItem = new MenuItem(String.valueOf("rainbow".toUpperCase()) + "(parameter)");
        menuItem.setActionCommand("draw rainbow()");
        menu5.add(menuItem);
        menu5.add("-");
        int n3 = 0;
        while (n3 < Action.COLORNAME.length) {
            menuItem = new MenuItem(Action.COLORNAME[n3]);
            menuItem.setActionCommand("draw " + Action.COLORNAME[n3]);
            menu5.add(menuItem);
            ++n3;
        }
        menu2.add(menu4);
        menu2.add(menu5);
    }

    private void createPredefFilters() {
        this.predefFilters = new Choice();
        this.predefFilters.add("----");
        int n = 0;
        while (n < PlanFilter.PREDEFLABELS.length) {
            this.predefFilters.add("** " + PlanFilter.PREDEFLABELS[n] + " **");
            ++n;
        }
        int n2 = 0;
        while (n2 <= PlanFilter.num) {
            this.predefFilters.add(PlanFilter.saveLabels[n2]);
            ++n2;
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    public void hide() {
        this.flagHide = true;
        this.aladin.toolbox.tool[13].mode = 1;
        this.aladin.toolbox.toolMode();
        this.aladin.toolbox.repaint();
        super.hide();
    }

    private void loadFilter() {
        String string = this.fd.getDirectory();
        String string2 = this.fd.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        File file = new File(string3);
        String string4 = new String();
        try {
            String string5;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            while ((string5 = dataInputStream.readLine()) != null) {
                string4 = String.valueOf(string4) + string5 + "\n";
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            this.aladin.message.warning("I/O error : " + iOException, 1);
            return;
        }
        this.plan.updateDefinition(string4, null);
        this.showProp(this.plan);
        this.titre.setText("Properties of the filter ``" + this.plan.label + "''");
        this.majPredefFilters(this.plan);
        this.aladin.calque.select.repaint();
        this.aladin.view.setMesure();
    }

    private void majPredefFilters(PlanFilter planFilter) {
        int n = PlanFilter.PREDEFLABELS.length + this.plan.numero + 1;
        this.predefFilters.remove(n);
        this.predefFilters.insert(this.plan.label, n);
        this.predefFilters.select(0);
    }

    protected void majProp() {
        int n = this.aladin.calque.getFirstSelected();
        if (n >= 0 && this.aladin.calque.plan[n].type != 6) {
            return;
        }
        if (this.aladin.toolbox.tool[13].mode == -1 && n >= 0 && this.aladin.calque.plan[n].type == 6) {
            this.showProp((PlanFilter)this.aladin.calque.plan[n]);
            return;
        }
        if (!this.flagHide) {
            this.hide();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0xFFFFFFEF) > 0) {
            this.popup.show(this.filterDef, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void notifyNewPlan() {
        this.computeCol = true;
    }

    protected Panel propertiesPlan() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        this.label = new TextField(this.plan.label, 15);
        Properties.addCouple(panel, "Label:", this.label, gridBagLayout, gridBagConstraints);
        if (this.plan.script.length() == 0) {
            this.plan.active = true;
        }
        Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
        PlanFilter planFilter = this.plan;
        Label label = new Label("Choose a predefined filter");
        label.setFont(Aladin.BOLD);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.createPredefFilters();
        Properties.addCouple(panel, "Predefined filters", this.predefFilters, gridBagLayout, gridBagConstraints);
        Label label2 = new Label("Or enter your own filter definition");
        label2.setFont(Aladin.BOLD);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(2, 2));
        Button button = new Button(FILTERHELP);
        button.setFont(Aladin.LBOLD);
        Button button2 = new Button(FILTERMANUAL);
        button2.setFont(Aladin.LBOLD);
        panel2.add((Component)button, "North");
        panel2.add((Component)button2, "South");
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel.add(panel2);
        this.filterDef = new TextArea(9, 50);
        this.filterDef.addMouseListener(this);
        this.filterDef.setFont(Aladin.COURIER);
        this.filterDef.setText(this.plan.script);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.filterDef, gridBagConstraints);
        panel.add(this.filterDef);
        if (Aladin.STANDALONE) {
            Button button3 = new Button(SAVEFILTER);
            Button button4 = new Button(LOADFILTER);
            Panel panel3 = new Panel();
            panel3.setLayout(new FlowLayout());
            panel3.add(button3);
            panel3.add(button4);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(panel3, gridBagConstraints);
            panel.add(panel3);
            gridBagConstraints.gridx = 0;
        }
        if (this.popup == null) {
            this.createPopup();
        }
        this.filterDef.add(this.popup);
        if (this.computeCol) {
            this.updateUCDAndColumn();
        }
        Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
        Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
        return panel;
    }

    private void saveFilter() {
        String string = this.fd.getDirectory();
        String string2 = this.fd.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        File file = new File(string3);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            dataOutputStream.writeBytes("filter " + this.plan.label + " {\n");
            dataOutputStream.writeBytes(this.plan.script);
            dataOutputStream.writeBytes("\n}\n");
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.aladin.message.warning("I/O error : " + iOException);
        }
    }

    private void showFileDialog(int n) {
        if (this.fd == null || Aladin.JAVABEFORE118) {
            this.fd = new FileDialog((Frame)this, "", n);
        } else {
            this.fd.setMode(n);
        }
        if (n == 1) {
            this.fd.setFile(String.valueOf(this.plan.label) + ".ajs");
        } else {
            this.fd.setFile("");
        }
        this.fd.show();
    }

    void showProp(PlanFilter planFilter) {
        this.flagHide = false;
        if (this.panel != null) {
            if (!this.oscript.equals(planFilter.script)) {
                this.filterDef.setText(planFilter.script);
            }
            if (!this.olabel.equals(planFilter.label)) {
                this.label.setText(planFilter.label);
            }
        }
        this.oscript = planFilter.script;
        this.olabel = planFilter.label;
        if (this.hcmemo == planFilter.hashCode()) {
            if (this.computeCol) {
                this.updateUCDAndColumn();
            }
            if (this.isShowing()) {
                return;
            }
            this.show();
            return;
        }
        boolean bl = this.hcmemo != 0;
        this.hcmemo = planFilter.hashCode();
        this.saveDef = "";
        this.plan = planFilter;
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout(5, 5));
        this.titre = new Label("Properties of the filter ``" + this.plan.label + "''", 1);
        this.titre.setFont(Aladin.LBOLD);
        Aladin.makeAdd(this.panel, this.titre, "North");
        Aladin.makeAdd(this.panel, this.propertiesPlan(), "Center");
        Aladin.makeAdd(this.panel, this.valid(), "South");
        Aladin.makeAdd(this, this.panel, "Center");
        if (!bl) {
            this.pack();
        }
        this.show();
    }

    private void sortLexico(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                if (stringArray[n2].toLowerCase().compareTo(string.toLowerCase()) < 0) {
                    String string2 = string;
                    string = stringArray[n2];
                    stringArray[n2] = string2;
                    stringArray[n] = string;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void updateUCDAndColumn() {
        MenuItem menuItem;
        Aladin.trace(3, "Recompute all available columns and UCD");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = this.aladin.calque.plan.length - 1;
        while (n >= 0) {
            Objet[] objetArray;
            Plan plan = this.aladin.calque.plan[n];
            if (plan.type == 2 && (objetArray = plan.pcat.o) != null) {
                int n2 = objetArray.length - 1;
                while (n2 >= 0) {
                    if (objetArray[n2] instanceof Source) {
                        Source source = (Source)objetArray[n2];
                        int n3 = source.leg.field.length - 1;
                        while (n3 >= 0) {
                            String string = source.leg.field[n3].name;
                            if (vector.indexOf(string) < 0) {
                                vector.addElement(string);
                            }
                            if ((string = source.leg.field[n3].ucd) != null && string.length() > 0 && vector2.indexOf(string) < 0) {
                                vector2.addElement(string);
                            }
                            --n3;
                        }
                    }
                    --n2;
                }
            }
            --n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        Object[] objectArray2 = new String[vector2.size()];
        vector2.copyInto(objectArray2);
        vector2 = null;
        this.sortLexico((String[])objectArray);
        this.sortLexico((String[])objectArray2);
        this.columnMenu.removeAll();
        this.currentUcdMenu.removeAll();
        this.columnMenu.add(PICKCOLUMN);
        this.columnMenu.add("-");
        int n4 = 0;
        while (n4 < objectArray.length) {
            menuItem = new MenuItem((String)objectArray[n4]);
            menuItem.setActionCommand("${" + (String)objectArray[n4] + "}");
            this.columnMenu.add(menuItem);
            ++n4;
        }
        int n5 = 0;
        while (n5 < objectArray2.length) {
            menuItem = new MenuItem((String)objectArray2[n5]);
            menuItem.setActionCommand("$[" + (String)objectArray2[n5] + "]");
            this.currentUcdMenu.add(menuItem);
            ++n5;
        }
        this.computeCol = false;
    }

    protected Panel valid() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.setFont(Aladin.LBOLD);
        panel.add(new Button("Apply"));
        panel.add(new Button("Close"));
        return panel;
    }
}

