/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.ZoomView;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class EISFov {
    double alpha;
    double delta;
    double x;
    double y;
    double angle;
    double cutout_x;
    double cutout_y;
    Color color;
    PointD p1;
    PointD p2;
    PointD p3;
    PointD p4;
    static final double CDFS_CENTER_X = 53.11629;
    static final double CDFS_CENTER_Y = -27.80875;

    EISFov(double d, double d2, double d3, double d4, double d5) {
        this.alpha = d;
        this.delta = d2;
        this.x = d3;
        this.y = d4;
        this.angle = d5;
        this.computePoints();
    }

    EISFov(String string, double d, double d2, double d3) throws Exception {
        Coord coord = new Coord(string);
        this.alpha = coord.al;
        this.delta = coord.del;
        this.x = d;
        this.y = d2;
        this.angle = d3;
        this.computePoints();
    }

    private void computePoints() {
        double d = this.alpha + this.x / 2.0 / Math.cos(this.delta * Math.PI / 180.0);
        double d2 = this.delta + this.y / 2.0;
        this.p1 = new PointD(d, d2);
        d = this.alpha - this.x / 2.0 / Math.cos(this.delta * Math.PI / 180.0);
        d2 = this.delta + this.y / 2.0;
        this.p2 = new PointD(d, d2);
        d = this.alpha - this.x / 2.0 / Math.cos(this.delta * Math.PI / 180.0);
        d2 = this.delta - this.y / 2.0;
        this.p3 = new PointD(d, d2);
        d = this.alpha + this.x / 2.0 / Math.cos(this.delta * Math.PI / 180.0);
        d2 = this.delta - this.y / 2.0;
        this.p4 = new PointD(d, d2);
    }

    protected boolean contains(int n, int n2, Plan plan, ZoomView zoomView) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Coord coord = new Coord(this.alpha, this.delta);
        coord = plan.projd.getXY(coord);
        Point point = zoomView.getViewCoord(coord.x, coord.y);
        double d = point.x;
        double d2 = point.y;
        coord = new Coord(this.p1.x, this.p1.y);
        coord = plan.projd.getXY(coord);
        point = zoomView.getViewCoord(coord.x, coord.y);
        double d3 = point.x;
        double d4 = point.y;
        PointD pointD = this.rotation(new PointD(d3, d4), new PointD(d, d2), this.angle);
        d3 = pointD.x;
        d4 = pointD.y;
        nArray[0] = (int)d3;
        nArray2[0] = (int)d4;
        coord = new Coord(this.p2.x, this.p2.y);
        coord = plan.projd.getXY(coord);
        point = zoomView.getViewCoord(coord.x, coord.y);
        double d5 = point.x;
        double d6 = point.y;
        pointD = this.rotation(new PointD(d5, d6), new PointD(d, d2), this.angle);
        d5 = pointD.x;
        d6 = pointD.y;
        nArray[1] = (int)d5;
        nArray2[1] = (int)d6;
        coord = new Coord(this.p3.x, this.p3.y);
        coord = plan.projd.getXY(coord);
        point = zoomView.getViewCoord(coord.x, coord.y);
        double d7 = point.x;
        double d8 = point.y;
        pointD = this.rotation(new PointD(d7, d8), new PointD(d, d2), this.angle);
        d7 = pointD.x;
        d8 = pointD.y;
        nArray[2] = (int)d7;
        nArray2[2] = (int)d8;
        coord = new Coord(this.p4.x, this.p4.y);
        coord = plan.projd.getXY(coord);
        point = zoomView.getViewCoord(coord.x, coord.y);
        double d9 = point.x;
        double d10 = point.y;
        pointD = this.rotation(new PointD(d9, d10), new PointD(d, d2), this.angle);
        d9 = pointD.x;
        d10 = pointD.y;
        nArray[3] = (int)d9;
        nArray2[3] = (int)d10;
        Rectangle rectangle = new Rectangle((int)d3, (int)d4, (int)(2.0 * (d - d3)), (int)(2.0 * (d2 - d4)));
        Polygon polygon = new Polygon(nArray, nArray2, 4);
        return polygon.contains(n, n2);
    }

    private PointD rotation(PointD pointD, PointD pointD2, double d) {
        double d2 = -d * Math.PI / 180.0;
        double d3 = pointD2.x + (pointD.x - pointD2.x) * Math.cos(d2) - (pointD.y - pointD2.y) * Math.sin(d2);
        double d4 = pointD2.y + (pointD.x - pointD2.x) * Math.sin(d2) + (pointD.y - pointD2.y) * Math.cos(d2);
        return new PointD(d3, d4);
    }
}

