/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;

public class Curseur
extends Canvas {
    static final int NO = -1;
    int[] niveaux;
    int currentTriangle;
    boolean flagDrag = false;
    int nbNiveaux = 0;
    Color[] couleurTriangle;
    final int mX = 10;
    final int mY = 0;
    final int Hp = 0;
    final int W = 276;
    final int H = 24;

    Curseur() {
        this.initNiveaux();
        this.initCouleurs();
        this.setBackground(Aladin.BKGD);
        this.resize(276, 24);
    }

    protected boolean addCurseur() {
        if (this.nbNiveaux >= 20) {
            return false;
        }
        this.niveaux[this.nbNiveaux] = 0;
        ++this.nbNiveaux;
        this.repaint();
        return true;
    }

    protected boolean addCurseur(int n) {
        if (this.nbNiveaux >= 20) {
            return false;
        }
        this.niveaux[this.nbNiveaux] = n;
        ++this.nbNiveaux;
        this.repaint();
        return true;
    }

    protected void drawTriangle(Graphics graphics, int n, int n2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = nArray[3] = n + 10;
        nArray[1] = nArray[0] - 7;
        nArray[2] = nArray[0] + 7;
        nArray2[3] = 4;
        nArray2[0] = 4;
        nArray2[1] = nArray2[2] = nArray2[0] + 10;
        graphics.setColor(this.couleurTriangle[n2]);
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
        graphics.setFont(Aladin.SPLAIN);
        graphics.drawString(String.valueOf(n), 10 + n - 7, 24);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    private void initCouleurs() {
        this.couleurTriangle = new Color[20];
        int n = 0;
        while (n < 20) {
            this.couleurTriangle[n] = Color.black;
            ++n;
        }
    }

    private void initNiveaux() {
        this.niveaux = new int[20];
        this.niveaux[0] = 100;
        this.nbNiveaux = 1;
    }

    public boolean keyDown(Event event, int n) {
        if (this.currentTriangle == -1) {
            return true;
        }
        if (n == 1007) {
            if (this.niveaux[this.currentTriangle] < 255) {
                int n2 = this.currentTriangle;
                this.niveaux[n2] = this.niveaux[n2] + 1;
            }
        } else if (n == 1006 && this.niveaux[this.currentTriangle] > 0) {
            int n3 = this.currentTriangle;
            this.niveaux[n3] = this.niveaux[n3] - 1;
        }
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        n -= 10;
        int n3 = 0;
        while (n3 < this.nbNiveaux) {
            if (n > this.niveaux[n3] - 5 && n < this.niveaux[n3] + 5) {
                this.currentTriangle = n3;
                return true;
            }
            ++n3;
        }
        this.currentTriangle = -1;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.currentTriangle == -1) {
            return true;
        }
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        this.niveaux[this.currentTriangle] = n;
        this.flagDrag = true;
        this.repaint();
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        n -= 10;
        this.requestFocus();
        int n3 = 0;
        while (n3 < this.nbNiveaux) {
            if (n > this.niveaux[n3] - 5 && n < this.niveaux[n3] + 5) {
                this.currentTriangle = n3;
                return true;
            }
            ++n3;
        }
        this.currentTriangle = -1;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.currentTriangle == -1) {
            return true;
        }
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        this.niveaux[this.currentTriangle] = n;
        this.flagDrag = false;
        this.repaint();
        return true;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(10, 3, 265, 3);
        int n = 0;
        while (n < this.nbNiveaux) {
            this.drawTriangle(graphics, this.niveaux[n], n);
            ++n;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(276, 24);
    }

    protected void reset() {
        this.nbNiveaux = 0;
        this.repaint();
    }
}

