/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.astro.Coo;

public final class Cote
extends Ligne {
    protected Cote(Plan plan) {
        super(plan);
        this.bout = 2;
    }

    protected Cote(Plan plan, double d, double d2) {
        super(plan, d, d2, (String)null);
        this.bout = 2;
    }

    protected Cote(Plan plan, double d, double d2, Cote cote) {
        this(plan, d, d2, "", cote);
    }

    protected Cote(Plan plan, double d, double d2, String string) {
        super(plan, d, d2, string);
        this.bout = 2;
    }

    protected Cote(Plan plan, double d, double d2, String string, Cote cote) {
        super(plan, d, d2, string, cote);
        this.bout = 2;
    }

    protected boolean in(double d, double d2, double d3) {
        if (!super.in(d, d2, d3)) {
            return false;
        }
        this.setId();
        return true;
    }

    protected boolean inside(double d, double d2, double d3) {
        Ligne ligne;
        Ligne ligne2;
        if (this.nearArrow(d, d2, d3)) {
            return true;
        }
        if (this.debligne == null) {
            ligne = ligne2 = this.finligne;
        } else {
            ligne = this.debligne;
            ligne2 = this;
        }
        return ligne2.in(d, d2, d3) && !ligne.nearArrow(d, d2, d3);
    }

    protected void setId() {
        Ligne ligne;
        Ligne ligne2;
        if (this.debligne != null) {
            ligne2 = this;
            ligne = this.debligne;
        } else {
            ligne2 = this.finligne;
            ligne = this;
        }
        Plan plan = this.plan.aladin.calque.getPlanRef();
        if (plan != null && plan.projd != null) {
            Coord coord = new Coord();
            coord.x = ligne.x;
            coord.y = ligne.y;
            Coord coord2 = new Coord();
            coord2.x = ligne2.x;
            coord2.y = ligne2.y;
            if (plan.projd.getCoord(coord) != null && plan.projd.getCoord(coord2) != null) {
                double d;
                double d2 = coord2.al - coord.al;
                double d3 = Math.abs(coord.del - coord2.del);
                double d4 = Coo.cosd(coord2.del);
                double d5 = d4 * Coo.sind(d2);
                double d6 = Coo.sind(coord2.del) * Coo.cosd(coord.del) - d4 * Coo.sind(coord.del) * Coo.cosd(d2);
                double d7 = d2 == 0.0 && d3 == 0.0 ? -1000.0 : (d = d6 == 0.0 ? 90.0 : Math.atan2(d5, d6) * 180.0 / Math.PI);
                if (d < 0.0) {
                    d += 360.0;
                }
                if ((d2 = Math.abs(d2)) > 180.0) {
                    d2 -= 360.0;
                }
                double d8 = d2 * Coo.cosd(coord.del);
                this.id = "Dist = " + Coord.getUnit(Coord.getDist(coord, coord2)) + " (diff : RA=" + Coord.getUnit(d8) + "/" + Coord.getUnitTime(d2 / 15.0) + ", DE=" + Coord.getUnit(d3) + ")" + (d == -1000.0 ? "" : " PA = " + (double)Math.round(d * 10.0) / 10.0 + " deg");
                return;
            }
        }
        int n = (int)Math.round(Math.abs(ligne.x - ligne2.x));
        int n2 = (int)Math.round(Math.abs(ligne.y - ligne2.y));
        this.id = String.valueOf(Math.round(Math.abs(Math.sqrt(n * n + n2 * n2)))) + " (delta x=" + n + ", delta y=" + n2 + ")";
    }

    protected void status(Aladin aladin) {
        this.setId();
        super.status(aladin);
    }
}

