/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public final class ColorMap
extends Canvas
implements Runnable {
    static final int MIN = 0;
    static final int MIL = 1;
    static final int MAX = 2;
    static final int NO = 3;
    static final int mX = 10;
    static final int mY = 10;
    static final int Hp = 150;
    static final int W = 276;
    static final int H = 185;
    static final int[] Y = new int[]{160, 160, 85, 11, 11};
    static final int[] Yr = new int[]{11, 11, 85, 160, 160};
    PlanImage pimg;
    byte[] pixels;
    int[] pixelsRGB;
    int width;
    int height;
    double[] hist;
    int currentTriangle = 3;
    int[] triangle = new int[3];
    Image img = null;
    boolean flagDrag = false;
    boolean flagKey = false;
    Thread thread = null;
    int COLOR = -1;
    static byte[] r = new byte[256];
    static byte[] g = new byte[256];
    static byte[] b = new byte[256];

    protected ColorMap(PlanImage planImage, int n) {
        int n2;
        double d = 0.0;
        this.pimg = planImage;
        if (planImage instanceof PlanImageRGB) {
            if (n == 0) {
                this.pixels = ((PlanImageRGB)planImage).red;
            } else if (n == 1) {
                this.pixels = ((PlanImageRGB)planImage).green;
            } else if (n == 2) {
                this.pixels = ((PlanImageRGB)planImage).blue;
            }
            n2 = 0;
            while (n2 < 3) {
                this.triangle[n2] = ((PlanImageRGB)planImage).RGBControl[n * 3 + n2];
                ++n2;
            }
        } else {
            this.pixels = planImage.pixels;
            n2 = 0;
            while (n2 < 3) {
                this.triangle[n2] = planImage.cmControl[n2];
                ++n2;
            }
        }
        this.width = planImage.width;
        this.height = planImage.height;
        this.COLOR = n;
        this.hist = new double[256];
        double d2 = 0.0;
        n2 = 0;
        while (n2 < this.pixels.length) {
            double d3;
            int n3 = this.pixels[n2] & 0xFF;
            this.hist[n3] = this.hist[n3] + 1.0;
            if (d3 > d2) {
                d2 = d3;
            } else if (d3 > d) {
                d = d3;
            }
            ++n2;
        }
        d = Math.log(d + 1.0);
        n2 = 0;
        while (n2 < this.hist.length) {
            this.hist[n2] = n2 > 0 && this.hist[n2] == 0.0 ? this.hist[n2 - 1] : Math.log(this.hist[n2] + 1.0);
            ++n2;
        }
        d += d / 5.0;
        n2 = 0;
        while (n2 < this.hist.length) {
            this.hist[n2] = this.hist[n2] * 150.0 / d;
            ++n2;
        }
        this.setBackground(Aladin.BKGD);
        this.resize(276, 185);
    }

    protected void ajustTriangle() {
        int n = 0;
        while (n < 2) {
            if (this.triangle[n] > this.triangle[n + 1]) {
                this.triangle[n + 1] = this.triangle[n];
            }
            ++n;
        }
        n = 2;
        while (n > 0) {
            if (this.triangle[n] < this.triangle[n - 1]) {
                this.triangle[n - 1] = this.triangle[n];
            }
            --n;
        }
    }

    protected void drawTriangle(Graphics graphics, int n) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = nArray[3] = n + 10;
        nArray[1] = nArray[0] - 7;
        nArray[2] = nArray[0] + 7;
        nArray2[3] = 164;
        nArray2[0] = 164;
        nArray2[1] = nArray2[2] = nArray2[0] + 10;
        graphics.setColor(Color.black);
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.setFont(Aladin.SPLAIN);
        graphics.drawString(String.valueOf(n), 10 + n - 7, 184);
    }

    protected IndexColorModel getCM() {
        return ColorMap.getCM(this.triangle[0], this.triangle[1], this.triangle[2], this.pimg.video == 1, this.pimg.typeCM);
    }

    protected static IndexColorModel getCM(int n, int n2, int n3, boolean bl, int n4) {
        double d;
        double d2;
        int n5 = 0;
        int n6 = n;
        while (n5 < n6) {
            ColorMap.r[n5] = 0;
            ++n5;
        }
        n5 = n3;
        while (n5 < 256) {
            ColorMap.r[n5] = -1;
            ++n5;
        }
        double d3 = n2 - n;
        double d4 = 128.0;
        if (d3 > 0.0) {
            d2 = d4 / d3;
            d = -d2 * (double)n;
            n5 = n;
            n6 = n2;
            while (n5 < n6) {
                double d5 = (double)n5 * d2 + d;
                ColorMap.r[n5] = (byte)d5;
                ++n5;
            }
        }
        if ((d3 = (double)(n3 - n2)) > 0.0) {
            d2 = d4 / d3;
            d = 128.0 - d2 * (double)n2;
            n5 = n2;
            n6 = n3;
            while (n5 < n6) {
                ColorMap.r[n5] = (byte)((double)n5 * d2 + d);
                ++n5;
            }
        }
        if (bl) {
            n5 = 0;
            while (n5 < 256) {
                ColorMap.r[n5] = ~r[n5];
                ++n5;
            }
        }
        if (n4 == 1) {
            n5 = 0;
            while (n5 < 256) {
                int n7;
                int n8 = r[n5] & 0xFF;
                int n9 = n8 << 1;
                if (n9 > 255) {
                    n9 = 255;
                }
                if ((n7 = n8 - 64 << 1) < 0) {
                    n7 = 0;
                } else if (n7 > 255) {
                    n7 = 255;
                }
                int n10 = n8 - 128 << 1;
                if (n10 < 0) {
                    n10 = 0;
                }
                ColorMap.r[n5] = (byte)n9;
                ColorMap.g[n5] = (byte)n7;
                ColorMap.b[n5] = (byte)n10;
                ++n5;
            }
        } else if (n4 == 2) {
            n5 = 0;
            while (n5 < 256) {
                int n11;
                int n12;
                int n13 = r[n5] & 0xFF;
                int n14 = n13 < 64 ? 0 : (n12 = n13 < 128 ? n13 - 64 << 2 : 255);
                int n15 = n13 < 64 ? n13 << 2 : (n13 < 128 ? 255 - (n13 - 64 << 2) : (n11 = n13 < 192 ? 0 : n13 - 192 << 2));
                int n16 = n13 < 32 ? 0 : (n13 < 128 ? (n13 - 32 << 3) / 3 : (n13 < 192 ? 255 - (n13 - 128 << 2) : 0));
                ColorMap.r[n5] = (byte)n12;
                ColorMap.g[n5] = (byte)n11;
                ColorMap.b[n5] = (byte)n16;
                ++n5;
            }
        } else {
            n5 = 0;
            while (n5 < 256) {
                ColorMap.g[n5] = ColorMap.b[n5] = r[n5];
                ++n5;
            }
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    protected void gris(Graphics graphics) {
        int[] nArray = this.pimg.video == 0 ? Y : Yr;
        int[] nArray2 = new int[]{10, 10 + this.triangle[0], 10 + this.triangle[1], 10 + this.triangle[2], 266};
        graphics.setColor(Color.black);
        int n = 0;
        while (n < 4) {
            graphics.drawLine(nArray2[n], nArray[n], nArray2[n + 1], nArray[n + 1]);
            graphics.drawLine(nArray2[n], nArray[n] - 1, nArray2[n + 1], nArray[n + 1] - 1);
            ++n;
        }
        n = 1;
        while (n < 4) {
            graphics.drawLine(nArray2[n], 163, nArray2[n], nArray[n]);
            ++n;
        }
    }

    public boolean keyDown(Event event, int n) {
        this.flagKey = false;
        if (this.currentTriangle == 3) {
            return true;
        }
        if (n == 1007) {
            if (this.triangle[this.currentTriangle] < 255) {
                int n2 = this.currentTriangle;
                this.triangle[n2] = this.triangle[n2] + 1;
            }
        } else if (n == 1006 && this.triangle[this.currentTriangle] > 0) {
            int n3 = this.currentTriangle;
            this.triangle[n3] = this.triangle[n3] - 1;
        }
        this.ajustTriangle();
        this.flagDrag = true;
        this.repaint();
        if (this.COLOR > -1) {
            this.pimg.aladin.view.setDynamicFilter(this.triangle, this.COLOR);
        } else {
            this.pimg.newCM(this.getCM());
        }
        this.repaint();
        this.flagKey = true;
        if (this.thread != null) {
            this.thread.stop();
        }
        this.thread = new Thread(this);
        this.thread.setPriority(4);
        this.thread.start();
        return true;
    }

    public boolean keyUp(Event event, int n) {
        if (n == 1004 || n == 1005 || n == 10) {
            this.ajustTriangle();
            this.flagDrag = false;
            this.repaint();
            if (this.COLOR > -1) {
                this.pimg.aladin.view.setFilter(this.triangle, this.COLOR);
                this.pimg.aladin.calque.zoom.zoomView.repaint();
            } else {
                IndexColorModel indexColorModel = this.getCM();
                this.pimg.setCM(indexColorModel);
                this.pimg.aladin.calque.zoom.zoomView.setCM(indexColorModel);
            }
            this.repaint();
            System.gc();
            System.runFinalization();
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (n2 < 160 || n2 > 175) {
            return true;
        }
        n -= 10;
        int n3 = 0;
        while (n3 < 3) {
            if (n > this.triangle[n3] - 7 && n < this.triangle[n3] + 7) {
                if (n3 < 1 && this.triangle[1] == this.triangle[2]) {
                    n3 = 2;
                }
                this.currentTriangle = n3;
                return true;
            }
            ++n3;
        }
        this.currentTriangle = 3;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.currentTriangle == 3) {
            return true;
        }
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        this.triangle[this.currentTriangle] = n;
        this.ajustTriangle();
        this.flagDrag = true;
        if (!event.shiftDown()) {
            if (this.COLOR > -1) {
                this.pimg.aladin.view.setDynamicFilter(this.triangle, this.COLOR);
            } else {
                this.pimg.newCM(this.getCM());
            }
        }
        this.repaint();
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (n2 < 160 || n2 > 175) {
            return true;
        }
        n -= 10;
        this.requestFocus();
        int n3 = 0;
        while (n3 < 3) {
            if (n > this.triangle[n3] - 7 && n < this.triangle[n3] + 7) {
                if (n3 < 1 && this.triangle[1] == this.triangle[2]) {
                    n3 = 2;
                }
                this.currentTriangle = n3;
                return true;
            }
            ++n3;
        }
        this.currentTriangle = 3;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.currentTriangle == 3) {
            return true;
        }
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        this.triangle[this.currentTriangle] = n;
        this.ajustTriangle();
        this.flagDrag = false;
        this.repaint();
        if (this.COLOR > -1) {
            this.pimg.aladin.view.setFilter(this.triangle, this.COLOR);
            this.pimg.aladin.calque.zoom.zoomView.repaint();
        } else {
            IndexColorModel indexColorModel = this.getCM();
            this.pimg.setCM(indexColorModel);
            this.pimg.aladin.calque.zoom.zoomView.setCM(indexColorModel);
        }
        System.gc();
        System.runFinalization();
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.img == null) {
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.img, 10, 10, null);
        this.gris(graphics);
        graphics.clearRect(0, 160, 276, 180);
        int n = 0;
        while (n < 3) {
            this.drawTriangle(graphics, this.triangle[n]);
            ++n;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(276, 185);
    }

    protected void previous() {
        if (this.pimg instanceof PlanImageRGB) {
            int n = 0;
            while (n < 3) {
                this.triangle[n] = ((PlanImageRGB)this.pimg).RGBControl[this.COLOR * 3 + n];
                ++n;
            }
        } else {
            int n = 0;
            while (n < 3) {
                this.triangle[n] = this.pimg.cmControl[n];
                ++n;
            }
        }
        this.repaint();
    }

    protected void reset() {
        this.triangle[0] = 0;
        this.triangle[1] = 128;
        this.triangle[2] = 255;
        this.repaint();
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        if (this.flagKey) {
            this.flagDrag = false;
            this.flagKey = false;
            if (this.COLOR > -1) {
                this.pimg.aladin.view.setFilter(this.triangle, this.COLOR);
                this.pimg.aladin.calque.zoom.zoomView.repaint();
            } else {
                IndexColorModel indexColorModel = this.getCM();
                this.pimg.setCM(indexColorModel);
                this.pimg.aladin.calque.zoom.zoomView.setCM(indexColorModel);
            }
            System.gc();
            System.runFinalization();
        }
    }

    public void update(Graphics graphics) {
        if (this.flagDrag) {
            this.paint(graphics);
            return;
        }
        if (this.img == null) {
            this.img = this.createImage(256, 150);
        }
        Graphics graphics2 = this.img.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, 256, 150);
        if (this.COLOR > -1) {
            if (this.pimg.video == 1) {
                graphics2.setColor(this.COLOR == 0 ? Color.cyan : (this.COLOR == 1 ? Color.magenta : Color.yellow));
            } else {
                graphics2.setColor(this.COLOR == 0 ? Color.red : (this.COLOR == 1 ? Color.green : Color.blue));
            }
        } else {
            graphics2.setColor(Color.blue);
        }
        int n = 0;
        while (n < 256) {
            graphics2.drawLine(n, 150, n, (int)(150.0 - this.hist[n]));
            ++n;
        }
        graphics2.setColor(Color.black);
        if (this.pimg instanceof PlanImageRGB) {
            graphics2.drawString(((PlanImageRGB)this.pimg).labels[this.COLOR], 100, 20);
        }
        graphics2.drawRect(0, 0, 256, 150);
        graphics2.dispose();
        this.paint(graphics);
    }
}

