/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicNode;
import cds.aladin.ResourceNode;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;

public class BasicTree
extends Canvas {
    protected ScrollPane scroll = null;
    protected PopupMenu popup;
    protected PopupMenu popupPrefs;
    protected static final String DELETE = "Delete";
    protected static final String COLLAPSE_ALL = "Collapse all";
    protected static final String EXPAND_ALL = "Expand all";
    protected static final String FLAT_VIEW = "Flat view";
    protected static final String HIER_VIEW = "Hierarchical view";
    boolean flatView = false;
    private GridBagLayout g = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private int prefHeight = 600;
    private int prefWidth = 250;
    static final int XSPACE = 22;
    static final int YSPACE = 18;
    static final int LOGOSIZE = 12;
    static final int LOGOPADDING = 4;
    static final Color LITBGCOLOR = Color.yellow;
    static final Color LITFGCOLOR = Color.magenta;
    static final Color selectedColor = new Color(255, 190, 255);
    static final Color mouseOverColor = Color.blue;
    static final Color underlineColor = Color.green;
    static final Color lineColor = Color.darkGray;
    static final Color voidColor = Color.red;
    static Font nameFont = Aladin.COURIER;
    static Font boldNameFont = Aladin.BCOURIER;
    BasicNode rootNode;
    BasicNode lastInfoNode;
    private BasicNode ancienCurNode;
    private Color bkgColor = Aladin.LGRAY;
    private boolean mustInit = true;
    private int neededHeight = 0;
    private Image buffer;
    Graphics h;
    private int hilightNode;
    int oHilightNode = -1;
    BasicNode selectedNode;
    BasicNode oselectedNode;
    private Vector nodeFullList;
    BasicNode[] nodeFullTab;
    private Vector nodeList;
    BasicNode[] nodeTab;
    private int yCurrent = 0;
    private boolean[] lastChild = new boolean[100];
    boolean last = false;
    private int maxWidth;
    private int tmpSize;
    private FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(boldNameFont);

    BasicTree(BasicNode basicNode) {
        this.rootNode = (ResourceNode)basicNode;
        this.rootNode.hide = true;
        this.setBackground(this.bkgColor);
        this.createPopup();
        this.traverseTree();
    }

    BasicTree(BasicNode basicNode, ScrollPane scrollPane) {
        this(basicNode);
        this.scroll = scrollPane;
    }

    BasicTree(ScrollPane scrollPane) {
        this(new ResourceNode(), scrollPane);
    }

    public boolean action(Event event, Object object) {
        if (object.equals(DELETE)) {
            this.removeNode(this.selectedNode);
            if (this.scroll != null) {
                this.scroll.doLayout();
            }
            this.repaint();
        } else if (object.equals(COLLAPSE_ALL)) {
            this.setAllNodes(this.rootNode, false);
            this.doDisplay();
            this.repaint();
        } else if (object.equals(EXPAND_ALL)) {
            this.setAllNodes(this.rootNode, true);
            this.doDisplay();
            this.repaint();
        } else if (object.equals(FLAT_VIEW) || object.equals(HIER_VIEW)) {
            this.flatView ^= true;
            this.popupPrefs.remove(this.popupPrefs.getItemCount() - 1);
            this.popupPrefs.add(this.flatView ? HIER_VIEW : FLAT_VIEW);
            this.doDisplay();
            this.repaint();
        }
        return true;
    }

    protected void clearSelected() {
        this.ancienCurNode = null;
        if (this.oHilightNode < 0 || this.oHilightNode >= this.nodeTab.length) {
            return;
        }
        BasicNode basicNode = this.nodeTab[this.oHilightNode];
        this.oHilightNode = -1;
        this.drawNodeName(basicNode, true);
        this.repaint();
    }

    private void computeHeight() {
        this.neededHeight = 0;
        this.computeNodeHeight(this.rootNode);
    }

    private void computeNodeHeight(BasicNode basicNode) {
        this.neededHeight += 18;
        if (!basicNode.isLeaf && basicNode.isOpen) {
            Enumeration enumeration = basicNode.getChildren();
            while (enumeration.hasMoreElements()) {
                this.computeNodeHeight((BasicNode)enumeration.nextElement());
            }
        }
    }

    void createPopup() {
        this.popup = new PopupMenu();
        this.popup.add(DELETE);
        super.add(this.popup);
        this.popupPrefs = new PopupMenu();
        this.popupPrefs.add(COLLAPSE_ALL);
        this.popupPrefs.add(EXPAND_ALL);
        this.popupPrefs.add("-");
        this.popupPrefs.add(this.flatView ? HIER_VIEW : FLAT_VIEW);
        super.add(this.popupPrefs);
    }

    private void displayIconLabel(BasicNode basicNode, int n) {
        n += 22;
        if (!basicNode.isLeaf) {
            this.drawLogo(n, this.yCurrent, basicNode);
        }
        if (basicNode.level > 0) {
            this.drawHorizLine(n, this.yCurrent, basicNode);
        }
        if (basicNode.isLeaf) {
            this.drawCheckBox(n, this.yCurrent, basicNode, true);
        }
        this.h.setFont(nameFont);
        basicNode.x = n += 22;
        basicNode.y = this.yCurrent;
        this.drawNodeName(basicNode);
    }

    private void displayTree(BasicNode basicNode, int n) {
        block11: {
            block10: {
                this.nodeList.addElement(basicNode);
                this.lastChild[n] = basicNode.isLastChild();
                basicNode.level = n;
                int n2 = -22;
                int n3 = 0;
                while (n3 < n) {
                    if (!this.lastChild[n3 + 1] || this.flatView && !this.last) {
                        this.drawVertLine(n2 + 22, this.yCurrent);
                    } else if (n3 == n - 1) {
                        this.drawHalfVertLine(n2 + 22, this.yCurrent);
                    }
                    n2 += 22;
                    ++n3;
                }
                if (!basicNode.hide) {
                    this.displayIconLabel(basicNode, n2);
                } else {
                    n2 += 22;
                    basicNode.x = n2 += 22;
                    basicNode.y = this.yCurrent;
                }
                if (basicNode.framed) {
                    this.frameNode(basicNode);
                }
                this.yCurrent += 18;
                if (!this.flatView) break block10;
                Vector vector = new Vector();
                this.getAllLeaves(basicNode, vector);
                int n4 = vector.size();
                Enumeration enumeration = vector.elements();
                int n5 = 0;
                while (enumeration.hasMoreElements()) {
                    if (++n5 == n4) {
                        this.last = true;
                    }
                    this.displayTree((BasicNode)enumeration.nextElement(), n + 1);
                }
                break block11;
            }
            if (basicNode.isLeaf || !basicNode.isOpen) break block11;
            Enumeration enumeration = basicNode.getChildren();
            while (enumeration.hasMoreElements()) {
                this.displayTree((BasicNode)enumeration.nextElement(), n + 1);
            }
        }
    }

    void doDisplay() {
        this.yCurrent = 0;
        this.nodeList = new Vector();
        if (this.h == null) {
            return;
        }
        this.h.setColor(this.bkgColor);
        this.h.fillRect(0, 0, this.size().width, this.size().height);
        this.h.setColor(Color.black);
        this.last = false;
        this.displayTree(this.rootNode, 0);
        this.hilightNode = -1;
        this.nodeTab = new BasicNode[this.nodeList.size()];
        this.nodeList.copyInto(this.nodeTab);
        this.nodeList = null;
        this.prefHeight = this.nodeTab.length * 18;
        if (!this.mustInit && this.scroll != null) {
            this.scroll.doLayout();
        }
    }

    private void drawCheckBox(int n, int n2, BasicNode basicNode, boolean bl) {
        int n3 = 11;
        int n4 = n;
        if (bl) {
            this.h.setColor(Color.white);
            this.h.fillRect(n4, n2 + 3, n3, n3);
        }
        this.h.setColor(Color.black);
        this.h.drawRect(n4, n2 + 3, n3, n3);
        this.h.setColor(Color.red);
        if (basicNode.isSelected()) {
            this.h.drawLine(n4, n2 + 3 + n3 / 2, n4 + n3 / 2, n2 + 3 + n3);
            this.h.drawLine(n4 + n3 / 2, n2 + 3 + n3, n4 + n3, n2 + 3);
        }
    }

    protected void drawFrame(BasicNode basicNode) {
        this.h.setColor(Color.black);
        this.h.drawRect(basicNode.x, basicNode.y / 18 * 18 + 2, this.h.getFontMetrics().stringWidth(basicNode.name), 12);
    }

    private void drawHalfVertLine(int n, int n2) {
        this.h.setColor(lineColor);
        this.h.drawLine(n + 11 - 2, n2 - 4, n + 11 - 2, n2 + 9 - 1);
    }

    private void drawHorizLine(int n, int n2, BasicNode basicNode) {
        this.h.setColor(lineColor);
        if (basicNode.isLeaf) {
            this.h.drawLine(12 + n - 22 - 2, this.yCurrent + 9 - 1, 16 + n + 11 - 22, this.yCurrent + 9 - 1);
        } else {
            this.h.drawLine(n - 12, this.yCurrent + 9 - 1, n + 2, this.yCurrent + 9 - 1);
        }
    }

    private void drawLogo(int n, int n2, BasicNode basicNode) {
        this.h.setColor(Color.black);
        this.h.drawRect(n + 2, n2 + 2, 12, 12);
        if (basicNode.isOpen) {
            this.h.drawLine(n + 2 + 4, n2 + 2 + 6, n + 2 + 12 - 4, n2 + 2 + 6);
        } else {
            this.h.drawLine(n + 2 + 6, n2 + 2 + 4, n + 2 + 6, n2 + 2 + 12 - 4);
            this.h.drawLine(n + 2 + 4, n2 + 2 + 6, n + 2 + 12 - 4, n2 + 2 + 6);
        }
    }

    private void drawNodeName(BasicNode basicNode) {
        this.drawNodeName(basicNode, false);
    }

    private void drawNodeName(BasicNode basicNode, boolean bl) {
        if (bl) {
            this.h.setColor(this.bkgColor);
            this.h.fillRect(basicNode.x, basicNode.y, this.h.getFontMetrics().stringWidth(basicNode.name) + 1, 18);
        }
        boolean bl2 = false;
        if (this.oHilightNode >= 0 && this.oHilightNode < this.nodeTab.length && this.nodeTab != null && basicNode.equals(this.nodeTab[this.oHilightNode])) {
            bl2 = true;
            if (basicNode.isLeaf) {
                this.h.setColor(underlineColor);
                int n = this.h.getFontMetrics().stringWidth(basicNode.name);
                this.h.drawLine(basicNode.x, basicNode.y + 9 + 5, basicNode.x + n, basicNode.y + 9 + 5);
            }
        }
        this.h.setColor(bl2 ? mouseOverColor : Color.black);
        this.h.setFont(basicNode.equals(this.lastInfoNode) ? boldNameFont : nameFont);
        this.h.drawString(basicNode.name, basicNode.x, basicNode.y + 9 + 3);
        if (basicNode.framed) {
            this.frameNode(basicNode);
        }
    }

    private void drawVertLine(int n, int n2) {
        this.h.setColor(lineColor);
        this.h.drawLine(n + 11 - 2, n2 - 4, n + 11 - 2, n2 + 18 + 2);
    }

    void frameNode(BasicNode basicNode) {
        basicNode.framed = true;
        this.drawFrame(basicNode);
        this.repaint();
    }

    protected void getAllLeaves(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            if (basicNode2.isLeaf) {
                vector.addElement(basicNode2);
            }
            this.getAllLeaves(basicNode2, vector);
        }
    }

    protected void getAllNonLeaves(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            if (!basicNode2.isLeaf) {
                vector.addElement(basicNode2);
            }
            this.getAllNonLeaves(basicNode2, vector);
        }
    }

    protected void getAllSubnodes(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            vector.addElement(basicNode2);
            this.getAllSubnodes(basicNode2, vector);
        }
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    BasicNode getRootNode() {
        return this.rootNode;
    }

    public Vector getSelectedLeaves() {
        Vector vector = new Vector();
        this.recGetSelectedLeaves(this.rootNode, vector);
        return vector;
    }

    public Dimension getSize() {
        if (this.mustInit && this.init()) {
            this.mustInit = false;
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    private boolean inLogo(BasicNode basicNode, int n) {
        int n2 = basicNode.level * 22;
        int n3 = basicNode.level * 22 + 2 + 12;
        return n >= n2 && n <= n3;
    }

    private boolean inNodeName(int n, BasicNode basicNode) {
        return n >= basicNode.x && n <= basicNode.x + this.h.getFontMetrics().stringWidth(basicNode.name);
    }

    protected boolean init() {
        this.majSize();
        this.buffer = this.createImage(this.size().width, this.size().height);
        if (this.buffer == null) {
            return false;
        }
        this.h = this.buffer.getGraphics();
        this.doDisplay();
        return true;
    }

    protected void majSize() {
        this.prefHeight = this.nodeFullTab.length * 18 + 20;
        this.setSize(this.prefWidth, this.prefHeight);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.oselectedNode = this.selectedNode;
        try {
            this.selectedNode = this.nodeTab[n2 / 18];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return true;
        }
        if (this.selectedNode.hide) {
            return true;
        }
        boolean bl = this.inLogo(this.selectedNode, n);
        boolean bl2 = this.inNodeName(n, this.selectedNode);
        if (!bl && event.modifiers != 0) {
            if (bl2) {
                this.onRightClickInNode(this.selectedNode, n, n2);
            } else {
                this.onRightClickOutNode(n, n2);
            }
            return true;
        }
        if (!bl && bl2) {
            this.onNodeSelected(this.selectedNode);
        }
        if (!this.selectedNode.equals(this.lastInfoNode) && !bl && bl2) {
            BasicNode basicNode = this.lastInfoNode;
            this.lastInfoNode = this.selectedNode;
            try {
                this.drawNodeName(this.selectedNode, true);
                if (basicNode != null && !basicNode.hide && this.nodeTab[basicNode.y / 18].equals(basicNode)) {
                    this.drawNodeName(basicNode, true);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        if (this.selectedNode.isLeaf) {
            if (bl) {
                this.selectedNode.isSelected ^= true;
                this.drawCheckBox(this.selectedNode.x - 22, this.selectedNode.y, this.selectedNode, true);
            }
            this.repaint();
        } else {
            if (bl) {
                this.selectedNode.changeState();
                if (this.selectedNode.isOpen) {
                    this.onNodeExpanded(this.selectedNode);
                } else {
                    this.onNodeCollapsed(this.selectedNode);
                }
                this.doDisplay();
            }
            this.repaint();
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        int n3;
        BasicNode basicNode;
        this.hilightNode = n2 / 18;
        this.h.setFont(nameFont);
        try {
            basicNode = this.nodeTab[this.hilightNode];
            if (basicNode.hide) {
                return true;
            }
            if (!this.inNodeName(n, basicNode)) {
                BasicNode basicNode2 = this.nodeTab[this.oHilightNode];
                this.onMouseMoved(basicNode2, false);
                this.oHilightNode = -1;
                this.ancienCurNode = null;
                this.drawNodeName(basicNode2, true);
                this.repaint();
                return true;
            }
            if (this.ancienCurNode == basicNode) {
                return true;
            }
            this.ancienCurNode = basicNode;
            n3 = this.oHilightNode;
            this.oHilightNode = this.hilightNode;
            this.drawNodeName(basicNode, true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return true;
        }
        this.onMouseMoved(basicNode, true);
        if (n3 != this.hilightNode) {
            try {
                BasicNode basicNode3 = this.nodeTab[n3];
                this.drawNodeName(basicNode3, true);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.repaint();
        return true;
    }

    protected void onMouseMoved(BasicNode basicNode, boolean bl) {
    }

    protected void onNodeCollapsed(BasicNode basicNode) {
    }

    protected void onNodeExpanded(BasicNode basicNode) {
    }

    protected void onNodeRemoved(BasicNode basicNode) {
    }

    protected void onNodeSelected(BasicNode basicNode) {
    }

    protected void onRightClickInNode(BasicNode basicNode, int n, int n2) {
        this.popup.show(this, n, n2);
    }

    protected void onRightClickOutNode(int n, int n2) {
        this.popupPrefs.show(this, n, n2);
    }

    public void openAllNodes(BasicNode basicNode) {
        this.setAllNodes(basicNode, true);
    }

    public void paint(Graphics graphics) {
        if (this.mustInit && this.init()) {
            this.mustInit = false;
        }
        if (this.buffer == null) {
            this.init();
        }
        graphics.drawImage(this.buffer, 0, 0, null);
    }

    private void recGetSelectedLeaves(BasicNode basicNode, Vector vector) {
        if (basicNode.isSelected()) {
            vector.addElement(basicNode);
        }
        if (basicNode.isOpen) {
            Enumeration enumeration = basicNode.getChildren();
            while (enumeration.hasMoreElements()) {
                this.recGetSelectedLeaves((BasicNode)enumeration.nextElement(), vector);
            }
        }
    }

    private void recSetAllNodes(BasicNode basicNode, boolean bl) {
        if (basicNode != this.rootNode) {
            basicNode.isOpen = bl;
        }
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            this.recSetAllNodes((BasicNode)enumeration.nextElement(), bl);
        }
    }

    private void recTraverseTree(BasicNode basicNode, int n) {
        this.nodeFullList.addElement(basicNode);
        this.tmpSize = (n += 22) + this.fm.stringWidth(basicNode.name);
        if (this.tmpSize > this.maxWidth) {
            this.maxWidth = this.tmpSize;
        }
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            this.recTraverseTree(basicNode2, n);
        }
    }

    private void removeNode(BasicNode basicNode) {
        if (basicNode == null) {
            return;
        }
        boolean bl = basicNode.getParent().removeChild(basicNode);
        this.onNodeRemoved(basicNode);
        if (bl) {
            this.traverseTree();
        }
        this.init();
    }

    protected void resetCb() {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            if (this.nodeFullTab[n].isLeaf) {
                this.nodeFullTab[n].isSelected = false;
            }
            ++n;
        }
        this.oHilightNode = -1;
        this.doDisplay();
        this.repaint();
    }

    public BasicNode searchNodeByName(String string) {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            if (this.nodeFullTab[n].name.equals(string)) {
                return this.nodeFullTab[n];
            }
            ++n;
        }
        return null;
    }

    public void setAllNodes(BasicNode basicNode, boolean bl) {
        this.recSetAllNodes(basicNode, bl);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.bkgColor = color;
    }

    public void setFlat(boolean bl) {
        this.flatView = bl;
    }

    void traverseTree() {
        this.nodeFullList = new Vector();
        this.maxWidth = 0;
        this.recTraverseTree(this.rootNode, 0);
        this.nodeFullTab = new BasicNode[this.nodeFullList.size()];
        this.nodeFullList.copyInto(this.nodeFullTab);
        this.prefWidth = this.maxWidth + 5;
    }

    void unframeAll() {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            if (this.nodeFullTab[n].framed) {
                this.unframeNode(this.nodeFullTab[n]);
            }
            ++n;
        }
    }

    void unframeNode(BasicNode basicNode) {
        Enumeration enumeration;
        if (basicNode.framed) {
            basicNode.framed = false;
            this.h.setColor(this.bkgColor);
            this.h.fillRect(basicNode.x, basicNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(basicNode.name) + 1, 18);
            this.drawNodeName(basicNode);
        }
        if ((enumeration = basicNode.getChildren()).hasMoreElements()) {
            BasicNode basicNode2 = basicNode.getChildrenAt(0);
            if (!basicNode2.isLeaf) {
                while (enumeration.hasMoreElements()) {
                    this.unframeNode((BasicNode)enumeration.nextElement());
                }
            }
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        if (this.mustInit && this.init()) {
            this.mustInit = false;
        }
        this.paint(graphics);
    }
}

